/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.propertymanager;

import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeEvent;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeListener;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyView;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class PropertyManager {
    private static final Logger logger = Logger.getLogger(PropertyManager.class);
    private GWPropertyChangeListener changeLogger = new GWPropertyChangeLogger();
    private List<PropertyWrapper> propertyWrappers = new LinkedList<PropertyWrapper>();
    private List<GWPropertyChangeListener> propertyChangeListeners = new ArrayList<GWPropertyChangeListener>();
    private boolean hasReadInitialProperties = false;

    public void addPropertyView(JComponent propertyView) {
        try {
            this.addPropertyView(PropertyWrapper.createPropertyWrapper(propertyView, this));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void addPropertyView(PropertyWrapper wrapper) {
        for (GWPropertyChangeListener listener : this.propertyChangeListeners) {
            wrapper.addGWPropertyChangeListener(listener);
        }
        this.propertyWrappers.add(wrapper);
    }

    public void addGWPropertyChangeListener(GWPropertyChangeListener propertyChangeListener) {
        if (!this.propertyChangeListeners.contains(propertyChangeListener)) {
            this.propertyChangeListeners.add(propertyChangeListener);
        }
        for (PropertyWrapper propertyWrapper : this.propertyWrappers) {
            propertyWrapper.addGWPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeGWPropertyChangeListener(GWPropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.remove(propertyChangeListener);
        for (PropertyWrapper propertyWrapper : this.propertyWrappers) {
            propertyWrapper.removeGWPropertyChangeListener(propertyChangeListener);
        }
    }

    public void setEnabledChangeLogger(boolean b) {
        if (b) {
            this.addGWPropertyChangeListener(this.changeLogger);
        } else {
            this.removeGWPropertyChangeListener(this.changeLogger);
        }
    }

    public void readInitialProperties() {
        this.hasReadInitialProperties = true;
        for (PropertyWrapper propertyWrapper : this.propertyWrappers) {
            propertyWrapper.readInitialProperty();
        }
    }

    public boolean hasReadInitialProperties() {
        return this.hasReadInitialProperties;
    }

    public void readProperties(Object source) {
        Class<?> aClass = source.getClass();
        Field[] fields = aClass.getDeclaredFields();
        logger.debug((Object)"-----------------------------------");
        for (Field field : fields) {
            if (field.getAnnotation(PropertyView.class) == null) continue;
            try {
                Object propertyView = field.get(source);
                if (!(propertyView instanceof JComponent)) continue;
                this.addPropertyView((JComponent)propertyView);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("The field " + aClass.getSimpleName() + "." + field.getName() + " should have public access modifier"));
            }
        }
    }

    public boolean hasChangedProperties() {
        for (PropertyWrapper propertyWrapper : this.propertyWrappers) {
            if (!propertyWrapper.hasChangedProperty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChangedProperties(JComponent component) {
        for (PropertyWrapper propertyWrapper : this.propertyWrappers) {
            if (!propertyWrapper.getPropertyView().equals(component)) continue;
            return propertyWrapper.hasChangedProperty();
        }
        return false;
    }

    public void printChanges() {
        if (this.hasChangedProperties()) {
            logger.debug((Object)"CHANGES:");
            for (PropertyWrapper propertyWrapper : this.propertyWrappers) {
                if (!propertyWrapper.hasChangedProperty()) continue;
                logger.debug((Object)("propertyView: " + PropertyWrapper.toString(propertyWrapper.getPropertyView())));
                logger.debug((Object)("initial: " + PropertyWrapper.toString(propertyWrapper.getInitialProperty())));
                logger.debug((Object)("newProperty: " + PropertyWrapper.toString(propertyWrapper.getProperty())));
            }
            logger.debug((Object)"\n");
        } else {
            logger.debug((Object)"HAVE NO CHANGED PROPERTIES");
        }
    }

    private class GWPropertyChangeLogger
    implements GWPropertyChangeListener {
        private GWPropertyChangeLogger() {
        }

        public void propertyChanged(GWPropertyChangeEvent event) {
            logger.debug((Object)("PropertyWrapper: " + event.getPropertyWrapper()));
            logger.debug((Object)("Source " + event.getSource()));
            logger.debug((Object)("InitialProperty: " + PropertyWrapper.toString(event.getInitialProperty())));
            logger.debug((Object)("Property: " + PropertyWrapper.toString(event.getProperty())));
        }
    }
}

