/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.propertymanager;

import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeEvent;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeListener;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyManager;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyView;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class PropertyManagerTest
extends JFrame {
    private static final Logger logger = Logger.getLogger(PropertyManagerTest.class);
    @PropertyView
    protected JTextField tf = new JTextField();
    @PropertyView
    protected JTextField tf1 = new JTextField();
    @PropertyView
    private JTextField tf2 = new JTextField();
    @PropertyView
    protected JComboBox cmb = new JComboBox<String>(new String[]{"aa", "bb", "cc", "dd", "ee"});
    @PropertyView
    protected JSpinner spn = new JSpinner(new SpinnerNumberModel(15, 0, 20, 2));
    private PropertyManager manager;
    @PropertyView
    protected JCheckBox cb = new JCheckBox("cb");
    @PropertyView
    protected JRadioButton rb = new JRadioButton("rb");
    @PropertyView
    protected JList list = new JList<String>(new String[]{"aa", "bb", "cc", "dd", "ee"});
    private GWPropertyChangeListener changeListener = new ChangeListener();

    public static void main(String[] args) {
        PropertyManagerTest frame = new PropertyManagerTest();
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public PropertyManagerTest() {
        JPanel panel = new JPanel(new GridLayout(8, 2));
        panel.add(new JLabel("tf"));
        panel.add(this.tf);
        panel.add(new JLabel("tf1"));
        panel.add(this.tf1);
        panel.add(new JLabel("tf2"));
        panel.add(this.tf2);
        panel.add(new JLabel("cmb"));
        panel.add(this.cmb);
        panel.add(new JLabel("spn"));
        panel.add(this.spn);
        panel.add(new JLabel("rb"));
        panel.add(this.rb);
        panel.add(new JLabel("cb"));
        panel.add(this.cb);
        panel.add(new JLabel("list"));
        panel.add(new JScrollPane(this.list));
        this.add((Component)panel, "Center");
        this.manager = new PropertyManager();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(new JButton(new ActionRead()));
        buttonPanel.add(new JButton(new ActionPrintChanges()));
        buttonPanel.add(new JCheckBox(new ActionEnabledListeners()));
        this.add((Component)buttonPanel, "Last");
        this.manager.readProperties(this);
    }

    private class ChangeListener
    implements GWPropertyChangeListener {
        private ChangeListener() {
        }

        public void propertyChanged(GWPropertyChangeEvent event) {
            logger.debug((Object)("PropertyWrapper: " + event.getPropertyWrapper()));
            logger.debug((Object)("Source " + event.getSource()));
            logger.debug((Object)("InitialProperty: " + event.getInitialProperty()));
            Object property = event.getProperty();
            if (property instanceof Object[]) {
                logger.debug((Object)("property: " + Arrays.toString((Object[])event.getProperty())));
            } else {
                logger.debug((Object)("Property: " + event.getProperty()));
            }
        }
    }

    private class ActionEnabledListeners
    extends AbstractAction {
        private ActionEnabledListeners() {
            super("Enable Listeners");
        }

        public void actionPerformed(ActionEvent e) {
            if (((JToggleButton)e.getSource()).isSelected()) {
                // empty if block
            }
            PropertyManagerTest.this.manager.setEnabledChangeLogger(((JToggleButton)e.getSource()).isSelected());
        }
    }

    private class ActionPrintChanges
    extends AbstractAction {
        private ActionPrintChanges() {
            super("Print Changes");
        }

        public void actionPerformed(ActionEvent e) {
            PropertyManagerTest.this.manager.printChanges();
        }
    }

    private class ActionRead
    extends AbstractAction {
        private ActionRead() {
            super("Read Initial Properties");
        }

        public void actionPerformed(ActionEvent e) {
            PropertyManagerTest.this.manager.readInitialProperties();
        }
    }
}

