/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.skinnable;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.ComponentPropertyManager;
import com.novell.gw.jclient.application.controls.skinnable.ISkinnable;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinnableDelegate<C extends JComponent>
implements ISkinnable {
    private static final Map<SkinProperty, ComponentProperty> DEFAULT_PROPERTY_BINDINGS = new HashMap<SkinProperty, ComponentProperty>();
    private Map<SkinProperty, ComponentProperty> propertyBindings = null;
    private C component;
    private boolean isSkinabilityEnabled = true;

    public SkinnableDelegate(C component) {
        this.component = component;
    }

    @Override
    public Set<SkinProperty> getSkinProperties() {
        if (this.propertyBindings == null) {
            return DEFAULT_PROPERTY_BINDINGS.keySet();
        }
        return this.propertyBindings.keySet();
    }

    @Override
    public void putSkinProperty(SkinProperty skinProperty, ComponentProperty componentProperty) {
        if (this.propertyBindings == null) {
            this.initPropertyBindings();
        }
        this.propertyBindings.put(skinProperty, componentProperty);
        this.updateProperty(componentProperty, ComponentPropertyManager.getInstance().getSkinPropertyValue(skinProperty), skinProperty);
    }

    @Override
    public void removeSkinProperty(SkinProperty skinProperty) {
        if (this.propertyBindings == null) {
            this.initPropertyBindings();
        }
        this.propertyBindings.remove((Object)skinProperty);
    }

    @Override
    public Object getSkinPropertyValue(SkinProperty skinProperty) {
        return this.getPropertyBindings().get((Object)skinProperty);
    }

    @Override
    public void processSkinPropertiesChange(Map<SkinProperty, Object> skinPropertyValues) {
        for (SkinProperty skinProperty : this.getSkinProperties()) {
            if (!skinPropertyValues.containsKey((Object)skinProperty)) continue;
            Object value = skinPropertyValues.get((Object)skinProperty);
            ComponentProperty property = this.getPropertyBindings().get((Object)skinProperty);
            this.updateProperty(property, value, skinProperty);
        }
    }

    public boolean isSkinabilityEnabled() {
        return this.isSkinabilityEnabled;
    }

    @Override
    public void setSkinabilityEnabled(boolean isSkinabilityEnabled) {
        if (isSkinabilityEnabled) {
            throw new RuntimeException("Revetring back to skinable properties is not implemented yet");
        }
        this.revertBackComponentPropertiesToDefaults();
        this.isSkinabilityEnabled = false;
    }

    @Override
    public Color getDefaultBackground() {
        Color componentDefaultBackground = null;
        if (this.component instanceof ISkinnable) {
            componentDefaultBackground = ((ISkinnable)this.component).getDefaultBackground();
        }
        return componentDefaultBackground;
    }

    @Override
    public Color getDefaultForeground() {
        Color componentDefaultForeground = null;
        if (this.component instanceof ISkinnable) {
            componentDefaultForeground = ((ISkinnable)this.component).getDefaultForeground();
        }
        return componentDefaultForeground;
    }

    private void revertBackComponentPropertiesToDefaults() {
        ((JComponent)this.component).setBackground(this.getDefaultBackground());
        ((JComponent)this.component).setForeground(this.getDefaultForeground());
    }

    private Map<SkinProperty, ComponentProperty> getPropertyBindings() {
        if (this.propertyBindings != null) {
            return this.propertyBindings;
        }
        return DEFAULT_PROPERTY_BINDINGS;
    }

    @Override
    public void clearPropertyBindings() {
        this.propertyBindings = new HashMap<SkinProperty, ComponentProperty>();
    }

    private Map<SkinProperty, ComponentProperty> initPropertyBindings() {
        this.propertyBindings = new HashMap<SkinProperty, ComponentProperty>();
        for (Map.Entry<SkinProperty, ComponentProperty> entry : DEFAULT_PROPERTY_BINDINGS.entrySet()) {
            this.propertyBindings.put(entry.getKey(), entry.getValue());
        }
        return this.propertyBindings;
    }

    private void updateProperty(ComponentProperty componentProperty, Object value, SkinProperty skinProperty) {
        if (this.isSkinabilityEnabled) {
            switch (componentProperty) {
                case BACKGROUND: {
                    ((JComponent)this.component).setBackground((Color)value);
                    break;
                }
                case FOREGROUND: {
                    ((JComponent)this.component).setForeground((Color)value);
                    break;
                }
                case FONT_SIZE: {
                    ((JComponent)this.component).setFont(Utils.deriveFontForSize(((Component)this.component).getFont(), ((Integer)value).intValue()));
                    break;
                }
                case CUSTOM: {
                    ((JComponent)this.component).putClientProperty((Object)skinProperty, value);
                    ((Component)this.component).repaint();
                    break;
                }
                default: {
                    assert (false) : "unexpected component property: " + (Object)((Object)componentProperty);
                    break;
                }
            }
        }
    }

    static {
        DEFAULT_PROPERTY_BINDINGS.put(SkinProperty.BACKGROUND_COLOR, ComponentProperty.BACKGROUND);
        DEFAULT_PROPERTY_BINDINGS.put(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.FOREGROUND);
    }
}

