/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.storageswitcher;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.multyactionlabel.CombinedCheckedIcon;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.UnderlinableLabel;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableComponent;
import com.novell.gw.jclient.application.controls.storageswitcher.StorageSwitcherController;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class StorageSwitcher
extends SkinnableComponent
implements MVCView {
    private static Logger logger = Logger.getLogger(StorageSwitcher.class);
    private MVCController controller;
    private static final int MODE_ONLINE = 0;
    private static final int MODE_CACHING = 1;
    private static final int MODE_ARCHIVE = 2;
    private static final int MODE_PROXY = 3;
    private static final int MODE_BACKUP = 4;
    private JPopupMenu popup;
    private JMenuItem itemUser;
    private JMenuItem itemArchive;
    private JMenuItem itemBackup;
    private JMenuItem itemOnline;
    private JMenuItem itemCaching;
    private JMenuItem itemProxy;
    private int mode;
    private JLabel arrowLabel;
    private UnderlinableLabel clickLabel;
    private boolean mouseOn = false;
    public static final Border SHIFT_BORDER = UIUtils.getComponentOrientation().isLeftToRight() ? BorderFactory.createEmptyBorder(2, 20, 2, 0) : BorderFactory.createEmptyBorder(2, 0, 2, 20);
    private static final Insets WIDER_INSETS = new Insets(4, 3, 4, 3);

    public StorageSwitcher(ActionList theActionList) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HEADER_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.controller = new StorageSwitcherController(this, (MVCController)theActionList);
        PopupListener popupListener = new PopupListener();
        this.clickLabel = new UnderlinableLabel();
        this.clickLabel.setForeground(Color.WHITE);
        this.clickLabel.setIcon(ImageResources.ICON_STORAGE_SWITCH);
        this.clickLabel.addMouseListener(popupListener);
        this.clickLabel.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
        this.arrowLabel = new OrientableLabel(ImageResources.ICON_DOWN_ARROW);
        this.arrowLabel.setFocusable(false);
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.arrowLabel.setHorizontalTextPosition(2);
        } else {
            this.arrowLabel.setHorizontalTextPosition(4);
        }
        this.arrowLabel.setIconTextGap(0);
        this.arrowLabel.addMouseListener(popupListener);
        Component filler = Box.createRigidArea(new Dimension(0, 0));
        filler.setFocusable(false);
        this.setLayout(new BoxLayout(this, 0));
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.add(this.clickLabel);
            this.add(filler);
            this.add(this.arrowLabel);
        } else {
            this.add(Box.createHorizontalGlue());
            this.add(this.arrowLabel);
            this.add(filler);
            this.add(this.clickLabel);
        }
        AppAction actionShowUser = theActionList.getAction(ActionKey.SHOW_USER_STORE);
        AppAction actionShowArchive = theActionList.getAction(ActionKey.SWITCH_ARCHIVE_STORAGE);
        AppAction actionShowBackup = theActionList.getAction(ActionKey.SWITCH_BACKUP_STORAGE);
        AppAction actionSwitchOnline = theActionList.getAction(ActionKey.SWITCH_ONLINE);
        AppAction actionSwitchCaching = theActionList.getAction(ActionKey.SWITCH_CACHING);
        AppAction actionProxy = theActionList.getAction(ActionKey.PROXY);
        this.itemUser = actionShowUser.getMenuItem();
        this.itemUser.setIcon(actionShowUser.getIcon());
        this.itemOnline = actionSwitchOnline.getMenuItem();
        this.itemOnline.setBorder(SHIFT_BORDER);
        this.itemOnline.setIcon(actionSwitchOnline.getIcon());
        this.itemCaching = actionSwitchCaching.getMenuItem();
        this.itemCaching.setBorder(SHIFT_BORDER);
        this.itemCaching.setIcon(actionSwitchCaching.getIcon());
        this.itemArchive = actionShowArchive.getMenuItem();
        this.itemArchive.setIcon(actionShowArchive.getIcon());
        this.itemBackup = actionShowBackup.getMenuItem();
        this.itemBackup.setIcon(actionShowBackup.getIcon());
        this.itemProxy = actionProxy.getMenuItem();
        this.itemProxy.setIcon(actionProxy.getIcon());
        actionShowUser.putValue("Name", EngineCommandManager.getUserInfo().getFromText());
        EngineMode mode = EngineCommandManager.getCurrentMode();
        if (EngineMode.CACHING == mode) {
            this.setMode(1);
        } else if (EngineMode.ONLINE == mode) {
            this.setMode(0);
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        if (GWCommandManager.getInstance(userGuid).isArchive()) {
            this.setMode(2);
        } else if (GWCommandManager.getInstance(userGuid).isBackupDB()) {
            this.setMode(4);
        } else if (!userGuid.equals(EngineCommandManager.getUserInfo().getGuid())) {
            this.setProxyMode();
        }
    }

    public void setTextVisible(boolean textVisible) {
        if (this.clickLabel != null) {
            this.clickLabel.setTextVisible(textVisible);
        }
    }

    public static Icon getImageIcon(Icon imageIcon) {
        if (OS.isMacOS()) {
            return imageIcon;
        }
        return new CombinedCheckedIcon(imageIcon);
    }

    private Dimension calcSize() {
        Font f = this.clickLabel.getFont();
        FontMetrics fm = this.clickLabel.getFontMetrics(f);
        Rectangle stringBounds = new Rectangle(0, 0, fm.stringWidth(this.clickLabel.getText()), fm.getHeight());
        Insets i = WIDER_INSETS;
        Icon clickIcon = this.clickLabel.getIcon();
        int w = (clickIcon == null ? 0 : clickIcon.getIconWidth()) + stringBounds.width + 2 * this.clickLabel.getIconTextGap();
        w += i.left;
        w += this.arrowLabel.getIcon() != null ? this.arrowLabel.getIcon().getIconWidth() : 0;
        int h = Math.max(stringBounds.height, this.clickLabel.getIcon() == null ? 0 : this.clickLabel.getIcon().getIconHeight());
        Icon arrowIcon = this.arrowLabel.getIcon();
        h = Math.max(h, arrowIcon != null ? arrowIcon.getIconHeight() : 0) + i.top + i.bottom;
        return new Dimension(w += i.right, h);
    }

    public Dimension getPreferredSize() {
        return this.calcSize();
    }

    private void addProxyHistory(JPopupMenu thePopup) {
        ProxyHistoryList proxyUserItems = EngineCommandManager.getProxyHistoryList();
        int nSize = proxyUserItems.size();
        for (int i = 0; i < nSize; ++i) {
            ProxyHistoryEntry entry = proxyUserItems.get(i);
            String entryName = entry.getDisplayName();
            String entryGuid = entry.getGuid();
            if (entryGuid.equals(EngineCommandManager.getUserInfo().getGuid())) continue;
            ProxyUserAction entryAction = new ProxyUserAction(entry);
            JMenuItem item = MenuItemFactory.createCkeckBoxMenuItem(entryAction);
            item.setIcon(ImageResources.ICON_ADDRESS_BOOK_USER);
            item.setBorder(SHIFT_BORDER);
            String userGuid = ControlsUtils.getUserGuid(this.controller);
            String currentName = GWCommandManager.getInstance(userGuid).getCurrentDataStore().getUserFields().getDisplayName();
            item.setSelected(entryName.equals(currentName));
            thePopup.add(item);
        }
    }

    private static int getUserMode() {
        EngineMode mode = EngineCommandManager.getCurrentMode();
        if (mode == EngineMode.ONLINE) {
            return 0;
        }
        if (mode == EngineMode.CACHING) {
            return 1;
        }
        logger.error((Object)("unsopported client mode: " + (Object)((Object)mode) + ". Defaults to ONLINE"));
        return 0;
    }

    public void setController(MVCController theController) {
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return null;
    }

    public void paint(Graphics g) {
        if (this.mouseOn) {
            this.clickLabel.setForeground((Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR));
            UIUtils.paintGradient(g, this);
        } else {
            this.clickLabel.setForeground((Color)this.getClientProperty((Object)SkinProperty.HEADER_TEXT_COLOR));
        }
        super.paint(g);
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.clickLabel != null) {
            this.clickLabel.setForeground(fg);
        }
    }

    public Insets getInsets() {
        return WIDER_INSETS;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void setMode(int theMode) {
        switch (theMode) {
            case 0: {
                this.clickLabel.setText(StringResources.ONLINE);
                this.itemOnline.setSelected(true);
                this.itemCaching.setSelected(false);
                break;
            }
            case 1: {
                this.clickLabel.setText(StringResources.CACHING);
                this.itemOnline.setSelected(false);
                this.itemCaching.setSelected(true);
                break;
            }
            case 2: {
                this.clickLabel.setText(StringResources.ARCHIVE);
                break;
            }
            case 4: {
                this.clickLabel.setText(StringResources.BACKUP);
                break;
            }
            case 3: {
                this.clickLabel.setText(StringResources.PROXY);
                this.itemUser.setSelected(false);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mode = theMode;
    }

    void switchStoreMode(StorageMode theStorageMode) {
        if (theStorageMode.isNormal()) {
            this.setMode(StorageSwitcher.getUserMode());
        } else if (theStorageMode.isArchive()) {
            this.setMode(2);
        } else if (theStorageMode.isBackup()) {
            this.setMode(4);
        }
    }

    public void updateMode() {
        if (EngineCommandManager.getCurrentMode() == EngineMode.ONLINE) {
            this.setMode(0);
        } else if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            this.setMode(1);
        }
    }

    public void setProxyMode() {
        this.setMode(3);
    }

    private JPopupMenu getPopupMenu() {
        this.popup = new GWPopupMenu();
        this.popup.add(this.itemUser);
        if (this.mode != 3) {
            if (this.mode != 2 && this.mode != 4) {
                this.popup.add(this.itemOnline);
                this.popup.add(this.itemCaching);
            }
            this.popup.addSeparator();
            if (this.mode != 4) {
                this.popup.add(this.itemArchive);
            }
            if (this.mode != 2) {
                this.popup.add(this.itemBackup);
            }
            if (this.mode == 0) {
                this.itemUser.setSelected(true);
                this.itemArchive.setSelected(false);
                this.itemBackup.setSelected(false);
                this.itemOnline.setSelected(true);
                this.itemCaching.setSelected(false);
            } else if (this.mode == 1) {
                this.itemUser.setSelected(true);
                this.itemArchive.setSelected(false);
                this.itemBackup.setSelected(false);
                this.itemOnline.setSelected(false);
                this.itemCaching.setSelected(true);
            } else if (this.mode == 2) {
                this.itemUser.setSelected(false);
                this.itemArchive.setSelected(true);
                this.itemBackup.setSelected(false);
            }
            if (this.mode == 4) {
                this.itemUser.setSelected(false);
                this.itemArchive.setSelected(false);
                this.itemBackup.setSelected(true);
            }
        }
        if (this.mode != 2 && this.mode != 4) {
            this.popup.addSeparator();
            this.popup.add(this.itemProxy);
            this.addProxyHistory(this.popup);
        }
        return this.popup;
    }

    private void showPopup() {
        ControlsUtils.getWindowForComponent(this).getBounds();
        Rectangle bounds = this.getBounds();
        Dimension ps = this.getPopupMenu().getPreferredSize();
        this.popup.show(this, bounds.width - ps.width - 6, bounds.height);
    }

    private class ProxyUserAction
    extends AbstractAction {
        private ProxyHistoryEntry entry;

        public ProxyUserAction(ProxyHistoryEntry theEntry) {
            super(theEntry.getDisplayName());
            this.entry = theEntry;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String oldUserGuid = ControlsUtils.getUserGuid(StorageSwitcher.this.controller);
                String userGuid = GWCommandManager.getInstance(oldUserGuid).performProxy(this.entry);
                Command command = new Command(750, userGuid);
                command.setAttribute((Object)AttributeKey.FRAME, SwingUtilities.getWindowAncestor(StorageSwitcher.this));
                command.setAttribute((Object)AttributeKey.FRAME_TITLE, this.entry.getDisplayName());
                StorageSwitcher.this.getController().processCommand(command);
                StorageSwitcher.this.getController().getActionList().performAction(ActionKey.REFRESH);
            }
            catch (EngineException e1) {
                JOptionPane.showMessageDialog(StorageSwitcher.this, EngineException.getErrorString((int)e1.getErrorCode()), StringResources.NOVELL_GROUPWISE, 2);
                logger.error((Object)e1);
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mouseEntered(MouseEvent e) {
            StorageSwitcher.this.mouseOn = true;
            StorageSwitcher.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            StorageSwitcher.this.mouseOn = false;
            StorageSwitcher.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            StorageSwitcher switcher = StorageSwitcher.this;
            if (!switcher.clickLabel.isFocusOwner()) {
                switcher.clickLabel.requestFocus();
            }
            switcher.showPopup();
        }
    }
}

