/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.textcomponent;

import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class EditableDropListener
extends DropTargetAdapter {
    private JTextComponent textComponent;
    private static Logger logger = Logger.getLogger(EditableDropListener.class);

    public EditableDropListener(JTextComponent theTextComponent) {
        this.textComponent = theTextComponent;
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            if (dtde.isDataFlavorSupported(GWFlavors.contactsFlavor)) {
                IContact[] contacts = (IContact[])dtde.getTransferable().getTransferData(GWFlavors.contactsFlavor);
                this.textComponent.setText(ContactUtils.toString(Arrays.asList(contacts)));
                dtde.dropComplete(true);
            } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                this.textComponent.setText(this.textComponent.getText() + dtde.getTransferable().getTransferData(DataFlavor.stringFlavor));
                dtde.dropComplete(true);
            } else {
                dtde.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }
}

