/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.textcomponent;

import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.DirtyStateManager;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.MultipleFieldsDirtyStateManager;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.application.controls.Borders;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.textcomponent.EditableDocumentListener;
import com.novell.gw.jclient.application.controls.textcomponent.EditableDropListener;
import com.novell.gw.jclient.application.controls.textcomponent.EditableFocusListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class EditableTextComponent
extends JComponent {
    private static Logger logger = Logger.getLogger(EditableTextComponent.class);

    public EditableTextComponent(JComponent theComponent, DirtyStateManager theDirtyStateManager) {
        if (theComponent == null) {
            throw new IllegalArgumentException("Component can not be NULL");
        }
        EditableTextComponent.addListeners(theComponent, theDirtyStateManager);
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        if (theComponent instanceof HTMLTextPane) {
            OrientableScrollPane scroll = new OrientableScrollPane(theComponent);
            scroll.setBorder(Borders.getEmptyTextComponentBorder(false));
            this.add((Component)scroll, "Center");
        } else {
            this.add((Component)theComponent, "Center");
        }
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    private static void addListeners(JComponent theComponent, DirtyStateManager theDirtyStateManager) {
        JTextComponent textComponent = null;
        if (theComponent instanceof JTextComponent) {
            textComponent = (JTextComponent)theComponent;
        } else if (theComponent instanceof SingleDateSelector) {
            SingleDateSelector selector = (SingleDateSelector)theComponent;
            textComponent = selector.getTextComponent();
        }
        if (textComponent != null) {
            textComponent.addFocusListener(new EditableFocusListener(textComponent));
            textComponent.addCaretListener(new ETCCaretListener(textComponent));
            if (!(theComponent instanceof HTMLTextPane) && !(theComponent instanceof ContactSearchComboField)) {
                textComponent.setDropTarget(new DropTarget(textComponent, 3, new EditableDropListener(textComponent)));
            }
            if (theDirtyStateManager != null) {
                Document document = textComponent.getDocument();
                document.addDocumentListener(new EditableDocumentListener(textComponent, theDirtyStateManager));
                if (theDirtyStateManager instanceof MultipleFieldsDirtyStateManager) {
                    MultipleFieldsDirtyStateManager manager = (MultipleFieldsDirtyStateManager)theDirtyStateManager;
                    manager.addComponent(textComponent);
                }
            }
        }
    }

    private static class ETCCaretListener
    implements CaretListener {
        private boolean wasSelected;
        private JTextComponent textComponent;

        public ETCCaretListener(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        public void caretUpdate(CaretEvent e) {
            boolean isSelected;
            boolean bl = isSelected = e.getDot() != e.getMark();
            if (isSelected != this.wasSelected) {
                Window window = SwingUtilities.getWindowAncestor(this.textComponent);
                if (window instanceof ApplicationFrame) {
                    ApplicationFrame frame = (ApplicationFrame)window;
                    frame.getAppActionList().processCommand(new Command(1160, this.textComponent));
                }
                this.wasSelected = isSelected;
            }
        }
    }
}

