/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.timepicker;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeEvent;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeListener;
import com.novell.gw.jclient.application.controls.timepicker.TimePicker;
import com.novell.gw.jclient.application.controls.timepicker.TimeTextField;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TimeDurationSelector
extends OrientablePanel
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(TimeDurationSelector.class);
    protected TimeTextField tfTime;
    protected AbstractButton pickerButton;
    private TimePicker timePicker;
    private TimeDuration duration;
    private ArrayList<DurationChangeListener> listeners;
    private TimePicker.DisplayTimeMode mode = TimePicker.DisplayTimeMode.START;
    private TimePicker.DisplayTimeMode displayTimeMode = TimePicker.DisplayTimeMode.START;

    public TimeDurationSelector() {
        this(new TimeDuration(GWCalendarUtils.getMinutes(GWCalendarUtils.getToday()), GWCalendarUtils.getMinutes(GWCalendarUtils.getToday()) + 60));
    }

    private TimeDurationSelector(TimeDuration theDuration) {
        this.listeners = new ArrayList();
        this.init();
        this.setDuration(theDuration);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.tfTime = new TimeTextField();
        this.tfTime.addKeyListener(new TimePickerListener());
        this.tfTime.addPropertyChangeListener("value", this);
        this.add((Component)this.tfTime, "Center");
        this.initPickerButton();
        this.add((Component)this.pickerButton, "After");
    }

    private void initPickerButton() {
        this.pickerButton = UIUtils.createToolButton(new TimePickerAction());
        this.pickerButton.setIcon(ImageResources.ACT_TIMEPICKER);
    }

    private void initPicker() {
        Window frame = SwingUtilities.getWindowAncestor(this);
        if (frame instanceof JFrame) {
            this.timePicker = new TimePicker((JFrame)frame, this.mode);
        }
    }

    private void showPicker() {
        if (this.timePicker == null) {
            this.initPicker();
        }
        if (this.timePicker != null) {
            this.updateTimePickerMode();
            TimeDuration durationForPicker = (TimeDuration)this.duration.clone();
            this.timePicker.setDuration(durationForPicker);
            this.timePicker.setLocationRelativeTo(this.timePicker.getParent());
            this.timePicker.setVisible(true);
            if (this.timePicker.isOkActionProcessed()) {
                this.setDuration(this.timePicker.getDuration(), this.timePicker.isStartDayIncremented());
            }
        }
    }

    protected void updateTimePickerMode() {
        if (this.duration.getEndMinutes() >= 1440) {
            if (this.displayTimeMode.equals((Object)TimePicker.DisplayTimeMode.END)) {
                logger.debug((Object)"change to End");
                this.setTimePickerMode(TimePicker.DisplayTimeMode.END);
            } else {
                assert (this.displayTimeMode.equals((Object)TimePicker.DisplayTimeMode.START)) : "Unexpected DisplayTimeMode: " + (Object)((Object)this.displayTimeMode);
                logger.debug((Object)"change to Start");
                this.setTimePickerMode(TimePicker.DisplayTimeMode.START);
            }
        } else {
            logger.debug((Object)"change to Start and End");
            this.setTimePickerMode(TimePicker.DisplayTimeMode.START);
        }
    }

    private boolean updateDuratuion(int minutes) {
        int end;
        boolean decreamentStartDate = false;
        int start = TimePicker.DisplayTimeMode.START.equals((Object)this.displayTimeMode) ? minutes : this.duration.getStartMinutes();
        if (start > (end = TimePicker.DisplayTimeMode.END.equals((Object)this.displayTimeMode) ? this.duration.getEndMinutes() / 1440 * 1440 + minutes : this.duration.getEndMinutes())) {
            if (TimePicker.DisplayTimeMode.START.equals((Object)this.displayTimeMode)) {
                end = start + MessageUtils.getDefaultAppointmentDuration();
            } else if (TimePicker.DisplayTimeMode.END.equals((Object)this.displayTimeMode)) {
                start = end - MessageUtils.getDefaultAppointmentDuration();
                if (start < 0) {
                    start += 1440;
                    end += 1440;
                    decreamentStartDate = true;
                }
            } else assert (false) : "unexpected display mode: " + (Object)((Object)this.displayTimeMode);
        }
        assert (start >= 0) : "start minutes is negative value: " + start;
        assert (end >= 0) : "end minutes is negative value: " + end;
        assert (start <= end) : "start (" + start + ") > end (" + end + ')';
        this.duration = new TimeDuration(start, end);
        this.updateTimePickerMode();
        return decreamentStartDate;
    }

    public void setDuration(TimeDuration duration) {
        this.setDuration(duration, false);
    }

    public void setDuration(TimeDuration duration, boolean startDayIncremented) {
        logger.debug((Object)("duration: " + duration));
        if (duration == null) {
            throw new IllegalArgumentException("Duration can not be null");
        }
        if (!duration.equals(this.duration)) {
            this.duration = (TimeDuration)duration.clone();
            this.updateTextField();
            DurationChangeEvent e = new DurationChangeEvent((TimeDuration)this.duration.clone(), this, false, startDayIncremented);
            this.fireDurationChanged(e);
        }
    }

    private void handleKey(int keyCode) {
        switch (keyCode) {
            case 40: {
                this.showPicker();
            }
        }
    }

    public TimeTextField getTextComponent() {
        return this.tfTime;
    }

    public TimeDuration getDuration() {
        return (TimeDuration)this.duration.clone();
    }

    private void setTimePickerMode(TimePicker.DisplayTimeMode mode) {
        if (this.mode != mode) {
            logger.debug((Object)("changing mode from " + (Object)((Object)this.mode) + " to " + (Object)((Object)mode)));
            this.mode = mode;
            this.initPicker();
        }
    }

    private void updateTextField() {
        Calendar date = GWCalendarUtils.getTodayWithoutTimeFraction();
        int minutes = this.displayTimeMode.equals((Object)TimePicker.DisplayTimeMode.END) ? this.duration.getEndMinutes() : this.duration.getStartMinutes();
        date.add(12, minutes);
        if (!date.equals(this.tfTime.getTime())) {
            this.tfTime.addPropertyChangeListener("value", this);
            this.tfTime.setTime(date);
            this.tfTime.removePropertyChangeListener("value", this);
        }
    }

    public TimePicker.DisplayTimeMode getDisplayTimeMode() {
        return this.displayTimeMode;
    }

    public void setDisplayTimeMode(TimePicker.DisplayTimeMode displayTimeMode) {
        if (displayTimeMode == null) {
            throw new IllegalArgumentException("displayTimeMode is null");
        }
        if (displayTimeMode.equals((Object)this.displayTimeMode)) {
            return;
        }
        this.displayTimeMode = displayTimeMode;
        this.updateTextField();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.pickerButton.setEnabled(b);
        this.tfTime.setEnabled(b);
    }

    private void fireDurationChanged(DurationChangeEvent e) {
        for (DurationChangeListener listener : this.listeners) {
            listener.valueChanged(e);
        }
    }

    public void addDurationChangeListener(DurationChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeDurationChangeListener(DurationChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Calendar date = Calendar.getInstance();
        date.setTime((Date)evt.getNewValue());
        int minutes = GWCalendarUtils.getMinutes(date);
        boolean decrementStartDate = this.updateDuratuion(minutes);
        if (decrementStartDate) {
            date.add(6, -1);
        }
        DurationChangeEvent changeEvent = new DurationChangeEvent((TimeDuration)this.duration.clone(), this, decrementStartDate);
        this.fireDurationChanged(changeEvent);
    }

    private class TimePickerListener
    extends KeyAdapter {
        private TimePickerListener() {
        }

        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            TimeDurationSelector.this.handleKey(keyCode);
        }
    }

    private class TimePickerAction
    extends AbstractAction {
        private TimePickerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!TimeDurationSelector.this.tfTime.isFocusOwner()) {
                TimeDurationSelector.this.tfTime.grabFocus();
            }
            TimeDurationSelector.this.showPicker();
        }
    }
}

