/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ButtonInfo;
import com.appframework.CustomizableToolBarComponent;
import com.appframework.CustomizableToolBarSeparator;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionsUtils;
import com.novell.gw.jclient.application.controls.menus.ToolBarPopupMenu;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolbarController;
import com.novell.gw.jclient.application.controls.toolbars.ToolbarCustomizationModeCommandObject;
import com.novell.gw.jclient.application.controls.toolbars.ext.ChevronToolbar;
import com.novell.gw.jclient.application.controls.toolbars.ext.SuperButton;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarComponentDragListener;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarComponentTransferData;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarUtils;
import com.novell.gw.jclient.application.controls.toolbars.ext.TransferableToolBarComponent;
import com.novell.gw.jclient.application.controls.toolbars.item.CustomizeToolBarDialog;
import com.novell.gw.jclient.application.controls.toolbars.navigation.InsertPosition;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.options.ActionInfo;
import com.novell.gw.jclient.bl.om.options.ComponentInfo;
import com.novell.gw.jclient.bl.om.options.SeparatorInfo;
import com.novell.gw.jclient.bl.om.options.ToolBarOptions;
import com.novell.gw.jclient.bl.om.options.ToolBarsOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationFrameToolBar
extends ChevronToolbar
implements MVCView {
    private static Logger logger = Logger.getLogger(ApplicationFrameToolBar.class);
    private ActionList appActionList;
    private ToolBarOptions.Style style = ToolBarOptions.Style.PICTURE_AND_SELECTED_TEXT;
    private MVCController controller;
    private ToolBarOptions.Layout layoutId = ToolBarOptions.Layout.SINGLE_ROW_OF_BUTTONS_ONLY;
    public static final int TOOLBAR_LAYOUT_SINGLE_ROW_OF_BUTTONS_ONLY = 0;
    public static final int TOOLBAR_LAYOUT_MULTIPLE_ROW_OF_BUTTONS = 1;
    private boolean customized = false;
    private DropTarget dropTarget;
    private ArrowPainter arrowPainter = new ArrowPainter();
    private List<ToolBarComponentDragListener> componentDragListenerList = new ArrayList<ToolBarComponentDragListener>();
    private JPopupMenu toolBarPopupMenu;
    private Map<Component, Boolean> componentStatesMap = new HashMap<Component, Boolean>();
    private boolean customizable = true;

    public ApplicationFrameToolBar(ActionList appActionList, String name) {
        this(appActionList, name, true);
    }

    public ApplicationFrameToolBar(ActionList appActionList, String name, boolean customizable) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.BACKGROUND);
        this.customizable = customizable;
        this.controller = new ApplicationFrameToolbarController(this, (MVCController)appActionList);
        this.setName(name);
        this.appActionList = appActionList;
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setFloatable(false);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        if (this.customizable) {
            this.toolBarPopupMenu = new ToolBarPopupMenu(appActionList, this);
            this.setComponentPopupMenu(this.toolBarPopupMenu);
            this.dropTarget = new DropTarget(this, 3, new ToolBarDropListener());
            this.dropTarget.setActive(false);
        }
    }

    public void rebuild() {
        this.removeAll();
        this.build();
        this.validate();
        this.repaint();
    }

    public void reset() {
        OptionManager instance = OptionManager.getInstance();
        ToolBarsOptions toolBarsOptions = instance.getToolBarsOptions();
        String name = this.getName();
        try {
            toolBarsOptions.putToolBarOptions(name, null);
            instance.writeOptions(instance.getToolBarsOptions());
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
        }
        toolBarsOptions.putToolBarOptions(name, this.getDefaultOptions());
        this.rebuild();
    }

    public static void main(String[] args) {
        ArrayList<ComponentInfo> defaults = new ArrayList<ComponentInfo>();
        ComponentInfo componentInfo = ComponentInfo.getInstance((Object)ActionKey.DELEGATE);
        defaults.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.ACCEPT);
        defaults.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.DECLINE);
        defaults.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.AB_FILTER_GROUP);
        defaults.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.AB_FILTER_OFF);
        defaults.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.AB_FILTER_ORGANIZATION);
        defaults.add(componentInfo);
        ArrayList<ComponentInfo> stored = new ArrayList<ComponentInfo>();
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.DELEGATE);
        stored.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.DECLINE);
        stored.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.AB_FILTER_GROUP);
        stored.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.AB_FILTER_OFF);
        componentInfo.setState(ToolBarOptions.State.REMOVED);
        stored.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.AB_FILTER_RESOURCE);
        componentInfo.setState(ToolBarOptions.State.ADDED);
        stored.add(componentInfo);
        componentInfo = ComponentInfo.getInstance((Object)ActionKey.AB_FILTER_USER);
        componentInfo.setState(ToolBarOptions.State.REMOVED);
        stored.add(componentInfo);
        List<ComponentInfo> result = ApplicationFrameToolBar.mergeNewSettings(defaults, stored);
        for (ComponentInfo info : result) {
            logger.debug((Object)("componentInfo: " + info));
        }
    }

    private static List<ComponentInfo> mergeNewSettings(List<ComponentInfo> defaults, List<ComponentInfo> stored) {
        ActionInfo actionInfo;
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>();
        result.addAll(stored);
        for (ComponentInfo componentInfo : defaults.toArray(new ComponentInfo[result.size()])) {
            int newIndex;
            if (!(componentInfo instanceof ActionInfo) || (newIndex = ComponentInfo.indexOfAction(result, (actionInfo = (ActionInfo)componentInfo).getComponentSource())) != -1) continue;
            componentInfo.setState(ToolBarOptions.State.DEFAULT);
            int oldIndex = defaults.indexOf(componentInfo);
            for (int i = oldIndex - 1; i >= 0; --i) {
                ComponentInfo temp = defaults.get(i);
                if (temp instanceof ActionInfo) {
                    newIndex = ComponentInfo.indexOfAction(result, ((ActionInfo)temp).getComponentSource());
                }
                if (newIndex > 0) break;
            }
            if (newIndex != -1) {
                result.add(newIndex + 1, componentInfo);
                continue;
            }
            result.add(componentInfo);
        }
        for (ComponentInfo componentInfo : result.toArray(new ComponentInfo[result.size()])) {
            if (!(componentInfo instanceof ActionInfo) || ComponentInfo.indexOfAction(defaults, (actionInfo = (ActionInfo)componentInfo).getComponentSource()) != -1 || componentInfo.getState() == ToolBarOptions.State.ADDED) continue;
            result.remove(componentInfo);
        }
        return result;
    }

    private static List<ComponentInfo> mergeOldSettings(List<ComponentInfo> newInfos, List oldInfos) {
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>();
        result.addAll(newInfos);
        for (Object o : oldInfos.toArray()) {
            ActionKey action;
            ButtonInfo buttonInfo;
            if (!(o instanceof ButtonInfo) || (buttonInfo = (ButtonInfo)o).equals(ButtonInfo.SEPARATOR) || (action = ActionsUtils.findAction(buttonInfo.getActionName())) == null) continue;
            int index = ComponentInfo.indexOfAction(result, action);
            if (index == -1) {
                int oldIndex = oldInfos.indexOf(buttonInfo);
                for (int i = oldIndex - 1; i >= 0; --i) {
                    ButtonInfo tempInfo = (ButtonInfo)oldInfos.get(i);
                    ActionKey tempAction = ActionsUtils.findAction(tempInfo.getActionName());
                    if (!tempInfo.equals(ButtonInfo.SEPARATOR) && tempAction != null) {
                        index = ComponentInfo.indexOfAction(result, tempAction);
                    }
                    if (index > 0) break;
                }
                ActionInfo newActionInfo = (ActionInfo)ComponentInfo.getInstance((Object)action);
                newActionInfo.setShowWithText(buttonInfo.isShowTextLabel());
                if (index != -1) {
                    result.add(index + 1, newActionInfo);
                    continue;
                }
                result.add(newActionInfo);
                continue;
            }
            ((ActionInfo)result.get(index)).setShowWithText(buttonInfo.isShowTextLabel());
        }
        return result;
    }

    private static ToolBarOptions.Style convertStyle(int style) {
        switch (style) {
            case 1: {
                return ToolBarOptions.Style.PICTURE;
            }
            case 3: {
                return ToolBarOptions.Style.PICTURE_AND_SELECTED_TEXT;
            }
            case 2: {
                return ToolBarOptions.Style.PICTURE_AND_TEXT;
            }
            case 4: {
                return ToolBarOptions.Style.PREVIEW;
            }
        }
        return ToolBarOptions.Style.PICTURE_AND_TEXT;
    }

    private static ToolBarOptions.Layout convertLayout(int layout) {
        switch (layout) {
            case 0: {
                return ToolBarOptions.Layout.SINGLE_ROW_OF_BUTTONS_ONLY;
            }
            case 1: {
                return ToolBarOptions.Layout.MULTIPLE_ROW_OF_BUTTONS;
            }
        }
        return ToolBarOptions.Layout.SINGLE_ROW_OF_BUTTONS_ONLY;
    }

    protected void init() {
        String name;
        OptionManager instance = OptionManager.getInstance();
        ToolBarsOptions toolBarsOptions = instance.getToolBarsOptions();
        ToolBarOptions toolBarOptions = toolBarsOptions.getToolBarOptions(name = this.getName());
        if (toolBarOptions == null) {
            ApplicationOptions applicationOptions = ApplicationOptions.getInstance();
            Boolean modified = applicationOptions.getBoolean(name + "TOOLBAR_MODIFIED");
            toolBarOptions = this.getDefaultOptions();
            if (modified != null && modified.booleanValue()) {
                List list = applicationOptions.getList(name);
                toolBarOptions.setLayout(ApplicationFrameToolBar.convertLayout(applicationOptions.getInteger(name + "TOOLBAR_STYLE")));
                toolBarOptions.setStyle(ApplicationFrameToolBar.convertStyle(applicationOptions.getInteger(name + "TOOLBAR_STYLE")));
                if (list.isEmpty() || !(list.get(0) instanceof String)) {
                    toolBarOptions.setComponentInfos(ApplicationFrameToolBar.mergeOldSettings(toolBarOptions.getComponentInfos(), list));
                }
                toolBarOptions.setChanged(true);
                applicationOptions.put(name, Collections.EMPTY_LIST);
                applicationOptions.put(name + "TOOLBAR_MODIFIED", false);
            }
            try {
                instance.writeOptions(instance.getToolBarsOptions());
            }
            catch (GWCommandException e) {
                logger.error((Object)e);
            }
            toolBarsOptions.putToolBarOptions(name, toolBarOptions);
        } else {
            ToolBarOptions defaultToolBarOptions = this.getDefaultOptions();
            List<ComponentInfo> storedInfos = toolBarOptions.getComponentInfos();
            List<ComponentInfo> defaultInfos = defaultToolBarOptions.getComponentInfos();
            boolean allDefaults = true;
            for (ComponentInfo componentInfo : storedInfos) {
                if (componentInfo.getState() == ToolBarOptions.State.DEFAULT) continue;
                allDefaults = false;
                break;
            }
            if (allDefaults) {
                toolBarOptions.setComponentInfos(defaultInfos);
            } else {
                toolBarOptions.setComponentInfos(ApplicationFrameToolBar.mergeNewSettings(defaultInfos, storedInfos));
            }
        }
    }

    protected void buildDefault() {
        ApplicationOptions options = ApplicationOptions.getInstance();
        options.put(this.getName() + "TOOLBAR_MODIFIED", Boolean.FALSE);
        options.put(this.getName() + "TOOLBAR_STYLE", 3);
        options.put(this.getName() + "TOOLBAR_LAYOUT", 0);
    }

    protected ToolBarOptions getDefaultOptions() {
        ToolBarOptions toolBarOptions = new ToolBarOptions();
        toolBarOptions.setName(this.getName());
        toolBarOptions.setStyle(ToolBarOptions.Style.PICTURE_AND_SELECTED_TEXT);
        toolBarOptions.setLayout(ToolBarOptions.Layout.SINGLE_ROW_OF_BUTTONS_ONLY);
        toolBarOptions.setChanged(false);
        return toolBarOptions;
    }

    @Override
    public void setName(String name) {
        logger.debug((Object)("name: " + name));
        if (name != null && name.contains("_")) {
            throw new IllegalArgumentException();
        }
        super.setName(name);
    }

    protected ButtonInfo getButtonInfo(ActionKey actionName) {
        boolean b = this.appActionList.getAction(actionName).showWithText();
        return new ButtonInfo(actionName.getOldName(), b);
    }

    protected ComponentInfo getDefaultComponentInfo(Object o) {
        ComponentInfo componentInfo = ComponentInfo.getInstance(o);
        if (componentInfo instanceof ActionInfo) {
            ActionInfo actionInfo = (ActionInfo)componentInfo;
            boolean showWithText = this.appActionList.getAction(actionInfo.getComponentSource()).showWithText();
            actionInfo.setShowWithText(showWithText);
        }
        return componentInfo;
    }

    protected void build() {
        ToolBarOptions toolBarOptions = OptionManager.getInstance().getToolBarsOptions().getToolBarOptions(this.getName());
        for (ComponentInfo componentInfo : toolBarOptions.getComponentInfos()) {
            if (componentInfo == null || componentInfo.getState() == ToolBarOptions.State.REMOVED) continue;
            if (componentInfo instanceof SeparatorInfo) {
                this.addSeparator();
                continue;
            }
            if (!(componentInfo instanceof ActionInfo)) continue;
            ActionInfo actionInfo = (ActionInfo)componentInfo;
            AppAction action = this.appActionList.getAction(actionInfo.getComponentSource());
            if (action == null) {
                logger.debug((Object)"action is null, probably application is closing while toolbar is customized, skipping component creation");
                continue;
            }
            JComponent toolBarComponent = action.getToolBarComponent();
            if (this.customized) {
                ((CustomizableToolBarComponent)((Object)toolBarComponent)).setPreviewMode(true);
            }
            if (toolBarComponent instanceof CustomizableToolBarComponent) {
                ((CustomizableToolBarComponent)((Object)toolBarComponent)).setShowTextLabel(actionInfo.isShowWithText());
            }
            this.add(toolBarComponent);
        }
        if (this.customizable) {
            this.propagatePopupMenu(this);
        }
        this.changeToolBarButtonsView(toolBarOptions.getStyle());
        this.changeToolBarLayout(toolBarOptions.getLayout());
    }

    public void setController(MVCController theController) {
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return this;
    }

    @Override
    public void addSeparator() {
        this.add(new CustomizableToolBarSeparator());
    }

    public void removeButton(CustomizableToolBarComponent component) {
        this.remove((Component)((Object)component));
    }

    public CustomizableToolBarComponent getButton(ActionKey actionKey) {
        int nCount = this.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            Component comp = this.getComponent(i);
            if (comp instanceof CustomizableToolBarComponent && !(comp instanceof CustomizableToolBarSeparator)) {
                if (((CustomizableToolBarComponent)((Object)comp)).getDefaultActionName() != actionKey) continue;
                return (CustomizableToolBarComponent)((Object)comp);
            }
            if (!(comp instanceof SuperButton)) continue;
            return ((SuperButton)comp).getButton(actionKey);
        }
        return null;
    }

    public boolean containsButton(ActionKey actionKey) {
        return this.getButton(actionKey) != null;
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof CustomizableToolBarComponent) {
            ((CustomizableToolBarComponent)((Object)comp)).changeComponentStyle(this.style);
        }
        return super.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        if (comp instanceof CustomizableToolBarComponent) {
            ((CustomizableToolBarComponent)((Object)comp)).changeComponentStyle(this.style);
        }
        return super.add(comp, index);
    }

    public ToolBarOptions.Style getStyle() {
        return this.style;
    }

    public void updateToolBarButtonsView() {
        this.changeToolBarButtonsView(this);
        this.validate();
    }

    public void changeToolBarButtonsView(ToolBarOptions.Style newStyle) {
        this.style = newStyle;
        this.updateToolBarButtonsView();
    }

    private void changeToolBarButtonsView(Container parent) {
        int nCount = parent.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            Component comp = parent.getComponent(i);
            if (comp instanceof CustomizableToolBarComponent) {
                ((CustomizableToolBarComponent)((Object)comp)).changeComponentStyle(this.style);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.changeToolBarButtonsView((Container)comp);
        }
    }

    public ToolBarOptions.Layout getLayoutId() {
        return this.layoutId;
    }

    public void changeToolBarLayout(ToolBarOptions.Layout layout) {
        if (layout != ToolBarOptions.Layout.MULTIPLE_ROW_OF_BUTTONS && layout != ToolBarOptions.Layout.SINGLE_ROW_OF_BUTTONS_ONLY) {
            throw new IllegalArgumentException("unsoported agrument value: " + (Object)((Object)layout));
        }
        if (this.layoutId == layout) {
            return;
        }
        if (layout == ToolBarOptions.Layout.MULTIPLE_ROW_OF_BUTTONS) {
            this.setLayout(this.getMultilineLayout());
        } else {
            this.setLayout(this.getChevronLayout());
        }
        this.layoutId = layout;
        this.validate();
    }

    public boolean isCustomized() {
        return this.customized;
    }

    public void setCustomized(boolean customized) {
        if (customized) {
            this.getRootPane().getLayeredPane().add((Component)this.arrowPainter, new Integer(JLayeredPane.DRAG_LAYER + 10));
            for (Component component : this.getComponents()) {
                if (!(component instanceof CustomizableToolBarComponent) || !(component instanceof JComponent)) continue;
                this.createDragListenerForComponent((JComponent)component, ComponentInfo.getInstance((CustomizableToolBarComponent)((Object)component)));
                ((CustomizableToolBarComponent)((Object)component)).setPreviewMode(true);
            }
            this.dropTarget.setActive(true);
            this.appActionList.processCommand(new GlobalCommand(1450, new ToolbarCustomizationModeCommandObject(this)));
        } else {
            if (this.getRootPane() != null) {
                this.getRootPane().getLayeredPane().remove(this.arrowPainter);
            }
            Component[] components = this.getComponents();
            int nCount = components.length;
            for (int i = 0; i < nCount; ++i) {
                if (!(components[i] instanceof CustomizableToolBarComponent) || !(components[i] instanceof JComponent)) continue;
                ((CustomizableToolBarComponent)((Object)components[i])).setPreviewMode(false);
            }
            logger.debug((Object)("number of registered drag listeners: " + this.componentDragListenerList.size()));
            for (ToolBarComponentDragListener listener : this.componentDragListenerList) {
                listener.clear();
            }
            this.componentDragListenerList.clear();
            this.dropTarget.setActive(false);
            this.appActionList.processCommand(new GlobalCommand(1460, new ToolbarCustomizationModeCommandObject(this)));
        }
        this.customized = customized;
        logger.debug((Object)("tool bar's customize mode is " + (customized ? "on" : "off")));
    }

    public void disableAll(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component is null");
        }
        if (component == this) {
            this.componentStatesMap.clear();
        }
        if (component instanceof CustomizableToolBarComponent) {
            ((CustomizableToolBarComponent)((Object)component)).setDisabledMode(true);
        } else {
            this.componentStatesMap.put(component, component.isEnabled());
            component.setEnabled(false);
            if (component instanceof Container) {
                for (Component child : ((Container)component).getComponents()) {
                    this.disableAll(child);
                }
            }
        }
    }

    public void enableAll(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component is null");
        }
        if (component instanceof CustomizableToolBarComponent) {
            ((CustomizableToolBarComponent)((Object)component)).setDisabledMode(false);
        } else {
            Boolean state = this.componentStatesMap.remove(component);
            if (state == null) {
                logger.warn((Object)('[' + this.getName() + "] state is not saved for component: " + component));
                state = true;
            }
            component.setEnabled(state);
            if (component instanceof Container) {
                for (Component child : ((Container)component).getComponents()) {
                    this.enableAll(child);
                }
            }
        }
    }

    public void removeToolBarComponent(JComponent component) {
        if (!this.customized) {
            throw new IllegalStateException("toolbar is not in customized mode");
        }
        if (!(component instanceof CustomizableToolBarComponent)) {
            throw new IllegalArgumentException("component is not CustomizableToolBarComponent instance");
        }
        this.removeButton((CustomizableToolBarComponent)((Object)component));
        CustomizeToolBarDialog.getInstance().updateToolBarConfig();
    }

    public void createDragListenerForComponent(JComponent component, ComponentInfo componentInfo) {
        ToolBarComponentTransferData componentTransferData = new ToolBarComponentTransferData(component, componentInfo);
        ToolBarComponentDragListener listener = new ToolBarComponentDragListener(component, 2, new TransferableToolBarComponent(componentTransferData));
        this.componentDragListenerList.add(listener);
    }

    private void propagatePopupMenu(Container container) {
        if (this.toolBarPopupMenu == null) {
            logger.warn((Object)("null is set as popup menu to all children of " + container.getClass().getName()));
        }
        for (Component component : container.getComponents()) {
            if (component instanceof JComponent) {
                ((JComponent)component).setComponentPopupMenu(this.toolBarPopupMenu);
            }
            if (!(component instanceof Container)) continue;
            this.propagatePopupMenu((Container)component);
        }
    }

    public InsertPosition getComponentInsertPosition(Point location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        Component targetComponent = null;
        boolean targetFound = false;
        for (Component component : this.getComponents()) {
            if (!(component instanceof CustomizableToolBarComponent) || !component.isVisible() || location.y > 4 && component.getY() > location.y || (targetComponent = component).getX() + targetComponent.getWidth() < location.x || targetComponent.getY() + targetComponent.getHeight() < location.y) continue;
            targetFound = true;
            break;
        }
        if (targetComponent == null) {
            logger.warn((Object)("no suitable component found for location: " + location));
            return null;
        }
        if (targetFound) {
            return new InsertPosition(targetComponent);
        }
        return new InsertPosition(targetComponent, false);
    }

    public boolean isMultipleRowLayoutAllowed() {
        return true;
    }

    private class ArrowPainter
    extends JComponent {
        private ArrowPainter() {
        }

        public void paintComponent(Graphics g) {
            Image image = ImageResources.ICON_YELLOW_DOWNWARD_ARROW.getImage();
            g.drawImage(image, 0, 0, ApplicationFrameToolBar.this);
        }

        public void adjustLocation(Point location) {
            if (this.getHeight() == 0) {
                this.setSize(ImageResources.ICON_YELLOW_DOWNWARD_ARROW.getIconWidth(), ImageResources.ICON_YELLOW_DOWNWARD_ARROW.getIconHeight());
            }
            Point layeredPaneLocation = ApplicationFrameToolBar.this.getRootPane().getLayeredPane().getLocationOnScreen();
            InsertPosition insertPosition = ApplicationFrameToolBar.this.getComponentInsertPosition(location);
            if (insertPosition == null) {
                logger.warn((Object)("no suitable component found for location: " + location));
                return;
            }
            int x = insertPosition.isBeforeComponent() ? insertPosition.getComponent().getLocationOnScreen().x - layeredPaneLocation.x - this.getWidth() / 2 : insertPosition.getComponent().getLocationOnScreen().x - layeredPaneLocation.x - this.getWidth() / 2 + insertPosition.getComponent().getWidth();
            int y = insertPosition.getComponent().getLocationOnScreen().y - layeredPaneLocation.y - this.getHeight();
            this.setLocation(x, y);
        }
    }

    private class ToolBarDropListener
    implements DropTargetListener {
        private ToolBarDropListener() {
        }

        private void processDragEnterAndOverEvent(DropTargetDragEvent event) {
            if (event.getTransferable().isDataFlavorSupported(TransferableToolBarComponent.componentFlavor) && (event.getDropAction() & event.getDropTargetContext().getDropTarget().getDefaultActions()) != 0) {
                event.acceptDrag(event.getDropAction());
                ApplicationFrameToolBar.this.arrowPainter.adjustLocation(event.getLocation());
                ApplicationFrameToolBar.this.arrowPainter.repaint();
                return;
            }
            event.rejectDrag();
        }

        public void dragEnter(DropTargetDragEvent e) {
            this.processDragEnterAndOverEvent(e);
        }

        public void dragOver(DropTargetDragEvent e) {
            this.processDragEnterAndOverEvent(e);
        }

        public void dropActionChanged(DropTargetDragEvent event) {
            logger.debug((Object)">>>>>dropActionChanged<<<<<");
            this.processDragEnterAndOverEvent(event);
        }

        public void dragExit(DropTargetEvent e) {
            logger.debug((Object)"dragExit");
            ApplicationFrameToolBar.this.arrowPainter.setSize(0, 0);
        }

        public void drop(DropTargetDropEvent e) {
            logger.debug((Object)"drop");
            ApplicationFrameToolBar.this.arrowPainter.setSize(0, 0);
            if ((e.getDropAction() & 3) != 0) {
                logger.debug((Object)"drop action ACTION_COPY || ACTION_MOVE");
                if (e.getTransferable().isDataFlavorSupported(TransferableToolBarComponent.componentFlavor)) {
                    logger.debug((Object)"flavor supported");
                    Object transferData = this.getTransferData(e.getTransferable());
                    logger.debug((Object)("transferData: " + transferData));
                    if (transferData == null) {
                        logger.debug((Object)"transferData == null");
                        e.rejectDrop();
                        return;
                    }
                    logger.debug((Object)("transferData class: " + transferData.getClass().getName()));
                    ToolBarComponentTransferData componentTransferData = (ToolBarComponentTransferData)transferData;
                    e.acceptDrop(e.getDropAction());
                    logger.debug((Object)"drop accepted");
                    if ((e.getDropAction() & 1) != 0 && componentTransferData.getComponentInfo() instanceof ActionInfo && ApplicationFrameToolBar.this.containsButton(((ActionInfo)componentTransferData.getComponentInfo()).getComponentSource())) {
                        logger.debug((Object)"component already present > skipping");
                    } else {
                        this.processComponentDrop(componentTransferData, e.getLocation(), e.getDropAction());
                    }
                    e.dropComplete(true);
                    logger.debug((Object)"drop completed");
                }
            }
        }

        private Object getTransferData(Transferable transferable) {
            Object transferData = null;
            if (transferable.isDataFlavorSupported(TransferableToolBarComponent.componentFlavor)) {
                try {
                    transferData = transferable.getTransferData(TransferableToolBarComponent.componentFlavor);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Exception: " + ex));
                }
            }
            return transferData;
        }

        private void processComponentDrop(ToolBarComponentTransferData componentTransferData, Point dropLocation, int action) {
            JComponent clone;
            if ((action & 2) != 0) {
                if (ApplicationFrameToolBar.this.getComponentAt(dropLocation) == componentTransferData.getComponent()) {
                    logger.debug((Object)"dropping component on itself");
                    return;
                }
                logger.debug((Object)"removind from component from drag source");
                ApplicationFrameToolBar.this.removeToolBarComponent(componentTransferData.getComponent());
            }
            InsertPosition insertPosition = ApplicationFrameToolBar.this.getComponentInsertPosition(dropLocation);
            Component target = insertPosition.getComponent();
            ComponentInfo componentInfo = componentTransferData.getComponentInfo();
            logger.debug((Object)("cloning component with action: " + componentInfo.getComponentSource()));
            if (componentInfo instanceof SeparatorInfo) {
                clone = new CustomizableToolBarSeparator();
            } else {
                ActionInfo actionInfo = (ActionInfo)componentInfo;
                ApplicationFrame appFrame = (ApplicationFrame)ApplicationFrameToolBar.this.getTopLevelAncestor();
                clone = ((ActionList)appFrame.getController()).getAction(actionInfo.getComponentSource()).getToolBarComponent();
                ((CustomizableToolBarComponent)((Object)clone)).setShowTextLabel(actionInfo.isShowWithText());
            }
            ((CustomizableToolBarComponent)((Object)clone)).setPreviewMode(true);
            if (!insertPosition.isBeforeComponent()) {
                logger.debug((Object)"adding at the end");
                ApplicationFrameToolBar.this.add(clone);
            } else {
                int targetIndex = ToolBarUtils.indexOf(target);
                logger.debug((Object)("target index: " + targetIndex));
                ApplicationFrameToolBar.this.add((Component)clone, targetIndex);
            }
            logger.debug((Object)("tool bar name: " + ApplicationFrameToolBar.this.getName()));
            CustomizeToolBarDialog.getInstance().updateToolBarConfig();
            ApplicationFrameToolBar.this.createDragListenerForComponent(clone, componentInfo);
            ApplicationFrameToolBar.this.validate();
            ApplicationFrameToolBar.this.repaint();
        }
    }
}

