/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.novell.gw.jclient.application.controls.toolbars.ext.Chevronable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ChevronLayout
implements LayoutManager {
    private static Logger logger = Logger.getLogger(ChevronLayout.class);
    int hgap;
    int vgap;
    private Set invisibleComponents = new LinkedHashSet();
    private Set invisibleComponentsOld = new LinkedHashSet();
    private Chevronable source;

    public ChevronLayout(Chevronable theSource) {
        this(theSource, 5, 5);
    }

    public ChevronLayout(Chevronable theSource, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.source = theSource;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public boolean isChevron(Component component) {
        return component == this.getChevron();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension result = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            int nVisibleMembers = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component component = target.getComponent(i);
                if (!component.isVisible() || this.isChevron(component)) continue;
                ++nVisibleMembers;
                Dimension componentPreferredSize = component.getPreferredSize();
                result.height = Math.max(result.height, componentPreferredSize.height);
                result.width += componentPreferredSize.width;
            }
            int hgaps = this.hgap * 2;
            if (nVisibleMembers > 1) {
                hgaps += (nVisibleMembers - 1) * this.hgap;
            }
            Insets insets = target.getInsets();
            result.width += insets.left + insets.right + hgaps;
            result.height += insets.top + insets.bottom + this.vgap * 2;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension result = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            int nVisibleMembers = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component component = target.getComponent(i);
                if (!component.isVisible() || this.isChevron(component)) continue;
                ++nVisibleMembers;
                Dimension componentMinimumSize = component.getMinimumSize();
                result.height = Math.max(result.height, componentMinimumSize.height);
                result.width += componentMinimumSize.width;
            }
            int hgaps = this.hgap * 2;
            if (nVisibleMembers > 1) {
                hgaps += (nVisibleMembers - 1) * this.hgap;
            }
            Insets insets = target.getInsets();
            result.width += insets.left + insets.right + hgaps;
            result.height += insets.top + insets.bottom + this.vgap * 2;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this.checkChevron(target);
            this.invisibleComponents.clear();
            Insets insets = target.getInsets();
            int x = insets.left + this.hgap;
            int maxX = target.getWidth() - (insets.right + this.hgap);
            this.getChevron().setVisible(false);
            boolean showChevron = this.preferredLayoutSize((Container)target).width >= target.getWidth();
            this.arrangeSize(this.getChevron(), target);
            int chevronWidth = this.getChevron().getPreferredSize().width;
            boolean isLeftToRight = target.getComponentOrientation().isLeftToRight();
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component component = target.getComponent(i);
                if (!component.isVisible() || this.isChevron(component)) continue;
                this.arrangeSize(component, target);
                int componentWidth = component.getPreferredSize().width;
                int desiredX = x + componentWidth;
                int n = desiredX = showChevron ? (desiredX = desiredX + (this.hgap + chevronWidth)) : desiredX;
                if (desiredX <= maxX && !this.getChevron().isVisible()) {
                    if (isLeftToRight) {
                        component.setLocation(x, this.getY(component, target));
                    } else {
                        component.setLocation(maxX - x - componentWidth, this.getY(component, target));
                    }
                    x += componentWidth + this.hgap;
                    continue;
                }
                if (showChevron && !this.getChevron().isVisible()) {
                    int chevronX = target.getWidth() - (insets.right + this.hgap) - chevronWidth;
                    if (isLeftToRight) {
                        this.getChevron().setLocation(chevronX, this.getY(this.getChevron(), target));
                    } else {
                        this.getChevron().setLocation(0, this.getY(this.getChevron(), target));
                    }
                    this.getChevron().setVisible(true);
                }
                this.invisibleComponents.add(component);
                ChevronLayout.hideComponent(component, target);
            }
            if (!((Object)this.invisibleComponents).equals(this.invisibleComponentsOld)) {
                this.componentsStateChanged(new LinkedHashSet(this.invisibleComponents));
                this.invisibleComponentsOld.clear();
                this.invisibleComponentsOld.addAll(this.invisibleComponents);
            }
        }
    }

    private static boolean contains(Container theContainer, Component theComponent) {
        boolean result = false;
        int nCount = theContainer.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            if (theContainer.getComponent(i) != theComponent) continue;
            result = true;
            break;
        }
        return result;
    }

    private void checkChevron(Container target) {
        if (!ChevronLayout.contains(target, this.getChevron())) {
            target.add(this.getChevron());
        }
    }

    private static void hideComponent(Component theComponent, Container target) {
        Point invisible = new Point(0, target.getHeight());
        if (!theComponent.getLocation().equals(invisible)) {
            theComponent.setLocation(invisible);
        }
    }

    private JComponent getChevron() {
        return this.source.getChevron();
    }

    private int getY(Component theComponent, Container target) {
        int result;
        int componentHeight = theComponent.getHeight();
        int vAlign = ChevronLayout.getVerticalAlign(theComponent);
        switch (vAlign) {
            case 1: {
                result = target.getInsets().top + this.vgap;
                break;
            }
            case 3: {
                result = target.getHeight() - (target.getInsets().bottom + this.vgap + componentHeight);
                break;
            }
            default: {
                int allowedHeight = target.getHeight() - (target.getInsets().top + target.getInsets().bottom + this.vgap * 2);
                result = target.getInsets().top + this.vgap + (allowedHeight - componentHeight) / 2;
            }
        }
        return result;
    }

    protected void arrangeSize(Component theComponent, Container theParent) {
        int width = theComponent.getPreferredSize().width;
        int height = this.resizeVertical(theComponent) ? theParent.getHeight() - (theParent.getInsets().top + theParent.getInsets().bottom + this.vgap * 2) : theComponent.getPreferredSize().height;
        theComponent.setSize(width, height);
    }

    protected static int getVerticalAlign(Component theComponent) {
        return 0;
    }

    protected boolean resizeVertical(Component theComponent) {
        return false;
    }

    protected void componentsStateChanged(Set theInvisibleComponents) {
    }
}

