/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.appframework.AppAction;
import com.appframework.components.customizedbutton.AbstractPopupPane;
import com.appframework.components.customizedbutton.ActionWithSepName;
import com.appframework.components.customizedbutton.PopupButton;
import com.appframework.components.customizedbutton.ToolBarSeparator;
import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableMenu;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class ChevronPopupMenu
extends GWPopupMenu {
    private static Logger logger = Logger.getLogger(ChevronPopupMenu.class);
    private static final int MENU_ITEM_HEIGHT = 22;
    private Set components = null;
    private Set lastBuiltComponents = null;

    public ChevronPopupMenu() {
        this.addPopupMenuListener(new RebuildItemsPopupMenuListener());
    }

    public void rebuild(Set theInvisibleComponents) {
        this.components = theInvisibleComponents;
    }

    protected void rebuildMenuItems() {
        if (this.lastBuiltComponents == null || !((Object)this.lastBuiltComponents).equals(this.components)) {
            this.lastBuiltComponents = this.components;
            this.rebuildMenuItems(this.lastBuiltComponents);
        }
    }

    protected void rebuildMenuItems(Set theComponents) {
        this.removeAll();
        if (theComponents == null || theComponents.isEmpty()) {
            return;
        }
        for (Object component : theComponents) {
            JComponent menuItem = this.getMenuItemFor(component);
            logger.debug((Object)("menuItem: " + menuItem));
            if (menuItem == null) continue;
            this.add(menuItem);
        }
    }

    protected JComponent getMenuItemFor(Object component) {
        if (component instanceof ToolBarSeparator || component instanceof JSeparator) {
            return new JPopupMenu.Separator();
        }
        if (component instanceof AbstractPopupPane) {
            return this.getMenuItemForAbstractPopupPane((AbstractPopupPane)component);
        }
        if (component instanceof PopupButton) {
            return this.getMenuItemForPopupButton((PopupButton)component);
        }
        if (component instanceof JButton) {
            return this.getMenuItemForJButton((JButton)component);
        }
        if (component instanceof ToolBarToggleButton) {
            return this.getMenuItemForJToggleButton((ToolBarToggleButton)component);
        }
        return null;
    }

    private JComponent getMenuItemForPopupButton(PopupButton popupButton) {
        Component button = popupButton.getButton();
        OrientableMenu menu = new OrientableMenu(button.getName());
        if (popupButton instanceof AbstractButton) {
            Icon icon = (Icon)((AbstractButton)((Object)popupButton)).getAction().getValue("SmallIcon");
            menu.setIcon(icon);
        }
        for (Component component : popupButton.getPopupElements()) {
            if (component instanceof JSeparator) {
                menu.addSeparator();
                continue;
            }
            if (!(component instanceof AbstractButton)) continue;
            Action action = ((AbstractButton)component).getAction();
            if (action instanceof AppAction) {
                menu.add(((AppAction)action).getMenuItem());
                continue;
            }
            menu.add(OS.createMenuItemForAction(action));
        }
        return menu;
    }

    private JComponent getMenuItemForJToggleButton(ToolBarToggleButton component) {
        Action action = component.getAction();
        if (action == null) {
            return null;
        }
        JMenuItem mi = action instanceof AppAction ? OS.createMenuItem((AppAction)action) : OS.createMenuItemForAction(action);
        ButtonGroup group = component.getGroup();
        if (group != null) {
            group.add(mi);
        }
        mi.setAccelerator(null);
        return mi;
    }

    private JComponent getMenuItemForJButton(JButton component) {
        Action action = component.getAction();
        if (action == null) {
            return null;
        }
        JMenuItem mi = OS.createMenuItemForAction(action);
        mi.setAccelerator(null);
        return mi;
    }

    private JComponent getMenuItemForAbstractPopupPane(AbstractPopupPane component) {
        List actions = component.getActionsList();
        if (actions.isEmpty()) {
            return null;
        }
        OrientableMenu menu = new OrientableMenu((String)component.getDefaultAction().getValue("Name"));
        menu.setIcon((Icon)component.getDefaultAction().getValue("SmallIcon"));
        int nSize = actions.size();
        for (int j = 0; j < nSize; ++j) {
            ActionWithSepName actionWithSepName = (ActionWithSepName)actions.get(j);
            Action action = actionWithSepName.getAction();
            if (action == null) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = OS.createMenuItemForAction(action);
            menu.add(mi);
        }
        return menu;
    }

    public void show(Component invoker, int x, int y) {
        this.rebuildMenuItems();
        super.show(invoker, x, y);
    }

    private class RebuildItemsPopupMenuListener
    implements PopupMenuListener {
        private RebuildItemsPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

