/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.novell.gw.jclient.application.controls.toolbars.ext.DropableToolBarAncestor;
import com.novell.gw.jclient.application.controls.toolbars.ext.ResizableToolbar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ToolBarUtils {
    private static final Logger logger = Logger.getLogger(ToolBarUtils.class);
    private static final int ALLOWED_SHIFT_TO_MOVE = 3;

    public static void doDisposeButtons(JComponent theParentComponent) {
        if (theParentComponent == null) {
            return;
        }
        Component[] components = theParentComponent.getComponents();
        Component component2 = null;
        for (Component component2 : components) {
            AbstractButton abstractButton;
            if (component2 instanceof AbstractButton && (abstractButton = (AbstractButton)component2).getAction() != null) {
                abstractButton.setAction(null);
            }
            if (!(component2 instanceof JComponent)) continue;
            ToolBarUtils.doDisposeButtons((JComponent)component2);
        }
    }

    public static int indexOf(Component theComponent) {
        int result = -1;
        Container parent = theComponent.getParent();
        if (parent != null) {
            Component[] components = parent.getComponents();
            int nCount = components.length;
            for (int i = 0; i < nCount; ++i) {
                if (theComponent != components[i]) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public static boolean isLastVisible(Component theComponent) {
        boolean result = false;
        int indexOf = ToolBarUtils.indexOf(theComponent);
        if (indexOf >= 0) {
            Container parent = theComponent.getParent();
            for (int i = parent.getComponentCount() - 1; i >= indexOf; --i) {
                Component component = parent.getComponent(i);
                if (!component.isVisible()) continue;
                result = component == theComponent;
                break;
            }
        }
        return result;
    }

    public static boolean isFirstVisible(Component theComponent) {
        boolean result = false;
        int indexOf = ToolBarUtils.indexOf(theComponent);
        if (indexOf >= 0) {
            Container parent = theComponent.getParent();
            for (int i = 0; i <= indexOf; ++i) {
                Component component = parent.getComponent(i);
                if (!component.isVisible()) continue;
                result = component == theComponent;
                break;
            }
        }
        return result;
    }

    public static void increasePreferredWidth(Component theComponent, int theValue) {
        if (theComponent instanceof ResizableToolbar) {
            ResizableToolbar resizableToolbar = (ResizableToolbar)theComponent;
            resizableToolbar.setCurrentWidth(resizableToolbar.getWidth());
        } else {
            Dimension preferredSize = theComponent.getPreferredSize();
            theComponent.setPreferredSize(new Dimension(preferredSize.width + theValue, preferredSize.height));
        }
    }

    public static Component getPreviousVisible(Container theParent, Component theComponent) {
        Component result = null;
        int indexOf = ToolBarUtils.indexOf(theComponent);
        for (int i = indexOf - 1; i >= 0; --i) {
            Component component = theParent.getComponent(i);
            if (!component.isVisible()) continue;
            result = component;
            break;
        }
        return result;
    }

    public static Component getNextVisible(Container theParent, Component theComponent) {
        Component result = null;
        int indexOf = ToolBarUtils.indexOf(theComponent);
        int nCount = theParent.getComponentCount();
        for (int i = indexOf + 1; i < nCount; ++i) {
            Component component = theParent.getComponent(i);
            if (!component.isVisible()) continue;
            result = component;
            break;
        }
        return result;
    }

    public static int getVisibleComponentsCount(Container theComponent) {
        int result = 0;
        int nCount = theComponent.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            if (!theComponent.getComponent(i).isVisible()) continue;
            ++result;
        }
        return result;
    }

    public static Component getPreviousResizable(Component theComponent) {
        Component result = null;
        Container parent = theComponent.getParent();
        int indexOf = ToolBarUtils.indexOf(theComponent);
        if (indexOf > 0) {
            for (int i = indexOf - 1; i >= 0; --i) {
                Component component = parent.getComponent(i);
                if (!component.isVisible() || !ToolBarUtils.isResizable(component)) continue;
                result = component;
                break;
            }
        }
        return result;
    }

    public static Component getNextResizable(Component theComponent) {
        Component result = null;
        Container parent = theComponent.getParent();
        int indexOf = ToolBarUtils.indexOf(theComponent);
        if (indexOf >= 0) {
            int number = parent.getComponentCount();
            for (int i = indexOf + 1; i < number; ++i) {
                Component component = parent.getComponent(i);
                if (!component.isVisible() || !ToolBarUtils.isResizable(component)) continue;
                result = component;
                break;
            }
        }
        return result;
    }

    public static boolean isResizable(Component theComponent) {
        return theComponent != null && (double)theComponent.getWidth() > theComponent.getMinimumSize().getWidth();
    }

    public static int getAllowedResizeShift(Component theComponent, int theDesiredShift) {
        int result = 0;
        if (theDesiredShift > 0) {
            int possibleResizeValue = theComponent.getWidth() - theComponent.getMinimumSize().width;
            if (possibleResizeValue < 0) {
                possibleResizeValue = 0;
            }
            result = Math.min(theDesiredShift, possibleResizeValue);
        }
        return result;
    }

    public static void processToolbarResizing(ResizableToolbar theToolbar, int shiftX) {
        Component previousResizable;
        Container parent = theToolbar.getParent();
        if (shiftX > 0 && !ToolBarUtils.isFirstVisible(theToolbar)) {
            Component resizable;
            Component component = resizable = ToolBarUtils.isResizable(theToolbar) ? theToolbar : ToolBarUtils.getNextResizable(theToolbar);
            if (resizable != null) {
                int allowedShift = ToolBarUtils.getAllowedResizeShift(resizable, shiftX);
                Component previous = ToolBarUtils.getPreviousVisible(parent, theToolbar);
                resizable.setBounds(resizable.getX() + allowedShift, resizable.getY(), resizable.getWidth() - allowedShift, resizable.getHeight());
                ToolBarUtils.increasePreferredWidth(resizable, -allowedShift);
                previous.setBounds(previous.getX(), previous.getY(), previous.getWidth() + allowedShift, previous.getHeight());
                ToolBarUtils.increasePreferredWidth(previous, allowedShift);
                parent.validate();
            }
        } else if (shiftX < 0 && !ToolBarUtils.isFirstVisible(theToolbar) && (previousResizable = ToolBarUtils.getPreviousResizable(theToolbar)) != null) {
            int allowedShift = -ToolBarUtils.getAllowedResizeShift(previousResizable, Math.abs(shiftX));
            previousResizable.setBounds(previousResizable.getX(), previousResizable.getY(), previousResizable.getWidth() + allowedShift, previousResizable.getHeight());
            ToolBarUtils.increasePreferredWidth(previousResizable, allowedShift);
            theToolbar.setBounds(theToolbar.getX() + allowedShift, theToolbar.getY(), theToolbar.getWidth() - allowedShift, theToolbar.getHeight());
            ToolBarUtils.increasePreferredWidth(theToolbar, -allowedShift);
            parent.validate();
        }
    }

    public static void processToolbarMoving(JComponent theComponent, Point theNewMouseLocation) {
        Container parent = theComponent.getParent();
        Component componentAt = parent.getComponentAt(theNewMouseLocation);
        if (componentAt != null && componentAt != theComponent && theNewMouseLocation.x - componentAt.getLocation().x <= 3) {
            parent.add((Component)theComponent, ToolBarUtils.indexOf(componentAt));
            parent.validate();
        }
    }

    public static int min(int n1, int n2, int n3, int n4) {
        return Math.min(Math.min(Math.min(n1, n2), n3), n4);
    }

    public static DropableToolBarAncestor getDropableToolBarAncestor(JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("toolbat is null");
        }
        DropableToolBarAncestor ancestor = null;
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof DropableToolBarAncestor)) continue;
            ancestor = (DropableToolBarAncestor)((Object)parent);
            break;
        }
        return ancestor;
    }
}

