/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.item;

import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.Category;
import com.appframework.CustomizableToolBarComponent;
import com.appframework.CustomizableToolBarSeparator;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarComponentDragListener;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarComponentTransferData;
import com.novell.gw.jclient.application.controls.toolbars.ext.TransferableToolBarComponent;
import com.novell.gw.jclient.application.dialogs.junkmail.HTMLLabel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.options.ActionInfo;
import com.novell.gw.jclient.bl.om.options.ComponentInfo;
import com.novell.gw.jclient.bl.om.options.SeparatorInfo;
import com.novell.gw.jclient.bl.om.options.ToolBarOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizeToolBarDialog
extends ApplicationDialog {
    private static Logger logger = Logger.getLogger(CustomizeToolBarDialog.class);
    private static String SEPARATOR_LABEL = '[' + StringResources.SEPARATOR + ']';
    private static CustomizeToolBarDialog instance;
    private JTabbedPane tpMain;
    private JList listCategories;
    private JPanel pnlDescription = new OrientablePanel(new GridBagLayout());
    private ApplicationFrameToolBar toolBar;
    private ComponentInfo selectedInfo;
    private CustomizableToolBarComponent previewButton;
    private ChangeShowTextAction showTextAction = new ChangeShowTextAction();
    private JCheckBox cbShowLabel = new JMnemonicCheckBox(this.showTextAction);
    private JCheckBox cbShowItemContextToolBar;
    private JCheckBox cbShowFolderContextToolBar;
    private boolean showItemContextToolBarInitValue;
    private boolean showFolderContextToolBarInitValue;
    private AbstractButton rbPicture = new JMnemonicRadioButton(new ChangeButtonStyleAction(StringResources.PICTURE, ToolBarOptions.Style.PICTURE));
    private AbstractButton rbPictureAndText = new JMnemonicRadioButton(new ChangeButtonStyleAction(StringResources.PICTURE_AND_TEXT, ToolBarOptions.Style.PICTURE_AND_TEXT));
    private AbstractButton rbPIctureAndSelText = new JMnemonicRadioButton(new ChangeButtonStyleAction(StringResources.PICTURE_AND_SELECTED_TEXT, ToolBarOptions.Style.PICTURE_AND_SELECTED_TEXT));
    private AbstractButton rbSingleRow = new JMnemonicRadioButton(new ChangeToolBarLayoutAction(StringResources.SINGLE_ROW_OF_BUTTONS_ONLY, ToolBarOptions.Layout.SINGLE_ROW_OF_BUTTONS_ONLY));
    private AbstractButton rbMultipleRows = new JMnemonicRadioButton(new ChangeToolBarLayoutAction(StringResources.MULTIPLE_ROW_OF_BUTTONS, ToolBarOptions.Layout.MULTIPLE_ROW_OF_BUTTONS));
    private JComponent pnlControls = new GWToolBar(new FlowLayout(3, 5, 5));
    private OrientablePanel pnlCustomize;
    private List<ComponentInfo> toolbarConfig;
    private ApplicationFrameActionList actionList;
    private JFrame frameOwner;
    private JComponent lbSepatator = new OrientableLabel(SEPARATOR_LABEL);
    private List<ToolBarComponentDragListener> componentDragListenerList = new ArrayList<ToolBarComponentDragListener>();
    private CustomizableToolBarComponent currentSelectedInControlsButton;
    private AddButtonAction addButtonAction;

    private CustomizeToolBarDialog(ApplicationFrame theFrame, ApplicationFrameToolBar toolBar) {
        super(toolBar.getController());
        this.frameOwner = theFrame;
        this.actionList = theFrame.getController();
        this.toolBar = toolBar;
        this.toolbarConfig = this.cloneList();
        this.setTitle(StringResources.TOOLBAR_PROPERTIES);
        this.buildUI();
        this.init();
        this.setModal(false);
    }

    public void rebuild(ApplicationFrame theFrame, ApplicationFrameToolBar toolBar) {
        JComponent pnlContent = (JComponent)this.getContentPane();
        pnlContent.removeAll();
        this.frameOwner = theFrame;
        this.actionList = theFrame.getAppActionList();
        this.toolBar = toolBar;
        this.toolbarConfig = this.cloneList();
        this.buildUI();
        this.init();
    }

    private List<ComponentInfo> cloneList() {
        ToolBarOptions toolBarOptions = OptionManager.getInstance().getToolBarsOptions().getToolBarOptions(this.toolBar.getName());
        List<ComponentInfo> list = toolBarOptions.getComponentInfos();
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>(list.size());
        for (ComponentInfo source : list) {
            if (source.getState() == ToolBarOptions.State.REMOVED) continue;
            ComponentInfo clone = ComponentInfo.getClone(source);
            result.add(clone);
        }
        return result;
    }

    private void buildUI() {
        JComponent pnlContent = (JComponent)this.getContentPane();
        pnlContent.setLayout(new BorderLayout(5, 5));
        this.tpMain = new OrientableTabbedPane();
        this.pnlCustomize = new OrientablePanel(new GridBagLayout());
        this.listCategories = new OrientableList();
        this.buildShowPane();
        this.buildCustomizePane();
        pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlContent.add(this.tpMain);
        pnlContent.add((Component)this.buildButtonsPane(), "South");
    }

    private void buildShowPane() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbPicture);
        bg.add(this.rbPictureAndText);
        bg.add(this.rbPIctureAndSelText);
        GridBagConstraints cs = new GridBagConstraints();
        cs.gridy = 0;
        cs.anchor = 23;
        cs.insets.left = 10;
        cs.insets.right = 50;
        OrientablePanel pnlToolBarStyle = new OrientablePanel(new GridBagLayout());
        pnlToolBarStyle.add((Component)this.rbPicture, cs);
        cs.insets.right = 0;
        pnlToolBarStyle.add((Component)this.rbPictureAndText, cs);
        cs.insets.left = 0;
        ++cs.gridy;
        pnlToolBarStyle.add((Component)CustomizeToolBarDialog.buildToolBarPreviewPanel(ToolBarOptions.Style.PICTURE), cs);
        cs.weightx = 1.0;
        cs.insets.bottom = 10;
        pnlToolBarStyle.add((Component)CustomizeToolBarDialog.buildToolBarPreviewPanel(ToolBarOptions.Style.PICTURE_AND_TEXT), cs);
        cs.insets.bottom = 0;
        ++cs.gridy;
        cs.gridwidth = 2;
        cs.insets.left = 10;
        pnlToolBarStyle.add((Component)this.rbPIctureAndSelText, cs);
        cs.insets.left = 0;
        ++cs.gridy;
        pnlToolBarStyle.add((Component)CustomizeToolBarDialog.buildToolBarPreviewPanel(ToolBarOptions.Style.PICTURE_AND_SELECTED_TEXT), cs);
        pnlToolBarStyle.setBorder(BorderFactory.createTitledBorder(StringResources.TOOLBAR_BUTTON_STYLE));
        OrientablePanel pnlShow = new OrientablePanel(new BorderLayout(0, 10));
        pnlShow.add((Component)pnlToolBarStyle, "North");
        cs = new GridBagConstraints();
        cs.gridy = 0;
        cs.anchor = 23;
        cs.weightx = 1.0;
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout(0, 10));
        pnlTemp.add((Component)this.buildDisplayOption(), "North");
        if (this.isOwnerMainFrame()) {
            OrientablePanel pnlCheckBoxes = new OrientablePanel(new GridBagLayout());
            this.cbShowItemContextToolBar = new JMnemonicCheckBox(new SwitchToolBarAction(StringResources.SHOW_ITEM_CONTEX_TOOLBAR, 900));
            pnlCheckBoxes.add((Component)this.cbShowItemContextToolBar, cs);
            ++cs.gridy;
            cs.weighty = 1.0;
            this.cbShowFolderContextToolBar = new JMnemonicCheckBox(new SwitchToolBarAction(StringResources.SHOW_FOLDER_CONTEX_TOOLBAR, 1340));
            pnlCheckBoxes.add((Component)this.cbShowFolderContextToolBar, cs);
            pnlTemp.add((Component)pnlCheckBoxes, "Center");
        }
        pnlShow.add((Component)pnlTemp, "Center");
        pnlShow.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tpMain.addTab(StringResources.SHOW, pnlShow);
    }

    private void buildCustomizePane() {
        GridBagConstraints cs = new GridBagConstraints();
        cs.gridy = 0;
        cs.gridwidth = 2;
        cs.insets = new Insets(5, 5, 5, 5);
        cs.fill = 2;
        HTMLLabel lbText = new HTMLLabel(StringResources.SELECT_A_CATEGORY_THEN_CLICK);
        cs.insets.bottom = 15;
        this.pnlCustomize.add((Component)lbText, cs);
        cs.insets.bottom = 5;
        ++cs.gridy;
        cs.gridwidth = 1;
        OrientablePanel pnlCategories = new OrientablePanel(new BorderLayout(5, 5));
        this.listCategories.setSelectionMode(0);
        OrientableScrollPane scroll = new OrientableScrollPane(this.listCategories);
        Dimension size = new Dimension(120, 100);
        scroll.setMinimumSize(size);
        scroll.setPreferredSize(size);
        pnlCategories.add((Component)scroll, "Center");
        this.addButtonAction = new AddButtonAction();
        this.addButtonAction.setEnabled(false);
        pnlCategories.add((Component)new OrientableButton(this.addButtonAction), "South");
        pnlCategories.add((Component)new OrientableLabel(StringResources.CATEGORIES_C), "North");
        cs.fill = 3;
        cs.weighty = 1.0;
        cs.insets.top = 0;
        this.pnlCustomize.add((Component)pnlCategories, cs);
        cs.insets.top = 5;
        List collection = this.actionList.getCategories();
        this.listCategories.setModel(new DefaultListModel());
        for (Object element : collection) {
            Category category = (Category)element;
            ((DefaultListModel)this.listCategories.getModel()).addElement(category);
        }
        this.listCategories.addListSelectionListener(new CategoryLSL());
        this.listCategories.setSelectedIndex(0);
        this.pnlControls.setBorder(BorderFactory.createTitledBorder(StringResources.CONTROLS));
        cs.weightx = 1.0;
        cs.fill = 1;
        cs.insets.top = 11;
        this.pnlCustomize.add((Component)this.pnlControls, cs);
        cs.insets.top = 5;
        ++cs.gridy;
        this.pnlDescription.setBorder(BorderFactory.createTitledBorder(StringResources.DESCRIPTION));
        cs.gridwidth = 2;
        cs.fill = 1;
        cs.weighty = 0.0;
        this.pnlDescription.setPreferredSize(new Dimension(10, 100));
        this.pnlDescription.setMinimumSize(new Dimension(10, 100));
        this.pnlCustomize.add((Component)this.pnlDescription, cs);
        this.pnlCustomize.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pnlCustomize.setPreferredSize(new Dimension(500, 410));
        this.tpMain.addTab(StringResources.CUSTOMIZE, this.pnlCustomize);
    }

    private JComponent buildDisplayOption() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbSingleRow);
        bg.add(this.rbMultipleRows);
        OrientablePanel pnlResult = new OrientablePanel(new BorderLayout());
        pnlResult.add((Component)this.rbSingleRow, "North");
        pnlResult.add((Component)this.rbMultipleRows, "South");
        this.rbSingleRow.setEnabled(this.toolBar.isMultipleRowLayoutAllowed());
        this.rbMultipleRows.setEnabled(this.toolBar.isMultipleRowLayoutAllowed());
        pnlResult.setBorder(BorderFactory.createTitledBorder(StringResources.DISPLAY_OPTIONS));
        return pnlResult;
    }

    private static JComponent buildToolBarPreviewPanel(ToolBarOptions.Style style) {
        OrientableLabel lbAB = new OrientableLabel(ImageResources.ICON_ACT_VIEW_ADDRESSBOOK);
        OrientableLabel lbFind = new OrientableLabel(ImageResources.ACT_FIND);
        OrientableLabel lbIP = new OrientableLabel(ImageResources.ACT_ITEM_PROPERTIES);
        switch (style) {
            case PICTURE_AND_SELECTED_TEXT: {
                ((JLabel)lbAB).setText(StringResources.ADDRESS_BOOK);
                break;
            }
            case PICTURE_AND_TEXT: {
                ((JLabel)lbAB).setText(StringResources.ADDRESS_BOOK);
                ((JLabel)lbFind).setText(StringResources.FIND);
                ((JLabel)lbIP).setText(StringResources.PROPERTY);
                lbAB.setHorizontalTextPosition(0);
                lbAB.setVerticalTextPosition(3);
                lbFind.setHorizontalTextPosition(0);
                lbFind.setVerticalTextPosition(3);
                lbIP.setHorizontalTextPosition(0);
                lbIP.setVerticalTextPosition(3);
            }
        }
        OrientablePanel result = new OrientablePanel();
        result.add(lbAB);
        result.add(lbFind);
        result.add(lbIP);
        return result;
    }

    private Container buildButtonsPane() {
        OrientablePanel pnlResult = new OrientablePanel(new FlowLayout(4));
        pnlResult.add(this.createOkCancelButtonsPanel());
        return pnlResult;
    }

    private void init() {
        switch (this.toolBar.getStyle()) {
            case PICTURE: {
                this.rbPicture.setSelected(true);
                break;
            }
            case PICTURE_AND_SELECTED_TEXT: {
                this.rbPIctureAndSelText.setSelected(true);
                break;
            }
            case PICTURE_AND_TEXT: {
                this.rbPictureAndText.setSelected(true);
                break;
            }
        }
        switch (this.toolBar.getLayoutId()) {
            case MULTIPLE_ROW_OF_BUTTONS: {
                this.rbMultipleRows.setSelected(true);
                break;
            }
            case SINGLE_ROW_OF_BUTTONS_ONLY: {
                this.rbSingleRow.setSelected(true);
                break;
            }
            default: {
                throw new AssertionError((Object)this.toolBar.getLayoutId());
            }
        }
        this.showItemContextToolBarInitValue = ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true);
        this.showFolderContextToolBarInitValue = ApplicationOptions.getInstance().getBoolean("FOLDER_CONTEXT_TOOLBAR_VISIBLE", true);
        if (this.isOwnerMainFrame()) {
            this.cbShowItemContextToolBar.setSelected(this.showItemContextToolBarInitValue);
            this.cbShowFolderContextToolBar.setSelected(this.showFolderContextToolBarInitValue);
        }
        this.toolBar.setCustomized(true);
    }

    private void addButtonToToolbar() {
        if (this.selectedInfo == null) {
            throw new IllegalStateException("selectedButtonInfo is null");
        }
        JComponent toolBarComponent = null;
        if (this.selectedInfo instanceof ActionInfo) {
            ActionInfo selectedActionInfo = (ActionInfo)this.selectedInfo;
            if (!this.toolBar.containsButton(selectedActionInfo.getComponentSource())) {
                toolBarComponent = ControlsUtils.setToSkinlessComponent(this.actionList.getAction(selectedActionInfo.getComponentSource()).getToolBarComponent());
                ((CustomizableToolBarComponent)((Object)toolBarComponent)).setShowTextLabel(selectedActionInfo.isShowWithText());
                ((CustomizableToolBarComponent)((Object)toolBarComponent)).setPreviewMode(true);
            }
        } else if (this.selectedInfo instanceof SeparatorInfo) {
            toolBarComponent = new CustomizableToolBarSeparator();
        }
        if (toolBarComponent == null) {
            logger.warn((Object)"toolBarComponent is null");
            return;
        }
        if (this.selectedInfo instanceof ActionInfo && this.toolbarConfig.contains(this.selectedInfo)) {
            throw new IllegalStateException();
        }
        this.toolbarConfig.add(ComponentInfo.getClone(this.selectedInfo));
        this.toolBar.add(toolBarComponent);
        this.toolBar.createDragListenerForComponent(toolBarComponent, ComponentInfo.getClone(this.selectedInfo));
        this.cbShowLabel.setEnabled(true);
        if (this.toolBar.getParent() != null) {
            ((JComponent)this.toolBar.getParent()).updateUI();
        }
        this.requestFocus();
    }

    private boolean isOwnerMainFrame() {
        return this.toolBar.getTopLevelAncestor() instanceof GWMainAppFrame;
    }

    private boolean isChanged() {
        boolean changed;
        ToolBarOptions options = OptionManager.getInstance().getToolBarsOptions().getToolBarOptions(this.toolBar.getName());
        ToolBarOptions.Style oldStyle = options.getStyle();
        ToolBarOptions.Layout oldLayout = options.getLayout();
        boolean bl = changed = oldStyle != this.toolBar.getStyle() || oldLayout != this.toolBar.getLayoutId();
        if (!changed && this.isOwnerMainFrame()) {
            changed = this.showItemContextToolBarInitValue != this.cbShowItemContextToolBar.isSelected() || this.showFolderContextToolBarInitValue != this.cbShowFolderContextToolBar.isSelected();
        }
        changed = changed || !((Object)options.getComponentInfos()).equals(this.toolbarConfig);
        return changed;
    }

    private void doConfirm() {
        if (this.isChanged()) {
            OptionManager optionManager = OptionManager.getInstance();
            ToolBarOptions options = optionManager.getToolBarsOptions().getToolBarOptions(this.toolBar.getName());
            options.setStyle(this.toolBar.getStyle());
            options.setLayout(this.toolBar.getLayoutId());
            options.setChanged(true);
            List<ComponentInfo> oldInfoList = options.getComponentInfos();
            this.toolbarConfig = CustomizeToolBarDialog.removeOddSeparators(this.toolbarConfig);
            if (!((Object)options.getComponentInfos()).equals(this.toolbarConfig)) {
                ActionInfo actionInfo;
                for (ComponentInfo componentInfo : oldInfoList) {
                    if (!(componentInfo instanceof ActionInfo)) continue;
                    actionInfo = (ActionInfo)componentInfo;
                    int index = ComponentInfo.indexOfAction(this.toolbarConfig, actionInfo.getComponentSource());
                    if (index == -1) {
                        componentInfo.setState(ToolBarOptions.State.REMOVED);
                        this.toolbarConfig.add(componentInfo);
                        continue;
                    }
                    this.toolbarConfig.get(index).setState(actionInfo.getState());
                }
                for (ComponentInfo componentInfo : this.toolbarConfig) {
                    if (!(componentInfo instanceof ActionInfo) || CustomizeToolBarDialog.containsAction(oldInfoList, (Object)(actionInfo = (ActionInfo)componentInfo).getComponentSource())) continue;
                    componentInfo.setState(ToolBarOptions.State.ADDED);
                }
                options.setComponentInfos(this.toolbarConfig);
            }
            try {
                optionManager.writeOptions(optionManager.getToolBarsOptions());
            }
            catch (GWCommandException e) {
                logger.error((Object)e);
            }
            this.actionList.processCommand(new GlobalCommand(1380, this.toolBar.getName()));
        }
        this.terminate();
    }

    private static List<ComponentInfo> removeOddSeparators(List<ComponentInfo> list) {
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>();
        boolean separatorBefore = false;
        for (ComponentInfo componentInfo : list) {
            if (componentInfo.equals(ComponentInfo.SEPARATOR_INFO)) {
                if (separatorBefore) continue;
                separatorBefore = true;
            } else {
                separatorBefore = false;
            }
            result.add(componentInfo);
        }
        return result;
    }

    public static boolean containsAction(List<ComponentInfo> infoList, Object o) {
        for (ComponentInfo componentInfo : infoList) {
            if (!o.equals(componentInfo.getComponentSource())) continue;
            return true;
        }
        return false;
    }

    private void doReject() {
        if (this.isChanged()) {
            if (this.isOwnerMainFrame()) {
                if (this.showItemContextToolBarInitValue != this.cbShowItemContextToolBar.isSelected()) {
                    ApplicationOptions.getInstance().put("ITEM_CONTEXT_TOOLBAR_VISIBLE", this.showItemContextToolBarInitValue);
                    this.toolBar.getController().processCommand(new Command(900));
                }
                if (this.showFolderContextToolBarInitValue != this.cbShowFolderContextToolBar.isSelected()) {
                    ApplicationOptions.getInstance().put("FOLDER_CONTEXT_TOOLBAR_VISIBLE", this.showFolderContextToolBarInitValue);
                    this.toolBar.getController().processCommand(new Command(1340));
                }
            }
            this.toolBar.rebuild();
        }
        this.terminate();
    }

    private void terminate() {
        this.unregisterDragListeners();
        this.pnlDescription.removeAll();
        this.pnlControls.removeAll();
        this.toolBar.setCustomized(false);
    }

    private boolean containsButtonInList(ComponentInfo componentInfo) {
        for (ComponentInfo element : this.toolbarConfig) {
            if (!element.getComponentSource().equals(componentInfo.getComponentSource())) continue;
            return true;
        }
        return false;
    }

    private ComponentInfo getButtonInfoFromList(ComponentInfo componentInfo) {
        for (ComponentInfo element : this.toolbarConfig) {
            if (!element.getComponentSource().equals(componentInfo.getComponentSource())) continue;
            return element;
        }
        return null;
    }

    private boolean showTextLabel(ComponentInfo componentInfo) {
        if (this.containsButtonInList(componentInfo)) {
            return (componentInfo = this.getButtonInfoFromList(componentInfo)) instanceof ActionInfo && ((ActionInfo)componentInfo).isShowWithText();
        }
        if (componentInfo instanceof ActionInfo) {
            ActionInfo actionInfo = (ActionInfo)componentInfo;
            return actionInfo.isShowWithText();
        }
        return false;
    }

    private void changeShowText() {
        if (this.selectedInfo instanceof ActionInfo) {
            ActionInfo infoFromList;
            boolean showTextLabel = (infoFromList = (ActionInfo)this.getButtonInfoFromList(this.selectedInfo)).isShowWithText();
            infoFromList.setShowWithText(!showTextLabel);
            CustomizableToolBarComponent button = this.toolBar.getButton(infoFromList.getComponentSource());
            button.setShowTextLabel(!showTextLabel);
            button.changeComponentStyle(this.toolBar.getStyle());
            this.previewButton.setShowTextLabel(!showTextLabel);
            this.previewButton.changeComponentStyle(this.toolBar.getStyle());
        }
    }

    private void switchToolBar(int commandId) {
        if (commandId != 900 && commandId != 1340) {
            throw new IllegalArgumentException("this commandId is not supported: " + commandId);
        }
        logger.debug((Object)("commandId: " + commandId));
        switch (commandId) {
            case 900: {
                ApplicationOptions.getInstance().put("ITEM_CONTEXT_TOOLBAR_VISIBLE", this.cbShowItemContextToolBar.isSelected());
                break;
            }
            case 1340: {
                ApplicationOptions.getInstance().put("FOLDER_CONTEXT_TOOLBAR_VISIBLE", this.cbShowFolderContextToolBar.isSelected());
            }
        }
        this.toolBar.getController().processCommand(new Command(commandId));
    }

    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<CustomizeToolBarDialog>(this, parentController);
    }

    @Override
    protected void processCancelAction(ActionEvent event) {
        super.processCancelAction(event);
        this.doReject();
        this.dispose();
    }

    @Override
    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        this.doReject();
        this.dispose();
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        this.doConfirm();
        this.dispose();
    }

    public static CustomizeToolBarDialog getInstance(ApplicationFrame frame, ApplicationFrameToolBar toolBar) {
        if (instance != null) {
            if (CustomizeToolBarDialog.instance.frameOwner == frame) {
                logger.debug((Object)"the same frame - rebuilding dialog");
                instance.doReject();
                instance.rebuild(frame, toolBar);
                logger.debug((Object)("rebuilded for tool bar [" + toolBar.getName() + ']'));
                return instance;
            }
            logger.debug((Object)"different frame - disposing and recreating dialog");
            instance.doReject();
            instance.dispose();
            instance = null;
            logger.debug((Object)"instance nullified");
        }
        if (instance == null) {
            instance = new CustomizeToolBarDialog(frame, toolBar);
            logger.debug((Object)("Created for tool bar [" + toolBar.getName() + ']'));
            return instance;
        }
        return instance;
    }

    public static CustomizeToolBarDialog getInstance() {
        return instance;
    }

    public ApplicationFrameToolBar getToolBar() {
        return this.toolBar;
    }

    public void showMe() {
        this.pack();
        this.setLocationRelativeTo(this.frameOwner);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public void updateToolBarConfig() {
        Component[] components;
        logger.debug((Object)("toolbar config before updating, size: " + this.toolbarConfig.size()));
        this.toolbarConfig.clear();
        for (Component component : components = this.toolBar.getComponents()) {
            if (!(component instanceof CustomizableToolBarComponent)) continue;
            this.toolbarConfig.add(ComponentInfo.getInstance((CustomizableToolBarComponent)((Object)component)));
        }
        this.updateCbShowLabel();
        logger.debug((Object)("toolbar config filled, size: " + this.toolbarConfig.size()));
    }

    public void unregisterDragListeners() {
        for (ToolBarComponentDragListener listener : this.componentDragListenerList) {
            listener.clear();
        }
        this.componentDragListenerList.clear();
    }

    private void updateCbShowLabel() {
        if (this.selectedInfo == null) {
            this.cbShowLabel.setEnabled(false);
            return;
        }
        boolean enabled = this.containsButtonInList(this.selectedInfo) && this.rbPIctureAndSelText.isSelected();
        this.cbShowLabel.setEnabled(enabled);
        if (this.rbPicture.isSelected()) {
            this.cbShowLabel.setSelected(false);
        } else if (this.rbPictureAndText.isSelected()) {
            this.cbShowLabel.setSelected(true);
        } else {
            this.cbShowLabel.setSelected(this.showTextLabel(this.selectedInfo));
        }
        if (this.previewButton != null) {
            this.previewButton.changeComponentStyle(this.getCurrentStyle());
        }
    }

    private ToolBarOptions.Style getCurrentStyle() {
        if (this.rbPicture.isSelected()) {
            return ToolBarOptions.Style.PICTURE;
        }
        if (this.rbPictureAndText.isSelected()) {
            return ToolBarOptions.Style.PICTURE_AND_TEXT;
        }
        return ToolBarOptions.Style.PICTURE_AND_SELECTED_TEXT;
    }

    private void separatorSelected() {
        this.pnlDescription.removeAll();
        GWToolBar pnlButton = new GWToolBar(new GridBagLayout());
        pnlButton.setBorder(null);
        OrientableLabel toolBarComponent = new OrientableLabel(StringResources.SEPARATOR);
        this.selectedInfo = ComponentInfo.SEPARATOR_INFO;
        this.previewButton = new CustomizableToolBarSeparator();
        GridBagConstraints cs = new GridBagConstraints();
        cs.anchor = 23;
        cs.insets.left = 5;
        cs.gridx = 0;
        cs.gridy = 0;
        pnlButton.add((Component)toolBarComponent, cs);
        GWTextArea lbl = new GWTextArea();
        lbl.setEditable(false);
        lbl.setOpaque(false);
        lbl.setText(StringResources.DESCRIPTION_SEPARATOR);
        cs.fill = 1;
        cs.gridx = 1;
        cs.weightx = 1.0;
        pnlButton.add((Component)lbl, cs);
        cs = new GridBagConstraints();
        cs.gridy = 0;
        cs.fill = 1;
        cs.weightx = 1.0;
        cs.anchor = 23;
        this.pnlDescription.add((Component)pnlButton, cs);
        this.pnlDescription.updateUI();
        this.addButtonAction.setEnabled(true);
        this.updateCbShowLabel();
    }

    public void createDragListenerForComponent(JComponent component, ComponentInfo componentInfo) {
        ToolBarComponentTransferData componentTransferData = new ToolBarComponentTransferData(component, ComponentInfo.getClone(componentInfo));
        ToolBarComponentDragListener listener = new ToolBarComponentDragListener(component, 1, new TransferableToolBarComponent(componentTransferData));
        this.componentDragListenerList.add(listener);
    }

    private class SwitchToolBarAction
    extends AbstractAction {
        private int commandId;

        public SwitchToolBarAction(String name, int commandId) {
            super(name);
            this.commandId = commandId;
        }

        public void actionPerformed(ActionEvent e) {
            CustomizeToolBarDialog.this.switchToolBar(this.commandId);
        }
    }

    private class ChangeToolBarLayoutAction
    extends AbstractAction {
        private ToolBarOptions.Layout layout;

        public ChangeToolBarLayoutAction(String name, ToolBarOptions.Layout layout) {
            super(name);
            this.layout = layout;
        }

        public void actionPerformed(ActionEvent e) {
            CustomizeToolBarDialog.this.toolBar.changeToolBarLayout(this.layout);
        }
    }

    private class ChangeShowTextAction
    extends AbstractAction {
        public ChangeShowTextAction() {
            super(StringResources.SHOW_LABEL);
        }

        public void actionPerformed(ActionEvent e) {
            CustomizeToolBarDialog.this.changeShowText();
        }
    }

    private class CategoryLSL
    implements ListSelectionListener {
        private CategoryLSL() {
        }

        public void valueChanged(ListSelectionEvent e) {
            CustomizeToolBarDialog.this.unregisterDragListeners();
            JList list = (JList)e.getSource();
            Category category = (Category)list.getModel().getElementAt(list.getSelectedIndex());
            List<ActionKey> actions = category.getActions();
            CustomizeToolBarDialog.this.pnlDescription.removeAll();
            CustomizeToolBarDialog.this.pnlControls.removeAll();
            for (ActionKey actionKey : actions) {
                AppAction appAction = CustomizeToolBarDialog.this.actionList.getAction(actionKey);
                JComponent toolBarComponent = ControlsUtils.setToSkinlessComponent(appAction.getToolBarComponent());
                ((CustomizableToolBarComponent)((Object)toolBarComponent)).setPreviewMode(true);
                ((CustomizableToolBarComponent)((Object)toolBarComponent)).changeComponentStyle(ToolBarOptions.Style.PICTURE);
                ActionInfo actionInfo = (ActionInfo)ComponentInfo.getInstance((Object)actionKey);
                ((CustomizableToolBarComponent)((Object)toolBarComponent)).addDefaultActionListener(new SelectButtonActionListener(actionInfo));
                CustomizeToolBarDialog.this.createDragListenerForComponent(toolBarComponent, actionInfo);
                CustomizeToolBarDialog.this.pnlControls.add(toolBarComponent);
            }
            if (!actions.isEmpty()) {
                JComponent separator = CustomizeToolBarDialog.this.lbSepatator;
                separator.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        CustomizeToolBarDialog.this.separatorSelected();
                        super.mouseClicked(e);
                    }
                });
                CustomizeToolBarDialog.this.createDragListenerForComponent(separator, ComponentInfo.SEPARATOR_INFO);
                CustomizeToolBarDialog.this.pnlControls.add(separator);
            }
            CustomizeToolBarDialog.this.addButtonAction.setEnabled(false);
            CustomizeToolBarDialog.this.pnlCustomize.updateUI();
        }
    }

    private class SelectButtonActionListener
    implements ActionListener {
        private ActionInfo actionInfo;

        public SelectButtonActionListener(ActionInfo actionInfo) {
            this.actionInfo = actionInfo;
        }

        public void actionPerformed(ActionEvent e) {
            JComponent comp;
            if (CustomizeToolBarDialog.this.currentSelectedInControlsButton != null) {
                comp = (JComponent)((Object)CustomizeToolBarDialog.this.currentSelectedInControlsButton);
                if (comp.getParent() != null && comp.getParent() instanceof ListPopupPane) {
                    comp = (ListPopupPane)comp.getParent();
                }
                ((CustomizableToolBarComponent)((Object)comp)).setAlwaysPressed(false);
            }
            if ((comp = (JComponent)e.getSource()).getParent() != null && comp.getParent() instanceof ListPopupPane) {
                comp = (ListPopupPane)comp.getParent();
            }
            ((CustomizableToolBarComponent)((Object)comp)).setAlwaysPressed(true);
            CustomizeToolBarDialog.this.currentSelectedInControlsButton = (CustomizableToolBarComponent)e.getSource();
            CustomizeToolBarDialog.this.pnlDescription.removeAll();
            GWToolBar pnlButton = new GWToolBar(new GridBagLayout());
            pnlButton.setBorder(null);
            AppAction appAction = CustomizeToolBarDialog.this.actionList.getAction(this.actionInfo.getComponentSource());
            JComponent toolBarComponent = ControlsUtils.setToSkinlessComponent(appAction.getToolBarComponent());
            CustomizeToolBarDialog.this.selectedInfo = this.actionInfo;
            CustomizeToolBarDialog.this.previewButton = (CustomizableToolBarComponent)((Object)toolBarComponent);
            CustomizeToolBarDialog.this.previewButton.setPreviewMode(true);
            boolean showWithText = CustomizeToolBarDialog.this.showTextLabel(this.actionInfo);
            CustomizeToolBarDialog.this.previewButton.setShowTextLabel(showWithText);
            CustomizeToolBarDialog.this.previewButton.changeComponentStyle(CustomizeToolBarDialog.this.getCurrentStyle());
            GridBagConstraints cs = new GridBagConstraints();
            cs.anchor = 23;
            cs.insets.left = 5;
            cs.gridx = 0;
            cs.gridy = 0;
            pnlButton.add((Component)toolBarComponent, cs);
            GWTextArea lbl = new GWTextArea();
            lbl.setEditable(false);
            lbl.setOpaque(false);
            String description = appAction.getDescription();
            if (description == null || description.equals("")) {
                description = appAction.getToolTipText();
            }
            lbl.setText(description);
            cs.fill = 1;
            cs.gridx = 1;
            cs.weightx = 1.0;
            pnlButton.add((Component)lbl, cs);
            cs = new GridBagConstraints();
            cs.gridy = 0;
            cs.fill = 1;
            cs.weightx = 1.0;
            cs.anchor = 23;
            CustomizeToolBarDialog.this.pnlDescription.add((Component)pnlButton, cs);
            ++cs.gridy;
            cs.insets.left = 5;
            cs.insets.top = 5;
            CustomizeToolBarDialog.this.pnlDescription.add((Component)CustomizeToolBarDialog.this.cbShowLabel, cs);
            CustomizeToolBarDialog.this.pnlDescription.updateUI();
            CustomizeToolBarDialog.this.addButtonAction.setEnabled(true);
            CustomizeToolBarDialog.this.updateCbShowLabel();
        }
    }

    private class AddButtonAction
    extends AbstractAction {
        public AddButtonAction() {
            super(StringResources.ADD_BUTTON);
        }

        public void actionPerformed(ActionEvent e) {
            CustomizeToolBarDialog.this.addButtonToToolbar();
        }
    }

    private class ChangeButtonStyleAction
    extends AbstractAction {
        private ToolBarOptions.Style style;

        public ChangeButtonStyleAction(String name, ToolBarOptions.Style style) {
            super(name);
            this.style = style;
        }

        public void actionPerformed(ActionEvent e) {
            CustomizeToolBarDialog.this.toolBar.changeToolBarButtonsView(this.style);
            CustomizeToolBarDialog.this.updateCbShowLabel();
        }
    }
}

