/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.appframework.ApplicationFrame;
import com.appframework.components.JListElementWrapper;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.ColorScheme;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.toolbars.navigation.MultipleCheckFoldersTree;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NavBarConfigDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(NavBarConfigDialog.class);
    private NavBarPanel navigationBar = null;
    private OrientableLabel lblDescLine1 = new OrientableLabel(StringResources.LABEL_NAVBAR_DESC_LINE1);
    private OrientableLabel lblDescLine2 = new OrientableLabel(StringResources.LABEL_NAVBAR_DESC_LINE2);
    private OrientableLabel lblFolder = new OrientableLabel(StringResources.LABEL_FOLDER_LIST);
    private OrientableLabel lblThemes = new OrientableLabel(StringResources.LABEL_COLOR_THEMES);
    private MultipleCheckFoldersTree treeFolders;
    private OrientableComboBox cbxThemes;

    NavBarConfigDialog(MVCController controller, NavBarPanel navigationBar) {
        ColorScheme[] values = ColorScheme.sortedValues();
        Object[] wrappers = new JListElementWrapper[values.length];
        for (int i = 0; i < values.length; ++i) {
            wrappers[i] = new JListElementWrapper<ColorScheme>(values[i], "getLocalizedName");
        }
        this.cbxThemes = new OrientableComboBox(wrappers);
        this.setTitle(StringResources.ACTION_CUSTOMIZE_NAVBAR);
        this.setModal(true);
        this.navigationBar = navigationBar;
        ApplicationFrame appFrame = GWClient.getActiveFrame();
        if (appFrame instanceof GWMainAppFrame) {
            GWMainAppFrame frame = (GWMainAppFrame)appFrame;
            String userGuid = frame.getUserGuid();
            this.treeFolders = new MultipleCheckFoldersTree(controller, userGuid, navigationBar.getNavBarModel().getVisibleFolderList());
            this.expandAll(this.treeFolders, true);
        }
        this.init();
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        NavBarConfigDialog.expandAll(tree, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                NavBarConfigDialog.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public List<AbstractFolder> getSelectedFolderList() {
        if (this.isActionCompleteSuccessfully() && this.treeFolders.isFolderListChanged() && !this.treeFolders.getSelectedFolderList().isEmpty()) {
            return this.treeFolders.getSelectedFolderList();
        }
        return this.navigationBar.getNavBarModel().getVisibleFolderList();
    }

    private void init() {
        this.getContentPane().removeAll();
        this.selectInitialColorScheme();
        this.lblThemes.setLabelFor(this.cbxThemes);
        if (LookAndFeelManager.isGtkLookAndFeel()) {
            this.cbxThemes.setEnabled(false);
        }
        this.lblFolder.setLabelFor(this.treeFolders);
        JPanel p = (JPanel)this.getContentPane();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 21;
        gc.insets = new Insets(10, 10, 0, 10);
        p.add((Component)this.lblDescLine1, gc);
        ++gc.gridy;
        gc.insets = new Insets(0, 10, 0, 10);
        p.add((Component)this.lblDescLine2, gc);
        ++gc.gridy;
        gc.insets = new Insets(5, 10, 0, 10);
        p.add((Component)this.lblFolder, gc);
        JScrollPane sp = new JScrollPane(this.treeFolders);
        ++gc.gridy;
        gc.insets = new Insets(0, 10, 0, 10);
        p.add((Component)sp, gc);
        ++gc.gridy;
        gc.insets = new Insets(10, 10, 0, 10);
        p.add((Component)this.lblThemes, gc);
        ++gc.gridy;
        gc.insets = new Insets(0, 10, 20, 10);
        p.add((Component)this.cbxThemes, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.insets = new Insets(10, 10, 10, 10);
        gc.anchor = 11;
        gc.fill = 2;
        gc.gridheight = 2;
        p.add((Component)this.btnOK, gc);
        gc.gridy += 2;
        gc.insets = new Insets(10, 10, 0, 10);
        p.add((Component)this.btnCancel, gc);
        this.setResizable(false);
    }

    private void selectInitialColorScheme() {
        String userGuid = EngineCommandManager.getUserGuid();
        int apiId = GWCommandManager.getInstance(userGuid).getAppearanceSettings().getColorScheme().getApiId();
        for (int i = 0; i < this.cbxThemes.getItemCount(); ++i) {
            if (((ColorScheme)((Object)((JListElementWrapper)this.cbxThemes.getItemAt(i)).getObject())).getApiId() != apiId) continue;
            this.cbxThemes.setSelectedIndex(i);
            return;
        }
        assert (false) : "no color scheme is selected";
    }

    ColorScheme getSelectedColorScheme() {
        if (this.isActionCompleteSuccessfully()) {
            return (ColorScheme)((Object)((JListElementWrapper)this.cbxThemes.getSelectedItem()).getObject());
        }
        return null;
    }

    @Override
    public void dispose() {
        this.treeFolders.clear();
        super.dispose();
    }
}

