/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.appframework.ApplicationFrame;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.folder.ActionMoreFolders;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.toolbars.navigation.CustomFolderAction;
import com.novell.gw.jclient.application.controls.toolbars.navigation.CustomizeNavBarAction;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButton;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPopupRadioMenuItem;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class NavBarMenuButton
extends NavBarButton {
    private boolean menuBarVisible = true;
    private boolean folderItemsVisible = true;
    private final Dimension mySize = new Dimension(24, 24);
    private static final Insets NAVBAR_MENU_BUTTON_INSETS = new Insets(0, 0, 4, 0);
    private List menuList = null;
    private JPopupMenu popupMenu = null;
    private MenuBar menuBarComponent = null;
    private JMenuBar mainMenuBar = null;

    public NavBarMenuButton(NavBarPanel navBarPanel) {
        super(ImageResources.ARROW_DOWN, navBarPanel);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                NavBarMenuButton.this.showPopupMenu(e.getPoint());
            }
        });
        this.setIcon(ImageResources.ARROW_DOWN);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setToolTipText(StringResources.TOOLTIP_NAVBAR_OPTIONS);
    }

    public Dimension getSize() {
        Dimension oldPrefSize = this.mySize;
        Dimension oldSize = super.getSize();
        int w = oldSize.width;
        if (oldPrefSize != null) {
            w = Math.max(w, oldPrefSize.width);
        }
        Dimension newSize = new Dimension(w, w);
        return newSize;
    }

    public Rectangle getBounds() {
        Rectangle r = super.getBounds();
        Dimension d = this.getSize();
        Rectangle nr = new Rectangle(r.x, r.y, Math.max(d.width, r.width), r.height);
        return nr;
    }

    public void setBounds(int x, int y, int w, int h) {
        Dimension d = this.getSize();
        super.setBounds(x, y, Math.max(w, d.width), h);
    }

    public Dimension getMinimumSize() {
        return this.mySize;
    }

    public Dimension getPreferredSize() {
        return this.mySize;
    }

    public Insets getInsets() {
        return NAVBAR_MENU_BUTTON_INSETS;
    }

    private boolean rebuildFolderItems() {
        boolean popupRecreated = false;
        if (this.folderItemsVisible) {
            ActionMoreFolders actionMoreFolders;
            int n;
            SelectFolderMenu mnuSelectFolder = new SelectFolderMenu();
            ApplicationFrame appFrame = GWClient.getActiveFrame();
            GWMainAppFrame frame = null;
            frame = appFrame instanceof GWMainAppFrame ? (GWMainAppFrame)appFrame : GWClient.getGWMainAppFrame();
            AbstractFolder selectedFolder = frame.getFolder();
            ButtonGroup bg = new ButtonGroup();
            List folders = this.masterPanel.getInvisibleFolderList();
            AbstractFolder root = null;
            int n2 = n = folders == null ? -1 : folders.size();
            for (int i = 0; i < n; ++i) {
                AbstractFolder currentFolder = (AbstractFolder)folders.get(i);
                if (i == 0) {
                    root = currentFolder;
                }
                if (i > 0 && currentFolder.getParent() != null && currentFolder.getParent().getID() != null && !currentFolder.getParent().getID().equals(root.getID())) continue;
                boolean folderSelected = selectedFolder != null && currentFolder != null && selectedFolder == currentFolder;
                CustomFolderAction action = new CustomFolderAction(currentFolder);
                NavBarPopupRadioMenuItem menuItem = new NavBarPopupRadioMenuItem(action);
                ((AbstractButton)menuItem).setSelected(folderSelected);
                mnuSelectFolder.add(menuItem);
                bg.add(menuItem);
            }
            if (mnuSelectFolder.getItemCount() > 0) {
                mnuSelectFolder.add(new JSeparator(0));
            }
            if ((actionMoreFolders = (ActionMoreFolders)this.masterPanel.getController().getActionList().getAction(ActionKey.SELECT_MORE_FOLDERS)) != null) {
                mnuSelectFolder.add(actionMoreFolders.getMenuItem());
            }
            if (this.popupMenu == null) {
                this.popupMenu = new GWPopupMenu();
                popupRecreated = true;
            }
            if (this.popupMenu.getComponentCount() > 1) {
                Component firstComponent = this.popupMenu.getComponent(0);
                Component secondComponent = this.popupMenu.getComponent(1);
                if (firstComponent instanceof SelectFolderMenu && secondComponent instanceof JSeparator) {
                    this.popupMenu.remove(1);
                    this.popupMenu.remove(0);
                }
            }
            if (mnuSelectFolder.getItemCount() > 0) {
                this.popupMenu.add((Component)mnuSelectFolder, 0);
                this.popupMenu.add((Component)new JSeparator(0), 1);
            }
        } else if (this.popupMenu != null && this.popupMenu.getComponentCount() > 1) {
            Component firstComponent = this.popupMenu.getComponent(0);
            Component secondComponent = this.popupMenu.getComponent(1);
            if (firstComponent instanceof SelectFolderMenu && secondComponent instanceof JSeparator) {
                this.popupMenu.remove(1);
                this.popupMenu.remove(0);
            }
        }
        return popupRecreated;
    }

    private void showPopupMenu(Point p) {
        JPopupMenu menu;
        this.setSelected(false);
        boolean popupRecreated = this.rebuildFolderItems();
        if (this.popupMenu != null && !popupRecreated) {
            this.popupMenu.show(this, p.x, p.y);
            return;
        }
        JPopupMenu jPopupMenu = menu = this.popupMenu == null ? new GWPopupMenu() : this.popupMenu;
        if (this.menuBarVisible) {
            menu.add(new HideMenuBarAction());
        } else {
            this.addMenuBarContents(menu);
            menu.add(new ShowMenuBarAction());
        }
        menu.add(new JSeparator(0));
        menu.add(new CustomizeNavBarAction(this.masterPanel));
        menu.show(this, p.x, p.y);
        this.popupMenu = menu;
    }

    public void invalidatePopup() {
        this.popupMenu = null;
    }

    private void addMenuBarContents(JPopupMenu popup) {
        JMenuBar menuBar = this.retrieveMenuBar();
        if (menuBar != null) {
            while (menuBar.getMenuCount() > 0) {
                JMenu menu = menuBar.getMenu(0);
                popup.add(menu);
                this.updateUI(menu);
            }
        }
    }

    private void updateUI(JMenu menu) {
        for (Component component : menu.getMenuComponents()) {
            if (component instanceof JMenu) {
                this.updateUI((JMenu)component);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            ((JMenuItem)component).updateUI();
        }
    }

    public boolean isMenuBarVisible() {
        return this.menuBarVisible;
    }

    public void setMenuBarVisible(boolean menuBarVisible) {
        if (this.menuBarVisible != menuBarVisible) {
            this.invalidatePopup();
        }
        this.menuBarVisible = menuBarVisible;
        JMenuBar menuBar = this.retrieveMenuBar();
        if (menuBar != null) {
            JFrame parent;
            if (this.menuBarVisible && menuBar.getMenuCount() < 1 && this.menuList != null) {
                int n = this.menuList.size();
                for (int i = 0; i < n; ++i) {
                    JMenu menu = (JMenu)this.menuList.get(i);
                    menuBar.add(menu);
                }
                this.menuList.clear();
                this.menuList = null;
            }
            menuBar.setVisible(this.menuBarVisible);
            if (OS.isMacOS() && (parent = (JFrame)SwingUtilities.getWindowAncestor(this)) != null) {
                if (!this.menuBarVisible) {
                    this.mainMenuBar = menuBar;
                    MenuBar mb = parent.getMenuBar();
                    if (mb != null) {
                        parent.setJMenuBar(null);
                        this.menuBarComponent = mb;
                        parent.remove(mb);
                    }
                } else if (this.mainMenuBar != null) {
                    JMenuBar res = this.mainMenuBar;
                    this.mainMenuBar = null;
                    if (this.menuBarComponent != null) {
                        parent.setMenuBar(this.menuBarComponent);
                        this.menuBarComponent = null;
                        res.setVisible(true);
                        parent.setJMenuBar(res);
                    }
                }
            }
        }
    }

    private JMenuBar retrieveMenuBar() {
        JMenuBar res = null;
        Container c = this.getParent();
        for (int i = 0; c != null && !(c instanceof JFrame) && i < 50; c = c.getParent(), ++i) {
        }
        if (c != null && c instanceof JFrame) {
            JFrame f = (JFrame)c;
            res = f.getJMenuBar();
            if (this.menuList == null) {
                this.menuList = new ArrayList();
                int n = res.getMenuCount();
                for (int ii = 0; ii < n; ++ii) {
                    JMenu menu = res.getMenu(ii);
                    this.menuList.add(menu);
                }
            }
        }
        if (OS.isMacOS() && res == null && (res = this.mainMenuBar) == null) {
            res = new GWMenuBar();
        }
        return res;
    }

    public boolean isFolderItemsVisible() {
        return this.folderItemsVisible;
    }

    public void setFolderItemsVisible(boolean folderItemsVisible) {
        if (this.folderItemsVisible != folderItemsVisible) {
            this.folderItemsVisible = folderItemsVisible;
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)UIUtils.enableAntialiasing(g);
        Color highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.BACK_TOP_END_COLOR);
        Color highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.BACKGROUND_COLOR);
        Color lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.BACK_TOP_END_COLOR);
        Color lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.BACKGROUND_COLOR);
        Color textColor = this.getForeground();
        Color borderColor = null;
        boolean paintSegments = true;
        if (this.getModel().isRollover()) {
            highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.SEL_START_COLOR);
            highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
            lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
            lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
            textColor = (Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR);
            borderColor = (Color)this.getClientProperty((Object)SkinProperty.HILITE_BORDER_COLOR);
        } else {
            paintSegments = false;
        }
        int deltaW = 2;
        int deltaH = 2;
        if (paintSegments) {
            int w = this.mySize.width - 1 - 2 * deltaW;
            int h = this.getSize().height - 2 * deltaH;
            GeneralPath border = new GeneralPath();
            border.moveTo(4 + deltaW, 1 + deltaH);
            border.lineTo(3 + deltaW, 1 + deltaH);
            border.lineTo(1 + deltaW, 3 + deltaH);
            border.lineTo(1 + deltaW, 4 + deltaH);
            border.lineTo(0 + deltaH, 5 + deltaH);
            border.lineTo(0 + deltaW, h - 6);
            border.lineTo(1 + deltaW, h - 5);
            border.lineTo(1 + deltaW, h - 4);
            border.lineTo(3 + deltaW, h - 2);
            border.lineTo(4 + deltaW, h - 2);
            border.lineTo(5 + deltaW, h - 1);
            border.lineTo(w - 6, h - 1);
            border.lineTo(w - 5, h - 2);
            border.lineTo(w - 4, h - 2);
            border.lineTo(w - 2, h - 4);
            border.lineTo(w - 2, h - 5);
            border.lineTo(w - 1, h - 6);
            border.lineTo(w - 1, 5 + deltaH);
            border.lineTo(w - 2, 4 + deltaH);
            border.lineTo(w - 2, 3 + deltaH);
            border.lineTo(w - 4, 1 + deltaH);
            border.lineTo(w - 5, 1 + deltaH);
            border.lineTo(w - 6, 0 + deltaH);
            border.lineTo(5 + deltaW, 0 + deltaH);
            GradientPaint paintHigherSegment = new GradientPaint(deltaW, deltaH, highSegmentColorFrom, deltaW, deltaH + (int)((double)this.getHeight() * 0.25), highSegmentColorTo);
            g2D.setPaint(paintHigherSegment);
            g2D.fill(border);
            GradientPaint paintLowerSegment = new GradientPaint(deltaW, deltaH + (int)((double)this.getHeight() * 0.25), lowSegmentColorFrom, deltaW, this.getHeight() - 2 * deltaH, lowSegmentColorTo);
            g2D.setPaint(paintLowerSegment);
            g2D.fill(border);
            if (borderColor != null) {
                g2D.setColor(borderColor);
                g2D.draw(border);
            }
        }
        g2D.setColor(textColor);
        g2D.setFont(this.masterPanel.getFont());
        if (this.getIcon() != null) {
            Rectangle r = this.getBounds();
            Dimension btnSize = this.getSize();
            int iw = this.getIcon().getIconWidth();
            int ih = this.getIcon().getIconHeight();
            Point p = new Point((r.width - iw - deltaW) / 2, (btnSize.height - ih) / 2);
            g2D.drawImage(((ImageIcon)this.getIcon()).getImage(), p.x, p.y, this);
        }
    }

    class HideMenuBarAction
    extends AbstractAction {
        public HideMenuBarAction() {
            super(StringResources.ACTION_HIDE_MAIN_MENU);
        }

        public void actionPerformed(ActionEvent e) {
            NavBarMenuButton.this.masterPanel.setMainMenuVisible(false, true);
        }
    }

    class ShowMenuBarAction
    extends AbstractAction {
        public ShowMenuBarAction() {
            super(StringResources.ACTION_DISPLAY_MAIN_MENU);
        }

        public void actionPerformed(ActionEvent e) {
            NavBarMenuButton.this.masterPanel.setMainMenuVisible(true, true);
        }
    }

    static class SelectFolderMenu
    extends GWMenu {
        public SelectFolderMenu() {
            super(StringResources.ACTION_SELECT_FOLDER);
        }
    }
}

