/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.resources.ImageResources;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.ColorScheme;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWMouseAdapter;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FolderPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.menus.ReducedFolderPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.ComponentPropertyManager;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.controls.toolbars.navigation.ChevronPanel;
import com.novell.gw.jclient.application.controls.toolbars.navigation.CustomFolderAction;
import com.novell.gw.jclient.application.controls.toolbars.navigation.CustomizeNavBarAction;
import com.novell.gw.jclient.application.controls.toolbars.navigation.InsertPosition;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButton;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButtonTransferData;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButtonTransferable;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarConfigDialog;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarDropTargetListener;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarMenuButton;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarModel;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanelController;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavBarPanel
extends SkinnablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger(NavBarPanel.class);
    private NavBarModel navBarModel;
    private boolean separatorVisible = true;
    private List<NavBarButton> buttonList = new ArrayList<NavBarButton>();
    private List<AbstractFolder> folderList = new ArrayList<AbstractFolder>();
    private List<FolderPopupMouseListener> buttonPopupListenerList = new ArrayList<FolderPopupMouseListener>();
    private Font defaultFont;
    private Font panelFont = this.defaultFont = new Font(PLAFChanger.getFontName(), 0, PLAFChanger.getFontSize());
    private NavBarMenuButton menuButton = new NavBarMenuButton(this);
    private JPanel pnlFolders = new ChevronPanel(0, 0, this);
    private JPanel pnlButtons = new OrientablePanel();
    private JButton btnFolderList;
    private JButton btnShowHideQuickViewer;
    private JButton btnShowHideMainMenu;
    private JPopupMenu popupMenu = new NavBarPopupMenu();
    private ButtonGroup bg = new ButtonGroup();
    private boolean navbarOptionsSupported = false;
    private DropTarget dropTarget;
    private IndicatorPainter indicatorPainter = new IndicatorPainter();
    private boolean reorderingFolderButtonsMode = false;
    public static final int PERMITTED_DRAG_FOLDER_BUTTON_ACTIONS = 2;
    private boolean isDefaultNavBarFontSizeSet = true;
    private NavBarPanelController controller;

    public NavBarPanel(GWMainAppFrameActionList actionList) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.BACKGROUND_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.BACK_TOP_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.BOTTOM_START_COLOR, ComponentProperty.CUSTOM);
        assert (actionList != null) : "actionList is null";
        this.controller = new NavBarPanelController(this, (MVCController)actionList);
        if (actionList != null) {
            this.initActions(actionList);
        }
        this.buildUI();
        this.navBarModel = new NavBarModel(this);
        this.addMouseListener(new PopupActionListener());
        this.pnlFolders.addMouseListener(new PopupActionListener());
        this.dropTarget = new DropTarget(this, 3, new NavBarDropTargetListener(this));
    }

    private String getUserGuid() {
        if (this.controller == null) {
            throw new IllegalStateException("controller not initialized yet");
        }
        return ControlsUtils.getUserGuid(this.controller);
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setController(MVCController controller) {
        if (!(controller instanceof NavBarPanelController)) {
            throw new IllegalArgumentException("ilelgal controller: " + controller);
        }
        this.controller = (NavBarPanelController)controller;
    }

    public Object getMVCModel() {
        return null;
    }

    public void setMVCModel(Object model) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)UIUtils.enableAntialiasing(g);
        float h = 0.3f;
        GradientPaint paintHigherSegment = new GradientPaint(0.0f, 0.0f, (Color)this.getClientProperty((Object)SkinProperty.BACK_TOP_END_COLOR), 0.0f, (float)this.getHeight() * h, (Color)this.getClientProperty((Object)SkinProperty.BOTTOM_START_COLOR));
        g2D.setPaint(paintHigherSegment);
        g2D.fillRect(0, 0, this.getWidth(), (int)((float)this.getHeight() * h));
        GradientPaint paintLowerSegment = new GradientPaint(0.0f, (float)this.getHeight() * h, (Color)this.getClientProperty((Object)SkinProperty.BOTTOM_START_COLOR), 0.0f, this.getHeight(), (Color)this.getClientProperty((Object)SkinProperty.BACKGROUND_COLOR));
        g2D.setPaint(paintLowerSegment);
        g2D.fillRect(0, (int)((float)this.getHeight() * h), this.getWidth(), this.getHeight());
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBorder(null);
        this.pnlFolders.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.pnlFolders.setOpaque(false);
        this.pnlButtons.setOpaque(false);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.btnFolderList.setVerticalAlignment(0);
        this.btnShowHideMainMenu.setToolTipText(StringResources.TOOLTIP_SHOW_HIDE_MAIN_MENU);
        this.btnShowHideMainMenu.setIcon(ImageResources.ACT_SHOW_HIDE_NAVBAR);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 22;
        this.pnlButtons.add((Component)this.btnFolderList, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        this.pnlButtons.add((Component)this.btnShowHideQuickViewer, gbc);
        ++gbc.gridx;
        this.pnlButtons.add((Component)this.btnShowHideMainMenu, gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 21;
        gbc.insets = new Insets(4, 2, 0, 0);
        this.add((Component)this.menuButton, gbc);
        ++gbc.gridx;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 25;
        gbc.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.pnlFolders, gbc);
        ++gbc.gridx;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 22;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.pnlButtons, gbc);
    }

    private void initActions(ActionList actionList) {
        AppAction actionQuickViewer = actionList.getAction(ActionKey.QUICKVIEWER);
        this.btnShowHideQuickViewer = new MiniNavBarButton(actionQuickViewer);
        AppAction actionShowHideFolder = actionList.getAction(ActionKey.SHOW_HIDE_FOLDER_LIST);
        this.btnFolderList = new MiniNavBarButton(actionShowHideFolder);
        this.btnShowHideMainMenu = new MiniNavBarButton(new ShowHideNavBarAction());
    }

    void setMainMenuVisible(boolean visible, boolean saveVisibility) {
        if (saveVisibility) {
            String userGuid = ControlsUtils.getUserGuid(this);
            GWCommandManager.getInstance(userGuid).getAppearanceSettings().setMainMenuVisible(visible);
        }
        this.menuButton.setMenuBarVisible(visible);
    }

    public boolean isSeparatorVisible() {
        return this.separatorVisible;
    }

    public void setSeparatorVisible(boolean separatorVisible) {
        if (this.separatorVisible != separatorVisible) {
            this.separatorVisible = separatorVisible;
            this.repaint();
        }
    }

    public Font getPanelFont() {
        return this.panelFont;
    }

    public void setPanelFont(Font panelFont) {
        if (panelFont != null && !panelFont.equals(this.panelFont)) {
            this.panelFont = panelFont;
            this.repaint();
        }
    }

    public List getFolderList() {
        return this.navBarModel.getFolderList();
    }

    public List getInvisibleFolderList() {
        List<Object> l = this.navBarModel == null ? new ArrayList() : this.navBarModel.getInvisibleFolderList();
        return l;
    }

    public void setFolderList(List<AbstractFolder> folderList) {
        if (folderList != null) {
            this.navBarModel.setFolderList(folderList);
            if (this.isVisibleFolderListChanged()) {
                this.initButtons();
            }
        }
    }

    public void updateFolderNames(List folders) {
        for (NavBarButton btn : this.buttonList) {
            AbstractFolder updatedFolder;
            CustomFolderAction action = (CustomFolderAction)btn.getAction();
            AbstractFolder folder = action.getFolder();
            int id = folders.indexOf(folder);
            if (id <= -1 || id >= folders.size() || (updatedFolder = (AbstractFolder)folders.get(id)) == null) continue;
            this.updateButton(btn, updatedFolder);
        }
    }

    private void updateButton(NavBarButton button, AbstractFolder folder) {
        CustomFolderAction action = new CustomFolderAction(folder);
        int index = this.buttonList.indexOf(button);
        this.folderList.set(index, folder);
        button.setAction(action);
    }

    private void initButtons() {
        int n;
        ApplicationFrame appFrame;
        logger.debug((Object)"initializing buttons");
        this.buttonList.clear();
        this.folderList.clear();
        this.buttonPopupListenerList.clear();
        this.pnlFolders.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        Insets folderTabInsets = new Insets(3, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        NavBarButton prevButton = null;
        List<AbstractFolder> visibleFolders = this.navBarModel.getVisibleFolderList();
        if (visibleFolders.isEmpty()) {
            logger.debug((Object)"no visible folders > initing nav bar folder");
            IDataStore dataStore = GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore();
            dataStore.initNavFolders();
            logger.debug((Object)"nav bar folders inited");
            visibleFolders = this.navBarModel.getVisibleFolderList();
        }
        GWMainAppFrame frame = (appFrame = GWClient.getActiveFrame()) instanceof GWMainAppFrame ? (GWMainAppFrame)appFrame : GWClient.getGWMainAppFrame();
        AbstractFolder selectedFolder = frame.getFolder();
        this.bg = new ButtonGroup();
        int n2 = n = visibleFolders == null ? -1 : visibleFolders.size();
        for (int i = 0; i < n; ++i) {
            AbstractFolder folder = visibleFolders.get(i);
            String folderName = folder.getShortName();
            CustomFolderAction action = new CustomFolderAction(folder);
            NavBarButton newButton = new NavBarButton(action, this);
            newButton.setText(folderName);
            newButton.setFirstButton(i == 0);
            newButton.setSelected(selectedFolder != null && folder.equals(selectedFolder));
            FolderPopupMouseListener listener = new FolderPopupMouseListener();
            this.buttonPopupListenerList.add(listener);
            newButton.addMouseListener(listener);
            if (prevButton != null) {
                prevButton.setNextButton(newButton);
            }
            this.bg.add(newButton);
            this.folderList.add(folder);
            this.buttonList.add(newButton);
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(newButton, 2, new NavBarDragGestureListener(newButton));
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 25;
            gbc.insets = folderTabInsets;
            this.pnlFolders.add((Component)newButton, gbc);
            ++gbc.gridx;
            prevButton = newButton;
        }
        this.validate();
        this.repaint();
    }

    public void selectFolder(AbstractFolder folder) {
        if (folder != null && this.navBarModel.getVisibleFolderList() != null) {
            boolean folderSelected = this.isFolderSelected(folder);
            if (this.folderList.contains(folder)) {
                NavBarButton button = this.buttonList.get(this.folderList.indexOf(folder));
                button.setSelected(folderSelected);
            } else {
                this.bg = new ButtonGroup();
                for (NavBarButton b : this.buttonList) {
                    b.getModel().setGroup(this.bg);
                    if (!b.isSelected()) continue;
                    b.setSelected(false);
                    b.getModel().setSelected(false);
                }
                this.pnlFolders.repaint();
            }
        }
    }

    public void setFolderListVisible(boolean b) {
        if (this.menuButton != null) {
            this.menuButton.setFolderItemsVisible(!b);
        }
    }

    public boolean isFolderSelected(AbstractFolder folder) {
        GWMainAppFrame frame = (GWMainAppFrame)ControlsUtils.getFrameForController(this.controller);
        if (folder != null) {
            AbstractFolder selectedFolder = frame.getFolder();
            return selectedFolder != null && selectedFolder == folder;
        }
        return false;
    }

    private void fixMenuFontSize() {
        int size = (Integer)ComponentPropertyManager.getInstance().getSkinPropertyValue(SkinProperty.NAVBAR_FONT_SIZE);
        int n = this.popupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.popupMenu.getComponent(i);
            if (!(c instanceof HeaderFontSizeMenu)) continue;
            HeaderFontSizeMenu mnu = (HeaderFontSizeMenu)c;
            int m = mnu.getItemCount();
            for (int k = 0; k < m; ++k) {
                JMenuItem item;
                item.setSelected(size == Integer.parseInt((item = mnu.getItem(k)).getText()));
            }
            break;
        }
    }

    private void updateColor() {
        Color newColor = JColorChooser.showDialog(this, StringResources.HEADER_COLOR, (Color)ComponentPropertyManager.getInstance().getSkinPropertyValue(SkinProperty.NAVBAR_TEXT_COLOR));
        if (newColor != null) {
            DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
            dataStoreSettings.setNavBarTextColor(newColor);
            dataStoreSettings.setNavBarTextColorSet(true);
            dataStoreSettings.setHeaderSettings();
            ComponentPropertyManager.getInstance().updateProperty(SkinProperty.NAVBAR_TEXT_COLOR, newColor);
        }
    }

    public void customizeNavigationBar() {
        this.menuButton.setSelected(false);
        NavBarConfigDialog dlg = new NavBarConfigDialog(this.controller, this);
        dlg.showMe();
        if (dlg.isActionCompleteSuccessfully()) {
            List<AbstractFolder> resultList = dlg.getSelectedFolderList();
            if (!((Object)this.navBarModel.getVisibleFolderList()).equals(resultList)) {
                logger.debug((Object)"selected folder list changed:");
                logger.debug((Object)("was: " + this.navBarModel.getVisibleFolderList()));
                logger.debug((Object)("is: " + resultList));
                this.navBarModel.updateFolderList(resultList);
                this.initButtons();
            }
            ColorScheme colorScheme = dlg.getSelectedColorScheme();
            this.saveNavBarOptions(colorScheme);
        }
    }

    public boolean isNavbarOptionsSupported() {
        return this.navbarOptionsSupported;
    }

    public void setNavbarOptionsSupported(boolean navbarOptionsSupported) {
        this.navbarOptionsSupported = navbarOptionsSupported;
    }

    private void saveNavBarOptions(ColorScheme colorScheme) {
        if (this.navbarOptionsSupported) {
            AppearanceSettings appearanceSettings = GWCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings();
            appearanceSettings.setColorScheme(colorScheme.getApiId());
            ComponentPropertyManager.getInstance().processSkinChanged();
        }
    }

    NavBarModel getNavBarModel() {
        return this.navBarModel;
    }

    public NavBarButton getFolderButtonAt(Point location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        Component component = SwingUtilities.getDeepestComponentAt(this, location.x, location.y);
        if (this.buttonList.contains(component) && component instanceof NavBarButton) {
            return (NavBarButton)component;
        }
        return null;
    }

    public AbstractFolder getFolder(NavBarButton button) {
        if (button == null) {
            throw new IllegalArgumentException("button is null");
        }
        int folderIndex = this.buttonList.indexOf(button);
        if (folderIndex == -1) {
            throw new IllegalArgumentException("button not present on this panel");
        }
        return this.folderList.get(folderIndex);
    }

    public boolean isReorderingFolderButtonsMode() {
        return this.reorderingFolderButtonsMode;
    }

    public void setReorderingFolderButtonsMode(boolean reorderingFolderButtonsMode) {
        if (this.reorderingFolderButtonsMode == reorderingFolderButtonsMode) {
            return;
        }
        this.reorderingFolderButtonsMode = reorderingFolderButtonsMode;
        if (reorderingFolderButtonsMode) {
            this.getRootPane().getLayeredPane().add((Component)this.indicatorPainter, new Integer(JLayeredPane.DRAG_LAYER + 10));
        } else {
            this.getRootPane().getLayeredPane().remove(this.indicatorPainter);
        }
    }

    public void adjustIndicatorPainterLocation(Point location) {
        if (location == null) {
            this.indicatorPainter.setSize(0, 0);
        } else {
            this.indicatorPainter.adjustLocation(location);
        }
    }

    public void repaintIndicatorPainter() {
        if (!this.reorderingFolderButtonsMode) {
            throw new IllegalStateException("Panel is not in reorderingFolderButtonsMode");
        }
        this.indicatorPainter.repaint();
    }

    public InsertPosition getFolderButtonInsertPosition(Point location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        location = SwingUtilities.convertPoint(this, location, this.pnlFolders);
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        Component targetComponent = null;
        boolean targetFound = false;
        for (Component component : this.pnlFolders.getComponents()) {
            if (!(component instanceof NavBarButton) || !component.isShowing() || component instanceof ChevronPanel.ChevronButton || component.getY() > location.y || (targetComponent = component).getX() + targetComponent.getWidth() < location.x) continue;
            targetFound = true;
            break;
        }
        if (targetComponent == null) {
            logger.warn((Object)("no suitable component found for location: " + location));
            return null;
        }
        if (targetFound) {
            return new InsertPosition(targetComponent);
        }
        return new InsertPosition(targetComponent, false);
    }

    public boolean moveFolderToPosition(String folderId, InsertPosition newPosition) {
        if (folderId == null) {
            throw new IllegalArgumentException("folderId is null");
        }
        if (newPosition == null) {
            throw new IllegalArgumentException("newPosition is null");
        }
        int insertIndex = this.buttonList.indexOf(newPosition.getComponent());
        if (insertIndex == -1) {
            logger.warn((Object)"button not present on this panel");
            return false;
        }
        if (!newPosition.isBeforeComponent()) {
            ++insertIndex;
        }
        boolean moveResult = this.navBarModel.moveFolder(folderId, insertIndex);
        logger.debug((Object)("moveResult: " + moveResult));
        if (moveResult) {
            this.initButtons();
        }
        return moveResult;
    }

    public boolean isVisibleFolderListChanged() {
        return !((Object)this.folderList).equals(this.navBarModel.getVisibleFolderList());
    }

    private class MiniNavBarButton
    extends OrientableButton {
        private Insets insets;

        private MiniNavBarButton(Action a) {
            super(a);
            this.insets = new Insets(0, 0, 0, 0);
            this.setMargin(this.insets);
            this.setFocusPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setText("");
        }
    }

    private class NavBarDragGestureListener
    implements DragGestureListener {
        private NavBarButton button;

        private NavBarDragGestureListener(NavBarButton button) {
            if (button == null) {
                throw new IllegalArgumentException("button is null");
            }
            this.button = button;
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            if ((dge.getDragAction() & 2) != 0 && NavBarPanel.this.getTopLevelAncestor() instanceof ApplicationFrame) {
                String frameId = ((ApplicationFrame)NavBarPanel.this.getTopLevelAncestor()).getID();
                NavBarButtonTransferData transferData = new NavBarButtonTransferData(NavBarPanel.this.getFolder(this.button).getID(), frameId);
                NavBarButtonTransferable transferable = new NavBarButtonTransferable(transferData);
                dge.startDrag(null, transferable);
                logger.debug((Object)("drug started [" + transferData + ']'));
            }
        }
    }

    private class IndicatorPainter
    extends JComponent {
        private IndicatorPainter() {
        }

        protected void paintComponent(Graphics g) {
            Image image = com.novell.gw.jclient.application.resources.ImageResources.ICON_YELLOW_UPWARD_ARROW.getImage();
            g.drawImage(image, 0, 0, NavBarPanel.this);
        }

        public void adjustLocation(Point location) {
            if (this.getHeight() == 0) {
                this.setSize(com.novell.gw.jclient.application.resources.ImageResources.ICON_YELLOW_UPWARD_ARROW.getIconWidth(), com.novell.gw.jclient.application.resources.ImageResources.ICON_YELLOW_UPWARD_ARROW.getIconHeight());
            }
            Point layeredPaneLocation = NavBarPanel.this.getRootPane().getLayeredPane().getLocationOnScreen();
            InsertPosition insertPosition = NavBarPanel.this.getFolderButtonInsertPosition(location);
            if (insertPosition == null) {
                logger.warn((Object)("no suitable component found for location: " + location));
                return;
            }
            int x = insertPosition.isBeforeComponent() ? insertPosition.getComponent().getLocationOnScreen().x - layeredPaneLocation.x - this.getWidth() / 2 : insertPosition.getComponent().getLocationOnScreen().x + insertPosition.getComponent().getWidth() - layeredPaneLocation.x - this.getWidth() / 2;
            int y = insertPosition.getComponent().getLocationOnScreen().y - layeredPaneLocation.y + insertPosition.getComponent().getHeight();
            this.setLocation(x, y);
        }
    }

    private class FolderPopupMouseListener
    extends GWMouseAdapter {
        private FolderPopupMouseListener() {
        }

        public void showPopup(MouseEvent e) {
            this.showPopupFolder(e.getComponent(), e.getPoint());
        }

        private void showPopupFolder(Component component, Point p) {
            ApplicationFrame appFrame = GWClient.getActiveFrame();
            GWMainAppFrame mainFrame = appFrame instanceof GWMainAppFrame ? (GWMainAppFrame)appFrame : GWClient.getGWMainAppFrame();
            int index = NavBarPanel.this.buttonPopupListenerList.indexOf(this);
            AbstractFolder folder = (AbstractFolder)NavBarPanel.this.folderList.get(index);
            logger.debug((Object)("popup index: " + index + ", folder [" + folder + ']'));
            ReducedFolderPopupMenu popupMenu = FolderPopupMenu.createReducedFolderPopupMenu(folder, mainFrame.getAppActionList());
            popupMenu.show(component, p.x, p.y);
        }
    }

    private class PopupActionListener
    extends GWMouseAdapter {
        private PopupActionListener() {
        }

        public void showPopup(MouseEvent event) {
            NavBarPanel.this.fixMenuFontSize();
            NavBarPanel.this.popupMenu.show(NavBarPanel.this, event.getX() + NavBarPanel.this.pnlFolders.getX(), event.getY());
        }
    }

    private static class DisableQuickInfoAction
    extends AbstractAction {
        public DisableQuickInfoAction() {
            super(StringResources.DISABLE_QUICK_INFO);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ResetToDefaultAction
    extends AbstractAction {
        public ResetToDefaultAction() {
            super(StringResources.RESET_TO_DEFAULT);
        }

        public void actionPerformed(ActionEvent e) {
            DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
            dataStoreSettings.setNavBarTextColorSet(false);
            dataStoreSettings.setNavBarFontSize(0);
            dataStoreSettings.setHeaderSettings();
            ComponentPropertyManager.getInstance().updateProperties(SkinProperty.NAVBAR_TEXT_COLOR, SkinProperty.NAVBAR_FONT_SIZE);
            NavBarPanel.this.isDefaultNavBarFontSizeSet = true;
        }
    }

    private class HeaderFontSizeMenu
    extends GWMenu {
        private ButtonGroup sizeGroup;
        private HeaderFontSizeAction sizeAction;

        public HeaderFontSizeMenu() {
            super(StringResources.HEADER_FONT_SIZE);
            this.sizeGroup = new ButtonGroup();
            this.sizeAction = new HeaderFontSizeAction();
            int size = (Integer)ComponentPropertyManager.getInstance().getSkinPropertyValue(SkinProperty.NAVBAR_FONT_SIZE);
            Integer[] arrSizes = FontOptions.SIZES_PLAINTEXT;
            int n = arrSizes.length;
            for (int i = 0; i < n; ++i) {
                JMenuItem item = MenuItemFactory.createCkeckBoxMenuItem(arrSizes[i].toString());
                item.setSelected(arrSizes[i] == size);
                this.sizeGroup.add(item);
                item.addActionListener(this.sizeAction);
                this.add(item);
            }
        }

        private class HeaderFontSizeAction
        extends AbstractAction {
            private HeaderFontSizeAction() {
            }

            public void actionPerformed(ActionEvent e) {
                JMenuItem src = (JMenuItem)e.getSource();
                int size = Integer.parseInt(src.getText());
                HeaderFontSizeMenu menuSize = HeaderFontSizeMenu.this;
                int n = menuSize.getItemCount();
                for (int i = 0; i < n; ++i) {
                    menuSize.getItem(i).setSelected(false);
                }
                src.setSelected(true);
                NavBarPanel.this.isDefaultNavBarFontSizeSet = false;
                DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
                dataStoreSettings.setNavBarFontSize(size);
                dataStoreSettings.setHeaderSettings();
                ComponentPropertyManager.getInstance().updateProperty(SkinProperty.NAVBAR_FONT_SIZE, size);
            }
        }
    }

    private class HeaderTextColorAction
    extends AbstractAction {
        public HeaderTextColorAction() {
            super(StringResources.HEADER_TEXT_COLOR_D);
        }

        public void actionPerformed(ActionEvent e) {
            NavBarPanel.this.updateColor();
        }
    }

    private class NavBarPopupMenu
    extends GWPopupMenu {
        public NavBarPopupMenu() {
            this.initMenu();
        }

        private void initMenu() {
            this.add(new HeaderTextColorAction());
            this.add(new HeaderFontSizeMenu());
            this.add(new ResetToDefaultAction());
            this.addSeparator();
            this.add(new DisableQuickInfoAction());
            this.addSeparator();
            this.add(new CustomizeNavBarAction(NavBarPanel.this));
        }
    }

    private class ShowHideNavBarAction
    extends AbstractAction {
        private ShowHideNavBarAction() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean visible = !NavBarPanel.this.menuButton.isMenuBarVisible();
            NavBarPanel.this.setMainMenuVisible(visible, true);
        }
    }
}

