/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.frames.FramesFactory;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.frames.open.FrameOpenActionList;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ChangeToManageDialog
extends ApplicationDialog {
    private static Logger logger = Logger.getLogger(ChangeToManageDialog.class);
    private OrientableRadioButton rbAppointment;
    private OrientableRadioButton rbTask;
    private OrientableRadioButton rbMail;
    private OrientableRadioButton rbPhone;
    private OrientableRadioButton rbRemanderNote;
    private OrientableRadioButton rbGroup;
    private OrientableRadioButton rbPosted;
    private AbstractItem item;
    private IMessage message;
    private ItemType selectedItemType;
    private boolean postedItem;
    private RadioButtonListener rbl;
    private OrientableList list;
    private DefaultListModel lstModel;

    public ChangeToManageDialog(AbstractItem item, ApplicationFrame theFrame, MVCController controller) {
        super((Frame)theFrame, controller, true);
        this.item = item;
        this.message = item.getNativeItem();
        this.buildUI();
        this.setSelection();
        this.setLocationRelativeTo(this.getParent());
    }

    private void setSelection() {
        this.selectedItemType = this.message.getItemType();
        this.rbPosted.setSelected(true);
        this.postedItem = true;
        if (this.item instanceof AppointmentItem) {
            this.rbRemanderNote.setSelected(true);
        } else if (this.item instanceof PhoneItem) {
            this.rbRemanderNote.setSelected(true);
        } else if (this.item instanceof TaskItem) {
            this.rbAppointment.setSelected(true);
        } else if (this.item instanceof MailItem) {
            this.rbAppointment.setSelected(true);
        } else if (this.item instanceof ReminderNote) {
            this.rbTask.setSelected(true);
        }
        this.rbl.actionRadioButton();
    }

    private void buildUI() {
        this.setTitle(StringResources.CHANGE_TO);
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        OrientablePanel p = new OrientablePanel(new GridLayout(1, 2, 10, 0));
        p.add(this.buildButtonPanel());
        p.add(this.buildListPanel());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        contentPane.add((Component)p, c);
        OrientablePanel panel = new OrientablePanel(new GridLayout(1, 2, 10, 0));
        OS.addButtons(panel, this.getBtnOk(), this.getBtnCancel());
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 22;
        c.fill = 0;
        contentPane.add((Component)panel, c);
        this.setContentPane(contentPane);
        this.pack();
    }

    private OrientablePanel buildListPanel() {
        this.lstModel = new DefaultListModel();
        this.list = new OrientableList((ListModel)this.lstModel);
        this.list.setSelectionMode(0);
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 21;
        c.fill = 0;
        panel.add((Component)new OrientableLabel(StringResources.VIEWS_C), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 19;
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)new OrientableScrollPane(this.list), c);
        return panel;
    }

    private OrientablePanel buildButtonPanel() {
        this.rbl = new RadioButtonListener();
        this.rbAppointment = new OrientableRadioButton(StringResources.APPOINTMENT);
        this.rbAppointment.addChangeListener(this.rbl);
        this.rbTask = new OrientableRadioButton(StringResources.TASK);
        this.rbTask.addChangeListener(this.rbl);
        this.rbPhone = new OrientableRadioButton(StringResources.PHONE);
        this.rbPhone.addChangeListener(this.rbl);
        this.rbRemanderNote = new OrientableRadioButton(StringResources.REMINDER_NOTE);
        this.rbRemanderNote.addChangeListener(this.rbl);
        this.rbGroup = new OrientableRadioButton(StringResources.GROUP);
        this.rbGroup.addChangeListener(this.rbl);
        this.rbPosted = new OrientableRadioButton(StringResources.POSTED);
        this.rbPosted.addChangeListener(this.rbl);
        this.rbMail = new OrientableRadioButton(StringResources.MAIL);
        this.rbMail.addChangeListener(this.rbl);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbAppointment);
        group.add(this.rbTask);
        group.add(this.rbPhone);
        group.add(this.rbRemanderNote);
        group.add(this.rbMail);
        group = new ButtonGroup();
        group.add(this.rbPosted);
        group.add(this.rbGroup);
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 21;
        panel.add((Component)this.rbMail, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 21;
        panel.add((Component)this.rbAppointment, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 21;
        panel.add((Component)this.rbPhone, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 21;
        panel.add((Component)this.rbRemanderNote, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 21;
        panel.add((Component)this.rbTask, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 2;
        c.anchor = 21;
        panel.add((Component)new JSeparator(0), c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 21;
        panel.add((Component)this.rbGroup, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 21;
        panel.add((Component)this.rbPosted, c);
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.ITEM_TYPE_C));
        return panel;
    }

    public static void changeItemToAndCreateComposeFrame(ActionList actionList, AbstractItem oldItem, ItemType newItemType, boolean changeToPosted) {
        boolean closeParentFrame;
        boolean onFrameCompose = actionList instanceof FrameComposeActionList;
        String userGuid = ControlsUtils.getUserGuid(actionList);
        boolean isHTML = onFrameCompose ? oldItem.isHTMLMessageComposition() : oldItem.getNativeItem().isHTMLMessage();
        AbstractItem newItem = ChangeToManageDialog.changeItemTo(oldItem, newItemType, isHTML, onFrameCompose);
        FrameCompose newFrameCompose = changeToPosted ? new FrameComposePostedItem(newItem, false, ComposeMode.NEW, userGuid) : FramesFactory.getComposeFrame(newItem, true, ComposeMode.NEW, userGuid);
        Command command = new GlobalCommand(480, newFrameCompose);
        ((FrameComposeActionList)newFrameCompose.getController()).processCommand(command);
        boolean bl = closeParentFrame = onFrameCompose || actionList instanceof FrameOpenActionList;
        if (closeParentFrame) {
            ((ApplicationFrameActionList)actionList).closeFrame();
        }
        newFrameCompose.showMe();
        if (onFrameCompose) {
            oldItem.getNativeItem().deleteAutoSaveFile();
        }
        if (newItem instanceof AppointmentItem && !changeToPosted) {
            boolean includeSelf = (Boolean)EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().getSettings().getAppointmentIncludeSelf().getValue();
            IAddressable self = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getUserFields();
            if (self != null && includeSelf) {
                ArrayList<IRecipient> recipientsList = new ArrayList<IRecipient>();
                recipientsList.add(APIAbWrapperManager.createRecipient(self));
                command = new Command(100, recipientsList);
                ((FrameComposeActionList)newFrameCompose.getController()).processCommand(command);
            }
        }
    }

    public void setDenyChangeToMail() {
        this.rbMail.setEnabled(false);
        this.rbPhone.setEnabled(false);
        this.rbAppointment.setSelected(true);
    }

    public static AbstractItem changeItemTo(AbstractItem oldItem, ItemType itemType, boolean isHTML, boolean isComposingParent) {
        AbstractItem newItem = oldItem;
        Object oldMessage = oldItem.getNativeItem();
        if (!oldMessage.canChangeTo(itemType)) {
            logger.debug((Object)("\n***** CANT CHANGE MESSAGE TO " + (Object)((Object)itemType) + " *****\n"));
            return null;
        }
        IMessage newMessage = oldMessage.changeTo(itemType);
        newItem = ChangeToManageDialog.getChangeItem(oldItem, newItem, newMessage, itemType, isHTML, isComposingParent);
        return newItem;
    }

    public static AbstractItem changeItemTo(AbstractItem oldItem, ItemType itemType, boolean isComposingParent, boolean keepOriginalMessage, boolean keepDistributionList) {
        AbstractItem newItem = oldItem;
        Object oldMessage = oldItem.getNativeItem();
        if (!oldMessage.canChangeTo(itemType)) {
            logger.debug((Object)("\n***** CANT CHANGE MESSAGE TO " + (Object)((Object)itemType) + " *****\n"));
            return null;
        }
        IMessage newMessage = oldMessage.changeTo(itemType, keepOriginalMessage, keepDistributionList);
        newItem = ChangeToManageDialog.getChangeItem(oldItem, newItem, newMessage, itemType, oldItem.getNativeItem().isHTMLMessage(), isComposingParent);
        return newItem;
    }

    private static AbstractItem getChangeItem(AbstractItem oldItem, AbstractItem newItem, IMessage newMessage, ItemType itemType, boolean isHTML, boolean isComposingParent) {
        if (itemType == ItemType.APPT) {
            MessageUtils.prepareNewAppointment((IAppointment)newMessage);
        }
        try {
            newItem = GWItemFactory.gwObjectToItem(newMessage);
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        newItem.setMessage(oldItem.getMessage().copyForItem(newItem, isHTML, isComposingParent));
        newItem.setSubject(oldItem.getSubject());
        newItem.setAttachments(oldItem.getAttachments());
        newItem.setRecipients(oldItem.getRecipientsList());
        return newItem;
    }

    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<ChangeToManageDialog>(this, parentController);
    }

    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        if (((MVCController)this.getController()).getActionList() instanceof FrameComposeActionList) {
            this.item = ((FrameCompose)((MVCController)this.getController()).getActionList().getMVCView()).getItemEdit().getGWItemComposition();
        }
        ChangeToManageDialog.changeItemToAndCreateComposeFrame(((MVCController)this.getController()).getActionList(), this.item, this.selectedItemType, this.postedItem);
    }

    private class RadioButtonListener
    implements ChangeListener {
        private RadioButtonListener() {
        }

        public void actionRadioButton() {
            ChangeToManageDialog.this.lstModel.clear();
            if (ChangeToManageDialog.this.rbPosted.isSelected()) {
                ChangeToManageDialog.this.postedItem = true;
                if (ChangeToManageDialog.this.rbMail.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.POSTED_MAIL + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.MAIL;
                }
                if (ChangeToManageDialog.this.rbPhone.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.POSTED_PHONE + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.PHONE;
                }
                if (ChangeToManageDialog.this.rbTask.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.POSTED_TASK + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.TODO;
                }
                if (ChangeToManageDialog.this.rbAppointment.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.POSTED_APPOINTMENT + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.APPT;
                }
                if (ChangeToManageDialog.this.rbRemanderNote.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.POSTED_REMINDER_NOTE + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.NOTE;
                }
            }
            if (ChangeToManageDialog.this.rbGroup.isSelected()) {
                ChangeToManageDialog.this.postedItem = false;
                if (ChangeToManageDialog.this.rbMail.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.MAIL + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.MAIL;
                }
                if (ChangeToManageDialog.this.rbPhone.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.PHONE_MESSAGE + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.PHONE;
                }
                if (ChangeToManageDialog.this.rbTask.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.TASK + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.TODO;
                }
                if (ChangeToManageDialog.this.rbAppointment.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.MEETING + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.APPT;
                }
                if (ChangeToManageDialog.this.rbRemanderNote.isSelected()) {
                    ChangeToManageDialog.this.lstModel.addElement(StringResources.REMINDER + " *");
                    ChangeToManageDialog.this.selectedItemType = ItemType.NOTE;
                }
            }
            ChangeToManageDialog.this.list.setSelectedIndex(0);
        }

        public void stateChanged(ChangeEvent e) {
            this.actionRadioButton();
        }
    }
}

