/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class DeleteFolderPane
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(DeleteFolderPane.class);
    public static final int DELETE_ITEMS_ONLY = 0;
    public static final int DELETE_FOLDERS_AND_ITEMS = 1;
    public static final int DELETION_CANCELED = 2;
    private JButton btnOK;
    private JButton btnCancel;
    private JRadioButton rbItemsOnly;
    private JRadioButton rbItemsAndFolder;
    private ButtonGroup buttonGroup;
    private JDialog parentDialog;
    private int returnValue = 2;

    protected DeleteFolderPane() throws HeadlessException {
        this.buildUI();
    }

    private void buildUI() {
        this.btnOK = new JButton(new OKAction());
        this.btnCancel = new JButton(new CancelAction());
        this.rbItemsOnly = new JMnemonicRadioButton(StringResources.ITEMS_ONLY);
        this.rbItemsOnly.setSelected(true);
        this.rbItemsAndFolder = new JMnemonicRadioButton(StringResources.FOLDERS_AND_ITEMS);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.rbItemsOnly);
        this.buttonGroup.add(this.rbItemsAndFolder);
        OrientablePanel pnlControls = new OrientablePanel();
        pnlControls.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ' ' + StringResources.DELETE_OPTIONS + ' '));
        pnlControls.setLayout(new BoxLayout(pnlControls, 3));
        pnlControls.add(this.rbItemsOnly);
        pnlControls.add(this.rbItemsAndFolder);
        OrientablePanel buttonPanel = new OrientablePanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        OS.addButtons(buttonPanel, this.btnOK, this.btnCancel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        this.add((Component)pnlControls, c);
        c.anchor = 12;
        c.gridx = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.btnOK, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.btnCancel, c);
        this.btnCancel.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteFolderPane.this.btnCancel.getAction().actionPerformed(e);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static int showDeleteDialog(Component parentComponent) {
        JDialog dialog;
        DeleteFolderPane pane = new DeleteFolderPane();
        pane.parentDialog = dialog = pane.createDialog(parentComponent, StringResources.DELETE_FOLDERS);
        UIUtils.centerWindow((Window)dialog, parentComponent);
        dialog.pack();
        dialog.setVisible(true);
        pane.parentDialog = null;
        dialog.dispose();
        return pane.returnValue;
    }

    private JDialog createDialog(Component parentComponent, String title) {
        if (parentComponent == null) {
            throw new NullPointerException();
        }
        Window window = ControlsUtils.getWindowForComponent(parentComponent);
        if (window == null) {
            throw new IllegalArgumentException("Component without parent window passed.");
        }
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        dialog.setContentPane(this);
        dialog.getRootPane().setDefaultButton(this.btnOK);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DeleteFolderPane.this.returnValue = 2;
            }
        });
        return dialog;
    }

    private int getValue() {
        return this.returnValue;
    }

    private void setParentDialog(JDialog theParentDialog) {
        this.parentDialog = theParentDialog;
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            if (DeleteFolderPane.this.parentDialog != null) {
                DeleteFolderPane.this.parentDialog.hide();
                DeleteFolderPane.this.returnValue = 2;
            }
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            DeleteFolderPane deletePane = DeleteFolderPane.this;
            if (deletePane.parentDialog != null) {
                deletePane.parentDialog.hide();
                deletePane.returnValue = deletePane.rbItemsOnly.isSelected() ? 0 : 1;
            }
        }
    }
}

