/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.components.EmptyStringDocumentListener;
import com.novell.gw.jclient.application.actions.edit.text.ActionFindText;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.FindTextConditions;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FindTextDialog
extends GWDialog {
    public JTextField tfFindWhat = new GWTextField();
    private JCheckBox cbMatchWhole = new JMnemonicCheckBox(StringResources.MATCH_WHOLE_WORD_ONLY);
    private JCheckBox cbMatchCase = new JMnemonicCheckBox(StringResources.MATCH_CASE);
    private JRadioButton rbUp = new JMnemonicRadioButton(StringResources.UP);
    private JRadioButton rbDown = new JMnemonicRadioButton(StringResources.DOWN);
    private FindTextConditions findTextConditions = new FindTextConditions();
    private ActionFindText actionFindText;

    public FindTextDialog(JFrame theFrame) {
        super(theFrame, false);
        this.setTitle(StringResources.FIND);
        this.buildUI();
    }

    public FindTextDialog(JFrame theFrame, FindTextConditions theConditions, ActionFindText theActionFindText) {
        this(theFrame);
        this.findTextConditions = theConditions;
        this.tfFindWhat.setText(this.findTextConditions.getSearchText());
        this.tfFindWhat.selectAll();
        this.cbMatchWhole.setSelected(this.findTextConditions.isMatchWholeWord());
        this.cbMatchCase.setSelected(this.findTextConditions.isMatchCase());
        if (this.findTextConditions.isUpDirection()) {
            this.rbUp.setSelected(true);
        } else {
            this.rbDown.setSelected(true);
        }
        this.actionFindText = theActionFindText;
    }

    private void buildUI() {
        OrientablePanel pnlSouth = new OrientablePanel(new BorderLayout(0, 10));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbDown);
        buttonGroup.add(this.rbUp);
        this.rbDown.setSelected(true);
        OrientablePanel pnlRadioButtons = new OrientablePanel();
        pnlRadioButtons.add(this.rbUp);
        pnlRadioButtons.add(this.rbDown);
        pnlRadioButtons.setBorder(BorderFactory.createTitledBorder(StringResources.DIRECTION));
        OrientablePanel pnlCheckButtons = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        pnlCheckButtons.add(this.cbMatchWhole);
        pnlCheckButtons.add(this.cbMatchCase);
        OrientablePanel pnlSearch = new OrientablePanel(new BorderLayout(10, 0));
        pnlSearch.add((Component)new JMnemonicLabel(StringResources.FIND_WHAT_C, this.tfFindWhat), "Before");
        pnlSearch.add((Component)this.tfFindWhat, "Center");
        pnlSouth.add((Component)pnlRadioButtons, "After");
        pnlSouth.add((Component)pnlCheckButtons, "Before");
        pnlSouth.add((Component)pnlSearch, "North");
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        pnlContent.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        pnlContent.add((Component)pnlSouth, constraints);
        constraints.weightx = 0.0;
        constraints.insets.left = 10;
        constraints.fill = 0;
        constraints.anchor = 24;
        pnlContent.add((Component)this.buildButtonsPanel(), constraints);
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pnlContent.setMinimumSize(pnlContent.getPreferredSize());
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        JMnemonicButton btnFindNext = new JMnemonicButton(new FindNextAction());
        this.tfFindWhat.getDocument().addDocumentListener(new EmptyStringDocumentListener(btnFindNext.getAction()));
        this.setDefaultButton(btnFindNext);
        pnlButtons.add(btnFindNext);
        pnlButtons.add(this.btnCancel);
        return pnlButtons;
    }

    public FindTextConditions getFindTextConditions() {
        this.findTextConditions.setMatchCase(this.cbMatchCase.isSelected());
        this.findTextConditions.setMatchWholeWord(this.cbMatchWhole.isSelected());
        this.findTextConditions.setSearchText(this.tfFindWhat.getText());
        this.findTextConditions.setUpDirection(this.rbUp.isSelected());
        return this.findTextConditions;
    }

    public boolean isMatchWholeWord() {
        return this.cbMatchWhole.isSelected();
    }

    public boolean isMatchCase() {
        return this.cbMatchCase.isSelected();
    }

    public boolean isUpDirection() {
        return this.rbUp.isSelected();
    }

    public String getSearchText() {
        return this.tfFindWhat.getText();
    }

    private class FindNextAction
    extends AbstractAction {
        public FindNextAction() {
            super(StringResources.FIND_NEXT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            FindTextDialog.this.actionFindText.setConditions(FindTextDialog.this.getFindTextConditions());
            FindTextDialog.this.actionFindText.performFindText();
        }
    }
}

