/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.availablefontchooser;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.availablefontchooser.AFCListCellRenderer;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AvailableFontChooserDialog
extends OkCancelDialog {
    private final String fontName;
    private JList list;
    public static final String SAMPLE = StringResources.SELECT_THIS_FONT_IF_IT_LOOKS_OK;

    public static void main(String[] args) {
        AvailableFontChooserDialog.showMe("UNAVAILABLE FONT");
    }

    public AvailableFontChooserDialog(String fontName) {
        this.fontName = fontName;
        this.setTitle("The default font is not available!");
        this.init();
        this.buildUI();
    }

    public String getSelectedFontName() {
        return ((Font)this.list.getSelectedValue()).getName();
    }

    private void init() {
        String[] fontNames = UIUtils.getSystemFonts();
        int fontSize = ((Font)UIManager.get("Label.font")).getSize();
        ArrayList<Font> fonts = new ArrayList<Font>();
        for (String fontName : fontNames) {
            Font font = new Font(fontName, 0, fontSize);
            boolean b = true;
            for (char c : SAMPLE.toCharArray()) {
                if (font.canDisplay(c)) continue;
                b = false;
                break;
            }
            if (!b) continue;
            fonts.add(font);
        }
        this.list = new OrientableList(fonts.toArray(new Font[fonts.size()]));
        this.list.setCellRenderer(new AFCListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new AFCSelectionListener());
        JButton btnOk = this.getBtnOk();
        btnOk.setText("Ok");
        btnOk.setEnabled(false);
        this.getBtnCancel().setText("Cancel");
    }

    private void buildUI() {
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.add((Component)this.createLabelsPanel(), "First");
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add((Component)this.createOkCancelButtonsPanel(), "Last");
    }

    private JPanel createLabelsPanel() {
        OrientablePanel panel = new OrientablePanel(new GridLayout(4, 0));
        panel.add(new OrientableLabel("The default font of '" + this.fontName + "' is not available on your system."));
        panel.add(new OrientableLabel(""));
        panel.add(new OrientableLabel("You must either install the '" + this.fontName + "' font or select a new font"));
        panel.add(new OrientableLabel("from the list below to use for the application:"));
        OrientablePanel labelsPanel = new OrientablePanel(new BorderLayout(10, 10));
        labelsPanel.add((Component)new OrientableLabel((Icon)UIManager.get("OptionPane.errorIcon")), "Before");
        labelsPanel.add((Component)panel, "Center");
        return labelsPanel;
    }

    protected void processCancelAction(ActionEvent event) {
        super.processCancelAction(event);
        System.exit(0);
    }

    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        System.exit(0);
    }

    public static AvailableFontChooserDialog showMe(String fontName) {
        AvailableFontChooserDialog dialog = new AvailableFontChooserDialog(fontName);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        return dialog;
    }

    private class AFCSelectionListener
    implements ListSelectionListener {
        private AFCSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            AvailableFontChooserDialog.this.getBtnOk().setEnabled(e.getFirstIndex() != -1);
        }
    }
}

