/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.categories;

import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TableRendererUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;

class CategoriesBooleanCellEditor
extends DefaultCellEditor {
    private static JCheckBox checkBox = new JCheckBox();
    private ICategoryList categories;

    public CategoriesBooleanCellEditor(ICategoryList categories) {
        super(checkBox);
        this.categories = categories;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Color background;
        Color foreground;
        ICategory category = (ICategory)value;
        Boolean b = this.categories.findCategoryIndex(category) != -1;
        if (isSelected) {
            foreground = category.getBackgroundColor();
            background = category.getTextColor();
        } else {
            foreground = category.getTextColor();
            background = category.getBackgroundColor();
        }
        if (foreground == null) {
            Color color = foreground = isSelected ? table.getSelectionForeground() : TableRendererUtils.ITEM_LIST_TABLE_FOREGROUND;
        }
        if (background == null) {
            background = isSelected ? table.getSelectionBackground() : TableRendererUtils.ITEM_LIST_TABLE_BACKGROUND;
        }
        checkBox.setForeground(foreground);
        checkBox.setBackground(background);
        return super.getTableCellEditorComponent(table, b, isSelected, row, column);
    }
}

