/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.categories;

import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TableRendererUtils;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesBooleanCellEditor;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesTableModel;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

class CategoriesBooleanCellRenderer
extends JCheckBox
implements TableCellRenderer {
    private static final Logger logger = Logger.getLogger(CategoriesBooleanCellEditor.class);
    private ICategoryList categories;
    private String userGuid;

    public CategoriesBooleanCellRenderer(ICategoryList categories, String userGuid) {
        this.userGuid = userGuid;
        this.categories = categories;
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background;
        Color foreground;
        if (value instanceof Boolean) {
            value = CategoryUtils.getCategory(row, this.userGuid);
        }
        ICategory category = (ICategory)value;
        if (isSelected) {
            foreground = category.getBackgroundColor();
            background = category.getTextColor();
        } else {
            foreground = category.getTextColor();
            background = category.getBackgroundColor();
        }
        if (foreground == null) {
            Color color = foreground = isSelected ? table.getSelectionForeground() : TableRendererUtils.ITEM_LIST_TABLE_FOREGROUND;
        }
        if (background == null) {
            background = isSelected ? table.getSelectionBackground() : TableRendererUtils.ITEM_LIST_TABLE_BACKGROUND;
        }
        this.setForeground(foreground);
        this.setBackground(background);
        CategoriesTableModel model = (CategoriesTableModel)table.getModel();
        ButtonModel buttonModel = this.getModel();
        if (model.isArmed(category)) {
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
        } else {
            buttonModel.setArmed(false);
            buttonModel.setPressed(false);
        }
        this.setSelected(this.categories.findCategoryIndex(CategoryUtils.getCategory(row, this.userGuid)) != -1);
        this.setBorder(null);
        return this;
    }
}

