/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.CustomizePanelsDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.EditPanelDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.PanelListCellRenderer;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColumnPanelsPane
extends OrientablePanel {
    private JList lstPanels = new OrientableList((ListModel)new DefaultListModel());
    private IPanelDisplaySettings[][] displaySettings = new IPanelDisplaySettings[30][];
    private String caption;
    private ActionMoveUpPanel actionMoveUp = new ActionMoveUpPanel();
    private ActionMoveDownPanel actionMoveDown = new ActionMoveDownPanel();
    private ActionEditPanel actionEdit = new ActionEditPanel();
    private ActionDeletePanel actionDelete = new ActionDeletePanel();
    private boolean isFirstColumn;
    private JList lstNeighborPanels;

    public ColumnPanelsPane(String caption) {
        if (caption == null) {
            throw new IllegalArgumentException("caption is null");
        }
        this.caption = caption;
        this.buildUI();
        this.lstPanels.addListSelectionListener(new PanelSelectionListener());
        this.lstPanels.getModel().addListDataListener(new PanelDataListener());
        this.handleListSelectionChange();
    }

    public void addNeighborPanelList(JList lstNeighborPanels, boolean isFirstColumn) {
        this.lstNeighborPanels = lstNeighborPanels;
        this.isFirstColumn = isFirstColumn;
        this.handleListSelectionChange();
    }

    public JList getList() {
        return this.lstPanels;
    }

    private JPanel createButtonsPanel() {
        OrientablePanel result = new OrientablePanel(new GridLayout(4, 1, 0, 5));
        OrientableButton btnMoveUp = new OrientableButton(this.actionMoveUp);
        OrientableButton btnMoveDown = new OrientableButton(this.actionMoveDown);
        OrientableButton btnEdit = new OrientableButton(this.actionEdit);
        OrientableButton btnDelete = new OrientableButton(this.actionDelete);
        btnEdit.setEnabled(false);
        result.add(btnMoveUp);
        result.add(btnMoveDown);
        result.add(btnEdit);
        result.add(btnDelete);
        return result;
    }

    private void buildUI() {
        this.lstPanels.setSelectionMode(0);
        this.lstPanels.setCellRenderer(new PanelListCellRenderer());
        OrientableLabel lblCaption = new OrientableLabel(this.caption);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 25;
        constraints.insets = CustomizePanelsDialog.getPanelListCaptionInsets();
        this.add((Component)lblCaption, constraints);
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new OrientableScrollPane(this.lstPanels), constraints);
        constraints.gridx = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.createButtonsPanel(), constraints);
    }

    public void addPanel(IPanelDisplaySettings panel) {
        ((DefaultListModel)this.lstPanels.getModel()).addElement(panel);
    }

    public int getPanelCount() {
        return this.lstPanels.getModel().getSize();
    }

    public IPanelDisplaySettings[] getPanels() {
        Object[] settings = new IPanelDisplaySettings[this.lstPanels.getModel().getSize()];
        ((DefaultListModel)this.lstPanels.getModel()).copyInto(settings);
        return settings;
    }

    public IPanelDisplaySettings[][] getDisplaySettings() {
        return this.displaySettings;
    }

    public void setPanels(IPanelDisplaySettings[][] ds) {
        this.removeAllPanels();
        for (IPanelDisplaySettings[] d : ds) {
            int nLen = d.length;
            for (int j = 0; j < nLen; ++j) {
                ((DefaultListModel)this.lstPanels.getModel()).addElement(d[j]);
            }
        }
    }

    public void removeAllPanels() {
        ((DefaultListModel)this.lstPanels.getModel()).clear();
    }

    private void handleListSelectionChange() {
        boolean enableButtons = false;
        if (this.lstPanels.getModel().getSize() != 0 && !this.lstPanels.isSelectionEmpty()) {
            enableButtons = true;
        }
        this.actionDelete.setEnabled(enableButtons);
        this.actionEdit.setEnabled(enableButtons);
        if (enableButtons && this.lstPanels.getModel().getSize() > 1) {
            this.actionMoveUp.setEnabled(this.lstPanels.getSelectedIndex() != 0);
            this.actionMoveDown.setEnabled(this.lstPanels.getSelectedIndex() != this.lstPanels.getModel().getSize() - 1);
        } else {
            this.actionMoveUp.setEnabled(false);
            this.actionMoveDown.setEnabled(false);
        }
        if (this.lstNeighborPanels != null && this.lstPanels.getModel().getSize() > 0) {
            if (this.isFirstColumn) {
                this.actionMoveDown.setEnabled(enableButtons);
            } else {
                this.actionMoveUp.setEnabled(enableButtons);
            }
        }
    }

    private class PanelDataListener
    implements ListDataListener {
        private PanelDataListener() {
        }

        public void contentsChanged(ListDataEvent e) {
            ColumnPanelsPane.this.handleListSelectionChange();
        }

        public void intervalAdded(ListDataEvent e) {
            ColumnPanelsPane.this.handleListSelectionChange();
        }

        public void intervalRemoved(ListDataEvent e) {
            ColumnPanelsPane.this.handleListSelectionChange();
        }
    }

    private class PanelSelectionListener
    implements ListSelectionListener {
        private PanelSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ColumnPanelsPane.this.handleListSelectionChange();
        }
    }

    private class ActionMoveDownPanel
    extends AbstractAction {
        public ActionMoveDownPanel() {
            super(StringResources.MOVE_DOWN);
        }

        public void actionPerformed(ActionEvent e) {
            JList list = ColumnPanelsPane.this.lstPanels;
            int selectedIndex = list.getSelectedIndex();
            ColumnPanelsPane thisDlg = ColumnPanelsPane.this;
            if (thisDlg.lstNeighborPanels == null || !thisDlg.isFirstColumn || selectedIndex != list.getModel().getSize() - 1) {
                Object elementAt = list.getModel().getElementAt(selectedIndex);
                ((DefaultListModel)list.getModel()).remove(selectedIndex);
                ((DefaultListModel)list.getModel()).insertElementAt(elementAt, selectedIndex + 1);
                list.setSelectedIndex(selectedIndex + 1);
            } else {
                Object elementAt = list.getModel().getElementAt(selectedIndex);
                ((DefaultListModel)list.getModel()).remove(selectedIndex);
                ((DefaultListModel)ColumnPanelsPane.this.lstNeighborPanels.getModel()).insertElementAt(elementAt, 0);
                if (list.getModel().getSize() > 0) {
                    list.setSelectedIndex(selectedIndex - 1);
                }
                ColumnPanelsPane.this.lstNeighborPanels.setSelectedIndex(0);
            }
        }
    }

    private class ActionMoveUpPanel
    extends AbstractAction {
        public ActionMoveUpPanel() {
            super(StringResources.MOVE_UP);
        }

        public void actionPerformed(ActionEvent e) {
            JList list = ColumnPanelsPane.this.lstPanels;
            int selectedIndex = list.getSelectedIndex();
            ColumnPanelsPane thisDlg = ColumnPanelsPane.this;
            if (thisDlg.lstNeighborPanels == null || thisDlg.isFirstColumn && selectedIndex != 0) {
                Object elementAt = list.getModel().getElementAt(selectedIndex);
                ((DefaultListModel)list.getModel()).remove(selectedIndex);
                ((DefaultListModel)list.getModel()).insertElementAt(elementAt, selectedIndex - 1);
                list.setSelectedIndex(selectedIndex - 1);
            } else {
                Object elementAt = list.getModel().getElementAt(selectedIndex);
                ((DefaultListModel)list.getModel()).remove(selectedIndex);
                ((DefaultListModel)ColumnPanelsPane.this.lstNeighborPanels.getModel()).addElement(elementAt);
                if (list.getModel().getSize() > 0) {
                    list.setSelectedIndex(0);
                }
                ColumnPanelsPane.this.lstNeighborPanels.setSelectedIndex(ColumnPanelsPane.this.lstNeighborPanels.getModel().getSize() - 1);
            }
        }
    }

    private class ActionDeletePanel
    extends AbstractAction {
        public ActionDeletePanel() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            JList list = ColumnPanelsPane.this.lstPanels;
            int selectedIndex = list.getSelectedIndex();
            ((DefaultListModel)list.getModel()).remove(list.getSelectedIndex());
            if (list.getModel().getSize() > selectedIndex) {
                list.setSelectedIndex(selectedIndex);
            } else if (list.getModel().getSize() > 0) {
                list.setSelectedIndex(list.getModel().getSize() - 1);
            }
        }
    }

    private class ActionEditPanel
    extends AbstractAction {
        public ActionEditPanel() {
            super(StringResources.EDIT);
        }

        public void actionPerformed(ActionEvent e) {
            IPanelDisplaySettings settings = (IPanelDisplaySettings)ColumnPanelsPane.this.lstPanels.getSelectedValue();
            Window window = SwingUtilities.getWindowAncestor(ColumnPanelsPane.this);
            EditPanelDialog dialog = new EditPanelDialog((JDialog)window, ControlsUtils.findClosestController(window), settings);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.isOkActionProcessed()) {
                ColumnPanelsPane.this.lstPanels.repaint();
            }
            dialog.dispose();
        }
    }
}

