/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(ColumnsDialog.class);
    private JList listAvail = new OrientableList();
    private JList listCurrent = new OrientableList();
    private JMnemonicButton buttonAdd;
    private JMnemonicButton buttonRemove;
    private JMnemonicButton buttonUp;
    private JMnemonicButton buttonDown;
    private JButton btnSuperSmaller;
    private JButton btnSmaller;
    private JButton btnLarger;
    private JButton btnSuperLarger;
    private JLabel testColumn;
    private JPanel columnPanel;
    private List<IColumnFieldInfo> selectedInfos;
    private List<IColumnFieldInfo> availableInfos;
    private IViewDisplaySettings displaySettings;
    private static final int MINIMUN_COLUMN_SIZE = 20;
    private boolean isContacts;

    public ColumnsDialog(JDialog parent, IViewDisplaySettings displaySettings, boolean isContacts) {
        super(parent);
        this.displaySettings = displaySettings;
        this.isContacts = isContacts;
        this.init();
        this.buildUI();
        this.setModal(true);
    }

    public ColumnsDialog(JFrame parent, IViewDisplaySettings displaySettings, boolean isContacts) {
        super(parent);
        if (displaySettings == null) {
            throw new IllegalArgumentException("DisplaySettings == null");
        }
        this.displaySettings = displaySettings;
        this.isContacts = isContacts;
        this.init();
        this.buildUI();
        this.setModal(true);
    }

    public static List<IColumnFieldInfo> getDifferenceByFieldID(List<IColumnFieldInfo> allFielInfos, List<IColumnFieldInfo> fieldInfos) {
        ArrayList<IColumnFieldInfo> result = new ArrayList<IColumnFieldInfo>();
        for (IColumnFieldInfo fieldInfo : allFielInfos) {
            if (fieldInfos.contains(fieldInfo)) continue;
            result.add(fieldInfo);
        }
        return result;
    }

    private void init() {
        this.selectedInfos = new ArrayList<IColumnFieldInfo>(Arrays.asList(this.displaySettings.getColumnAndSortInfo().getVisibleColumns()));
        String userGuid = ControlsUtils.getUserGuid(this);
        IColumnFieldInfo[] allFieldInfos = GWCommandManager.getInstance(userGuid).getCurrentDataStore().getDisplayColumnFields(this.isContacts);
        this.availableInfos = ColumnsDialog.getDifferenceByFieldID(Arrays.asList(allFieldInfos), this.selectedInfos);
        Collections.sort(this.availableInfos, new Comparator<IColumnFieldInfo>(){

            @Override
            public int compare(IColumnFieldInfo o1, IColumnFieldInfo o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.initModels();
        this.listAvail.setSelectionMode(0);
        this.listCurrent.setSelectionMode(0);
        this.listAvail.addListSelectionListener(new ListSelectionListenerImpl());
        this.listCurrent.addListSelectionListener(new ListSelectionListenerImpl());
        this.listAvail.addMouseListener(new AddItemListener());
        this.listCurrent.addMouseListener(new RemoveItemListener());
        this.columnPanel = new OrientablePanel();
        this.testColumn = new OrientableLabel();
        this.testColumn.setHorizontalAlignment(0);
        this.buttonAdd = new JMnemonicButton(StringResources.ADD);
        this.buttonRemove = new JMnemonicButton(StringResources.REMOVE);
        this.buttonUp = new JMnemonicButton(StringResources.UP);
        this.buttonDown = new JMnemonicButton(StringResources.DOWN);
        this.btnSuperSmaller = new OrientableButton(StringResources.LL);
        this.btnSmaller = new OrientableButton(StringResources.L_SMALLER);
        this.btnLarger = new OrientableButton(StringResources.LARGER_R);
        this.btnSuperLarger = new OrientableButton(StringResources.RR);
        PositionListener actionListener = new PositionListener();
        this.buttonAdd.addActionListener(actionListener);
        this.buttonRemove.addActionListener(actionListener);
        this.buttonUp.addActionListener(actionListener);
        this.buttonDown.addActionListener(actionListener);
        WidthListener widthListener = new WidthListener();
        this.btnSuperSmaller.addActionListener(widthListener);
        this.btnSmaller.addActionListener(widthListener);
        this.btnLarger.addActionListener(widthListener);
        this.btnSuperLarger.addActionListener(widthListener);
    }

    private void buildUI() {
        this.setTitle(StringResources.SELECT_COLUMNS);
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            this.btnSuperSmaller.setText(StringResources.RR);
            this.btnSuperLarger.setText(StringResources.LL);
        }
        this.testColumn.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnPanel.add(this.testColumn);
        this.changeAvailListButtons();
        this.changeCurrentListButtons();
        ColumnsDialog.initSelection(this.listAvail);
        ColumnsDialog.initSelection(this.listCurrent);
        GridBagLayout layout = new GridBagLayout();
        OrientablePanel panelMain = new OrientablePanel(layout);
        panelMain.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        c.weightx = 100.0;
        JMnemonicLabel labelAvailable = new JMnemonicLabel(StringResources.AVAILABLE_COLUMNS_C, this.listAvail);
        panelMain.add((Component)labelAvailable, c);
        c.gridx = 2;
        c.insets = new Insets(5, 5, 0, 5);
        JMnemonicLabel labelCurrent = new JMnemonicLabel(StringResources.SELECTED_COLUMNS_C, this.listCurrent);
        panelMain.add((Component)labelCurrent, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 3;
        c.weighty = 100.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 0);
        OrientableScrollPane scrollAvail = new OrientableScrollPane(this.listAvail, 22, 32);
        scrollAvail.setPreferredSize(new Dimension(150, scrollAvail.getPreferredSize().height));
        panelMain.add((Component)scrollAvail, c);
        c.gridx = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridheight = 1;
        OrientableScrollPane scrollCurrent = new OrientableScrollPane(this.listCurrent, 22, 32);
        scrollCurrent.setPreferredSize(new Dimension(150, scrollCurrent.getPreferredSize().height));
        panelMain.add((Component)scrollCurrent, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 0);
        OrientablePanel panelMiddle = new OrientablePanel(layout);
        panelMain.add((Component)panelMiddle, c);
        c.gridx = 0;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        panelMiddle.add((Component)this.buttonAdd, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 0);
        panelMiddle.add((Component)this.buttonRemove, c);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 3;
        c.insets = new Insets(5, 0, 5, 5);
        OrientablePanel panelControls = new OrientablePanel(new GridLayout(1, 2, 5, 0));
        panelControls.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.COLUMN_POSITION), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panelMain.add((Component)panelControls, c);
        panelControls.add(this.buttonUp);
        panelControls.add(this.buttonDown);
        OrientablePanel panelWidth = new OrientablePanel(new BorderLayout());
        panelWidth.setBorder(BorderFactory.createTitledBorder(StringResources.COLUMN_WIDTH));
        OrientablePanel widthButtons = new OrientablePanel(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.fill = 0;
        cc.anchor = 10;
        cc.gridx = 0;
        cc.gridy = 0;
        widthButtons.add((Component)this.btnSuperSmaller, cc);
        ++cc.gridx;
        widthButtons.add((Component)this.btnSmaller, cc);
        ++cc.gridx;
        widthButtons.add((Component)this.btnLarger, cc);
        ++cc.gridx;
        widthButtons.add((Component)this.btnSuperLarger, cc);
        panelWidth.add((Component)widthButtons, "North");
        panelWidth.add((Component)this.columnPanel, "Center");
        c.gridx = 0;
        c.gridy = 4;
        c.gridheight = 2;
        c.gridwidth = 3;
        c.insets = new Insets(5, 5, 5, 5);
        panelMain.add((Component)panelWidth, c);
        this.panCenterPanel.add((Component)panelMain, "Center");
        this.panCenterPanel.add((Component)this.buildButtonsPane(), "After");
        this.setDefaultButton(this.btnOK);
        this.pack();
    }

    private IColumnFieldInfo getSelectedColumnInfo() {
        if (this.listCurrent.getModel().getSize() > 0) {
            return (IColumnFieldInfo)this.listCurrent.getSelectedValue();
        }
        return null;
    }

    private void updateTestColumn() {
        String testColumnName = "";
        int testColumnWidth = 0;
        IColumnFieldInfo selectedInfo = this.getSelectedColumnInfo();
        if (selectedInfo != null) {
            testColumnName = selectedInfo.getName();
            testColumnWidth = selectedInfo.getWidth();
        }
        Dimension initialSize = new Dimension(testColumnWidth, PLAFChanger.getFontSize() + 8);
        this.testColumn.setText(testColumnName);
        this.testColumn.setPreferredSize(initialSize);
    }

    private JPanel buildButtonsPane() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlButtons);
        adapter.setColumnCount(1);
        this.btnOK = new OrientableButton(new OkAction());
        adapter.addComponent(this.btnOK);
        adapter.addComponent(this.btnCancel);
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout());
        pnlContent.add((Component)pnlButtons, "North");
        return pnlContent;
    }

    private void initModels() {
        this.listAvail.setModel(new ColumnListModel(this.availableInfos));
        this.listCurrent.setModel(new ColumnListModel(this.selectedInfos));
    }

    private static void initSelection(JList theList) {
        if (theList.getModel().getSize() > 0) {
            theList.setSelectedIndex(0);
        }
    }

    private static void setSelectedIndex(JList theList, int theIndex) {
        if (theIndex >= 0) {
            if (theIndex < theList.getModel().getSize()) {
                theList.setSelectedIndex(theIndex);
            } else {
                ColumnsDialog.setSelectedIndex(theList, --theIndex);
            }
        }
    }

    private void changeAvailListButtons() {
        boolean result = this.listAvail.getModel().getSize() > 0 && this.listAvail.getSelectedIndex() >= 0;
        this.buttonAdd.setEnabled(result);
    }

    private void changeCurrentListButtons() {
        int index = this.listCurrent.getSelectedIndex();
        int size = this.listCurrent.getModel().getSize();
        this.buttonUp.setEnabled(index > 0 && size > 1);
        this.buttonDown.setEnabled(index >= 0 && size > 1 && index < size - 1);
        this.buttonRemove.setEnabled(index >= 0 && size > 1);
        boolean enabled = index >= 0 && size > 0;
        this.btnSuperSmaller.setEnabled(enabled);
        this.btnSmaller.setEnabled(enabled);
        this.btnSuperLarger.setEnabled(enabled);
        this.btnLarger.setEnabled(enabled);
    }

    private void moveItem(boolean theDirection) {
        int index = this.listCurrent.getSelectedIndex();
        Object object = this.listCurrent.getModel().getElementAt(index);
        ((ColumnListModel)this.listCurrent.getModel()).removeElementAt(index);
        ((ColumnListModel)this.listCurrent.getModel()).insertElementAt((IColumnFieldInfo)object, theDirection ? --index : ++index);
        ColumnsDialog.setSelectedIndex(this.listCurrent, index);
    }

    private void addItem() {
        int sourceIndex = this.listAvail.getSelectedIndex();
        int targetIndex = this.listCurrent.getSelectedIndex();
        boolean needSelection = false;
        if (targetIndex < 0) {
            targetIndex = 0;
            needSelection = true;
        }
        Object object = this.listAvail.getModel().getElementAt(sourceIndex);
        ((ColumnListModel)this.listCurrent.getModel()).addElement((IColumnFieldInfo)object);
        if (object != null) {
            ((ColumnListModel)this.listAvail.getModel()).removeElementAt(sourceIndex);
        }
        ColumnsDialog.setSelectedIndex(this.listAvail, sourceIndex);
        if (needSelection) {
            ColumnsDialog.setSelectedIndex(this.listCurrent, 0);
        }
    }

    private void removeItem() {
        Object object;
        int sourceIndex = this.listCurrent.getSelectedIndex();
        int targetIndex = this.listAvail.getSelectedIndex();
        boolean needSelection = false;
        if (targetIndex < 0) {
            targetIndex = 0;
            needSelection = true;
        }
        if ((object = this.listCurrent.getModel().getElementAt(sourceIndex)) != null) {
            ((ColumnListModel)this.listAvail.getModel()).insertElementAt((IColumnFieldInfo)object, targetIndex);
        }
        ((ColumnListModel)this.listCurrent.getModel()).removeElementAt(sourceIndex);
        ColumnsDialog.setSelectedIndex(this.listCurrent, sourceIndex);
        if (needSelection) {
            ColumnsDialog.setSelectedIndex(this.listAvail, 0);
        }
    }

    private void moveItemUp() {
        this.moveItem(true);
    }

    private void moveItemDown() {
        this.moveItem(false);
    }

    @Override
    public void showMe() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void changeWidth(int delta) {
        int height = this.testColumn.getHeight();
        int width = this.testColumn.getWidth();
        int newWidth = width + delta;
        if (newWidth < 20 && delta < 0) {
            newWidth = 20;
        } else if (newWidth >= this.columnPanel.getWidth() - 10) {
            newWidth = this.columnPanel.getWidth() - 10;
        }
        this.testColumn.setMaximumSize(new Dimension(newWidth, height));
        this.testColumn.setMinimumSize(new Dimension(newWidth, height));
        this.testColumn.setPreferredSize(new Dimension(newWidth, height));
        this.columnPanel.updateUI();
        IColumnFieldInfo selectedColumnInfo = this.getSelectedColumnInfo();
        if (selectedColumnInfo != null) {
            selectedColumnInfo.setWidth(newWidth);
        }
    }

    private class WidthListener
    implements ActionListener {
        private WidthListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (ColumnsDialog.this.btnSuperSmaller.equals(source)) {
                ColumnsDialog.this.changeWidth(-20);
            } else if (ColumnsDialog.this.btnSmaller.equals(source)) {
                ColumnsDialog.this.changeWidth(-5);
            } else if (ColumnsDialog.this.btnLarger.equals(source)) {
                ColumnsDialog.this.changeWidth(5);
            } else if (ColumnsDialog.this.btnSuperLarger.equals(source)) {
                ColumnsDialog.this.changeWidth(20);
            }
        }
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Object source = e.getSource();
            if (ColumnsDialog.this.listAvail.equals(source)) {
                ColumnsDialog.this.changeAvailListButtons();
            } else if (ColumnsDialog.this.listCurrent.equals(source)) {
                ColumnsDialog.this.changeCurrentListButtons();
                ColumnsDialog.this.updateTestColumn();
            }
        }
    }

    private class PositionListener
    implements ActionListener {
        private PositionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (ColumnsDialog.this.buttonAdd.equals(source)) {
                ColumnsDialog.this.addItem();
            } else if (ColumnsDialog.this.buttonRemove.equals(source)) {
                ColumnsDialog.this.removeItem();
            } else if (ColumnsDialog.this.buttonUp.equals(source)) {
                ColumnsDialog.this.moveItemUp();
            } else if (ColumnsDialog.this.buttonDown.equals(source)) {
                ColumnsDialog.this.moveItemDown();
            }
            ColumnsDialog.this.changeAvailListButtons();
            ColumnsDialog.this.changeCurrentListButtons();
            ColumnsDialog.this.updateTestColumn();
        }
    }

    private class RemoveItemListener
    extends MouseAdapter {
        private RemoveItemListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && ColumnsDialog.this.listCurrent.getModel().getSize() > 1) {
                ColumnsDialog.this.removeItem();
                ColumnsDialog.this.changeAvailListButtons();
                ColumnsDialog.this.changeCurrentListButtons();
            }
        }
    }

    private class AddItemListener
    extends MouseAdapter {
        private AddItemListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                ColumnsDialog.this.addItem();
                ColumnsDialog.this.changeAvailListButtons();
                ColumnsDialog.this.changeCurrentListButtons();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnListModel
    extends AbstractListModel {
        List<IColumnFieldInfo> fieldInfos;

        public ColumnListModel(List<IColumnFieldInfo> fieldInfos) {
            this.fieldInfos = fieldInfos;
        }

        @Override
        public int getSize() {
            return this.fieldInfos.size();
        }

        @Override
        public Object getElementAt(int theIndex) {
            return this.fieldInfos.get(theIndex);
        }

        public void insertElementAt(IColumnFieldInfo fieldInfo, int theIndex) {
            this.fieldInfos.add(theIndex, fieldInfo);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void removeElementAt(int theIndex) {
            this.fieldInfos.remove(theIndex);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void addElement(IColumnFieldInfo fieldInfo) {
            this.fieldInfos.add(fieldInfo);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void removeElement(IColumnFieldInfo fieldInfo) {
            this.fieldInfos.remove(fieldInfo);
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            ColumnsDialog.this.displaySettings.setColumnAndSortInfo(ColumnsDialog.this.selectedInfos.toArray(new IColumnFieldInfo[ColumnsDialog.this.selectedInfos.size()]), ColumnsDialog.this.displaySettings.getColumnAndSortInfo().getSortField());
            ColumnsDialog.this.setActionCompleteSuccessfully(true);
            GWDialog.disposeDialog(ColumnsDialog.this);
        }
    }
}

