/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.folder.FolderCountInfo;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.itemlisttable.IconsFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColorChooserButton;
import com.novell.gw.jclient.application.dialogs.folderproperties.SavablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class GeneralPanel
extends SavablePanel {
    private MVCController controller;
    private final AbstractFolder folder;
    private FoldersNameTextField tfFoldersName;
    private GWTextArea taInfo;
    private GWTextArea taDescription;
    private OrientableCheckBox cbAutoselect;
    private OrientableCheckBox cbCalendarShowInMainCalendar;
    private OrientableCheckBox cbCalendarColor;
    private OrientableComboBox cbAddressBooks;
    private ColorChooserButton btnColorChooser;
    private Color calendarColor;
    private CountThread countThread;

    public GeneralPanel(AbstractFolder folder, MVCController controller) {
        this.folder = folder;
        this.controller = controller;
        this.init();
        this.buildUI();
        this.loadProperties();
    }

    private void init() {
        this.tfFoldersName = new FoldersNameTextField(this.getFolder());
        this.propertyManager.addPropertyView(this.tfFoldersName);
        this.cbAutoselect = new OrientableCheckBox(StringResources.SELECT_UNREAD_ITEM_WHEN_FOLDER_IS_OPENED);
        this.propertyManager.addPropertyView(this.cbAutoselect);
        this.cbAddressBooks = new OrientableComboBox();
        this.propertyManager.addPropertyView(this.cbAddressBooks);
        this.btnColorChooser = new ColorChooserButton(null);
        this.propertyManager.addPropertyView(this.btnColorChooser);
        this.cbCalendarColor = new OrientableCheckBox(StringResources.COLOR_C);
        this.propertyManager.addPropertyView(this.cbCalendarColor);
        this.cbCalendarShowInMainCalendar = new OrientableCheckBox(StringResources.SHOW_IN_MAIN_CALENDAR);
        this.propertyManager.addPropertyView(this.cbCalendarShowInMainCalendar);
        this.taDescription = new GWTextArea(5, 1);
        this.propertyManager.addPropertyView(this.taDescription);
        this.taInfo = new GWTextArea();
    }

    private IFolder getFolder() {
        return this.folder.getNativeFolder();
    }

    public MVCController getController() {
        return this.controller;
    }

    private void buildUI() {
        FolderType type;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(this);
        gridBagAdapter.setColumnCount(2);
        gridBagAdapter.setResizableColumn(1);
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.setFill(0);
        gridBagAdapter.addComponent(new OrientableLabel(IconsFactory.getIconForFolder(this.getFolder())));
        gridBagAdapter.addComponent(this.tfFoldersName);
        gridBagAdapter.setGridWidth(2);
        gridBagAdapter.addComponent(new JSeparator());
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.TYPE_C));
        gridBagAdapter.addComponent(new OrientableLabel(this.folder.getTypeString()));
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.OWNER_C));
        gridBagAdapter.addComponent(new OrientableLabel(this.folder.getNativeFolder().getOwnerName()));
        if (!(this.folder instanceof QueryFolder)) {
            gridBagAdapter.addComponent(new OrientableLabel(StringResources.CONTAINS_C));
            String countString = StringResources.COUNTING_CONTENTS;
            this.doCountThread();
            this.taInfo.setEditable(false);
            this.taInfo.setOpaque(false);
            this.taInfo.setText(countString);
            gridBagAdapter.addComponent(this.taInfo);
        }
        if (this.folder.getNativeFolder().canSelectFirstUnreadPropertyOption()) {
            gridBagAdapter.addComponent(new OrientableLabel(""));
            this.cbAutoselect.setSelected(this.getFolder().getSelectFirstUnreadItemState());
            gridBagAdapter.addComponent(this.cbAutoselect);
            gridBagAdapter.addComponent(new OrientableLabel(""));
            GWTextArea taNote = new GWTextArea();
            ((JTextComponent)taNote).setEditable(false);
            taNote.setOpaque(false);
            ((JTextComponent)taNote).setText(StringResources.SELECT_UNREAD_ITEM_DESCRIPTION);
            gridBagAdapter.addComponent(taNote);
        }
        if ((type = this.getFolder().getType()) == FolderType.CONTACTS) {
            gridBagAdapter.setGridWidth(2);
            gridBagAdapter.addComponent(new OrientableLabel(StringResources.ADDRESS_BOOK_C));
            ArrayList<AbstractAddressBook> personalAddressBooks = new ArrayList<AbstractAddressBook>();
            for (AbstractAddressBook addressBook : EngineCommandManager.getAddressBooks()) {
                if (!(addressBook instanceof PersonalAddressBook)) continue;
                personalAddressBooks.add(addressBook);
            }
            AbstractAddressBook addressBook = ((ContactsFolder)this.folder).getAddressBook(EngineCommandManager.getAddressBookManager());
            this.cbAddressBooks.setModel(new DefaultComboBoxModel<Object>(personalAddressBooks.toArray()));
            this.cbAddressBooks.setSelectedItem(addressBook);
            gridBagAdapter.setGridWidth(2);
            gridBagAdapter.addComponent(this.cbAddressBooks);
        } else if (type == FolderType.USER_CONTACTS) {
            gridBagAdapter.addComponent(new OrientableLabel(StringResources.ADDRESS_BOOK_C));
            gridBagAdapter.addComponent(new OrientableLabel(this.folder.getName()));
        }
        if (this.folder instanceof SubCalendarFolder || this.folder instanceof CalendarFolder) {
            this.calendarColor = this.folder.getNativeFolder().getCalendarColor();
            this.btnColorChooser.setColor(this.calendarColor);
            this.btnColorChooser.addPropertyChangeListener(new PropertyColorChangedAction());
            OrientablePanel calendarPanel = new OrientablePanel(new GridLayout(2, 1));
            OrientablePanel calendarShowPanel = new OrientablePanel(new FlowLayout(3));
            calendarPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), StringResources.CALENDAR_FOLDER));
            this.cbCalendarShowInMainCalendar.setSelected(this.folder.isSubCalendarShown());
            calendarShowPanel.add(this.cbCalendarShowInMainCalendar);
            if (this.folder instanceof CalendarFolder) {
                this.cbCalendarShowInMainCalendar.setEnabled(false);
            }
            calendarPanel.add(calendarShowPanel);
            OrientablePanel calendarColorPanel = new OrientablePanel(new FlowLayout(3));
            this.cbCalendarColor.setSelected(this.calendarColor != null);
            this.btnColorChooser.setEnabled(this.calendarColor != null);
            this.cbCalendarColor.addChangeListener(new CalendarColorCheckBoxListener());
            if (this.calendarColor == null) {
                this.calendarColor = AppointmentAcceptLevel.BUSY.getColor();
            }
            calendarColorPanel.add(this.cbCalendarColor);
            calendarColorPanel.add(this.btnColorChooser);
            calendarPanel.add(calendarColorPanel);
            gridBagAdapter.addComponent(new OrientableLabel(""));
            gridBagAdapter.addComponent(calendarPanel);
        }
        gridBagAdapter.setGridWidth(2);
        gridBagAdapter.addComponent(new JSeparator());
        gridBagAdapter.setGridWidth(1);
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.DESCRIPTION_C));
        gridBagAdapter.addComponent(new OrientableLabel(""));
        this.taDescription.setText(this.folder.getDescription());
        OrientableScrollPane scroll = new OrientableScrollPane(this.taDescription);
        gridBagAdapter.setGridHeight(0);
        gridBagAdapter.setGridWidth(0);
        gridBagAdapter.setWidthX(3);
        gridBagAdapter.setWidthY(3);
        gridBagAdapter.addComponent(scroll);
        gridBagAdapter.setWidthY(100);
        gridBagAdapter.addComponent(new OrientableLabel());
    }

    public boolean saveProperties() {
        IFolder nativeFolder;
        super.saveProperties();
        this.tfFoldersName.updateFoldersName(this.getFolder());
        if (this.folder instanceof ContactsFolder) {
            if (this.cbAddressBooks != null && this.cbAddressBooks.getSelectedItem() instanceof PersonalAddressBook) {
                PersonalAddressBook addressBook = (PersonalAddressBook)this.cbAddressBooks.getSelectedItem();
                ((ContactsFolder)this.folder).setAddressBook(addressBook);
                this.getController().processCommand(new Command(1200, this.folder));
                this.getController().processCommand(new Command(360, addressBook));
            } else {
                this.getController().processCommand(new Command(1920, this.folder));
            }
        }
        if ((nativeFolder = this.folder.getNativeFolder()).canSelectFirstUnreadPropertyOption()) {
            this.folder.setSelectFirstUnreadItemState(this.cbAutoselect.isSelected());
        }
        if (this.folder.isCalendarChildFolder()) {
            ((SubCalendarFolder)this.folder).setSubCalendarShown(this.cbCalendarShowInMainCalendar.isSelected());
            if (this.cbCalendarColor.isSelected()) {
                nativeFolder.setCalendarColor(this.calendarColor);
            } else {
                nativeFolder.setCalendarColor(null);
            }
        }
        if (this.folder instanceof CalendarFolder) {
            if (this.cbCalendarColor.isSelected()) {
                nativeFolder.setCalendarColor(this.calendarColor);
            } else {
                nativeFolder.setCalendarColor(null);
            }
        }
        this.folder.setDescription(this.taDescription.getText());
        this.propertyManager.readInitialProperties();
        return true;
    }

    private void setCalendarColor(Color color) {
        if (color == null) {
            this.cbCalendarColor.setSelected(false);
        }
        this.calendarColor = color;
        this.btnColorChooser.setColor(color);
        if (this.calendarColor == null) {
            this.calendarColor = AppointmentAcceptLevel.BUSY.getColor();
        }
    }

    private void doCountThread() {
        this.countThread = new CountThread();
        this.countThread.start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.countThread.waitForCounting();
    }

    private class CountThread
    extends Thread {
        private boolean m_bCountThreadRunning = false;

        private CountThread() {
        }

        public void run() {
            int nChildren;
            int nDraft;
            int nPosted;
            int nSent;
            this.m_bCountThreadRunning = true;
            FolderCountInfo folderCountInfo = GeneralPanel.this.folder.getCountOFContents();
            int nReceived = folderCountInfo.getReceivedCount();
            int nTotalCount = nReceived + (nSent = folderCountInfo.getSentCount()) + (nPosted = folderCountInfo.getPostedCount()) + (nDraft = folderCountInfo.getDraftCount()) + (nChildren = folderCountInfo.getChildFoldersCount());
            final String strCount = nTotalCount > 0 ? (!(GeneralPanel.this.folder instanceof ContactsFolder) ? nReceived + " " + StringResources.RECEIVED_ITEMS + ", " + nSent + ' ' + StringResources.SENT_ITEMS + ", " + nPosted + ' ' + StringResources.POSTED_ITEMS + ", " + nDraft + ' ' + StringResources.DRAFT_ITEMS + (GeneralPanel.this.folder.canHaveChildren() ? ", " + nChildren + ' ' + StringResources.FOLDERS : "") : nReceived + " " + StringResources.CONTACTS + ", " + nSent + ' ' + StringResources.GROUPS + ", " + nPosted + ' ' + StringResources.RESOURCES + ", " + nDraft + ' ' + StringResources.ORGANIZATIONS) : StringResources.FOLDER_IS_EMPTY;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GeneralPanel.this.taInfo.setText(strCount);
                }
            });
            this.m_bCountThreadRunning = false;
        }

        private void waitForCounting() {
            while (this.m_bCountThreadRunning) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    private class PropertyColorChangedAction
    implements PropertyChangeListener {
        private PropertyColorChangedAction() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(ColorChooserButton.COLOR_CHANGE_PROPERTY_NAME)) {
                GeneralPanel.this.setCalendarColor(GeneralPanel.this.btnColorChooser.getColor());
            }
        }
    }

    private class CalendarColorCheckBoxListener
    implements ChangeListener {
        private CalendarColorCheckBoxListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (GeneralPanel.this.cbCalendarColor.isSelected()) {
                GeneralPanel.this.btnColorChooser.setColor(GeneralPanel.this.calendarColor);
                GeneralPanel.this.btnColorChooser.setEnabled(true);
            } else {
                GeneralPanel.this.btnColorChooser.setColor(null);
                GeneralPanel.this.btnColorChooser.setEnabled(false);
            }
        }
    }

    private class FoldersNameTextField
    extends GWTextField {
        public FoldersNameTextField(IFolder folder) {
            super(folder.getName());
            boolean isEditable = folder.canRename();
            this.setEditable(isEditable);
        }

        public void updateFoldersName(IFolder folder) {
            if (folder.canRename()) {
                folder.setName(this.getText());
            }
        }
    }
}

