/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.folder.FolderAccessRights;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.SavablePanel;
import com.novell.gw.jclient.application.dialogs.folderproperties.SharingPropertyPaneController;
import com.novell.gw.jclient.application.dialogs.newfolder.ShareListTable;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SharingPropertyPane
extends SavablePanel
implements MVCView {
    protected ShareListTable tableContactList;
    private JButton btnAddUser = new OrientableButton(new AddUserAction());
    private JButton btnRemoveUser = new OrientableButton(new RemoveUserAction());
    private JButton btnViewAddressBook = new JButton(new ViewAddressBookAction());
    protected SearchTextField tfName;
    private AbstractButton cbAdd = new OrientableCheckBox(new AccessAddAction());
    private AbstractButton cbEdit = new OrientableCheckBox(new AccessEditAction());
    private AbstractButton cbDelete = new OrientableCheckBox(new AccessDeleteAction());
    private SharingPropertyPaneController controller;
    protected boolean isReadOnly;
    private JDialog parentDialog;
    private JScrollPane scrollTable;
    protected AbstractFolder folder;
    private JButton btnDefault;
    protected JPanel pnlBottom = new OrientablePanel(new GridBagLayout());

    public SharingPropertyPane(JDialog theParentDialog, MVCController theParentController, AbstractFolder theFolder) {
        super(new BorderLayout());
        this.folder = theFolder;
        this.parentDialog = theParentDialog;
        this.btnDefault = this.parentDialog.getRootPane().getDefaultButton();
        this.controller = new SharingPropertyPaneController(this, theParentController);
        this.tableContactList = new ShareListTable(this.controller);
        this.tfName = new SearchTextField();
        this.tfName.setName("SharingPropertyPane_tfName");
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SharingPropertyPane.this.enableAddButton();
            }

            public void removeUpdate(DocumentEvent e) {
                SharingPropertyPane.this.enableAddButton();
            }

            public void changedUpdate(DocumentEvent e) {
                SharingPropertyPane.this.enableAddButton();
            }
        });
        this.buildUI();
        this.tableContactList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (e.getKeyCode() == itemDeleteKey) {
                    SharingPropertyPane.this.btnRemoveUser.getAction().actionPerformed(null);
                }
            }
        });
        this.tfName.setListener(new SearchResultListener(){

            public void searchFinished(SearchEvent e) {
                if (e.getFoundContact() != null) {
                    ArrayList<IAddressable> contacts = new ArrayList<IAddressable>(1);
                    contacts.add(e.getFoundContact());
                    SharingPropertyPane.this.tableContactList.addContacts(contacts);
                } else {
                    JOptionPane.showMessageDialog(SharingPropertyPane.this, StringResources.formatString(StringResources.IS_NOT_A_VALID_GROUPWISE_USER, SharingPropertyPane.this.tfName.getText(), SharingPropertyPane.this.tfName.getText()), StringResources.NOVELL_GROUPWISE, 2);
                }
                SharingPropertyPane.this.tfName.setText("");
                SharingPropertyPane.this.tfName.requestFocus();
            }
        });
    }

    public SharingPropertyPane(JDialog theParentDialog, MVCController theParentController) {
        this(theParentDialog, theParentController, null);
    }

    private void enableAddButton() {
        if (this.tfName.getText().trim().length() == 0) {
            this.btnAddUser.setEnabled(false);
            this.parentDialog.getRootPane().setDefaultButton(this.btnDefault);
        } else {
            this.btnAddUser.setEnabled(true);
            this.parentDialog.getRootPane().setDefaultButton(this.btnAddUser);
        }
    }

    public void buildUI() {
        this.setPreferredSize(new Dimension(420, 370));
        this.add((Component)this.buildBottomPane(), "Center");
    }

    public boolean saveSharedList() {
        return this.tableContactList.saveSharedList(this.folder);
    }

    public boolean unShareFolder() {
        return this.tableContactList.unShareFolder(this.folder);
    }

    private JPanel buildBottomPane() {
        OrientablePanel pnlName = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.insets.right = 5;
        constraints.anchor = 21;
        pnlName.add((Component)new OrientableLabel(StringResources.NAME_C), constraints);
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        pnlName.add((Component)this.tfName, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        this.btnViewAddressBook.setPreferredSize(new Dimension(23, 23));
        pnlName.add((Component)this.btnViewAddressBook, constraints);
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(2, 1, 0, 5));
        pnlButtons.add(this.btnAddUser);
        pnlButtons.add(this.btnRemoveUser);
        OrientablePanel pnlTop = new OrientablePanel(new BorderLayout());
        pnlTop.add((Component)pnlName, "Center");
        pnlTop.add((Component)pnlButtons, "After");
        constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.gridy = 1;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets.top = 5;
        constraints.fill = 2;
        this.pnlBottom.add((Component)pnlTop, constraints);
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.scrollTable = new ColoredScrollPane(this.tableContactList);
        this.pnlBottom.add((Component)this.scrollTable, constraints);
        JPanel pnlCheckBoxes = this.buildAccessPanel();
        constraints.weighty = 0.0;
        constraints.gridy = 4;
        constraints.fill = 2;
        this.pnlBottom.add((Component)pnlCheckBoxes, constraints);
        return this.pnlBottom;
    }

    private JPanel buildAccessPanel() {
        OrientablePanel pnlCheckBoxes = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets.left = 30;
        pnlCheckBoxes.add((Component)this.cbAdd, constraints);
        constraints.insets.left = 0;
        pnlCheckBoxes.add((Component)this.cbEdit, constraints);
        constraints.insets.right = 0;
        pnlCheckBoxes.add((Component)this.cbDelete, constraints);
        pnlCheckBoxes.setBorder(BorderFactory.createTitledBorder(StringResources.ADDITIONAL_ACCESS));
        return pnlCheckBoxes;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    protected void enableShareControls(boolean isEnable) {
        this.btnViewAddressBook.setEnabled(isEnable);
        this.tfName.setEditable(isEnable);
        if (isEnable) {
            if (this.tableContactList.getRowCount() > 0 && !this.isReadOnly) {
                this.enableCheckBoxes(true);
                this.btnRemoveUser.setEnabled(true);
            }
        } else {
            this.enableCheckBoxes(false);
            this.btnRemoveUser.setEnabled(false);
        }
        this.tableContactList.setEnabled(isEnable);
        this.tableContactList.setBackground(this.tfName.getBackground());
        this.scrollTable.getViewport().setBackground(this.tfName.getBackground());
        if (this.isReadOnly) {
            this.tableContactList.setEnabled(true);
        }
    }

    public void setController(MVCController theController) {
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof FolderSharedEntry) {
            FolderAccessRights accessEntry = ((FolderSharedEntry)theModel).getAccessRights();
            if (!this.isReadOnly) {
                this.enableCheckBoxes(true);
                this.btnRemoveUser.setEnabled(true);
            }
            this.cbAdd.setSelected(accessEntry.hasAddAccess());
            this.cbDelete.setSelected(accessEntry.hasDeleteAccess());
            this.cbEdit.setSelected(accessEntry.hasEditAccess());
        }
    }

    private void enableCheckBoxes(boolean b) {
        this.cbAdd.setEnabled(b);
        this.cbDelete.setEnabled(b);
        this.cbEdit.setEnabled(b);
    }

    public Object getMVCModel() {
        return null;
    }

    public FolderSharedList getFolderSharedAccessList() {
        return this.tableContactList.getAccessList();
    }

    protected class ViewAddressBookAction
    extends AbstractAction {
        public ViewAddressBookAction() {
            super("", ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
        }

        public void actionPerformed(ActionEvent e) {
            AddressSelectorDialog selectorDialog = new AddressSelectorDialog(SharingPropertyPane.this.parentDialog, SharingPropertyPane.this.getController());
            selectorDialog.setVisible(true);
            if (selectorDialog.isOkActionProcessed()) {
                SharingPropertyPane.this.tableContactList.addContacts(selectorDialog.getSelectedContacts());
            }
        }
    }

    protected class AccessDeleteAction
    extends AbstractAction {
        public AccessDeleteAction() {
            super(StringResources.DELETE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SharingPropertyPane.this.tableContactList.changeDeleteRights(((JCheckBox)e.getSource()).isSelected());
        }
    }

    protected class AccessEditAction
    extends AbstractAction {
        public AccessEditAction() {
            super(StringResources.EDIT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SharingPropertyPane.this.tableContactList.changeEditRights(((JCheckBox)e.getSource()).isSelected());
        }
    }

    protected class AccessAddAction
    extends AbstractAction {
        public AccessAddAction() {
            super(StringResources.ADD);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SharingPropertyPane.this.tableContactList.changeAddRights(((JCheckBox)e.getSource()).isSelected());
        }
    }

    protected class RemoveUserAction
    extends AbstractAction {
        public RemoveUserAction() {
            super(StringResources.REMOVE_USER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SharingPropertyPane.this.tableContactList.removeSelectedUser();
            if (SharingPropertyPane.this.tableContactList.getRowCount() == 0) {
                SharingPropertyPane.this.enableCheckBoxes(false);
                SharingPropertyPane.this.cbAdd.setSelected(false);
                SharingPropertyPane.this.cbDelete.setSelected(false);
                SharingPropertyPane.this.cbEdit.setSelected(false);
                SharingPropertyPane.this.btnRemoveUser.setEnabled(false);
            }
        }
    }

    protected class AddUserAction
    extends AbstractAction {
        public AddUserAction() {
            super(StringResources.ADD_USER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SharingPropertyPane.this.tfName.updateListener();
        }
    }
}

