/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColumnsDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByTableMode;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public abstract class AdvancedViewByTableMode
extends ViewByTableMode {
    private JTextArea taColumns = new GWTextArea(3, 10);
    private JButton btnEditColumn = new OrientableButton(new ActionEditColumns());

    protected AdvancedViewByTableMode(String userGuid, IFolder folder, ViewBySettings viewBySettings) {
        super(userGuid, folder, viewBySettings);
        this.init();
    }

    private void init() {
        this.taColumns.setEditable(false);
        this.rbColumns.addItemListener(new ColumnsItemListener());
        this.propertyManager.addPropertyView(this.taColumns);
    }

    public boolean loadProperties() {
        IViewDisplaySettings viewDisplaySettings = this.getFolderDisplaySettings().asViewDisplaySettings();
        this.taColumns.setText(AdvancedViewByTableMode.getColumnsAsString(viewDisplaySettings.getColumnAndSortInfo().getVisibleColumns()));
        return super.loadProperties();
    }

    static JPanel createCheckBoxesPanel(JCheckBox[][] checkBoxes) {
        OrientablePanel panel = new OrientablePanel(new GridLayout(checkBoxes.length, checkBoxes[0].length, 5, 5));
        JCheckBox[][] arr$ = checkBoxes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JCheckBox[] boxes;
            for (JCheckBox checkBox : boxes = arr$[i$]) {
                panel.add(checkBox);
            }
        }
        return panel;
    }

    static JPanel createLabelWithSeparator(String text) {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        panel.add((Component)new OrientableLabel(text), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets.left = 5;
        panel.add((Component)new JSeparator(), constraints);
        return panel;
    }

    static JPanel createSpinnerWithLabel(JSpinner spinner, JLabel label) {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 21;
        constraints.fill = 2;
        panel.add((Component)spinner, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets.left = 5;
        panel.add((Component)label, constraints);
        return panel;
    }

    protected JPanel createColumnsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        panel.add((Component)new OrientableScrollPane(this.taColumns), constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 24;
        constraints.fill = 0;
        panel.add((Component)this.btnEditColumn, constraints);
        return panel;
    }

    public static String getColumnsAsString(IColumnFieldInfo[] columnFieldInfos) {
        StringBuilder stringBuilder = new StringBuilder();
        int size = columnFieldInfos.length;
        for (int i = 0; i < size; ++i) {
            IColumnFieldInfo columnInfo = columnFieldInfos[i];
            stringBuilder.append(columnInfo.getName());
            if (i >= size - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private class ActionEditColumns
    extends AbstractAction {
        private ActionEditColumns() {
            super(StringResources.EDIT_COLUMNS_D);
        }

        public void actionPerformed(ActionEvent e) {
            JDialog parent = (JDialog)SwingUtilities.getWindowAncestor(AdvancedViewByTableMode.this.btnEditColumn);
            IViewDisplaySettings viewDisplaySettings = AdvancedViewByTableMode.this.folderDisplaySettings.asViewDisplaySettings();
            ColumnsDialog columnsDialog = new ColumnsDialog(parent, viewDisplaySettings, AdvancedViewByTableMode.this.folder.isContactsFolder());
            columnsDialog.showMe();
            AdvancedViewByTableMode.this.taColumns.setText(AdvancedViewByTableMode.getColumnsAsString(viewDisplaySettings.getColumnAndSortInfo().getVisibleColumns()));
        }
    }

    private class ColumnsItemListener
    implements ItemListener {
        private ColumnsItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            boolean selected = AdvancedViewByTableMode.this.rbColumns.isSelected();
            AdvancedViewByTableMode.this.btnEditColumn.setEnabled(selected);
            AdvancedViewByTableMode.this.taColumns.setEnabled(selected);
        }
    }
}

