/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.Savable;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeEvent;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeListener;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyManager;
import com.novell.gw.jclient.application.dialogs.folderproperties.MoreDisplaySettingsDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBySettings;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class ViewBy
implements Savable {
    private static final Logger logger = Logger.getLogger(ViewBy.class);
    protected PropertyManager propertyManager = new PropertyManager();
    protected JButton btnMoreDisplaySettings = new OrientableButton(new MoreDisplaySettingsAction());
    protected IFolderDisplaySettings folderDisplaySettings;
    protected final String userGuid;
    protected final IFolder folder;
    private final ViewBySettings viewBySettings;
    private boolean aditionalSettingsChanged = false;

    protected ViewBy(String userGuid, IFolder folder, ViewBySettings viewBySettings) {
        this.userGuid = userGuid;
        this.folder = folder;
        this.viewBySettings = viewBySettings;
    }

    public IFolderDisplaySettings getFolderDisplaySettings() {
        return this.folderDisplaySettings;
    }

    public void setFolderDisplaySettings(IFolderDisplaySettings folderDisplaySettings) {
        this.folderDisplaySettings = folderDisplaySettings;
        this.loadProperties();
    }

    public void addGWPropertyChangeListener(GWPropertyChangeListener propertyChangeListener) {
        this.propertyManager.addGWPropertyChangeListener(propertyChangeListener);
    }

    public void removeGWPropertyChangeListener(GWPropertyChangeListener propertyChangeListener) {
        this.propertyManager.removeGWPropertyChangeListener(propertyChangeListener);
    }

    public boolean isChangedProperties() {
        return this.aditionalSettingsChanged || this.propertyManager.hasChangedProperties();
    }

    public boolean loadProperties() {
        if (!this.propertyManager.hasReadInitialProperties()) {
            this.propertyManager.readInitialProperties();
        }
        return true;
    }

    public abstract JPanel getLeftPanel();

    public abstract JPanel getRightPanel();

    public abstract int getViewMode();

    public abstract String getViewName();

    public boolean saveProperties() {
        logger.debug((Object)("saveProperties (View Mode: " + this.getViewName() + ")"));
        return this.folderDisplaySettings.setViewMode(this.getViewMode());
    }

    public String toString() {
        return this.getViewName();
    }

    private class MoreDisplaySettingsAction
    extends AbstractAction {
        public MoreDisplaySettingsAction() {
            super(StringResources.MORE_DISPLAY_SETTINGS_D);
        }

        public void actionPerformed(ActionEvent e) {
            if (ViewBy.this.viewBySettings.isChangedProperties()) {
                ViewBy.this.viewBySettings.saveProperties();
            }
            Window dialog = null;
            Window window = SwingUtilities.getWindowAncestor(ViewBy.this.btnMoreDisplaySettings);
            if (window instanceof Dialog) {
                dialog = new MoreDisplaySettingsDialog((Dialog)window, ViewBy.this.userGuid, ViewBy.this.folder, ViewBy.this.folderDisplaySettings);
            } else if (window instanceof Frame) {
                dialog = new MoreDisplaySettingsDialog((Frame)window, ViewBy.this.userGuid, ViewBy.this.folder, ViewBy.this.folderDisplaySettings);
            }
            if (dialog != null) {
                dialog.setLocationRelativeTo(window);
                ((OkCancelDialog)dialog).setVisible(true);
                if (((MoreDisplaySettingsDialog)dialog).isChangedProperties() && ((OkCancelDialog)dialog).isOkActionProcessed()) {
                    ViewBy.this.aditionalSettingsChanged = true;
                    ViewBy.this.viewBySettings.setFolderDisplaySettings(ViewBy.this.folderDisplaySettings);
                    ViewBy.this.viewBySettings.processGWPropertyChangeEvent(new GWPropertyChangeEvent(null, null));
                }
            }
        }
    }
}

