/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties.viewby;

import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.Savable;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeEvent;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeListener;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyManager;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewBy;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByCalendar;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByConversation;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByDetails;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByDetails_Contacts;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByPanels;
import com.novell.gw.jclient.application.dialogs.folderproperties.viewby.ViewByTasklist;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ViewBySettings
implements Savable {
    private static final Logger logger = Logger.getLogger(ViewBySettings.class);
    private PropertyManager propertyManager = new PropertyManager();
    protected final String userGUid;
    protected JComboBox cmbViewBy = new OrientableComboBox();
    private CardLayout rightPanelLayout = new CardLayout();
    private CardLayout leftPanelLayout = new CardLayout();
    private IFolderDisplaySettings displaySettings;
    protected final IFolder folder;
    protected JPanel pnlRight = new OrientablePanel(this.rightPanelLayout);
    protected JPanel pnlLeft = new OrientablePanel(this.leftPanelLayout);
    protected JPanel pnlLeftAdvanced = new OrientablePanel();
    protected Map<Integer, ViewBy> viewByMap = new HashMap<Integer, ViewBy>();
    private ViewBy lastSelectedViewBy;
    private List<ViewBy> supportedViewMods = new ArrayList<ViewBy>();
    private GWPropertyChangeListener propertyChangeListener;

    public ViewBySettings(String userGUid, IFolder folder) {
        this.userGUid = userGUid;
        this.folder = folder;
        this.init();
        this.buidlUI();
    }

    private void init() {
        this.initViewModes();
        for (Integer viewMode : ControlsUtils.getSupportedViewMods(this.folder, false)) {
            ViewBy viewBy = this.viewByMap.get(viewMode);
            if (viewBy == null) continue;
            this.supportedViewMods.add(viewBy);
        }
        Collections.sort(this.supportedViewMods, new Comparator<ViewBy>(){

            @Override
            public int compare(ViewBy o1, ViewBy o2) {
                return o1.getViewName().compareTo(o2.getViewName());
            }
        });
        this.cmbViewBy.setModel(new DefaultComboBoxModel<Object>(this.supportedViewMods.toArray()));
        this.cmbViewBy.addActionListener(new ViewByActionListener());
        this.propertyManager.addPropertyView(this.cmbViewBy);
    }

    protected void initViewModes() {
        boolean isContacts = this.folder.isContactsFolder();
        ViewBy viewBy = isContacts ? new ViewByDetails_Contacts(this.userGUid, this.folder, this) : new ViewByDetails(this.userGUid, this.folder, this);
        this.viewByMap.put(viewBy.getViewMode(), viewBy);
        viewBy = new ViewByConversation(this.userGUid, this.folder, this);
        this.viewByMap.put(viewBy.getViewMode(), viewBy);
        viewBy = new ViewByTasklist(this.userGUid, this.folder, this);
        this.viewByMap.put(viewBy.getViewMode(), viewBy);
        viewBy = new ViewByPanels(this.userGUid, this.folder, this);
        this.viewByMap.put(viewBy.getViewMode(), viewBy);
        viewBy = new ViewByCalendar(this.userGUid, this.folder, this);
        this.viewByMap.put(viewBy.getViewMode(), viewBy);
    }

    public ViewBy getSelectedViewBy() {
        return (ViewBy)this.cmbViewBy.getSelectedItem();
    }

    private void updateView(ViewBy viewBy) {
        this.lastSelectedViewBy = viewBy;
        viewBy.setFolderDisplaySettings(this.displaySettings);
        String viewModeString = Integer.toString(viewBy.getViewMode());
        this.leftPanelLayout.show(this.pnlLeft, viewModeString);
        this.rightPanelLayout.show(this.pnlRight, viewModeString);
    }

    public IFolderDisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    public boolean setFolderDisplaySettings(IFolderDisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
        this.lastSelectedViewBy = null;
        return this.loadProperties();
    }

    protected void buidlUI() {
        this.pnlLeftAdvanced.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets.bottom = 10;
        this.pnlLeftAdvanced.add((Component)this.cmbViewBy, constraints);
        ++constraints.gridy;
        for (Integer viewMode : this.viewByMap.keySet()) {
            this.pnlLeft.add(viewMode.toString(), this.viewByMap.get(viewMode).getLeftPanel());
        }
        this.pnlLeftAdvanced.add((Component)this.pnlLeft, constraints);
        for (Integer viewMode : this.viewByMap.keySet()) {
            this.pnlRight.add(viewMode.toString(), this.viewByMap.get(viewMode).getRightPanel());
        }
    }

    public JPanel getRightPanel() {
        return this.pnlRight;
    }

    public JPanel getLeftPanel() {
        return this.pnlLeftAdvanced;
    }

    public void setGWPropertyChangeListener(GWPropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
        this.propertyManager.addGWPropertyChangeListener(propertyChangeListener);
        for (ViewBy viewBy : this.viewByMap.values()) {
            viewBy.addGWPropertyChangeListener(propertyChangeListener);
        }
    }

    public void processGWPropertyChangeEvent(GWPropertyChangeEvent propertyChangeEvent) {
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.propertyChanged(propertyChangeEvent);
        }
    }

    public void removeGWPropertyChangeListener(GWPropertyChangeListener propertyChangeListener) {
        this.propertyManager.removeGWPropertyChangeListener(propertyChangeListener);
    }

    public boolean isChangedProperties() {
        ViewBy viewBy = (ViewBy)this.cmbViewBy.getSelectedItem();
        return viewBy.isChangedProperties() || this.propertyManager.hasChangedProperties();
    }

    public boolean saveProperties() {
        logger.debug((Object)"saveProperties");
        ViewBy viewBy = (ViewBy)this.cmbViewBy.getSelectedItem();
        boolean result = this.displaySettings.setViewMode(viewBy.getViewMode());
        result = result && viewBy.saveProperties();
        logger.debug((Object)("result: " + result));
        return result;
    }

    public boolean loadProperties() {
        ViewBy defaultViewBy = this.viewByMap.get(this.displaySettings.getViewMode());
        if (defaultViewBy == null) {
            Collection<ViewBy> collection = this.viewByMap.values();
            defaultViewBy = collection.toArray(new ViewBy[collection.size()])[0];
        }
        if (!this.supportedViewMods.contains(defaultViewBy)) {
            defaultViewBy = this.supportedViewMods.get(0);
        }
        this.cmbViewBy.setSelectedItem(defaultViewBy);
        if (!this.propertyManager.hasReadInitialProperties()) {
            this.propertyManager.readInitialProperties();
        }
        return true;
    }

    private class ViewByActionListener
    implements ActionListener {
        private ViewByActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)"actionPerformed");
            if (ViewBySettings.this.lastSelectedViewBy != null && ViewBySettings.this.lastSelectedViewBy.isChangedProperties()) {
                logger.debug((Object)"saving");
                ViewBySettings.this.lastSelectedViewBy.saveProperties();
            }
            ViewBy viewBy = (ViewBy)ViewBySettings.this.cmbViewBy.getSelectedItem();
            ViewBySettings.this.updateView(viewBy);
        }
    }
}

