/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.appframework.utils.OS;
import com.novell.gw.engine.JunkMailAddParams;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.junkmail.HTMLLabel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class JunkMailAddDialog
extends GWDialog {
    protected JTextArea taAddress = new GWTextArea();
    protected JRadioButton rbEmailAddress = new JMnemonicRadioButton();
    protected JRadioButton rbDomain = new JMnemonicRadioButton(){

        public void setText(String text) {
            super.setText("<html>" + text + "</html>");
        }
    };
    protected JRadioButton rbNone = new JMnemonicRadioButton();
    protected JLabel lbAddAddress = new HTMLLabel();
    protected JLabel lbListDisabled = new OrientableLabel();
    protected JCheckBox cbMoveItem = new JMnemonicCheckBox();
    protected JCheckBox cbEnableList = new JMnemonicCheckBox();
    protected boolean bDisplayEnableList = false;
    protected String emailAddressAdd;
    protected String domainAddressAdd;
    protected String noneAddressAdd;
    private JunkMailAddParams mailAddParams;

    public JunkMailAddDialog(JFrame theFrame, JunkMailAddParams params) {
        this.setModal(true);
        this.mailAddParams = params;
        this.setTitle(this.getString(1));
        this.initActions();
        this.init();
        this.buildUI();
    }

    public void showMe() {
        this.rbEmailAddress.doClick();
        super.showMe();
    }

    private void initActions() {
        this.rbEmailAddress.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JunkMailAddDialog.this.lbAddAddress.setText(JunkMailAddDialog.this.emailAddressAdd);
                JunkMailAddDialog.this.taAddress.setText(JunkMailAddDialog.this.mailAddParams.getAddresses());
            }
        });
        this.rbDomain.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JunkMailAddDialog.this.lbAddAddress.setText(JunkMailAddDialog.this.domainAddressAdd);
                JunkMailAddDialog.this.taAddress.setText(JunkMailAddDialog.this.mailAddParams.getDomains());
            }
        });
        this.rbNone.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JunkMailAddDialog.this.lbAddAddress.setText(JunkMailAddDialog.this.noneAddressAdd);
                JunkMailAddDialog.this.taAddress.setText("");
            }
        });
    }

    private String getString(int strinID) {
        String dlgString = this.mailAddParams.getDlgString(strinID);
        return StringResources.readMnemonicInfo(dlgString);
    }

    private void init() {
        String sListEnable;
        this.emailAddressAdd = this.getString(4);
        this.domainAddressAdd = this.getString(5);
        this.noneAddressAdd = this.getString(13);
        this.rbEmailAddress.setText(this.getString(6));
        this.rbDomain.setText(this.getString(7));
        this.rbNone.setText(this.getString(12));
        this.cbMoveItem.setText(this.getString(8));
        this.cbMoveItem.setSelected((this.mailAddParams.getFlags() & 0x1000) > 0);
        this.taAddress.setText(this.mailAddParams.getAddresses());
        if ((this.mailAddParams.getFlags() & 0x400000) == 0 && (sListEnable = this.getString(11)) != null && sListEnable.length() > 0) {
            this.bDisplayEnableList = true;
            this.cbEnableList.setText(sListEnable);
            boolean selected = (this.mailAddParams.getFlags() & 0x100000) > 0;
            this.cbEnableList.setSelected(selected);
            boolean disable = (this.mailAddParams.getFlags() & 0x200000) > 0;
            this.cbEnableList.setEnabled(!disable);
            this.lbListDisabled.setText(this.getString(10));
        }
    }

    protected void buildUI() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbEmailAddress);
        buttonGroup.add(this.rbDomain);
        buttonGroup.add(this.rbNone);
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        pnlContent.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.insets.bottom = 3;
        constraints.anchor = 21;
        pnlContent.add((Component)new OrientableLabel(this.getString(2)), constraints);
        this.taAddress.setEditable(false);
        this.taAddress.setRows(4);
        constraints.gridy = 1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.insets.bottom = 5;
        constraints.ipady = 55;
        pnlContent.add((Component)new OrientableScrollPane(this.taAddress), constraints);
        ++constraints.gridy;
        constraints.ipady = 0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.insets.bottom = 20;
        pnlContent.add((Component)this.lbAddAddress, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 1;
        pnlContent.add((Component)this.rbEmailAddress, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 5;
        constraints.fill = 2;
        pnlContent.add((Component)this.rbDomain, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 5;
        constraints.fill = 2;
        pnlContent.add((Component)this.rbNone, constraints);
        ++constraints.gridy;
        pnlContent.add((Component)new JSeparator(), constraints);
        ++constraints.gridy;
        constraints.anchor = 23;
        if (!this.bDisplayEnableList) {
            constraints.weighty = 1.0;
        }
        pnlContent.add((Component)this.cbMoveItem, constraints);
        ++constraints.gridy;
        if (this.bDisplayEnableList) {
            constraints.insets.top = 20;
            constraints.anchor = 23;
            pnlContent.add((Component)new JSeparator(), constraints);
            ++constraints.gridy;
            constraints.insets.bottom = 3;
            constraints.insets.top = 0;
            pnlContent.add((Component)this.lbListDisabled, constraints);
            ++constraints.gridy;
            constraints.insets.bottom = 5;
            constraints.weighty = 1.0;
            pnlContent.add((Component)this.cbEnableList, constraints);
            ++constraints.gridy;
        }
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(buttonPanel, this.btnOK, this.btnCancel);
        constraints.anchor = 23;
        constraints.weighty = 0.0;
        pnlContent.add((Component)buttonPanel, constraints);
    }

    protected void performOkAction() {
        if (this.rbDomain.isSelected()) {
            this.mailAddParams.setAddressType(2);
        } else if (this.rbEmailAddress.isSelected()) {
            this.mailAddParams.setAddressType(1);
        } else {
            this.mailAddParams.setAddressType(8);
        }
        if ((this.mailAddParams.getFlags() & 0x4000) == 0) {
            this.mailAddParams.setMoveItem(this.cbMoveItem.isSelected());
        }
        if ((this.mailAddParams.getFlags() & 0x400000) == 0) {
            this.mailAddParams.setListEnable(this.cbEnableList.isSelected());
        }
        super.performOkAction();
    }
}

