/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.JunkMailList;
import com.novell.gw.engine.JunkMailListManager;
import com.novell.gw.engine.JunkMailSettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.junkmail.AddressesListPane;
import com.novell.gw.jclient.application.dialogs.junkmail.BlockListPanel;
import com.novell.gw.jclient.application.dialogs.junkmail.JunkListPanel;
import com.novell.gw.jclient.application.dialogs.junkmail.JunkMailDialogController;
import com.novell.gw.jclient.application.dialogs.junkmail.JunkSettingsPanel;
import com.novell.gw.jclient.application.dialogs.junkmail.TrustListPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunkMailDialog
extends ApplicationDialog<JunkMailDialogController> {
    private static Logger logger = Logger.getLogger(JunkMailDialog.class);
    public static final int ADDRESS_TYPE_ALL = 3;
    private JTabbedPane tabOptions = new OrientableTabbedPane();
    private JunkMailSettings junkMailSettings;
    private JunkSettingsPanel junkSettingsPanel;
    private JunkMailListManager junkMailListManager;
    private JPanel junkListPanel;
    private final ActionListener settingChangeListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JunkMailDialog.this.checkModel();
        }
    };
    private final ActionListener listsChangeListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JunkMailDialog.this.modelChanged();
        }
    };

    public JunkMailDialog(JFrame parent, MVCController parentController) throws HeadlessException {
        super((Frame)parent, parentController);
        this.init();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        int junkFixedHeight = this.junkListPanel.getSize().height;
        int junkSettingsHeight = this.junkSettingsPanel.getPreferredSize().height;
        this.junkSettingsPanel.setPreferredSize(new Dimension(this.junkListPanel.getSize().width, junkSettingsHeight));
    }

    private void init() {
        String userGuid = ControlsUtils.getUserGuid(this.getController());
        try {
            this.junkMailListManager = GWCommandManager.getInstance(userGuid).getJunkMailListManager();
        }
        catch (EngineException e) {
            logger.error((Object)e);
        }
        this.buildUI();
        this.junkMailSettings = GWCommandManager.getInstance(userGuid).getJunkMailSettings();
        this.junkSettingsPanel.setSettings(this.junkMailSettings);
    }

    private void buildUI() {
        this.setTitle(StringResources.JUNK_MAIL_HANDLING);
        this.tabOptions.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.junkSettingsPanel = new JunkSettingsPanel(this.settingChangeListener);
        this.tabOptions.addTab(StringResources.SETTINGS, new OrientableScrollPane(this.junkSettingsPanel));
        try {
            JunkMailList list = this.junkMailListManager.createList(3, 3);
            this.junkListPanel = new JunkListPanel(list);
            this.tabOptions.addTab(this.junkListPanel.getName(), new OrientableScrollPane(this.junkListPanel));
            list = this.junkMailListManager.createList(2, 3);
            AddressesListPane listPanel = new BlockListPanel(list);
            this.tabOptions.addTab(listPanel.getName(), new OrientableScrollPane(listPanel));
            list = this.junkMailListManager.createList(1, 3);
            listPanel = new TrustListPanel(list);
            this.tabOptions.addTab(listPanel.getName(), new OrientableScrollPane(listPanel));
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.getContentPane().add((Component)this.tabOptions, "Center");
        this.getContentPane().add((Component)this.createButonsPanel(), "South");
        this.tabOptions.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                OrientableScrollPane scrollPane = (OrientableScrollPane)((JTabbedPane)e.getSource()).getSelectedComponent();
                Component component = ((JViewport)scrollPane.getComponents()[0]).getComponents()[0];
                if (component instanceof AddressesListPane) {
                    ((AddressesListPane)component).updateTableSelection();
                }
            }
        });
    }

    private void checkModel() {
        if (this.junkMailSettings != null) {
            JunkMailSettings s = this.junkSettingsPanel.getSettings();
            this.getBtnApply().setEnabled(!this.junkMailSettings.equals((Object)s));
        } else {
            this.getBtnApply().setEnabled(true);
        }
    }

    private void modelChanged() {
        this.getBtnApply().setEnabled(true);
    }

    private void applyChanges() {
        String userGuid = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(ApplicationFrame.class, this)).getUserGuid();
        this.junkMailSettings = this.junkSettingsPanel.getSettings();
        try {
            GWCommandManager.getInstance(userGuid).setJunkMailSettings(this.junkMailSettings);
            this.junkMailListManager.apply();
        }
        catch (GWCommandException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, StringResources.JUNK_MAIL_SETTINGS_ERROR, "", 0);
        }
        this.getBtnApply().setEnabled(false);
    }

    private boolean askForChangesLose() {
        int res = JOptionPane.showConfirmDialog(this, StringResources.JUNK_SETTINGS_LOSE_CHANGES_Q, StringResources.WARNING_E, 2, 2);
        return res == 0;
    }

    private JPanel createButonsPanel() {
        this.getBtnApply().addActionListener(this.settingChangeListener);
        this.getBtnApply().setEnabled(false);
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(buttonPanel, this.getBtnOk(), this.getBtnCancel(), this.getBtnApply());
        return buttonPanel;
    }

    @Override
    protected JunkMailDialogController createController(MVCController parentController) {
        return new JunkMailDialogController(this, parentController);
    }

    @Override
    protected void processApplyAction(ActionEvent event) {
        super.processApplyAction(event);
        this.applyChanges();
    }

    @Override
    protected void processCancelAction(ActionEvent event) {
        if (this.getBtnApply().isEnabled() && !this.askForChangesLose()) {
            return;
        }
        super.processCancelAction(event);
        this.dispose();
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        this.applyChanges();
    }
}

