/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.login;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class FilePathSelectEditPanel
extends JPanel {
    private JButton btnCachingPath;
    private JTextField txtCachingPath;
    private String path;
    private Dimension prefSize;

    public FilePathSelectEditPanel(String thePath, Dimension thePrefferedSize) {
        this.path = thePath;
        this.prefSize = thePrefferedSize;
        this.buildUI();
    }

    private void buildUI() {
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setLayout(new BorderLayout(0, 0));
        if (this.prefSize != null) {
            this.setMinimumSize(this.prefSize);
            this.setPreferredSize(this.prefSize);
        }
        this.txtCachingPath = new GWTextField(this.path);
        this.btnCachingPath = new JButton(ImageResources.ACT_DRAFT_OPEN);
        this.btnCachingPath.setPreferredSize(new Dimension(24, 16));
        this.btnCachingPath.addActionListener(new BrowseButtonActionListener(StringResources.SELECT_DIRECTORY, 0));
        this.add((Component)this.txtCachingPath, "Center");
        this.add((Component)this.btnCachingPath, "After");
    }

    public void addDocumentListener(DocumentListener listener) {
        this.txtCachingPath.getDocument().addDocumentListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        if (this.txtCachingPath != null) {
            this.txtCachingPath.addFocusListener(listener);
        }
    }

    public void setEnabled(boolean b) {
        this.txtCachingPath.setEnabled(b);
        this.btnCachingPath.setEnabled(b);
    }

    public void setEditable(boolean b) {
        this.txtCachingPath.setEditable(b);
    }

    public String getPath() {
        return this.txtCachingPath.getText();
    }

    public void grabFocus() {
        this.txtCachingPath.grabFocus();
    }

    class BrowseButtonActionListener
    implements ActionListener {
        private int type;
        private String message;

        public BrowseButtonActionListener(String theMessage, int theType) {
            this.message = theMessage;
            this.type = theType;
        }

        public void actionPerformed(ActionEvent e) {
            FilePathSelectEditPanel panel = FilePathSelectEditPanel.this;
            String oldPath = "";
            if (this.type == 0) {
                oldPath = panel.txtCachingPath.getText();
            }
            if (OS.isMacOS()) {
                File f;
                boolean isOK;
                String dialogCaption = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(panel);
                if (frame == null) {
                    return;
                }
                File fileOldPath = new File(oldPath);
                GWMacFileChooser fileChoser = new GWMacFileChooser(frame, dialogCaption, fileOldPath, 0);
                fileChoser.setVisible(true);
                String selectedFile = fileChoser.getFile();
                String selecteddirectory = fileChoser.getDirectory();
                if (selectedFile != null && (isOK = (f = new File(selecteddirectory + selectedFile)).isDirectory())) {
                    panel.txtCachingPath.setText(f.getPath());
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser chooser = new JFileChooser(oldPath);
                chooser.setDialogTitle(this.message);
                chooser.setFileSelectionMode(1);
                chooser.setApproveButtonText(StringResources.SELECT);
                int retVal = chooser.showOpenDialog(FilePathSelectEditPanel.this.getParent());
                if (retVal == 0) {
                    String path = chooser.getSelectedFile().getPath();
                    if (this.type == 0) {
                        panel.txtCachingPath.setText(path);
                    }
                }
            }
        }
    }
}

