/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.login;

import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.GWSplash;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePasswordField;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.login.FilePathSelectEditPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.LoginOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class GWLoginDialogImproved2
extends GWDialog {
    private static Logger logger = Logger.getLogger(GWLoginDialogImproved2.class);
    private JPanel rootPanel;
    private JLabel lblUserId;
    private JLabel lblPassword;
    private JLabel lblServerAddress;
    private JTextField txtUserId;
    private JPasswordField txtPassword;
    private JTextField txtServerAddress;
    private JButton btnOK;
    private JButton btnAbout;
    private JButton btnCancel;
    private String userName = "";
    private String userPassword = "";
    private String serverAddress = "";
    private boolean lockState = false;
    private JRadioButton chkOnline;
    private JRadioButton chkCaching;
    private JLabel lblServerPort;
    private JTextField txtServerPort;
    private String serverPort = "";
    private String cachingPath = "";
    FilePathSelectEditPanel pathSelector;

    public GWLoginDialogImproved2(String theTitle, boolean theLockState, String errorMessage) {
        super(GWSplash.getInstance());
        this.init(theTitle, errorMessage);
        this.setLockState(theLockState);
        this.pack();
        this.validateSize();
    }

    public GWLoginDialogImproved2(ApplicationFrame theFrame, String theTitle, boolean theLockState, String errorMessage) {
        super(theFrame);
        this.init(theTitle, errorMessage);
        this.setLockState(theLockState);
        this.pack();
        this.validateSize();
    }

    public void setLockState(boolean theLockState) {
        this.lockState = theLockState;
        if (this.lockState) {
            this.doLock();
        }
    }

    private void doLock() {
        this.lblUserId.setEnabled(false);
        this.lblServerAddress.setEnabled(false);
        this.txtUserId.setEnabled(false);
        this.btnAbout.setEnabled(false);
        this.txtServerAddress.setEnabled(false);
        this.chkCaching.setEnabled(false);
        this.chkOnline.setEnabled(false);
        this.lblServerPort.setEnabled(false);
        this.txtServerPort.setEnabled(false);
        this.pathSelector.setEnabled(false);
    }

    private void init(String theTitle, String errorMessage) {
        this.setTitle(theTitle);
        LoginOptions loginOptions = OptionManager.getInstance().getLoginOptions();
        this.txtUserId = new GWTextField(loginOptions.getUserName());
        this.txtPassword = new OrientablePasswordField(25);
        this.txtPassword.enableInputMethods(true);
        this.txtServerAddress = new GWTextField(loginOptions.getServerName(), 15);
        this.txtServerPort = new GWTextField(5);
        this.txtServerPort.setDocument(new PortDocument());
        this.txtServerPort.setText(String.valueOf(loginOptions.getServerPort()));
        this.txtUserId.setName("GWLoginDialogImproved2_txtUserId");
        this.txtPassword.setName("GWLoginDialogImproved2_txtPassword");
        this.txtServerAddress.setName("GWLoginDialogImproved2_txtServerAddress");
        this.txtServerPort.setName("GWLoginDialogImproved2_txtServerPort");
        EngineMode mode = loginOptions.getMode();
        this.rootPanel = new OrientablePanel(new GridBagLayout());
        this.lblUserId = new JMnemonicLabel(StringResources.USER_ID_BREQUIREDB_C, this.txtUserId);
        this.lblPassword = new JMnemonicLabel(StringResources.PASSWORD_C, this.txtPassword);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 5, 5);
        this.rootPanel.add((Component)this.lblUserId, c);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 4;
        c.weightx = 2.0;
        c.insets = new Insets(0, 0, 5, 0);
        this.rootPanel.add((Component)this.txtUserId, c);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 5, 5);
        this.rootPanel.add((Component)this.lblPassword, c);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 2.0;
        c.insets = new Insets(0, 0, 5, 0);
        this.rootPanel.add((Component)this.txtPassword, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 5, 5);
        ButtonGroup bg = new ButtonGroup();
        this.chkOnline = new JMnemonicRadioButton(StringResources.ACTION_ONLINE);
        bg.add(this.chkOnline);
        this.chkOnline.addActionListener(new UpdateCheckboxesListener());
        this.chkOnline.setSelected(mode == EngineMode.ONLINE);
        this.rootPanel.add((Component)this.chkOnline, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 22;
        c.insets = new Insets(0, 0, 5, 5);
        this.lblServerAddress = new JMnemonicLabel(StringResources.ADDRESS_C, this.txtServerAddress);
        this.lblServerAddress.setHorizontalAlignment(UIUtils.getComponentOrientation().isLeftToRight() ? 4 : 2);
        this.rootPanel.add((Component)this.lblServerAddress, c);
        c.anchor = 10;
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 2.0;
        c.insets = new Insets(0, 0, 5, 0);
        this.rootPanel.add((Component)this.txtServerAddress, c);
        c.gridx = 4;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 5, 5, 5);
        this.lblServerPort = new JMnemonicLabel(StringResources.PORT_C, this.txtServerPort);
        this.rootPanel.add((Component)this.lblServerPort, c);
        c.gridx = 5;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 2.0;
        c.insets = new Insets(0, 0, 5, 0);
        this.rootPanel.add((Component)this.txtServerPort, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 5, 5);
        this.chkCaching = new JMnemonicRadioButton(StringResources.CACHING_MAILBOX_PATH_C);
        bg.add(this.chkCaching);
        this.chkCaching.addActionListener(new UpdateCheckboxesListener());
        this.chkCaching.setSelected(mode == EngineMode.CACHING);
        this.rootPanel.add((Component)this.chkCaching, c);
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 2.0;
        c.insets = new Insets(0, 0, 5, 0);
        this.pathSelector = new FilePathSelectEditPanel(OptionManager.getInstance().getCachingPath(), this.txtServerPort.getPreferredSize());
        this.rootPanel.add((Component)this.pathSelector, c);
        if (errorMessage != null) {
            c.anchor = 23;
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(0, 0, 0, 0);
            GWTextArea taError = new GWTextArea();
            this.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent e) {
                    GWLoginDialogImproved2.this.pack();
                }
            });
            ((JTextComponent)taError).setEditable(false);
            taError.setMargin(new Insets(2, 5, 5, 5));
            ((JTextComponent)taError).setText(errorMessage);
            taError.setOpaque(true);
            taError.setBackground(new Color(UIManager.getColor("Panel.background").darker().getRGB()));
            this.rootPanel.add((Component)taError, c);
        }
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(4));
        this.btnOK = new OrientableButton(new BtnOKAction());
        this.btnCancel = new JButton(new BtnCancelAction());
        this.btnAbout = new JMnemonicButton(new BtnAboutAction());
        OS.addButtons(buttonPanel, this.btnOK, this.btnCancel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.add((Component)this.rootPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
        this.addWindowListener(new LoginDialogWindowsListener());
        LoginDialogDocumentListener listener = new LoginDialogDocumentListener();
        this.txtUserId.getDocument().addDocumentListener(listener);
        this.txtPassword.getDocument().addDocumentListener(listener);
        this.txtServerAddress.getDocument().addDocumentListener(listener);
        this.pathSelector.addDocumentListener(listener);
        LoginDialogFocusListener focusListener = new LoginDialogFocusListener();
        this.txtUserId.addFocusListener(focusListener);
        this.txtPassword.addFocusListener(focusListener);
        this.txtServerAddress.addFocusListener(focusListener);
        this.txtServerPort.addFocusListener(focusListener);
        this.pathSelector.addFocusListener(focusListener);
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        this.canOk();
        this.enableControls();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                GWLoginDialogImproved2.this.toFront();
            }
        });
    }

    private void enableControls() {
        if (this.chkOnline.isSelected()) {
            this.pathSelector.setEnabled(false);
            this.pathSelector.setEditable(false);
            this.txtServerAddress.setEnabled(true);
            this.txtServerAddress.setEditable(true);
            this.lblServerAddress.setEnabled(true);
            this.txtServerPort.setEnabled(true);
            this.txtServerPort.setEditable(true);
            this.lblServerPort.setEnabled(true);
            this.txtUserId.setEnabled(true);
            this.txtUserId.setEditable(true);
            this.lblUserId.setEnabled(true);
            this.txtServerAddress.grabFocus();
        } else if (this.chkCaching.isSelected()) {
            this.txtServerAddress.setEnabled(false);
            this.txtServerAddress.setEditable(false);
            this.lblServerAddress.setEnabled(false);
            this.txtServerPort.setEnabled(false);
            this.txtServerPort.setEditable(false);
            this.lblServerPort.setEnabled(false);
            this.pathSelector.setEnabled(true);
            this.pathSelector.setEditable(true);
            this.txtUserId.setEnabled(true);
            this.txtUserId.setEditable(true);
            this.lblUserId.setEnabled(true);
            this.pathSelector.grabFocus();
        }
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public EngineMode getMode() {
        if (this.chkOnline.isSelected()) {
            return EngineMode.ONLINE;
        }
        if (this.chkCaching.isSelected()) {
            return EngineMode.CACHING;
        }
        return EngineMode.ONLINE;
    }

    public String getCachingPath() {
        return this.cachingPath;
    }

    public void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    private void canOk() {
        boolean enabled = false;
        enabled = this.chkCaching.isSelected() ? this.pathSelector.getPath().length() > 0 : this.txtUserId.getText().length() > 0;
        this.btnOK.setEnabled(enabled);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public JTextField getTxtUserId() {
        return this.txtUserId;
    }

    public JPasswordField getTxtPassword() {
        return this.txtPassword;
    }

    public JTextField getTxtServerAddress() {
        return this.txtServerAddress;
    }

    public void setBounds(int x, int y, int width, int height) {
        if (width < 15 || height < 15) {
            return;
        }
        super.setBounds(x, y, width, height);
    }

    private void validateSize() {
        Dimension size = this.getSize();
        if (size.width < 50) {
            this.setSize(510, 200);
        }
    }

    public static void main(String[] args) {
        GWLoginDialogImproved2 dlgLogin = new GWLoginDialogImproved2(StringResources.JAVA_CLIENT_FOR_GROUPWISEBTMB_LOGIN_C, false, null);
        dlgLogin.pack();
        dlgLogin.setResizable(false);
        dlgLogin.setModal(true);
        UIUtils.centerWindowOnScreen(dlgLogin);
        dlgLogin.setVisible(true);
    }

    private class UpdateCheckboxesListener
    implements ActionListener {
        private UpdateCheckboxesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GWLoginDialogImproved2.this.enableControls();
            GWLoginDialogImproved2.this.canOk();
        }
    }

    static class PortDocument
    extends PlainDocument {
        PortDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] chars = str.toCharArray();
            StringBuilder newStr = new StringBuilder();
            for (int i = 0; i < chars.length; ++i) {
                char aChar = chars[i];
                if (!Character.isDigit(aChar)) continue;
                newStr.append(aChar);
            }
            super.insertString(offs, newStr.toString(), a);
        }
    }

    private static class VersionDialog
    extends GWDialog {
        private JLabel imageLabel;

        public VersionDialog(GWDialog theFrame) {
            super(theFrame);
            this.setTitle(StringResources.ABOUT_GROUPWISE);
            this.imageLabel = new OrientableLabel(ControlsUtils.getSplashImage());
            this.imageLabel.setMinimumSize(new Dimension(405, 400));
            this.imageLabel.setPreferredSize(new Dimension(405, 400));
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.imageLabel, "Center");
            contentPane.setPreferredSize(new Dimension(420, 445));
            JTextArea textArea = new JTextArea("     GroupWise Client\n     Version 1.0 (alfa), build 65.24.03\n     Java Runtime Name : \n     " + System.getProperty("java.runtime.name") + '\n' + "     Java Runtime Version : " + '\n' + "     " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vendor.url") + ')' + '\n' + "     Java VM Vendor : " + '\n' + "     " + System.getProperty("java.vm.vendor") + '\n' + "     OS Name : " + System.getProperty("os.name") + '\n' + "     OS Architecture : " + System.getProperty("os.arch") + '\n' + "     User Country : " + System.getProperty("user.country") + '\n' + "     User Name : " + System.getProperty("user.name") + '\n');
            Font theFont = new Font(PLAFChanger.getFontName(), 0, 14);
            textArea.setFont(theFont);
            textArea.setEditable(false);
            OrientableScrollPane scrlPane = new OrientableScrollPane(textArea);
            scrlPane.setPreferredSize(new Dimension(405, 130));
            GWDialog.CancelDialogAction action = new GWDialog.CancelDialogAction(this);
            this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(27, 0), action);
            this.getRootPane().getActionMap().put(action, action);
            contentPane.add((Component)scrlPane, "South");
            this.setSize(new Dimension(420, 465));
            this.setResizable(false);
        }
    }

    static class LoginDialogFocusListener
    implements FocusListener {
        LoginDialogFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            JTextComponent field = (JTextComponent)e.getSource();
            field.selectAll();
        }

        public void focusLost(FocusEvent e) {
            JTextComponent field = (JTextComponent)e.getSource();
            field.select(0, 0);
        }
    }

    class LoginDialogWindowsListener
    extends WindowAdapter {
        LoginDialogWindowsListener() {
        }

        public void windowOpened(WindowEvent e) {
            if ("".equals(GWLoginDialogImproved2.this.txtUserId.getText())) {
                GWLoginDialogImproved2.this.txtUserId.requestFocus();
            } else {
                GWLoginDialogImproved2.this.txtPassword.requestFocus();
            }
        }
    }

    class LoginDialogDocumentListener
    implements DocumentListener {
        LoginDialogDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            GWLoginDialogImproved2.this.canOk();
        }

        public void removeUpdate(DocumentEvent e) {
            GWLoginDialogImproved2.this.canOk();
        }

        public void changedUpdate(DocumentEvent e) {
            GWLoginDialogImproved2.this.canOk();
        }
    }

    class BtnAboutAction
    extends AbstractAction {
        public BtnAboutAction() {
            super(StringResources.ACTION_INFO);
        }

        public void actionPerformed(ActionEvent e) {
            VersionDialog aboutDialog = new VersionDialog(GWLoginDialogImproved2.this);
            UIUtils.centerWindowOnScreen(aboutDialog);
            aboutDialog.setVisible(true);
        }
    }

    class BtnCancelAction
    extends AbstractAction {
        public BtnCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            GWLoginDialogImproved2.this.setActionCompleteSuccessfully(false);
            GWLoginDialogImproved2.this.setVisible(false);
        }
    }

    class BtnOKAction
    extends AbstractAction {
        public BtnOKAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            if (GWLoginDialogImproved2.this.btnCancel.hasFocus()) {
                GWLoginDialogImproved2.this.setVisible(false);
            } else {
                GWLoginDialogImproved2 dlg = GWLoginDialogImproved2.this;
                dlg.setActionCompleteSuccessfully(true);
                dlg.userName = dlg.txtUserId.getText();
                dlg.userPassword = new String(dlg.txtPassword.getPassword());
                dlg.serverAddress = dlg.txtServerAddress.getText();
                dlg.serverPort = dlg.txtServerPort.getText();
                dlg.cachingPath = dlg.pathSelector.getPath();
                GWLoginDialogImproved2.this.setVisible(false);
            }
        }
    }
}

