/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.newfolder;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePane;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

class FolderTypePane
extends OrientablePanel {
    private AbstractButton rbPersonalFolder = new JMnemonicRadioButton(StringResources.PERSONAL_FOLDER);
    private AbstractButton rbSharedFolder = new JMnemonicRadioButton(StringResources.SHARED_FOLDER);
    private MVCController controller;
    private FolderNamePane folderNamePane;

    public FolderTypePane(MVCController controller, FolderNamePane folderNamePane) {
        this.setLayout(new GridBagLayout());
        this.folderNamePane = folderNamePane;
        this.controller = controller;
        this.buildUI();
    }

    private void buildUI() {
        GridBagConstraints constraints = new GridBagConstraints();
        GWTextArea taTitle = new GWTextArea();
        taTitle.setEditable(false);
        taTitle.setText(StringResources.SELECT_THE_KIND_OF_FOLDER);
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.insets.bottom = 10;
        this.add((Component)taTitle, constraints);
        constraints.insets.bottom = 0;
        constraints.weightx = 0.0;
        ++constraints.gridy;
        constraints.fill = 0;
        this.add((Component)FolderTypePane.buildTypeRow(new OrientableLabel(ImageResources.FLD_FOLDER), this.rbPersonalFolder), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        this.add((Component)FolderTypePane.buildTypeRow(new OrientableLabel(ImageResources.FLD_SHAREDDIR), this.rbSharedFolder), constraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbSharedFolder);
        buttonGroup.add(this.rbPersonalFolder);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.rbPersonalFolder.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 || e.getStateChange() == 2) {
                    FolderTypePane.this.folderNamePane.setMVCModel((Object)(e.getStateChange() != 1 ? 1 : 0));
                }
            }
        });
    }

    public boolean isSharingFolderType() {
        return this.rbSharedFolder.isSelected();
    }

    public void setPersonalFolderType() {
        this.rbPersonalFolder.setSelected(true);
    }

    private static JComponent buildTypeRow(JComponent component1, final AbstractButton button) {
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout(10, 0));
        pnlContent.add((Component)component1, "Before");
        pnlContent.add((Component)button, "Center");
        button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JDialog window = (JDialog)SwingUtilities.getWindowAncestor(button);
                    window.setTitle(StringResources.CREATE + ' ' + button.getText());
                }
            }
        });
        return pnlContent;
    }
}

