/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.newfolder;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.ab.Addressable;
import com.novell.gw.folder.FolderAccessRights;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.properties.AbstractShareListTableModel;
import com.novell.gw.jclient.application.controls.gwcomponent.GWMouseAdapter;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.dialogs.newfolder.ShareListTableController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ShareListTable
extends GWTable
implements MVCView {
    private static Logger logger = Logger.getLogger(ShareListTable.class);
    private ShareListTableController controller;
    private CurrentPopupMenu popupMenu;
    ShareListTableModel model;

    public ShareListTable(MVCController theParentController) {
        this.controller = new ShareListTableController(this, theParentController);
        this.model = new ShareListTableModel(this.controller);
        this.setModel(this.model);
        this.popupMenu = new CurrentPopupMenu();
        this.getSelectionModel().setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new MyListSelectionListener());
        this.setShowGrid(false);
        this.add(this.popupMenu);
        this.addMouseListener(new CurrentMouseListener());
    }

    private void selectNearestIndex(int index) {
        int size = this.model.getRowCount();
        if (size == 0) {
            return;
        }
        int selectionIndex = index >= size ? size - 1 : index;
        this.setRowSelectionInterval(selectionIndex, selectionIndex);
    }

    public void removeSelectedUser() {
        int index = this.getSelectedRow();
        if (index != -1) {
            this.model.removeUser(index);
            this.model.fireTableDataChanged();
            this.selectNearestIndex(index);
        }
    }

    public void setController(MVCController theController) {
        if (theController instanceof ShareListTableController) {
            this.controller = (ShareListTableController)theController;
        }
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof FolderSharedList) {
            FolderSharedList data = (FolderSharedList)theModel;
            this.model.setData(data);
            if (data.getSize() > 0) {
                this.selectEntry(0);
            }
        } else {
            throw new IllegalArgumentException("Incorrect MVC model was passed " + theModel);
        }
    }

    public void addContacts(List theUsers) {
        int nSize = theUsers.size();
        for (int i = 0; i < nSize; ++i) {
            this.model.addContact((IAddressable)theUsers.get(i));
        }
        if (this.model.getRowCount() > 0) {
            this.selectEntry(0);
        }
    }

    private void selectEntry(int index) {
        if (this.getSelectedRow() == index) {
            Command command = new Command(280, this.model.getAccessList().get(index));
            this.getController().processCommand(command);
        } else {
            this.setRowSelectionInterval(index, index);
        }
    }

    public Object getMVCModel() {
        return null;
    }

    public void changeAddRights(boolean b) {
        this.model.getAccessList().get(this.getSelectedRow()).getAccessRights().setAddAccess(b);
        this.repaint();
    }

    public void changeEditRights(boolean b) {
        this.model.getAccessList().get(this.getSelectedRow()).getAccessRights().setEditAccess(b);
        this.repaint();
    }

    public void changeDeleteRights(boolean b) {
        this.model.getAccessList().get(this.getSelectedRow()).getAccessRights().setDeleteAccess(b);
        this.repaint();
    }

    public boolean saveSharedList(AbstractFolder theFolder) {
        boolean isSavedSuccessful = false;
        try {
            isSavedSuccessful = theFolder.setSharedList(this.model.getAccessList());
            this.controller.processCommand(new Command(200));
        }
        catch (GWCommandException e) {
            JOptionPane.showMessageDialog(this, StringResources.UNABLE_TO_SHARE_FOLDER, StringResources.ADDRESS_BOOK_ERROR, 2);
        }
        return isSavedSuccessful;
    }

    public boolean unShareFolder(AbstractFolder theFolder) {
        boolean isUnSharedSuccessful = false;
        try {
            isUnSharedSuccessful = theFolder.setSharedList(null);
            this.controller.processCommand(new Command(200));
        }
        catch (GWCommandException e) {
            JOptionPane.showMessageDialog(this, StringResources.UNABLE_TO_SHARE_FOLDER, StringResources.ADDRESS_BOOK_ERROR, 2);
        }
        return isUnSharedSuccessful;
    }

    public FolderSharedList getAccessList() {
        return this.model.getAccessList();
    }

    private void showPopupMenu(Point p) {
        this.popupMenu.show(this, p.x, p.y);
    }

    private void viewDetails() {
        MessageUtils.showBusyCursor(true);
        Window owner = SwingUtilities.getWindowAncestor(this);
        IAddressable contact = APIAbWrapperManager.getAddressable(this.model.getAccessList().get(this.getSelectedRow()).getAddressable());
        ContactDetailsDialog dialog = ContactDetailsDialog.createContactDetailsDialog(owner, contact, null);
        dialog.showMe();
        MessageUtils.showBusyCursor(false);
    }

    private class CurrentMouseListener
    extends GWMouseAdapter {
        private CurrentMouseListener() {
        }

        public void showPopup(MouseEvent event) {
            ShareListTable.this.showPopupMenu(event.getPoint());
        }

        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger() && e.getClickCount() == 2) {
                ShareListTable.this.viewDetails();
            }
        }
    }

    private class CurrentPopupMenu
    extends GWPopupMenu {
        public CurrentPopupMenu() {
            this.add(new JMenuItem(new AbstractAction(StringResources.REMOVE){

                public void actionPerformed(ActionEvent e) {
                    ShareListTable.this.removeSelectedUser();
                }
            }));
            this.add(new JMenuItem(new AbstractAction(StringResources.DETAILS){

                public void actionPerformed(ActionEvent e) {
                    ShareListTable.this.viewDetails();
                }
            }));
        }
    }

    protected static class ShareListTableModel
    extends AbstractShareListTableModel {
        private FolderSharedList accessList = new FolderSharedList();
        public Vector columns = new Vector();

        public ShareListTableModel(MVCController controller) {
            super(controller);
            this.columns.add(StringResources.NAME);
            this.columns.add(StringResources.STATUS);
            this.columns.add(StringResources.ACCESS);
            this.columns.add("");
        }

        protected void addContactToShareList(IUserContact contact) {
            FolderAccessRights accessRights = new FolderAccessRights(false, false);
            FolderSharedEntry folderSharedAccessEntry = new FolderSharedEntry((Addressable)contact.getNativeContact(), accessRights);
            boolean isCopyAddress = false;
            for (int i = 0; i < this.accessList.getSize(); ++i) {
                if (!this.accessList.get(i).getAddressable().getDisplayName().equals(contact.getDisplayName()) && !this.accessList.get(i).getAddressable().getEmailAddress().equals(contact.getEmailAddress())) continue;
                isCopyAddress = true;
                break;
            }
            if (isCopyAddress) {
                JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.THE_SAME_EMAIL_ADDRRESS, contact.getDisplayName()), StringResources.MESSAGE, 0);
            } else {
                this.accessList.add(folderSharedAccessEntry);
            }
            this.fireTableDataChanged();
        }

        public void setData(FolderSharedList theUsers) {
            int nSize = theUsers.getSize();
            for (int i = 0; i < nSize; ++i) {
                this.accessList.add(theUsers.get(i));
            }
            this.fireTableDataChanged();
        }

        public void removeUser(int index) {
            this.accessList.remove(index);
        }

        public String getColumnName(int column) {
            return (String)this.columns.get(column);
        }

        public int getRowCount() {
            return this.accessList.getSize();
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        private String getUserRights(FolderSharedEntry theEntry) {
            FolderAccessRights rights = theEntry.getAccessRights();
            StringBuilder textRights = new StringBuilder();
            if (rights.hasReadAccess()) {
                textRights.append(StringResources.READ);
                textRights.append(", ");
            }
            if (rights.hasAddAccess()) {
                textRights.append(StringResources.ADD);
                textRights.append(", ");
            }
            if (rights.hasDeleteAccess()) {
                textRights.append(StringResources.DELETE);
                textRights.append(", ");
            }
            if (rights.hasEditAccess()) {
                textRights.append(StringResources.EDIT);
                textRights.append(", ");
            }
            if (textRights.length() > 2) {
                textRights.delete(textRights.length() - 2, textRights.length());
            }
            return textRights.toString();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            FolderSharedEntry accessEntry = this.accessList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return accessEntry.getName();
                }
                case 1: {
                    return accessEntry.getStatus();
                }
                case 2: {
                    return this.getUserRights(accessEntry);
                }
            }
            return "";
        }

        public FolderSharedList getAccessList() {
            return this.accessList;
        }
    }

    protected class MyListSelectionListener
    implements ListSelectionListener {
        protected MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = ((DefaultListSelectionModel)e.getSource()).getAnchorSelectionIndex();
            if (index >= 0 && index < ShareListTable.this.getRowCount()) {
                Command command = new Command(280, ShareListTable.this.model.getAccessList().get(index));
                ShareListTable.this.getController().processCommand(command);
            }
        }
    }
}

