/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.proxy;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.AddressableListEntry;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelector;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorCloseListener;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.proxy.ProxyDialogController;
import com.novell.gw.jclient.application.dialogs.proxy.UserListTableModel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ProxyDialog
extends ApplicationDialog {
    private static Logger logger = Logger.getLogger(ProxyDialog.class);
    private JButton btnRemove = new JMnemonicButton(new RemoveAction());
    private AddressSelector stfUser;
    private JLabel lbUserName = new OrientableLabel(StringResources.USER_NAME_C);
    private UserListTableModel model = new UserListTableModel();
    private JTable tableUsers = new ExtendedGWTable(this.model);
    private boolean selectCausedByRemove = false;

    public ProxyDialog(ApplicationFrame theFrame) {
        super((Frame)theFrame, theFrame.getController(), true);
        this.stfUser = new AddressSelector(null, (MVCController)this.getController());
        this.stfUser.setAddressSelectorCloseListener(new AddressSelectorCloseListener(){

            public void contactSelected(IContact theContact) {
                boolean isMyself = theContact.getUserName().equals(EngineCommandManager.getUserInfo().getID());
                ProxyHistoryEntry entry = new ProxyHistoryEntry((Addressable)theContact.getNativeContact());
                ProxyDialog.this.performProxy(entry, isMyself);
            }
        });
        this.setTitle(StringResources.PROXY);
        this.buildUI();
    }

    private void buildUI() {
        OrientablePanel pnlLeft = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlLeft);
        adapter.setColumnCount(3);
        adapter.setResizableColumn(0);
        adapter.setGridWidth(3);
        adapter.setInsets(new Insets(0, 5, 5, 5));
        adapter.setAnchor(21);
        adapter.setFill(0);
        adapter.addComponent(this.lbUserName);
        adapter.setGridWidth(3);
        adapter.addComponent(this.stfUser);
        OrientablePanel pnlTable = new OrientablePanel(new BorderLayout());
        pnlTable.add((Component)new OrientableLabel(StringResources.USERS_LIST_C), "North");
        ColoredScrollPane scroll = new ColoredScrollPane(this.tableUsers);
        scroll.setPreferredSize(new Dimension(350, 150));
        pnlTable.add((Component)scroll, "Center");
        adapter.setGridWidth(3);
        adapter.setWidthY(100);
        adapter.setInsets(new Insets(0, 5, 5, 5));
        adapter.addComponent(pnlTable);
        OrientablePanel contentPane = new OrientablePanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)pnlLeft, "Center");
        contentPane.add((Component)this.buildButtonsPane(), "After");
        this.add(contentPane);
        this.tableUsers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ProxyDialog.this.processItemSelection();
            }
        });
        if (this.tableUsers.getRowCount() > 0) {
            this.tableUsers.setRowSelectionInterval(0, 0);
        }
        this.tableUsers.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (e.getKeyCode() == itemDeleteKey) {
                    ProxyDialog.this.btnRemove.getAction().actionPerformed(null);
                } else if (e.getKeyCode() == 10) {
                    ProxyDialog.this.processOkAction(null);
                }
            }
        });
        this.tableUsers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    int selectedRow = ProxyDialog.this.tableUsers.getSelectedRow();
                    if (ProxyDialog.this.performProxy(ProxyDialog.this.model.getEntryAt(selectedRow), selectedRow == 0)) {
                        ProxyDialog.this.saveChanges();
                        ProxyDialog.this.dispose();
                    }
                }
            }
        });
    }

    private void processItemSelection() {
        int selectedRow = this.tableUsers.getSelectedRow();
        if (selectedRow != -1) {
            boolean onlyOneSelected = this.tableUsers.getSelectedRows().length <= 1;
            this.btnRemove.setEnabled(selectedRow != 0 || !onlyOneSelected);
            if (this.selectCausedByRemove) {
                this.selectCausedByRemove = false;
                this.stfUser.setText("");
            } else {
                this.stfUser.setText(this.model.getEntryAt(selectedRow).getDisplayName());
            }
        }
    }

    private JPanel buildButtonsPane() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlButtons);
        adapter.setColumnCount(1);
        adapter.addComponent(this.getBtnOk());
        adapter.addComponent(this.getBtnCancel());
        adapter.addComponent(this.btnRemove);
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout());
        pnlContent.add((Component)pnlButtons, "North");
        return pnlContent;
    }

    private void saveChanges() {
        this.model.saveChanges();
    }

    private boolean performProxy(ProxyHistoryEntry theUser, boolean isMyself) {
        boolean isPerformed = false;
        if (isMyself) {
            ((MVCController)this.getController()).getActionList().performAction(ActionKey.SHOW_USER_STORE);
            this.saveChanges();
            isPerformed = true;
        } else {
            try {
                if (this.model.containsEntry(theUser)) {
                    String oldUserGuid = ControlsUtils.getUserGuid(this.getController());
                    String userGuid = GWCommandManager.getInstance(oldUserGuid).performProxy(theUser);
                    ((MVCController)this.getController()).processCommand(new Command(750, userGuid));
                    ((MVCController)this.getController()).getActionList().performAction(ActionKey.REFRESH);
                    isPerformed = true;
                } else {
                    int bAdded = this.model.addEntry(theUser);
                    this.saveChanges();
                    if (bAdded != -1) {
                        String oldUserGuid = ControlsUtils.getUserGuid(this.getController());
                        String userGuid = GWCommandManager.getInstance(oldUserGuid).performProxy(theUser);
                        ((MVCController)this.getController()).processCommand(new Command(750, userGuid));
                        ((MVCController)this.getController()).getActionList().performAction(ActionKey.REFRESH);
                        isPerformed = true;
                    }
                }
            }
            catch (EngineException e1) {
                JOptionPane.showMessageDialog(this, EngineException.getErrorString((int)e1.getErrorCode()), StringResources.NOVELL_GROUPWISE, 2);
            }
        }
        return isPerformed;
    }

    protected MVCController createController(MVCController parentController) {
        return new ProxyDialogController(this, parentController);
    }

    protected void processOkAction(ActionEvent event) {
        ProxyHistoryEntry nccUser;
        this.saveChanges();
        String text = this.stfUser.getText().trim();
        if (text.length() == 0) {
            this.dispose();
            return;
        }
        IContact nccContact = this.stfUser.getContact();
        if (nccContact == null) {
            nccUser = this.model.getEntryAt(this.tableUsers.getSelectedRow());
            if (!nccUser.getDisplayName().equals(text)) {
                nccUser = new ProxyHistoryEntry(APIAbWrapperManager.createAddress(text, text).getNativeAddressable());
            }
        } else {
            nccUser = new ProxyHistoryEntry((Addressable)nccContact.getNativeContact());
        }
        boolean isMyself = this.model.getEntryAt(0).isEqual((AddressableListEntry)nccUser);
        if (this.performProxy(nccUser, isMyself)) {
            super.processOkAction(event);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, StringResources.NOT_A_VALID_GROUPWISE_USER, StringResources.NOVELL_GROUPWISE, 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(StringResources.REMOVE);
            this.setEnabled(false);
        }

        private void removeEntries(List<ProxyHistoryEntry> entriesToRemove) {
            for (ProxyHistoryEntry entry : entriesToRemove) {
                this.removeEntry(entry);
            }
        }

        private void removeEntriesAt(int[] indices) {
            LinkedList<ProxyHistoryEntry> entriesToRemove = new LinkedList<ProxyHistoryEntry>();
            for (int index : indices) {
                if (index <= 0) continue;
                entriesToRemove.add(ProxyDialog.this.model.getEntryAt(index));
            }
            this.removeEntries(entriesToRemove);
        }

        private void removeEntry(ProxyHistoryEntry entry) {
            for (int index = 0; index < ProxyDialog.this.model.getRowCount(); ++index) {
                if (!ProxyDialog.this.model.getEntryAt(index).equals(entry)) continue;
                ProxyDialog.this.model.removeEntryAt(index);
                break;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProxyDialog.this.selectCausedByRemove = true;
            this.removeEntriesAt(ProxyDialog.this.tableUsers.getSelectedRows());
        }
    }
}

