/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.proxy;

import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import javax.swing.table.AbstractTableModel;

class UserListTableModel
extends AbstractTableModel {
    public String[] columns = new String[]{StringResources.USER_NAME, StringResources.ADDRESS};
    private ProxyHistoryList proxyHistoryList = EngineCommandManager.getProxyHistoryList();

    public String getColumnName(int column) {
        return this.columns[column];
    }

    public int getRowCount() {
        return this.proxyHistoryList.size();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.proxyHistoryList.get(rowIndex).getDisplayName();
            }
            case 1: {
                return this.proxyHistoryList.get(rowIndex).getEmailAddress();
            }
        }
        return "";
    }

    public ProxyHistoryEntry getEntryAt(int index) {
        return this.proxyHistoryList.get(index);
    }

    public boolean removeEntryAt(int index) {
        boolean result = this.proxyHistoryList.remove(index);
        if (result) {
            this.fireTableRowsDeleted(index, index);
        }
        return result;
    }

    public int addEntry(IAddressable addressable) {
        return this.addEntry(new ProxyHistoryEntry(addressable.getNativeAddressable()));
    }

    public int addEntry(ProxyHistoryEntry theHistoryEntry) {
        int result = this.proxyHistoryList.add(theHistoryEntry);
        if (result != -1) {
            this.fireTableDataChanged();
        }
        return result;
    }

    public boolean containsEntry(ProxyHistoryEntry theHistoryEntry) {
        boolean contains = false;
        for (int index = 0; index < this.proxyHistoryList.size() && !contains; contains |= this.proxyHistoryList.get(index).getGuid().equals(theHistoryEntry.getGuid()), ++index) {
        }
        return contains;
    }

    public void saveChanges() {
        this.proxyHistoryList.commit();
    }
}

