/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.components.EmptyStringDocumentListener;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.FoldersDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.rules.AdvancedConditionsDialog;
import com.novell.gw.jclient.application.dialogs.rules.AppointmentConflictWrapper;
import com.novell.gw.jclient.application.dialogs.rules.CreateRuleDialogActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleAction;
import com.novell.gw.rules.RuleActionAccept;
import com.novell.gw.rules.RuleActionCategory;
import com.novell.gw.rules.RuleActionDelegate;
import com.novell.gw.rules.RuleActionDelete;
import com.novell.gw.rules.RuleActionForward;
import com.novell.gw.rules.RuleActionLink;
import com.novell.gw.rules.RuleActionList;
import com.novell.gw.rules.RuleActionMove;
import com.novell.gw.rules.RuleActionReply;
import com.novell.gw.rules.RuleActionSend;
import com.novell.gw.rules.RuleList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRuleDialog
extends ApplicationDialog<CreateRuleDialogActionList> {
    private static Logger logger = Logger.getLogger(CreateRuleDialog.class);
    private Rule rule;
    private int eventExecutionType = 5;
    private RuleActionList ruleActionList;
    private IFolder selectedFolder;
    private JButton btnEvent = new OrientableButton(new EventAction());
    private JButton btnAddAction = new JMnemonicButton(new AddAction());
    private JButton btnEditAction = new JMnemonicButton(new EditAction());
    private JButton btnDeleteAction = new JMnemonicButton(new DeleteAction());
    private JButton btnConditions = new JMnemonicButton(StringResources.DEFINE_CONDITIONS_D);
    private JTextField tfRuleName = new GWTextField();
    private JTextField tfFolder = new GWTextField();
    private JTextArea taConditions = new GWTextArea();
    private JPanel pnlEventItem = new OrientablePanel(new FlowLayout(3));
    private JPanel pnlEventFolder = new OrientablePanel(new BorderLayout(5, 0));
    private JPopupMenu popupEvent = new CurrentPopupMenu();
    private JPopupMenu popupAddAction = new GWPopupMenu();
    private JCheckBox cbItemTypeMail = new JMnemonicCheckBox(new ItemTypeAction(StringResources.MAIL));
    private JCheckBox cbItemTypeAppointment = new JMnemonicCheckBox(new ItemTypeAction(StringResources.APPOINTMENT));
    private JCheckBox cbItemTypeTask = new JMnemonicCheckBox(new ItemTypeAction(StringResources.TASK));
    private JCheckBox cbItemTypeReminderNote = new JMnemonicCheckBox(new ItemTypeAction(StringResources.REMINDER_NOTE));
    private JCheckBox cbItemTypePhoneMessage = new JMnemonicCheckBox(new ItemTypeAction(StringResources.PHONE_MESSAGE));
    private JCheckBox cbBoxTypeReceived = new JMnemonicCheckBox(StringResources.RECEIVED);
    private JCheckBox cbBoxTypeSent = new JMnemonicCheckBox(StringResources.SENT);
    private JCheckBox cbBoxTypePosted = new JMnemonicCheckBox(StringResources.POSTED);
    private JCheckBox cbBoxTypeDraft = new JMnemonicCheckBox(StringResources.DRAFT);
    private JComboBox cmbConflict = new OrientableComboBox(new Object[]{new AppointmentConflictWrapper(0), new AppointmentConflictWrapper(1), new AppointmentConflictWrapper(2)});
    private JList listRuleActions = new OrientableList();
    private DefaultListModel ruleActionListModel = new DefaultListModel();
    private boolean isRuleEdited;
    private String userGuid;

    public CreateRuleDialog(JDialog parentDialog, MVCController parentController, Rule rule, String userGuid) {
        super((Dialog)parentDialog, parentController);
        this.tfRuleName.setName("CreateRuleDialog_tfRuleName");
        this.tfFolder.setName("CreateRuleDialog_tfFolder");
        this.taConditions.setName("CreateRuleDialog_taConditions");
        this.cbItemTypeMail.setName("CreateRuleDialog_cbItemTypeMail");
        this.cbItemTypeAppointment.setName("CreateRuleDialog_cbItemTypeAppointment");
        this.cbItemTypeTask.setName("CreateRuleDialog_cbItemTypeTask");
        this.cbItemTypeReminderNote.setName("CreateRuleDialog_cbItemTypeReminderNote");
        this.cbItemTypePhoneMessage.setName("CreateRuleDialog_cbItemTypePhoneMessage");
        this.cbBoxTypeReceived.setName("CreateRuleDialog_cbBoxTypeReceived");
        this.cbBoxTypeSent.setName("CreateRuleDialog_cbBoxTypeSent");
        this.cbBoxTypePosted.setName("CreateRuleDialog_cbBoxTypePosted");
        this.cbBoxTypeDraft.setName("CreateRuleDialog_tfRuleName");
        this.userGuid = userGuid;
        this.rule = rule != null ? rule : GWCommandManager.getInstance(this.userGuid).createRule();
        this.ruleActionList = this.rule.getActionList();
        this.isRuleEdited = rule != null;
        ((CreateRuleDialogActionList)this.getController()).initRuleActions(this.rule);
        this.init();
        if (rule != null) {
            this.setTitle(StringResources.EDIT_RULE);
            this.readRule(this.rule);
        } else {
            this.setTitle(StringResources.NEW_RULE);
        }
    }

    @Override
    protected CreateRuleDialogActionList createController(MVCController parentController) {
        return new CreateRuleDialogActionList(this, parentController);
    }

    private void init() {
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        this.rebuildAddActionPopup();
        this.buildUI();
        this.taConditions.setText(StringResources.ACT_ON_All_ITEMS);
        this.listRuleActions.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean isEmpty;
                JList list = (JList)e.getSource();
                boolean bl = isEmpty = list.getModel().getSize() > 0;
                if (isEmpty) {
                    RuleAction ruleAction = (RuleAction)list.getSelectedValue();
                    if (ruleAction != null) {
                        CreateRuleDialog.this.btnEditAction.setEnabled(ruleAction.isEditable());
                    }
                    boolean b = CreateRuleDialog.this.tfRuleName.getText().trim().length() == 0;
                    CreateRuleDialog.this.getBtnOk().setEnabled(!b);
                } else {
                    CreateRuleDialog.this.btnEditAction.setEnabled(false);
                    CreateRuleDialog.this.getBtnOk().setEnabled(false);
                }
                CreateRuleDialog.this.btnDeleteAction.setEnabled(isEmpty);
            }
        });
        this.listRuleActions.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    CreateRuleDialog.this.editSelectedAction();
                }
            }
        });
    }

    void addRuleAction(RuleAction theRuleAction) {
        assert (theRuleAction != null);
        RuleActionList actionList = this.rule.getActionList();
        this.ruleActionList.addAction(theRuleAction, actionList.getSize());
        this.ruleActionListModel.addElement(theRuleAction);
        this.listRuleActions.setSelectedValue(theRuleAction, true);
    }

    private void selectNearestValue(int index) {
        int size = this.ruleActionListModel.getSize();
        if (size == 0) {
            return;
        }
        int selectionIndex = index >= size ? size - 1 : index;
        this.listRuleActions.setSelectedIndex(selectionIndex);
    }

    public Rule getRule() {
        return this.rule;
    }

    private void rebuildAddActionPopup() {
        this.popupAddAction.removeAll();
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_SEND_MAIL).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_FORWARD).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_DELEGATE).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_REPLY).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_ACCEPT).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_CATEGORY).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_DECLINE).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_EMPTY_ITEM).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_MOVE_TO_FOLDER).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_LINK_TO_FOLDER).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_MARK_AS_PRIVATE).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_MARK_AS_READ).getMenuItem());
        if (this.eventExecutionType != 5 && this.eventExecutionType != 10) {
            this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_ARCHIVE).getMenuItem());
        }
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_MARK_AS_UNREAD).getMenuItem());
        this.popupAddAction.add(((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_STOP_RULE).getMenuItem());
    }

    private void buildEventPanes() {
        this.pnlEventItem.add(new OrientableLabel(StringResources.AND_ITEMS_ARE_C));
        this.pnlEventItem.add(this.cbBoxTypeReceived);
        this.pnlEventItem.add(this.cbBoxTypeSent);
        this.pnlEventItem.add(this.cbBoxTypePosted);
        this.pnlEventItem.add(this.cbBoxTypeDraft);
        this.pnlEventFolder.add((Component)new OrientableLabel(StringResources.SELECT_FOLDER_C), "Before");
        this.tfFolder.setEditable(false);
        this.pnlEventFolder.add((Component)this.tfFolder, "Center");
        OrientableButton btnOpenFolder = new OrientableButton(new SelectFolderAction());
        Dimension dimension = new Dimension(btnOpenFolder.getPreferredSize().width, this.tfRuleName.getPreferredSize().height);
        btnOpenFolder.setPreferredSize(dimension);
        this.pnlEventFolder.add((Component)btnOpenFolder, "After");
    }

    private void rebuildDescriptionText() {
        int itemTypeMask = this.getItemTypeMask();
        if (itemTypeMask == 0 && (this.eventExecutionType == 1 || this.eventExecutionType == 2)) {
            this.taConditions.setText(StringResources.RULE_WARNING_FOR_EXIT_OR_STARTUP_EVENT);
        } else {
            this.taConditions.setText(this.rule.getFilterDescription(this.getItemTypeMask()));
        }
        this.taConditions.repaint();
    }

    private void rebuildEventPane(boolean isSelectFolderPane, String theText) {
        this.btnEvent.setText(theText);
        for (Component component : this.popupEvent.getComponents()) {
            JMenuItem menuItem = (JMenuItem)component;
            if (!menuItem.getText().equals(theText)) continue;
            menuItem.setSelected(true);
        }
        JPanel pnlContent = (JPanel)this.getContentPane();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.insets.top = 10;
        constraints.insets.right = 10;
        if (isSelectFolderPane) {
            pnlContent.remove(this.pnlEventItem);
            pnlContent.add((Component)this.pnlEventFolder, constraints);
        } else {
            pnlContent.remove(this.pnlEventFolder);
            pnlContent.add((Component)this.pnlEventItem, constraints);
        }
    }

    private void buildUI() {
        this.popupEvent.add(MenuItemFactory.createCkeckBoxMenuItem(new SelectEventAction(5)));
        this.popupEvent.add(MenuItemFactory.createCkeckBoxMenuItem(new SelectEventAction(10)));
        this.popupEvent.add(MenuItemFactory.createCkeckBoxMenuItem(new SelectEventAction(19)));
        this.popupEvent.add(MenuItemFactory.createCkeckBoxMenuItem(new SelectEventAction(4)));
        this.popupEvent.add(MenuItemFactory.createCkeckBoxMenuItem(new SelectEventAction(3)));
        this.popupEvent.add(MenuItemFactory.createCkeckBoxMenuItem(new SelectEventAction(1)));
        this.popupEvent.add(MenuItemFactory.createCkeckBoxMenuItem(new SelectEventAction(2)));
        this.popupEvent.add(MenuItemFactory.createCkeckBoxMenuItem(new SelectEventAction(9)));
        this.listRuleActions.setModel(this.ruleActionListModel);
        this.buildEventPanes();
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.setLayout(new GridBagLayout());
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout(5, 0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.insets.top = 10;
        constraints.insets.right = 10;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 2;
        this.tfRuleName.getDocument().addDocumentListener(new EmptyStringDocumentListener(this.getBtnOk().getAction()){

            protected void setActionEnable(Document document) {
                block2: {
                    try {
                        String text = document.getText(0, document.getLength());
                        boolean isEmpty = text.trim().length() == 0;
                        int size = CreateRuleDialog.this.ruleActionListModel.getSize();
                        CreateRuleDialog.this.getBtnOk().setEnabled(!isEmpty && size > 0);
                    }
                    catch (BadLocationException e) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        });
        pnlTemp.add((Component)new JMnemonicLabel(StringResources.RULE_NAME_C, this.tfRuleName), "Before");
        pnlTemp.add((Component)this.tfRuleName, "Center");
        pnlContent.add((Component)pnlTemp, constraints);
        pnlTemp = new OrientablePanel(new BorderLayout(10, 0));
        pnlTemp.add((Component)new JMnemonicLabel(StringResources.WHEN_EVENT_IS, this.btnEvent), "Before");
        pnlTemp.add((Component)new JSeparator(), "Center");
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.gridwidth = 2;
        pnlContent.add((Component)pnlTemp, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        this.btnEvent.setHorizontalTextPosition(10);
        pnlContent.add((Component)this.btnEvent, constraints);
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        pnlContent.add((Component)this.pnlEventItem, constraints);
        constraints.gridy = 3;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        pnlTemp = new OrientablePanel(new BorderLayout(10, 0));
        pnlTemp.add((Component)new OrientableLabel(StringResources.IF_CONDITIONS_ARE), "Before");
        pnlTemp.add((Component)new JSeparator(), "Center");
        pnlContent.add((Component)pnlTemp, constraints);
        constraints.gridy = 4;
        constraints.gridx = 0;
        pnlContent.add((Component)this.buildConditionsPane(), constraints);
        constraints.gridy = 5;
        constraints.gridx = 0;
        pnlTemp = new OrientablePanel(new FlowLayout(4));
        this.getBtnOk().setText(StringResources.SAVE);
        this.getBtnOk().setEnabled(false);
        OS.addButtons(pnlTemp, this.getBtnOk(), this.getBtnCancel());
        constraints.insets.top = 0;
        constraints.anchor = 24;
        constraints.insets.right = 5;
        constraints.weighty = 1.0;
        pnlContent.add((Component)pnlTemp, constraints);
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
        this.setDefaultButton(this.getBtnOk());
    }

    private JComponent buildConditionsPane() {
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.left = 10;
        pnlContent.add((Component)new OrientableLabel(StringResources.ITEM_TYPE_C), constraints);
        constraints.fill = 0;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.insets.bottom = 10;
        this.btnConditions.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AdvancedConditionsDialog dialog = new AdvancedConditionsDialog(CreateRuleDialog.this, (MVCController)CreateRuleDialog.this.getController(), CreateRuleDialog.this.rule.getFilter(), CreateRuleDialog.this.userGuid);
                dialog.pack();
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                if (dialog.isOkActionProcessed()) {
                    CreateRuleDialog.this.rule.setFilter(dialog.getFilter());
                    CreateRuleDialog.this.rebuildDescriptionText();
                }
                dialog.dispose();
            }
        });
        this.btnConditions.setText(StringResources.DEFINE_CONDITIONS_D);
        pnlContent.add((Component)this.btnConditions, constraints);
        constraints.insets.bottom = 0;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        pnlContent.add((Component)this.cbItemTypeMail, constraints);
        constraints.gridy = 2;
        pnlContent.add((Component)this.cbItemTypeAppointment, constraints);
        constraints.gridy = 3;
        pnlContent.add((Component)this.cbItemTypeTask, constraints);
        constraints.gridy = 4;
        pnlContent.add((Component)this.cbItemTypeReminderNote, constraints);
        constraints.gridy = 5;
        pnlContent.add((Component)this.cbItemTypePhoneMessage, constraints);
        constraints.gridy = 1;
        constraints.gridx = 1;
        constraints.gridheight = 5;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        this.taConditions.setEditable(false);
        this.taConditions.setBackground(pnlContent.getBackground());
        pnlContent.add((Component)new OrientableScrollPane(this.taConditions), constraints);
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout(5, 0));
        pnlTemp.add((Component)new JMnemonicLabel(StringResources.APPOINTMENT_CONFLICT_EXIST, this.cmbConflict), "Before");
        pnlTemp.add((Component)this.cmbConflict, "Center");
        constraints.gridy = 6;
        constraints.gridx = 1;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.insets.top = 10;
        pnlContent.add((Component)pnlTemp, constraints);
        pnlTemp = new OrientablePanel(new BorderLayout(10, 0));
        pnlTemp.add((Component)new OrientableLabel(StringResources.THE_ACTIONS_ARE_C), "Before");
        pnlTemp.add((Component)new JSeparator(), "Center");
        constraints.gridy = 7;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.insets.left = 0;
        pnlContent.add((Component)pnlTemp, constraints);
        constraints.gridy = 8;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.insets.left = 10;
        this.btnAddAction.setHorizontalTextPosition(10);
        pnlContent.add((Component)this.btnAddAction, constraints);
        constraints.gridy = 9;
        pnlContent.add((Component)this.btnEditAction, constraints);
        constraints.gridy = 10;
        pnlContent.add((Component)this.btnDeleteAction, constraints);
        constraints.gridy = 8;
        constraints.gridx = 1;
        constraints.gridheight = 3;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.listRuleActions);
        scrollPane.setPreferredSize(new Dimension(20, 20));
        pnlContent.add((Component)scrollPane, constraints);
        return pnlContent;
    }

    private boolean isSelectFolderEventType() {
        return this.eventExecutionType == 10 || this.eventExecutionType == 4 || this.eventExecutionType == 3;
    }

    private void writeRule() {
        this.rule.setName(this.tfRuleName.getText());
        this.rule.setEventExecutionType(this.eventExecutionType);
        this.rule.setItemTypeMask(this.getItemTypeMask());
        this.rule.setConflict(((AppointmentConflictWrapper)this.cmbConflict.getSelectedItem()).getAppointmentConflictType());
        if (this.isSelectFolderEventType()) {
            if (this.selectedFolder != null) {
                this.rule.setFolder(this.selectedFolder.getNativeFolder());
            }
        } else {
            this.rule.setBoxTypeMask(this.getBoxTypeMask());
        }
        this.rule.setActionList(this.ruleActionList);
    }

    private void readRule(Rule theRule) {
        this.tfRuleName.setText(theRule.getName());
        this.tfFolder.setText(theRule.getFolderName());
        this.selectedFolder = APIFolderWrapperManager.getFolder(theRule.getFolder());
        SelectEventAction selectEventAction = new SelectEventAction(theRule.getEventExecutionType());
        this.rebuildEventPane(selectEventAction.isSelectFolder(), selectEventAction.toString());
        this.eventExecutionType = selectEventAction.getEventExecutionType();
        this.setItemTypeMask(theRule.getItemTypeMask());
        this.cmbConflict.setSelectedItem(new AppointmentConflictWrapper(theRule.getConflict()));
        if (this.eventExecutionType == 5 || this.eventExecutionType == 19 || this.eventExecutionType == 1 || this.eventExecutionType == 9 || this.eventExecutionType == 2) {
            this.setBoxTypeMask(theRule.getBoxTypeMask());
        }
        int n = this.ruleActionList.getSize();
        for (int i = 0; i < n; ++i) {
            this.ruleActionListModel.addElement(this.ruleActionList.getActionAt(i));
        }
        if (this.ruleActionList.getSize() > 0) {
            this.listRuleActions.setSelectedIndex(0);
        }
        this.rebuildDescriptionText();
    }

    private int getBoxTypeMask() {
        int result = 0;
        if (this.cbBoxTypeReceived.isSelected()) {
            result |= 1;
        }
        if (this.cbBoxTypeSent.isSelected()) {
            result |= 2;
        }
        if (this.cbBoxTypeDraft.isSelected()) {
            result |= 8;
        }
        if (this.cbBoxTypePosted.isSelected()) {
            result |= 4;
        }
        return result;
    }

    private void setBoxTypeMask(int boxType) {
        if ((boxType & 1) != 0) {
            this.cbBoxTypeReceived.setSelected(true);
        }
        if ((boxType & 2) != 0) {
            this.cbBoxTypeSent.setSelected(true);
        }
        if ((boxType & 8) != 0) {
            this.cbBoxTypeDraft.setSelected(true);
        }
        if ((boxType & 4) != 0) {
            this.cbBoxTypePosted.setSelected(true);
        }
    }

    private int getItemTypeMask() {
        int result = 0;
        if (this.cbItemTypeMail.isSelected()) {
            result |= ItemType.MAIL.getValue();
        }
        if (this.cbItemTypeAppointment.isSelected()) {
            result |= ItemType.APPT.getValue();
        }
        if (this.cbItemTypePhoneMessage.isSelected()) {
            result |= ItemType.PHONE.getValue();
        }
        if (this.cbItemTypeReminderNote.isSelected()) {
            result |= ItemType.NOTE.getValue();
        }
        if (this.cbItemTypeTask.isSelected()) {
            result |= ItemType.TODO.getValue();
        }
        return result;
    }

    private void setItemTypeMask(int mask) {
        if ((mask & ItemType.MAIL.getValue()) != 0) {
            this.cbItemTypeMail.setSelected(true);
        }
        if ((mask & ItemType.APPT.getValue()) != 0) {
            this.cbItemTypeAppointment.setSelected(true);
        }
        if ((mask & ItemType.PHONE.getValue()) != 0) {
            this.cbItemTypePhoneMessage.setSelected(true);
        }
        if ((mask & ItemType.NOTE.getValue()) != 0) {
            this.cbItemTypeReminderNote.setSelected(true);
        }
        if ((mask & ItemType.TODO.getValue()) != 0) {
            this.cbItemTypeTask.setSelected(true);
        }
    }

    private void deleteSelectedAction() {
        int index = this.listRuleActions.getSelectedIndex();
        if (this.ruleActionList.deleteAction(index)) {
            this.ruleActionListModel.remove(index);
        }
        this.selectNearestValue(index);
    }

    private void editSelectedAction() {
        RuleAction ruleAction = (RuleAction)this.listRuleActions.getSelectedValue();
        if (ruleAction == null) {
            return;
        }
        ActionEvent event = new ActionEvent(ruleAction, 0, "");
        if (ruleAction instanceof RuleActionForward) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_FORWARD).actionPerformed(event);
        } else if (ruleAction instanceof RuleActionSend) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_SEND_MAIL).actionPerformed(event);
        } else if (ruleAction instanceof RuleActionDelegate) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_DELEGATE).actionPerformed(event);
        } else if (ruleAction instanceof RuleActionAccept) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_ACCEPT).actionPerformed(event);
        } else if (ruleAction instanceof RuleActionDelete) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_DECLINE).actionPerformed(event);
        } else if (ruleAction instanceof RuleActionReply) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_REPLY).actionPerformed(event);
        } else if (ruleAction instanceof RuleActionLink) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_LINK_TO_FOLDER).actionPerformed(event);
        } else if (ruleAction instanceof RuleActionMove) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_MOVE_TO_FOLDER).actionPerformed(event);
        } else if (ruleAction instanceof RuleActionCategory) {
            ((CreateRuleDialogActionList)this.getController()).getAction(ActionKey.RULE_CATEGORY).actionPerformed(event);
        }
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        this.writeRule();
        boolean result = this.rule.save();
        if (result && !this.isRuleEdited) {
            RuleList ruleList = GWCommandManager.getInstance(this.userGuid).getRuleList();
            int index = ruleList.addRule(this.rule, -1);
            ruleList.saveRule(index);
        }
        ((CreateRuleDialogActionList)this.getController()).processCommand(new Command(980));
        if (result) {
            this.setVisible(false);
            this.dispose();
        }
        super.processOkAction(event);
    }

    private class CurrentPopupMenu
    extends GWPopupMenu {
        private ButtonGroup buttonGroup = new ButtonGroup();

        private CurrentPopupMenu() {
        }

        public JMenuItem add(JMenuItem menuItem) {
            super.add(menuItem);
            this.buttonGroup.add(menuItem);
            return menuItem;
        }
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_OPEN_FOLDER);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractFolder folderToSelect = null;
            if (CreateRuleDialog.this.selectedFolder == null) {
                try {
                    folderToSelect = GWCommandManager.getInstance(CreateRuleDialog.this.userGuid).getRootFolder();
                }
                catch (GWCommandException e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)e1, (Throwable)e1);
                }
            } else {
                folderToSelect = GWCommandManager.getInstance(CreateRuleDialog.this.userGuid).getGWFolder(CreateRuleDialog.this.selectedFolder);
            }
            FoldersDialog foldersDialog = new FoldersDialog(CreateRuleDialog.this, (MVCController)CreateRuleDialog.this.getController(), folderToSelect, StringResources.SELECT_THE_FOLDER_BELOW);
            foldersDialog.pack();
            foldersDialog.setLocationRelativeTo(null);
            foldersDialog.setVisible(true);
            if (foldersDialog.isOkActionProcessed()) {
                IFolder nativeFolder = foldersDialog.getSelectedFolder().getNativeFolder();
                CreateRuleDialog.this.selectedFolder = nativeFolder;
                CreateRuleDialog.this.tfFolder.setText(nativeFolder.getFullPath());
            }
        }
    }

    private class ItemTypeAction
    extends AbstractAction {
        public ItemTypeAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            CreateRuleDialog.this.rebuildDescriptionText();
        }
    }

    private class SelectEventAction
    extends AbstractAction {
        private boolean isSelectFolder;
        private int eventExecutionType;

        private void init() {
            switch (this.eventExecutionType) {
                case 5: {
                    this.putValue("Name", StringResources.NEW_ITEM);
                    this.isSelectFolder = false;
                    break;
                }
                case 10: {
                    this.putValue("Name", StringResources.FILED_ITEM);
                    this.isSelectFolder = true;
                    break;
                }
                case 19: {
                    this.putValue("Name", StringResources.COMPLETED_ITEM);
                    this.isSelectFolder = false;
                    break;
                }
                case 4: {
                    this.putValue("Name", StringResources.OPEN_FOLDER);
                    this.isSelectFolder = true;
                    break;
                }
                case 3: {
                    this.putValue("Name", StringResources.CLOSE_FOLDER);
                    this.isSelectFolder = true;
                    break;
                }
                case 1: {
                    this.putValue("Name", StringResources.STARTUP);
                    this.isSelectFolder = false;
                    break;
                }
                case 2: {
                    this.putValue("Name", StringResources.EXIT);
                    this.isSelectFolder = false;
                    break;
                }
                case 9: {
                    this.putValue("Name", StringResources.USER_ACTIVATED);
                    this.isSelectFolder = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public SelectEventAction(int theEventExecutionType) {
            this.eventExecutionType = theEventExecutionType;
            this.init();
        }

        public boolean isSelectFolder() {
            return this.isSelectFolder;
        }

        public int getEventExecutionType() {
            return this.eventExecutionType;
        }

        public String toString() {
            return (String)this.getValue("Name");
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            CreateRuleDialog.this.eventExecutionType = this.eventExecutionType;
            CreateRuleDialog.this.rebuildEventPane(this.isSelectFolder, menuItem.getText());
            Component[] components = ((JPopupMenu)menuItem.getParent()).getComponents();
            CreateRuleDialog.this.rebuildDescriptionText();
            for (Component component : components) {
                if (component == menuItem) continue;
                ((JMenuItem)component).setSelected(false);
            }
            menuItem.setSelected(true);
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(StringResources.DELETE_ACTION);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            CreateRuleDialog.this.deleteSelectedAction();
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            super(StringResources.EDIT_ACTION);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            CreateRuleDialog.this.editSelectedAction();
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super(StringResources.ADD_ACTION, ImageResources.ADV_FILTER_UP_DOWN);
        }

        public void actionPerformed(ActionEvent e) {
            JButton btnEvent = (JButton)e.getSource();
            CreateRuleDialog.this.rebuildAddActionPopup();
            CreateRuleDialog.this.popupAddAction.show(btnEvent, 0, btnEvent.getHeight());
        }
    }

    private class EventAction
    extends AbstractAction {
        public EventAction() {
            super(StringResources.NEW_ITEM, ImageResources.ADV_FILTER_UP_DOWN);
        }

        public void actionPerformed(ActionEvent e) {
            JButton btnEvent = (JButton)e.getSource();
            CreateRuleDialog.this.popupEvent.show(btnEvent, 0, 0);
        }
    }
}

