/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.rules.CreateRuleDialog;
import com.novell.gw.jclient.application.dialogs.rules.RulesDialogController;
import com.novell.gw.jclient.application.dialogs.rules.RulesTable;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.rules.Rule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesDialog
extends ApplicationDialog<RulesDialogController> {
    private RulesTable tableRules;
    private JButton btnNew = new JMnemonicButton(new NewAction());
    private JButton btnEdit = new JMnemonicButton(new EditAction());
    private JButton btnCopy = new JMnemonicButton(new CopyAction());
    private JButton btnDelete = new JMnemonicButton(new DeleteAction());
    private JButton btnDisable = new JMnemonicButton(new DisableAction());
    private JButton btnRun = new JMnemonicButton(new RunAction());
    private JButton btnRefresh;
    private JButton btnMoveUp = new JMnemonicButton(new MoveUpAction());
    private JButton btnMoveDown = new JMnemonicButton(new MoveDownAction());
    private String userGuid;

    public RulesDialog(ApplicationFrame applicationFrame, AbstractFolder theFolder, IItem[] items) {
        super((Frame)applicationFrame, applicationFrame.getController(), true);
        this.setTitle(StringResources.RULES);
        this.userGuid = applicationFrame.getUserGuid();
        this.tableRules = new RulesTable((MVCController)this.getController(), this.btnDisable, theFolder, items, this.userGuid);
        this.buildUI();
        this.tableRules.selectRow(0);
    }

    @Override
    protected RulesDialogController createController(MVCController parentController) {
        return new RulesDialogController(this, parentController);
    }

    private void buildUI() {
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.setLayout(new BorderLayout(10, 10));
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Container pnlButtons = this.buildButtonsPane();
        pnlContent.add((Component)pnlButtons, "After");
        OrientablePanel pnlLeft = new OrientablePanel(new BorderLayout(10, 10));
        pnlLeft.add((Component)new OrientableLabel("<html>" + StringResources.RULES_ARE_EXECUTED_IN_THE_ORDER + "</html>"), "North");
        pnlLeft.add((Component)this.buildTablePane(), "Center");
        pnlLeft.setPreferredSize(new Dimension(350, 300));
        pnlContent.add((Component)pnlLeft, "Center");
        this.setDefaultButton(this.getBtnCancel());
    }

    private Container buildTablePane() {
        OrientablePanel pnlTable = new OrientablePanel(new BorderLayout());
        pnlTable.add((Component)new ColoredScrollPane(this.tableRules), "Center");
        pnlTable.add((Component)new OrientableLabel(StringResources.RULES_LIST_C), "North");
        return pnlTable;
    }

    private Container buildButtonsPane() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        this.getBtnCancel().setText(StringResources.CLOSE);
        pnlButtons.add(this.getBtnCancel());
        pnlButtons.add(this.btnNew);
        pnlButtons.add(this.btnEdit);
        pnlButtons.add(this.btnCopy);
        pnlButtons.add(this.btnDelete);
        pnlButtons.add(this.btnDisable);
        pnlButtons.add(this.btnRun);
        if (GWCommandManager.getInstance(this.userGuid).getCurrentDataStore().isCaching()) {
            this.btnRefresh = new JMnemonicButton(new RefreshAction());
            pnlButtons.add(this.btnRefresh);
        } else {
            pnlButtons.add(Box.createHorizontalStrut(5));
        }
        pnlButtons.add(this.btnMoveUp);
        pnlButtons.add(this.btnMoveDown);
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)pnlButtons, "North");
        return pnlTemp;
    }

    @Override
    public void setMVCModel(Object theModel) {
        if (theModel instanceof Rule) {
            Rule rule = (Rule)theModel;
            this.btnEdit.setEnabled(true);
            this.btnCopy.setEnabled(true);
            this.btnDisable.setEnabled(true);
            this.btnRun.setEnabled(true);
            int selectedRow = this.tableRules.getSelectedRow();
            int count = this.tableRules.getRowCount();
            boolean b = count > 1 && selectedRow != 0;
            this.btnMoveUp.setEnabled(b);
            b = count > 1 && selectedRow < count - 1;
            this.btnMoveDown.setEnabled(b);
            if (rule.isEnabled()) {
                this.btnDisable.setText(StringResources.DISABLE);
            } else {
                this.btnDisable.setText(StringResources.ENABLE);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.btnDelete.setEnabled(true);
    }

    public void setButtonsDisable() {
        this.btnEdit.setEnabled(false);
        this.btnCopy.setEnabled(false);
        this.btnDisable.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnRun.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
    }

    public void refreshTable() {
        if (this.tableRules != null) {
            this.tableRules.refreshTable();
        }
    }

    protected class MoveDownAction
    extends AbstractAction {
        public MoveDownAction() {
            super(StringResources.MOVE_DOWN);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            RulesDialog.this.tableRules.moveDown();
        }
    }

    protected class MoveUpAction
    extends AbstractAction {
        public MoveUpAction() {
            super(StringResources.MOVE_UP);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            RulesDialog.this.tableRules.moveUp();
        }
    }

    protected class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(StringResources.COPY_D);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            RulesDialog.this.tableRules.copyRule();
        }
    }

    protected class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(StringResources.REFRESH);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            RulesDialog.this.tableRules.refresh();
        }
    }

    protected class RunAction
    extends AbstractAction {
        public RunAction() {
            super(StringResources.RUN);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            RulesDialog.this.tableRules.executeRule();
        }
    }

    protected class DisableAction
    extends AbstractAction {
        public DisableAction() {
            super(StringResources.DISABLE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            RulesDialog.this.tableRules.setSelectedRuleEnabled();
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(StringResources.DELETE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            RulesDialog.this.tableRules.deleteSelectedRule();
        }
    }

    protected class EditAction
    extends AbstractAction {
        public EditAction() {
            super(StringResources.EDIT_D);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            RulesDialog.this.tableRules.editRule();
        }
    }

    protected class NewAction
    extends AbstractAction {
        public NewAction() {
            super(StringResources.NEW_D);
        }

        public void actionPerformed(ActionEvent e) {
            CreateRuleDialog dialog = new CreateRuleDialog(RulesDialog.this, (MVCController)RulesDialog.this.getController(), null, RulesDialog.this.userGuid);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            dialog.dispose();
        }
    }
}

