/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.rules.IVacationRuleDataProvider;
import com.novell.gw.jclient.application.dialogs.rules.VacationRuleDialogController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.rules.VacationRuleInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VacationRuleDialog
extends ApplicationDialog {
    private static final Insets CHECKBOX_INSETS = new Insets(10, 2, 5, 5);
    private static final Insets CONTROL_INSETS = new Insets(5, 5, 5, 5);
    private static final Insets DATE_SELECTOR_INSETS = new Insets(5, 3, 5, 5);
    private static final Insets LABEL_FOR_INSETS = new Insets(5, 5, 1, 5);
    private static final Insets LABELED_CONTROL_INSETS = new Insets(2, 5, 5, 5);
    private static final int VIEW_PORT_ROWS = 7;
    private OrientableCheckBox cbActivateVacationRule;
    private OrientableTextField tfReplySubject;
    private OrientableTextArea taReplyMessage;
    private OrientableCheckBox cbReplyToExternalUsers;
    private ConfirmationDateSelector dsStartDate;
    private ConfirmationDateSelector dsEndDate;

    public VacationRuleDialog(ApplicationFrame theFrame) {
        super((Frame)theFrame, theFrame.getController(), true);
        this.setTitle(StringResources.VACATION_RULE);
        this.buildUI();
        this.init();
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlButtons);
        adapter.setColumnCount(2);
        adapter.setRowCount(1);
        this.getBtnOk().getAction().putValue("Name", StringResources.SAVE);
        this.getBtnOk().getAction().putValue("ShortDescription", StringResources.SAVE);
        JButton btnSave = this.getBtnOk();
        if (OS.isMacOS()) {
            adapter.addComponent(this.getBtnCancel());
            adapter.addComponent(btnSave);
        } else {
            adapter.addComponent(btnSave);
            adapter.addComponent(this.getBtnCancel());
        }
        OrientablePanel pnlWrapper = new OrientablePanel(new BorderLayout());
        pnlWrapper.add((Component)pnlButtons, "East");
        return pnlWrapper;
    }

    private void buildConstraints(GridBagConstraints gbc, int x, int y, int w, int h, int wx, int wy, int fill, int anchor, Insets insets) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.insets = insets;
    }

    private JPanel buildDateSelectorsPanel() {
        OrientablePanel pnlDateSelectors = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.buildInStartDateLabel(pnlDateSelectors, constraints);
        this.buildInStartDateSelector(pnlDateSelectors, constraints);
        this.buildInEndDateLabel(pnlDateSelectors, constraints);
        this.buildInEndDateSelector(pnlDateSelectors, constraints);
        OrientablePanel pnlWrapper = new OrientablePanel(new BorderLayout());
        pnlWrapper.add((Component)pnlDateSelectors, "West");
        return pnlWrapper;
    }

    private void buildInActivationCheckBox(JPanel pnlContent, GridBagConstraints constraints) {
        this.cbActivateVacationRule = new OrientableCheckBox(StringResources.ACTIVATE_MY_VACATION_RULE);
        this.buildConstraints(constraints, 0, 0, 1, 1, 0, 0, 0, 23, CHECKBOX_INSETS);
        pnlContent.add((Component)this.cbActivateVacationRule, constraints);
    }

    private void buildInButtonsPanel(JPanel pnlContent, GridBagConstraints constraints) {
        JPanel pnlButtons = this.buildButtonsPanel();
        this.buildConstraints(constraints, 0, 9, 1, 1, 1, 0, 2, 26, CONTROL_INSETS);
        pnlContent.add((Component)pnlButtons, constraints);
    }

    private void buildInControls(JPanel pnlContent) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.buildInActivationCheckBox(pnlContent, constraints);
        this.buildInReplyNotificationLabel(pnlContent, constraints);
        this.buildInSubjectLabel(pnlContent, constraints);
        this.buildInSubjectTextField(pnlContent, constraints);
        this.buildInMessageLabel(pnlContent, constraints);
        this.buildInMessageTextArea(pnlContent, constraints);
        this.buildInReplyCheckBox(pnlContent, constraints);
        this.buildInDateSelectorsPanel(pnlContent, constraints);
        this.buildInDatesNotificationLabel(pnlContent, constraints);
        this.buildInButtonsPanel(pnlContent, constraints);
    }

    private void buildInDatesNotificationLabel(JPanel pnlContent, GridBagConstraints constraints) {
        OrientableLabel lbDatesNotification = new OrientableLabel(StringResources.DATES_ARE_SCHEDULED);
        this.buildConstraints(constraints, 0, 8, 1, 1, 0, 0, 0, 21, CONTROL_INSETS);
        pnlContent.add((Component)lbDatesNotification, constraints);
    }

    private void buildInDateSelectorsPanel(JPanel pnlContent, GridBagConstraints constraints) {
        JPanel pnlDateSelectors = this.buildDateSelectorsPanel();
        this.buildConstraints(constraints, 0, 7, 1, 1, 1, 0, 2, 23, new Insets(0, 0, 0, 0));
        pnlContent.add((Component)pnlDateSelectors, constraints);
    }

    private void buildInEndDateLabel(JPanel pnlContent, GridBagConstraints constraints) {
        OrientableLabel lbEndDate = new OrientableLabel(StringResources.END_DATEK_U);
        this.buildConstraints(constraints, 2, 0, 1, 1, 0, 0, 0, 22, CONTROL_INSETS);
        pnlContent.add((Component)lbEndDate, constraints);
    }

    private void buildInEndDateSelector(JPanel pnlContent, GridBagConstraints constraints) {
        this.dsEndDate = new ConfirmationDateSelector();
        this.dsEndDate.addChangeListener(new CheckBoxConfirmationStateListener());
        this.dsEndDate.addDateChangeListener(new DatesVerifierListener());
        this.buildConstraints(constraints, 3, 0, 1, 1, 0, 0, 0, 23, DATE_SELECTOR_INSETS);
        pnlContent.add((Component)this.dsEndDate, constraints);
    }

    private void buildInMessageLabel(JPanel pnlContent, GridBagConstraints constraints) {
        OrientableLabel lbMessage = new OrientableLabel(StringResources.MESSAGE_C);
        this.buildConstraints(constraints, 0, 4, 1, 1, 0, 0, 0, 25, LABEL_FOR_INSETS);
        pnlContent.add((Component)lbMessage, constraints);
    }

    private void buildInMessageTextArea(JPanel pnlContent, GridBagConstraints constraints) {
        this.taReplyMessage = new OrientableTextArea(7, 1);
        this.buildConstraints(constraints, 0, 5, 1, 1, 1, 1, 1, 23, LABELED_CONTROL_INSETS);
        OrientableScrollPane pnlScrollWrapper = new OrientableScrollPane(this.taReplyMessage, 22, 31);
        pnlContent.add((Component)pnlScrollWrapper, constraints);
    }

    private void buildInStartDateLabel(JPanel pnlContent, GridBagConstraints constraints) {
        OrientableLabel lbStartDate = new OrientableLabel(StringResources.START_DATEK_U);
        this.buildConstraints(constraints, 0, 0, 1, 1, 0, 0, 0, 21, CONTROL_INSETS);
        pnlContent.add((Component)lbStartDate, constraints);
    }

    private void buildInStartDateSelector(JPanel pnlContent, GridBagConstraints constraints) {
        this.dsStartDate = new ConfirmationDateSelector();
        this.dsStartDate.addChangeListener(new CheckBoxConfirmationStateListener());
        this.dsStartDate.addDateChangeListener(new DatesVerifierListener());
        this.buildConstraints(constraints, 1, 0, 1, 1, 0, 0, 0, 23, DATE_SELECTOR_INSETS);
        pnlContent.add((Component)this.dsStartDate, constraints);
    }

    private void buildInSubjectLabel(JPanel pnlContent, GridBagConstraints constraints) {
        OrientableLabel lbSubject = new OrientableLabel(StringResources.SUBJECT_C);
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 0, 0, 25, LABEL_FOR_INSETS);
        pnlContent.add((Component)lbSubject, constraints);
    }

    private void buildInSubjectTextField(JPanel pnlContent, GridBagConstraints constraints) {
        this.tfReplySubject = new OrientableTextField();
        this.buildConstraints(constraints, 0, 3, 1, 1, 1, 0, 2, 23, LABELED_CONTROL_INSETS);
        pnlContent.add((Component)this.tfReplySubject, constraints);
    }

    private void buildInReplyCheckBox(JPanel pnlContent, GridBagConstraints constraints) {
        this.cbReplyToExternalUsers = new OrientableCheckBox(StringResources.REPLY_TO_EXTERNAL_USERS);
        this.buildConstraints(constraints, 0, 6, 1, 1, 0, 0, 0, 21, CHECKBOX_INSETS);
        pnlContent.add((Component)this.cbReplyToExternalUsers, constraints);
    }

    private void buildInReplyNotificationLabel(JPanel pnlContent, GridBagConstraints constraints) {
        OrientableLabel lbReplyNotification = new OrientableLabel(StringResources.ENTER_THE_SUBJECT_AND_MESSAGE);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 0, 0, 21, CONTROL_INSETS);
        pnlContent.add((Component)lbReplyNotification, constraints);
    }

    private void buildUI() {
        Container container = this.getContentPane();
        OrientablePanel pnlContent = new OrientablePanel();
        container.add(pnlContent);
        GridBagLayout gridBagLayout = new GridBagLayout();
        pnlContent.setLayout(gridBagLayout);
        this.buildInControls(pnlContent);
    }

    private void init() {
        this.populateDiaglog(this.getDataProvider().getVacationRuleInfo());
    }

    private IVacationRuleDataProvider getDataProvider() {
        return (IVacationRuleDataProvider)this.getController();
    }

    private VacationRuleInfo getVacationRuleInfoFromDialog() {
        VacationRuleInfo vacationRuleInfo = this.dsStartDate.isConfirmed() && this.dsEndDate.isConfirmed() ? new VacationRuleInfo(this.getDataProvider().getVacationRuleInfo().getName(), this.tfReplySubject.getText(), this.taReplyMessage.getText(), this.cbActivateVacationRule.isSelected(), this.dsStartDate.getDate(), this.dsEndDate.getDate(), this.cbReplyToExternalUsers.isSelected()) : new VacationRuleInfo(this.getDataProvider().getVacationRuleInfo().getName(), this.tfReplySubject.getText(), this.taReplyMessage.getText(), this.cbActivateVacationRule.isSelected(), null, null, this.cbReplyToExternalUsers.isSelected());
        return vacationRuleInfo;
    }

    private void populateDiaglog(VacationRuleInfo vacationRuleInfo) {
        if (vacationRuleInfo != null) {
            this.cbActivateVacationRule.setSelected(vacationRuleInfo.isActive());
            this.tfReplySubject.setText(vacationRuleInfo.getReplySubject());
            this.taReplyMessage.setText(vacationRuleInfo.getReplyMessage());
            this.cbReplyToExternalUsers.setSelected(vacationRuleInfo.isReplyToExternalUsers());
            this.dsStartDate.setDate(vacationRuleInfo.getStartDate());
            this.dsEndDate.setDate(vacationRuleInfo.getEndDate());
            boolean isConfirmed = this.getDataProvider().isDatesSelected();
            this.dsStartDate.setConfirmed(isConfirmed);
            this.dsEndDate.setConfirmed(isConfirmed);
        }
    }

    protected MVCController createController(MVCController parentController) {
        return new VacationRuleDialogController(this, parentController);
    }

    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        VacationRuleInfo vacationRuleInfo = this.getVacationRuleInfoFromDialog();
        this.getDataProvider().setVacationRuleInfo(vacationRuleInfo);
    }

    private class ConfirmationDateSelector
    extends OrientablePanel {
        private SingleDateSelector dsDatePicker;
        private JCheckBox cbApproveDate;

        public ConfirmationDateSelector() {
            this.buildUI();
        }

        private void buildInApproveCheckBox() {
            this.cbApproveDate = new OrientableCheckBox();
            this.cbApproveDate.setSelected(false);
            this.cbApproveDate.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (ConfirmationDateSelector.this.dsDatePicker != null) {
                        ((JComponent)ConfirmationDateSelector.this.dsDatePicker.getTextComponent()).setEnabled(ConfirmationDateSelector.this.cbApproveDate.isSelected());
                    }
                }
            });
            this.add((Component)this.cbApproveDate, "Before");
        }

        private void buildInControls() {
            this.setLayout(new BorderLayout());
            this.buildInDatePicker();
            this.buildInApproveCheckBox();
        }

        private void buildInDatePicker() {
            this.dsDatePicker = new SingleDateSelector();
            ((JComponent)this.dsDatePicker.getTextComponent()).setBorder(BorderFactory.createEmptyBorder());
            this.dsDatePicker.addValueChangeListener(new DateValueChangeListener(){

                public void valueChanged(DateChangeEvent e) {
                    if (ConfirmationDateSelector.this.cbApproveDate != null) {
                        ConfirmationDateSelector.this.cbApproveDate.setSelected(true);
                    }
                }
            });
            ((JComponent)this.dsDatePicker.getTextComponent()).setEnabled(false);
            this.add((Component)this.dsDatePicker, "Center");
        }

        private void buildUI() {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setBackground(Color.WHITE);
            this.buildInControls();
        }

        public void addChangeListener(ChangeListener listener) {
            this.cbApproveDate.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cbApproveDate.removeChangeListener(listener);
        }

        public void addDateChangeListener(DateValueChangeListener listener) {
            this.dsDatePicker.addDateChangeListener(listener);
        }

        public void removeDateChangeListener(DateValueChangeListener listener) {
            this.dsDatePicker.removeDateChangeListener(listener);
        }

        public void addValueChangeListener(DateValueChangeListener listener) {
            this.dsDatePicker.addValueChangeListener(listener);
        }

        public void removeValueChangeListener(DateValueChangeListener listener) {
            this.dsDatePicker.removeValueChangeListener(listener);
        }

        public Date getDate() {
            return this.dsDatePicker.getDate().getTime();
        }

        public boolean isConfirmed() {
            return this.cbApproveDate.isSelected();
        }

        public void setConfirmed(boolean confirmed) {
            this.cbApproveDate.setSelected(confirmed);
        }

        public void setDate(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.dsDatePicker.setDate(calendar);
        }
    }

    private class DatesVerifierListener
    implements DateValueChangeListener {
        private DatesVerifierListener() {
        }

        public void valueChanged(DateChangeEvent e) {
            if (VacationRuleDialog.this.dsStartDate != null && VacationRuleDialog.this.dsEndDate != null && VacationRuleDialog.this.dsEndDate.getDate().before(VacationRuleDialog.this.dsStartDate.getDate())) {
                VacationRuleDialog.this.dsEndDate.setDate(VacationRuleDialog.this.dsStartDate.getDate());
            }
        }
    }

    private class CheckBoxConfirmationStateListener
    implements ChangeListener {
        private CheckBoxConfirmationStateListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (VacationRuleDialog.this.dsStartDate != null && VacationRuleDialog.this.dsEndDate != null) {
                VacationRuleDialog.this.getBtnOk().setEnabled(VacationRuleDialog.this.dsStartDate.isConfirmed() == VacationRuleDialog.this.dsEndDate.isConfirmed());
            }
        }
    }
}

