/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules.actions;

import com.appframework.mvc.MVCController;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.addressbook.DLSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.popedit.StringParser;
import com.novell.gw.jclient.application.dialogs.rules.actions.ReplyMailActionDialog;
import com.novell.gw.jclient.application.dialogs.rules.actions.RuleActionDialog;
import com.novell.gw.jclient.application.dialogs.rules.actions.ValidateAttachmentDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMailActionDialog
extends RuleActionDialog {
    private static final Logger logger = Logger.getLogger(AbstractMailActionDialog.class);
    protected ContactSearchComboField stfTO;
    private ContactSearchComboField stfCC;
    private ContactSearchComboField stfBC;
    protected JTextField tfFrom = new GWTextField();
    private JButton btnAddressBook = new JMnemonicButton(new ViewAddressSelectorAction());
    protected JTextArea taMessage = new GWTextArea();
    protected JTextField tfSubject = new GWTextField();
    protected JComponent lbTo;
    private boolean isComponentShownFirstTime = true;
    protected JTextField tfFiles;
    private static final String FILE_SEPARATOR = ", ";
    private String userGuid;

    AbstractMailActionDialog(JDialog parentDialog, MVCController parentController, RuleAction theRuleAction, Rule theRule, String userGuid) {
        super(parentDialog, parentController, theRuleAction, theRule);
        this.userGuid = userGuid;
        this.init();
        this.buildUI();
    }

    private void init() {
        this.tfFiles = new GWTextField(){

            public void setText(String theText) {
                super.setText(theText);
                if (theText != null && theText.length() > 0) {
                    this.setCaretPosition(0);
                }
            }
        };
        this.stfTO = new ContactSearchComboField((MVCController)this.getController(), RecipientCopyType.getTo());
        this.stfCC = new ContactSearchComboField((MVCController)this.getController(), RecipientCopyType.getCc());
        this.stfBC = new ContactSearchComboField((MVCController)this.getController(), RecipientCopyType.getBc());
        this.propertyManager.setEnabledChangeLogger(true);
        this.propertyManager.addPropertyView(this.stfTO);
        this.propertyManager.addPropertyView(this.stfCC);
        this.propertyManager.addPropertyView(this.stfBC);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, this.stfTO);
        this.tfFrom.setText(GWCommandManager.getInstance(this.userGuid).getCurrentUserInfo().getID());
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                if (AbstractMailActionDialog.this.isComponentShownFirstTime) {
                    if (AbstractMailActionDialog.this instanceof ReplyMailActionDialog) {
                        AbstractMailActionDialog.this.taMessage.grabFocus();
                        AbstractMailActionDialog.this.taMessage.setCaretPosition(0);
                    } else {
                        AbstractMailActionDialog.this.stfTO.grabFocus();
                    }
                    AbstractMailActionDialog.this.isComponentShownFirstTime = false;
                }
            }
        });
    }

    private void buildUI() {
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        pnlContent.setPreferredSize(new Dimension(510, 220));
        pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlContent.setLayout(new BorderLayout(10, 5));
        OrientablePanel pnlButtons = new OrientablePanel(new BorderLayout());
        OrientablePanel pnlTemp = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        pnlTemp.add(this.getBtnOk());
        pnlTemp.add(this.getBtnCancel());
        pnlTemp.add(this.btnAddressBook);
        pnlTemp.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        pnlButtons.add((Component)pnlTemp, "North");
        pnlContent.add((Component)pnlButtons, "After");
        OrientablePanel pnlCenter = new OrientablePanel(new GridBagLayout());
        TitleValueContainer container = new TitleValueContainer(pnlCenter);
        OrientablePanel pnlAttachments = new OrientablePanel(new BorderLayout(5, 0));
        pnlAttachments.add((Component)this.tfFiles, "Center");
        container.buildRow(new JMnemonicLabel(StringResources.FROM_C, this.tfFrom), this.tfFrom, new JMnemonicLabel(StringResources.CC_C, this.stfCC), this.stfCC, 0);
        container.buildRow(this.lbTo, this.stfTO, new JMnemonicLabel(StringResources.BC_C, this.stfBC), this.stfBC, 1);
        container.buildRow(new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject), this.tfSubject, new JMnemonicLabel(StringResources.FILES_C, pnlAttachments), pnlAttachments, 2);
        container.buildRow((JComponent)new JMnemonicLabel(StringResources.MESSAGE_C, this.taMessage), (JComponent)new OrientableScrollPane(this.taMessage), 3, true);
        pnlContent.add((Component)pnlCenter, "Center");
        this.tfFiles.setDropTarget(new DropTarget(this.tfFiles, 3, new MADDropTargetListener()));
    }

    @Override
    public void readInitialProperties() {
        super.readInitialProperties();
        this.getBtnOk().setEnabled(false);
    }

    List<IRecipient> getRecipients() {
        ArrayList<IRecipient> result = new ArrayList<IRecipient>();
        result.addAll(this.stfTO.getRecipients());
        result.addAll(this.stfCC.getRecipients());
        result.addAll(this.stfBC.getRecipients());
        return result;
    }

    String getAttachments(String savedAttachments) {
        int length;
        String text = this.tfFiles.getText().trim();
        StringBuilder result = new StringBuilder();
        if (text.length() > 0) {
            List tokens = StringParser.getTokens(text, new char[]{','});
            int nSize = tokens.size();
            for (int i = 0; i < nSize; ++i) {
                String token = ((String)tokens.get(i)).trim();
                if (new File(token).isFile() || savedAttachments != null && savedAttachments.indexOf(token) != -1) {
                    result.append(token);
                    result.append(FILE_SEPARATOR);
                    continue;
                }
                ValidateAttachmentDialog dialog = new ValidateAttachmentDialog((JDialog)this, token);
                dialog.showMe();
                if (!dialog.isActionCompleteSuccessfully()) continue;
                result.append(dialog.getFileName());
                result.append(FILE_SEPARATOR);
            }
        }
        if ((length = result.length()) > 2) {
            result.delete(length - 2, length);
        }
        return result.toString();
    }

    void setRecipients(DistributionList theDistributionList) {
        this.stfTO.setRecipients(AbstractMailActionDialog.getRecipientsByCopyType(RecipientCopyType.getTo(), theDistributionList));
        this.stfCC.setRecipients(AbstractMailActionDialog.getRecipientsByCopyType(RecipientCopyType.getCc(), theDistributionList));
        this.stfBC.setRecipients(AbstractMailActionDialog.getRecipientsByCopyType(RecipientCopyType.getBc(), theDistributionList));
    }

    private static List<IRecipient> getRecipientsByCopyType(RecipientCopyType theCopyType, DistributionList theDistributionList) {
        ArrayList<IRecipient> result = new ArrayList<IRecipient>();
        int n = theDistributionList.getSize();
        for (int i = 0; i < n; ++i) {
            IRecipient recipient = APIAbWrapperManager.getRecipient(theDistributionList.getRecipient(i));
            if (!recipient.getCopyType().hasRecipientCopyType(theCopyType)) continue;
            result.add(recipient);
        }
        return result;
    }

    private class MADDropTargetListener
    extends DropTargetAdapter {
        private MADDropTargetListener() {
        }

        public void dragOver(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getSourceActions());
        }

        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable data = dtde.getTransferable();
            StringBuilder result = new StringBuilder();
            try {
                if (dtde.getCurrentDataFlavorsAsList().contains(GWFlavors.uriListFlavor)) {
                    String stringUrl = (String)data.getTransferData(GWFlavors.uriListFlavor);
                    if (stringUrl.length() > 0 && stringUrl.charAt(stringUrl.length() - 1) == '\u0000') {
                        stringUrl = stringUrl.substring(0, stringUrl.length() - 1);
                    }
                    stringUrl = URLDecoder.decode(stringUrl);
                    List tokens = StringParser.getTokens(stringUrl, "\r\n");
                    int nSize = tokens.size();
                    for (int i = 0; i < nSize; ++i) {
                        String filePath = (String)tokens.get(i);
                        try {
                            if ("".equals(filePath)) continue;
                            result.append(new URL(filePath).getPath());
                            result.append(AbstractMailActionDialog.FILE_SEPARATOR);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                } else if (dtde.getCurrentDataFlavorsAsList().contains(DataFlavor.javaFileListFlavor)) {
                    List fileList = (List)data.getTransferData(DataFlavor.javaFileListFlavor);
                    int nSize = fileList.size();
                    for (int i = 0; i < nSize; ++i) {
                        File file = (File)fileList.get(i);
                        result.append(file.getAbsolutePath());
                        result.append(AbstractMailActionDialog.FILE_SEPARATOR);
                    }
                } else if (dtde.getCurrentDataFlavorsAsList().contains(DataFlavor.stringFlavor)) {
                    result.append((String)data.getTransferData(DataFlavor.stringFlavor));
                }
                try {
                    if (result.length() > 0) {
                        AbstractMailActionDialog.this.tfFiles.getDocument().insertString(AbstractMailActionDialog.this.tfFiles.getCaretPosition(), result.toString(), null);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            catch (UnsupportedFlavorException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private class ViewAddressSelectorAction
    extends AbstractAction {
        public ViewAddressSelectorAction() {
            super(StringResources.ADDRESS_BOOK_D);
        }

        public void actionPerformed(ActionEvent e) {
            DLSelectorDialog dialog = new DLSelectorDialog(AbstractMailActionDialog.this, (List)AbstractMailActionDialog.this.getRecipients(), (MVCController)AbstractMailActionDialog.this.getController());
            dialog.setVisible(true);
            if (dialog.isOkActionProcessed()) {
                AbstractMailActionDialog.this.stfTO.setRecipients(dialog.getToRecipients());
                AbstractMailActionDialog.this.stfCC.setRecipients(dialog.getCCRecipients());
                AbstractMailActionDialog.this.stfBC.setRecipients(dialog.getBCRecipients());
            }
        }
    }
}

