/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules.actions;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.rules.actions.AbstractAcceptActionDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleAction;
import com.novell.gw.rules.RuleActionAccept;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

class AcceptActionDialog
extends AbstractAcceptActionDialog {
    private JList calendarList;

    public AcceptActionDialog(JDialog parentDialog, MVCController parentController, RuleAction thRuleAction, Rule theRule) {
        super(parentDialog, parentController, thRuleAction, theRule);
        this.setTitle(StringResources.ACCEPT_WITH_OPTIONS);
        this.rbBusy.setSelected(true);
    }

    protected boolean writeRuleAction() {
        AppointmentAcceptLevel acceptLevel = AppointmentAcceptLevel.NONE;
        if (this.rbFree.isSelected()) {
            acceptLevel = AppointmentAcceptLevel.FREE;
        } else if (this.rbTentative.isSelected()) {
            acceptLevel = AppointmentAcceptLevel.TENTATIVE;
        } else if (this.rbBusy.isSelected()) {
            acceptLevel = AppointmentAcceptLevel.BUSY;
        } else if (this.rbOutOfOffice.isSelected()) {
            acceptLevel = AppointmentAcceptLevel.OUT_OF_OFFICE;
        }
        if (this.ruleAction == null) {
            this.ruleAction = new RuleActionAccept(this.rule, acceptLevel.getValue());
        }
        ((RuleActionAccept)this.ruleAction).setComment(this.taComments.getText());
        ((RuleActionAccept)this.ruleAction).setCalendarFolder(((AbstractFolder)this.calendarList.getModel().getElementAt(this.calendarList.getSelectedIndex())).getNativeFolder().getNativeFolder());
        return true;
    }

    protected void readRuleAction() {
        RuleActionAccept actionAccept = (RuleActionAccept)this.ruleAction;
        AppointmentAcceptLevel acceptLevel = AppointmentAcceptLevel.getEnum(actionAccept.getAcceptLevel());
        if (acceptLevel == AppointmentAcceptLevel.FREE) {
            this.rbFree.setSelected(true);
        } else if (acceptLevel == AppointmentAcceptLevel.TENTATIVE) {
            this.rbTentative.setSelected(true);
        } else if (acceptLevel == AppointmentAcceptLevel.BUSY) {
            this.rbBusy.setSelected(true);
        } else if (acceptLevel == AppointmentAcceptLevel.OUT_OF_OFFICE) {
            this.rbOutOfOffice.setSelected(true);
        }
        this.taComments.setText(actionAccept.getComment());
        this.calendarList.setSelectedValue(EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getGWFolder(APIFolderWrapperManager.getFolder(actionAccept.getCalendarFolder())), true);
    }

    protected OrientablePanel buildCalendarpPanel() {
        this.calendarList = new JList();
        this.calendarList.setModel(new CalendarListModel());
        this.calendarList.setCellRenderer(new CalendarListRenderer());
        this.calendarList.setSelectedIndex(0);
        JScrollPane calendarScroll = new JScrollPane(this.calendarList);
        calendarScroll.setPreferredSize(new Dimension(300, 150));
        OrientablePanel pnlCalendar = new OrientablePanel(new BorderLayout());
        pnlCalendar.add((Component)new OrientableLabel(StringResources.ACCEPT_TO), "North");
        pnlCalendar.add((Component)calendarScroll, "Center");
        return pnlCalendar;
    }

    private class CalendarListRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarListRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(2, 2, 0, 2));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            AbstractFolder f = (AbstractFolder)value;
            this.setIcon(ControlsUtils.getImageForFolder(f));
            this.setText(f.getName());
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class CalendarListModel
    extends DefaultListModel {
        private List folderList;
        private CalendarFolder calendarFolder = EngineCommandManager.getCalendarFolder(EngineCommandManager.getUserGuid());

        public CalendarListModel() {
            this.folderList = this.calendarFolder.getChildFolders();
        }

        public Object getElementAt(int index) {
            if (index == 0) {
                return this.calendarFolder;
            }
            return this.folderList.get(index - 1);
        }

        public int getSize() {
            return this.folderList.size() + 1;
        }
    }
}

