/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules.actions;

import com.appframework.mvc.MVCController;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.addressbook.DLSelectorDialog;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.rules.actions.RuleActionDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleAction;
import com.novell.gw.rules.RuleActionDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class DelegateActionDialog
extends RuleActionDialog {
    private JButton btnAddressBook = new JMnemonicButton(new ViewAddressSelectorAction());
    private ContactSearchComboField stfTO;
    private JTextArea taCommentsToSender = new GWTextArea();
    private JTextArea taCommentsToRecipient = new GWTextArea();

    public DelegateActionDialog(JDialog parentDialog, MVCController parentController, RuleAction theRuleAction, Rule theRule) {
        super(parentDialog, parentController, theRuleAction, theRule);
        this.setTitle(StringResources.DELEGATE);
        this.init();
        this.buildUI();
    }

    private void init() {
        this.stfTO = new ContactSearchComboField((MVCController)this.getController(), RecipientCopyType.getTo());
        this.propertyManager.addPropertyView(this.stfTO);
    }

    protected boolean writeRuleAction() {
        boolean bRet = true;
        ArrayList<IRecipient> result = new ArrayList<IRecipient>();
        DistributionList distributionList = new DistributionList();
        result.addAll(this.stfTO.getRecipients());
        if (result.size() > 0) {
            int n = result.size();
            for (int i = 0; i < n; ++i) {
                distributionList.addRecipient(((IRecipient)result.get(i)).getNativeRecipient());
            }
            if (this.ruleAction == null) {
                this.ruleAction = new RuleActionDelegate(this.rule, distributionList);
            } else {
                ((RuleActionDelegate)this.ruleAction).setDistributionList(distributionList);
            }
            ((RuleActionDelegate)this.ruleAction).setCommentToRecipient(this.taCommentsToRecipient.getText());
            ((RuleActionDelegate)this.ruleAction).setCommentToSender(this.taCommentsToSender.getText());
        } else {
            Toolkit.getDefaultToolkit().beep();
            bRet = false;
        }
        return bRet;
    }

    protected void processOkAction(ActionEvent event) {
        if (this.stfTO.getRecipients().size() > 0) {
            super.processOkAction(event);
        }
    }

    protected void readInitialProperties() {
        super.readInitialProperties();
        this.getBtnOk().setEnabled(false);
    }

    protected void readRuleAction() {
        RuleActionDelegate actionSend = (RuleActionDelegate)this.ruleAction;
        DistributionList distributionList = actionSend.getDistributionList();
        ArrayList<IRecipient> recipients = new ArrayList<IRecipient>(distributionList.getSize());
        int nSize = distributionList.getSize();
        for (int i = 0; i < nSize; ++i) {
            recipients.add(APIAbWrapperManager.getRecipient(distributionList.getRecipient(i)));
        }
        this.stfTO.setRecipients(recipients);
        this.taCommentsToRecipient.setText(actionSend.getCommentToRecipient());
        this.taCommentsToSender.setText(actionSend.getCommentToSender());
    }

    private void buildUI() {
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        pnlContent.setLayout(new BorderLayout(10, 10));
        OrientablePanel pnlButtons = new OrientablePanel(new BorderLayout());
        OrientablePanel pnlTemp = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        pnlTemp.add(this.getBtnOk());
        pnlTemp.add(this.getBtnCancel());
        pnlTemp.add(this.btnAddressBook);
        pnlTemp.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        pnlButtons.add((Component)pnlTemp, "North");
        pnlContent.add((Component)pnlButtons, "After");
        OrientablePanel pnlCenter = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.top = 5;
        constraints.insets.right = 5;
        constraints.anchor = 21;
        pnlCenter.add((Component)new JMnemonicLabel(StringResources.TO_C, this.stfTO), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        pnlCenter.add((Component)this.stfTO, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        pnlCenter.add((Component)new JMnemonicLabel(StringResources.COMMENTS_TO_SENDER_C, this.taCommentsToSender), constraints);
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets.top = 3;
        pnlCenter.add((Component)new OrientableScrollPane(this.taCommentsToSender), constraints);
        constraints.insets.top = 5;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        pnlCenter.add((Component)new JMnemonicLabel(StringResources.COMMENTS_TO_RECIPIENT_C, this.taCommentsToRecipient), constraints);
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets.top = 3;
        pnlCenter.add((Component)new OrientableScrollPane(this.taCommentsToRecipient), constraints);
        constraints.insets.top = 5;
        pnlContent.add((Component)pnlCenter, "Center");
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pnlContent.setPreferredSize(new Dimension(410, 300));
    }

    private class ViewAddressSelectorAction
    extends AbstractAction {
        public ViewAddressSelectorAction() {
            super(StringResources.ADDRESS_C);
        }

        public void actionPerformed(ActionEvent e) {
            DLSelectorDialog dialog = new DLSelectorDialog(DelegateActionDialog.this, (List)DelegateActionDialog.this.stfTO.getRecipients(), (MVCController)DelegateActionDialog.this.getController());
            dialog.setVisible(true);
            if (dialog.isOkActionProcessed()) {
                DelegateActionDialog.this.stfTO.setRecipients(dialog.getToRecipients());
            }
        }
    }
}

