/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules.actions;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeEvent;
import com.novell.gw.jclient.application.controls.propertymanager.GWPropertyChangeListener;
import com.novell.gw.jclient.application.controls.propertymanager.PropertyManager;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleAction;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuleActionDialog
extends ApplicationDialog<ApplicationDialogController>
implements GWPropertyChangeListener {
    RuleAction ruleAction;
    Rule rule;
    private boolean isRuleEdited = true;
    protected PropertyManager propertyManager = new PropertyManager();

    RuleActionDialog(JDialog parentDialog, MVCController parentController, RuleAction ruleAction, Rule rule) {
        super((Dialog)parentDialog, parentController, true);
        this.ruleAction = ruleAction;
        if (this.ruleAction == null) {
            this.isRuleEdited = false;
        }
        this.rule = rule;
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                RuleActionDialog.this.readInitialProperties();
                if (RuleActionDialog.this.ruleAction != null) {
                    RuleActionDialog.this.readRuleAction();
                }
            }
        });
        this.propertyManager.addGWPropertyChangeListener(this);
    }

    @Override
    public void propertyChanged(GWPropertyChangeEvent event) {
        JButton ok = this.getBtnOk();
        if (event.getPropertyManager().hasChangedProperties()) {
            ok.setEnabled(true);
        } else {
            ok.setEnabled(false);
        }
    }

    @Override
    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<RuleActionDialog>(this, parentController);
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        this.writeRuleAction();
        this.sendCommands();
        super.processOkAction(event);
    }

    protected abstract boolean writeRuleAction();

    protected abstract void readRuleAction();

    protected void readInitialProperties() {
        this.propertyManager.readInitialProperties();
    }

    void sendCommands() {
        Command command;
        if (this.isRuleEdited) {
            command = new Command(990);
        } else {
            assert (this.ruleAction != null);
            command = new Command(970, this.ruleAction);
        }
        ((ApplicationDialogController)this.getController()).processCommand(command);
    }

    public RuleAction getRuleAction() {
        return this.ruleAction;
    }
}

