/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.compose;

import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionSwitchMainToolBar;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameCompose
extends ApplicationFrame<FrameComposeActionList, Object> {
    private static Logger logger = Logger.getLogger(FrameCompose.class);
    protected ItemEditPanel itemEdit;
    protected ApplicationFrameToolBar toolbar;
    private String titlePrefix;
    private AutoSaveTimerAction autoSaveTimerAction = new AutoSaveTimerAction();
    private Timer autoSaveTimer = new Timer(30000, this.autoSaveTimerAction);
    private boolean spellCheckSuppressed = false;

    public FrameCompose(String theTitle, boolean fillSendOptions, String theOptionFrameName, String toolBarName, String userGuid) {
        super(theTitle, theOptionFrameName, userGuid);
        boolean bAutoSaveEnabled;
        this.toolBarName = toolBarName;
        this.titlePrefix = theTitle;
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(userGuid).getDataStoreSettings();
        boolean bl = bAutoSaveEnabled = (Boolean)dataStoreSettings.getDisableAutoSave().getValue() == false;
        if (bAutoSaveEnabled) {
            this.autoSaveTimer.start();
        }
        this.setController(new FrameComposeActionList(this, (MVCController)GWClient.getApplication()));
        ActionSwitchMainToolBar actionSwitch = (ActionSwitchMainToolBar)((FrameComposeActionList)this.appActionList).getAction(ActionKey.SWITCH_MAIN_TOOLBAR);
        actionSwitch.setToolBarName(this.toolBarName);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Dimension d = FrameCompose.this.getSize();
                int width = 600;
                int height = 475;
                if (d.getWidth() < (double)width && d.getHeight() >= (double)height) {
                    FrameCompose.this.setSize(new Dimension(width, d.height));
                } else if (d.getWidth() >= (double)width && d.getHeight() < (double)height) {
                    FrameCompose.this.setSize(new Dimension(d.width, height));
                } else if (d.getWidth() < (double)width && d.getHeight() < (double)height) {
                    FrameCompose.this.setSize(new Dimension(width, height));
                }
            }
        });
        this.setDropTarget(new DropTarget(this, new DropTargetAdapter(){

            public void drop(DropTargetDropEvent dtde) {
                Transferable transferable = dtde.getTransferable();
                TransferHandler transferHandler = FrameCompose.this.getItemEdit().getAttachmentView().getListContent().getTransferHandler();
                if (transferHandler.canImport(null, transferable.getTransferDataFlavors())) {
                    dtde.acceptDrop(dtde.getDropAction());
                    transferHandler.importData(null, transferable);
                }
            }
        }));
    }

    protected void buildUI(AbstractItem theNewItem, ComposeMode composeMode) {
        GWToolBarPanel toolBarPanel = new GWToolBarPanel();
        toolBarPanel.add((Component)this.toolbar, "Center");
        this.setToolBarPanel(toolBarPanel, "North");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setMinimumSize(new Dimension(720, 550));
        contentPane.setPreferredSize(new Dimension(720, 550));
        KeyStroke keyStroke = OS.isMacOS() ? KeyStroke.getKeyStroke(83, 0x200 | OS.getMetaKey()) : KeyStroke.getKeyStroke(83, 512);
        contentPane.registerKeyboardAction(((FrameComposeActionList)this.getController()).getAction(this instanceof FrameComposePostedItem ? ActionKey.POST_ITEM : ActionKey.SEND_ITEM), keyStroke, 2);
    }

    public AbstractItem getNewItem() {
        return this.itemEdit.getGWItemComposition();
    }

    public List getRecipientList() {
        return this.itemEdit.getRecipientsList();
    }

    public ItemEditPanel getItemEdit() {
        return this.itemEdit;
    }

    public HTMLTextPane getItemEditHTMLTextPane() {
        return this.itemEdit.getMessageEditor();
    }

    public JTextField getSubject() {
        return this.itemEdit.getSubject();
    }

    public void clearDirtyState() {
        this.itemEdit.clearDirtyState();
    }

    @Override
    protected void afterShow() {
        super.afterShow();
        this.clearDirtyState();
    }

    @Override
    public void beforeDispose() {
        super.beforeDispose();
        this.autoSaveTimer.stop();
        if (this.itemEdit.isItemInChecklist()) {
            this.itemEdit.getCheckListViewPanel().saveChanges();
            this.itemEdit.getCheckListViewPanel().release();
        }
    }

    public AbstractItem getGwItem() {
        return this.itemEdit.getInitialItem();
    }

    public abstract ComposeItemSendOptions getItemSendOptions();

    public void updateTitle(String string) {
        this.setTitle(this.titlePrefix + ' ' + string);
    }

    @Override
    public void release() {
        super.release();
        this.toolbar = null;
        this.itemEdit = null;
    }

    @Override
    public void showMe() {
        super.showMe();
        this.toFront();
    }

    public void stopTimer() {
        this.autoSaveTimer.removeActionListener(this.autoSaveTimerAction);
        this.autoSaveTimer.stop();
        this.autoSaveTimer.addActionListener(this.autoSaveTimerAction);
    }

    public void startTimer() {
        this.autoSaveTimer.start();
    }

    public IDataStore getFromDataStore() {
        return this.itemEdit.getFromDataStore();
    }

    public boolean isSpellCheckSuppressed() {
        return this.spellCheckSuppressed;
    }

    public void setSpellCheckSuppressed(boolean spellCheckSuppressed) {
        this.spellCheckSuppressed = spellCheckSuppressed;
    }

    private class AutoSaveTimerAction
    implements ActionListener {
        private AutoSaveTimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)"Performing Auto Save");
            FrameCompose.this.itemEdit.getGWItemComposition().autoSave();
        }
    }
}

