/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.AccountDnD;

import com.novell.gw.jclient.application.frames.options.AccountDnD.ArrowPainter;
import com.novell.gw.jclient.application.frames.options.AccountsDragTableModelInterface;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JLayeredPane;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class AccountsTableDropTargetListener
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(AccountsTableDropTargetListener.class);
    private JTable table;
    private ArrowPainter arrowPainter = new ArrowPainter();

    public AccountsTableDropTargetListener(JTable theTable) {
        this.table = theTable;
        this.table.getRootPane().getLayeredPane().add((Component)this.arrowPainter, new Integer(JLayeredPane.DRAG_LAYER + 10));
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.getDropAction() != 2 || dtde.getCurrentDataFlavors()[0] != GWFlavors.intFlavor) {
            dtde.rejectDrag();
            return;
        }
        logger.debug((Object)"drag enter");
        this.arrowPainter.setVisible(true);
        dtde.acceptDrag(2);
    }

    public void dragExit(DropTargetEvent dte) {
        this.arrowPainter.setVisible(false);
        logger.debug((Object)"drag exit");
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.getDropAction() != 2 || dtde.getCurrentDataFlavors()[0] != GWFlavors.intFlavor) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(2);
        this.updateArrowPainter(dtde);
    }

    private void updateArrowPainter(DropTargetDragEvent dtde) {
        int currentRow = this.table.rowAtPoint(dtde.getLocation());
        int selectedRow = -1;
        try {
            selectedRow = (Integer)dtde.getTransferable().getTransferData(GWFlavors.intFlavor);
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        int x = this.table.getLocation().x;
        int y = this.table.getParent().getLocationOnScreen().y - this.table.getRootPane().getLocationOnScreen().y + currentRow * this.table.getRowHeight();
        if (currentRow > selectedRow) {
            y += this.table.getRowHeight();
        }
        this.arrowPainter.updatePosition(x, y);
    }

    public void drop(DropTargetDropEvent dtde) {
        this.arrowPainter.setVisible(false);
        if (dtde.getDropAction() != 2 || dtde.getCurrentDataFlavors()[0] != GWFlavors.intFlavor) {
            dtde.rejectDrop();
            return;
        }
        logger.debug((Object)"accept drop");
        dtde.acceptDrop(2);
        Transferable transfer = dtde.getTransferable();
        int selectedRow = -1;
        try {
            selectedRow = (Integer)transfer.getTransferData(GWFlavors.intFlavor);
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        logger.debug((Object)("read trasfer data : " + selectedRow + ", move to row : " + this.table.rowAtPoint(dtde.getLocation())));
        ((AccountsDragTableModelInterface)((Object)this.table.getModel())).movRow(selectedRow, this.table.rowAtPoint(dtde.getLocation()));
        dtde.dropComplete(true);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

