/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.Account;
import com.novell.gw.account.GroupWiseAccount;
import com.novell.gw.account.ImapAccount;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.account.Pop3Account;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.folderstree.CheckFoldersTree;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePasswordField;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.newfolder.CreateFolderDialog;
import com.novell.gw.jclient.application.dialogs.passworddialog.PasswordChangeDialog;
import com.novell.gw.jclient.application.frames.options.AccountPropertiesDialogController;
import com.novell.gw.jclient.application.frames.options.AccountUtils;
import com.novell.gw.jclient.application.frames.options.compose.send.SignaturePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class AccountPropertiesDialog
extends ApplicationDialog {
    private static Logger logger = Logger.getLogger(AccountPropertiesDialog.class);
    public static final int DEFAULT_POP3_PORT = 110;
    public static final int DEFAULT_SMTP_PORT = 25;
    public static final int DEFAULT_IMAP_PORT = 143;
    public static final int DEFAULT_NNTP_PORT = 119;
    public static final int DEFAULT_POP3_PORT_SSL = 995;
    public static final int DEFAULT_SMTP_PORT_SSL = 465;
    public static final int DEFAULT_IMAP_PORT_SSL = 993;
    private Account account;
    private JTextField tfAccountName;
    private JLabel lblAccountTypeString;
    private JTextField tfFromName;
    private JTextField tfOrganization;
    private JTextField tfEmailAddress;
    private JTextField tfReplyAddress;
    private JTextField tfIPAddress;
    private JTextField tfIPPort;
    private JCheckBox ckRefreshAddressBookAndRules;
    private JSpinner spRefreshAddressBooksTime;
    private JButton btnOnlinePassword;
    private JCheckBox ckIncludeAccount;
    private JCheckBox ckUploadAccount;
    private SignaturePanel signaturePanel;
    private JTextField tfIncomingServer;
    private JTextField tfIncomingServerLogin;
    private JPasswordField tfIncomingServerPassword;
    private JTextField tfOutgoingServer;
    private JTextField tfOutgoingServerLogin;
    private JPasswordField tfOutgoingServerPassword;
    private JCheckBox ckLogOnUsingSPA;
    private JCheckBox ckOutgoingServerRequiresAuth;
    private JCheckBox ckUseSameSettings;
    private JCheckBox cbServerRequiresAuth;
    private JCheckBox cbUseIncomingSSL;
    private JCheckBox cbUseOutgoingSSL;
    private JCheckBox ckLeaveACopy;
    private JCheckBox ckRemoveFromServerAfterDays;
    private JCheckBox ckRemoveFromServerAfterTrash;
    private JSpinner spRemoveAfterDays;
    private JTextField tfIncomingPort;
    private JButton btnIncomingDefaultPort;
    private JTextField tfOutgoingPort;
    private JButton btnOutgoingDefaultPort;
    private JSpinner spServerTimeout;
    private JTextField tfRootFolderPath;
    private JCheckBox ckOnlyShowSubscribedFolders;
    private JCheckBox ckDownloadHeadersOnly;
    private JCheckBox ckDownloadNewItemsOnly;
    private JCheckBox ckSendRetrieveWhenFolderIsSelected;
    private JCheckBox ckRemoveItemsFromTrash;
    private JCheckBox ckDownloadExternalFileBodies;
    private JRadioButton rbAllMessages;
    private JRadioButton rbMaximum;
    private JSpinner spMaximum;
    private JCheckBox ckNeverDownloadOldMessages;
    private JCheckBox ckMessagesLess;
    private JSpinner spMessagesLess;
    private JCheckBox ckHeadersOnly;
    private JCheckBox ckExpandNewThreads;
    private JCheckBox ckRemoveOldMessages;
    private JSpinner spRemoveOldMessages;
    private JCheckBox ckAutomaticallyWatchThreads;
    private CheckFoldersTree checkFoldersTree;
    private JButton btnCreateFolder;
    private OrientableCheckBox cbShowDetailedError;

    public AccountPropertiesDialog(JDialog parent, Account theAccount, MVCController parentController) {
        super((Dialog)parent, parentController);
        this.account = theAccount;
        this.buildUI();
        this.initControls();
        this.setTitle(theAccount.getName() + ' ' + StringResources.PROPERTIES_C);
        this.setDefaultCloseOperation(2);
        this.enableControls();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initControls() {
        this.tfAccountName.setText(this.account.getName());
        this.lblAccountTypeString.setText(AccountUtils.getAccountTypeString(this.account));
        this.tfFromName.setText(this.account.getFromText());
        this.tfOrganization.setText(this.account.getOrganization());
        this.tfEmailAddress.setText(this.account.getEmailAddress());
        if (this.account instanceof GroupWiseAccount) {
            this.initGWAccountControls();
            return;
        }
        this.tfReplyAddress.setText(this.account.getReplyAddress());
        if (this.account instanceof Pop3Account) {
            this.initPop3AccountControls();
        } else if (this.account instanceof ImapAccount) {
            this.initImapAccountControls();
        } else if (this.account instanceof NntpAccount) {
            this.initNntpAccountControls();
        }
        this.initListeners();
    }

    private void initNntpAccountControls() {
        NntpAccount nntpAccount = (NntpAccount)this.account;
        this.tfIncomingServer.setText(nntpAccount.getIncomingServer());
        this.tfIncomingServerLogin.setText(nntpAccount.getIncomingServerLoginName());
        this.tfIncomingServerPassword.setText(nntpAccount.getIncomingServerPassword());
        boolean isRequiresAuthenticate = nntpAccount.isRequiresAuthenticate();
        this.cbServerRequiresAuth.setSelected(nntpAccount.isRequiresAuthenticate());
        this.tfIncomingServerLogin.setEnabled(isRequiresAuthenticate);
        this.tfIncomingServerPassword.setEnabled(isRequiresAuthenticate);
        this.tfIncomingPort.setText(String.valueOf(nntpAccount.getIncomingServerPort()));
        this.btnIncomingDefaultPort.setEnabled(Integer.parseInt(this.tfIncomingPort.getText()) != 119);
        this.cbUseIncomingSSL.setSelected(nntpAccount.getIncomingServerUseSSL());
        this.spServerTimeout.setValue(nntpAccount.getServerTimeout());
        this.ckNeverDownloadOldMessages.setSelected(nntpAccount.isDontGetOldMessages());
        int maxDaysOldMessages = nntpAccount.getMaxDaysOldMessages();
        if (maxDaysOldMessages == -1) {
            this.ckMessagesLess.setSelected(false);
            this.spMessagesLess.setValue(0);
            this.spMessagesLess.setEnabled(false);
        } else {
            this.ckMessagesLess.setSelected(true);
            this.spMessagesLess.setValue(maxDaysOldMessages);
        }
        this.ckHeadersOnly.setSelected(nntpAccount.getHeadersOnly());
        this.ckSendRetrieveWhenFolderIsSelected.setSelected(nntpAccount.getSyncWhenFolderSelected());
        this.ckExpandNewThreads.setSelected(nntpAccount.getExpandThreads());
        boolean bRemoveOldMessages = nntpAccount.getRemoveAfterNumDaysState();
        this.ckRemoveOldMessages.setSelected(bRemoveOldMessages);
        this.spRemoveOldMessages.setValue(nntpAccount.getRemoveAfterNumDays());
        this.spRemoveOldMessages.setEnabled(bRemoveOldMessages);
        this.ckAutomaticallyWatchThreads.setSelected(nntpAccount.getAutoWatchMyPostings());
        this.cbShowDetailedError.setSelected(nntpAccount.getShowDetailedErrorMessages());
        int numMessagesPerDL = nntpAccount.getNumMessagesPerDownload();
        if (numMessagesPerDL == -1) {
            this.rbAllMessages.setSelected(true);
            this.spMaximum.setValue(0);
            this.spMaximum.setEnabled(false);
            this.ckNeverDownloadOldMessages.setEnabled(false);
        } else {
            this.spMaximum.setValue(numMessagesPerDL);
            this.rbMaximum.setSelected(true);
        }
    }

    private void initImapAccountControls() {
        ImapAccount imapAccount = (ImapAccount)this.account;
        this.tfIncomingServer.setText(imapAccount.getIncomingServer());
        this.tfIncomingServerLogin.setText(imapAccount.getIncomingServerLoginName());
        this.tfIncomingServerPassword.setText(imapAccount.getIncomingServerPassword());
        this.cbUseIncomingSSL.setSelected(imapAccount.getIncomingServerUseSSL());
        this.tfOutgoingServer.setText(imapAccount.getOutgoingServer());
        this.cbUseOutgoingSSL.setSelected(imapAccount.getOutgoingServerUseSSL());
        this.ckLogOnUsingSPA.setSelected(imapAccount.getUseSecurePasswordAuth());
        this.ckOutgoingServerRequiresAuth.setSelected(imapAccount.getOutgoingServerRequiresAuth());
        this.ckUseSameSettings.setSelected(imapAccount.getUseIncomingAuthForOutgoing());
        this.cbShowDetailedError.setSelected(imapAccount.getShowDetailedErrorMessages());
        if (!this.ckOutgoingServerRequiresAuth.isSelected()) {
            this.ckUseSameSettings.setEnabled(false);
        } else if (this.ckUseSameSettings.isSelected()) {
            this.tfOutgoingServerLogin.setEnabled(false);
            this.tfOutgoingServerPassword.setEnabled(false);
        } else {
            this.tfOutgoingServerLogin.setText(imapAccount.getOutgoingServerLoginName());
            this.tfOutgoingServerPassword.setText(imapAccount.getOutgoingServerPassword());
        }
        this.tfIncomingPort.setText(String.valueOf(imapAccount.getIncomingServerPort()));
        this.btnIncomingDefaultPort.setEnabled(Integer.parseInt(this.tfIncomingPort.getText()) != 143);
        this.cbUseIncomingSSL.setSelected(imapAccount.getIncomingServerUseSSL());
        this.tfOutgoingPort.setText(String.valueOf(imapAccount.getOutgoingServerPort()));
        this.btnOutgoingDefaultPort.setEnabled(Integer.parseInt(this.tfOutgoingPort.getText()) != 25);
        this.cbUseOutgoingSSL.setSelected(imapAccount.getOutgoingServerUseSSL());
        this.spServerTimeout.setValue(imapAccount.getServerTimeout());
        this.tfRootFolderPath.setText(imapAccount.getRootPath());
        this.ckOnlyShowSubscribedFolders.setSelected(imapAccount.getShowSubscribedOnly());
        this.ckDownloadHeadersOnly.setSelected(imapAccount.getHeadersOnly());
        this.ckDownloadNewItemsOnly.setSelected(imapAccount.getDownloadNewOnly());
        this.ckSendRetrieveWhenFolderIsSelected.setSelected(imapAccount.getSyncWhenFolderSelected());
        this.ckRemoveItemsFromTrash.setSelected(imapAccount.getExpungeWhenDeleted());
        this.ckDownloadExternalFileBodies.setSelected(imapAccount.getDownloadExternalBodies());
    }

    private void initPop3AccountControls() {
        Pop3Account pop3Account = (Pop3Account)this.account;
        this.tfIncomingServer.setText(pop3Account.getIncomingServer());
        this.tfIncomingServerLogin.setText(pop3Account.getIncomingServerLoginName());
        this.tfIncomingServerPassword.setText(pop3Account.getIncomingServerPassword());
        this.tfOutgoingServer.setText(pop3Account.getOutgoingServer());
        this.ckLogOnUsingSPA.setSelected(pop3Account.getUseSecurePasswordAuth());
        this.ckOutgoingServerRequiresAuth.setSelected(pop3Account.getOutgoingServerRequiresAuth());
        this.ckUseSameSettings.setSelected(pop3Account.getUseIncomingAuthForOutgoing());
        this.cbShowDetailedError.setSelected(pop3Account.getShowDetailedErrorMessages());
        if (!this.ckOutgoingServerRequiresAuth.isSelected()) {
            this.ckUseSameSettings.setEnabled(false);
        } else if (this.ckUseSameSettings.isSelected()) {
            this.tfOutgoingServerLogin.setEnabled(false);
            this.tfOutgoingServerPassword.setEnabled(false);
        } else {
            this.tfOutgoingServerLogin.setText(pop3Account.getOutgoingServerLoginName());
            this.tfOutgoingServerPassword.setText(pop3Account.getOutgoingServerPassword());
        }
        this.ckLeaveACopy.setSelected(pop3Account.getLeaveCopyOnServer());
        this.ckRemoveFromServerAfterDays.setSelected(pop3Account.getRemoveAfterNumDaysState());
        this.spRemoveAfterDays.setValue(pop3Account.getRemoveAfterNumDays());
        this.ckRemoveFromServerAfterTrash.setSelected(pop3Account.getRemoveMessagesAfterPurge());
        if (this.ckLeaveACopy.isSelected()) {
            this.ckRemoveFromServerAfterDays.setEnabled(true);
            this.ckRemoveFromServerAfterTrash.setEnabled(true);
        } else {
            this.ckRemoveFromServerAfterDays.setEnabled(false);
            this.ckRemoveFromServerAfterTrash.setEnabled(false);
        }
        this.tfIncomingPort.setText(String.valueOf(pop3Account.getIncomingServerPort()));
        this.btnIncomingDefaultPort.setEnabled(Integer.parseInt(this.tfIncomingPort.getText()) != 110);
        this.cbUseIncomingSSL.setSelected(pop3Account.getIncomingServerUseSSL());
        this.tfOutgoingPort.setText(String.valueOf(pop3Account.getOutgoingServerPort()));
        this.btnOutgoingDefaultPort.setEnabled(Integer.parseInt(this.tfOutgoingPort.getText()) != 25);
        this.cbUseOutgoingSSL.setSelected(pop3Account.getOutgoingServerUseSSL());
        this.spServerTimeout.setValue(pop3Account.getServerTimeout());
        IFolder accountFolder = APIFolderWrapperManager.getFolder(pop3Account.getFolder());
        GWCommandManager manager = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid());
        if (accountFolder == null) {
            try {
                this.checkFoldersTree.selectFolder(manager.getMailboxFolder());
            }
            catch (GWCommandException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        } else {
            this.checkFoldersTree.selectFolder(manager.getGWFolder(accountFolder));
        }
    }

    private void initGWAccountControls() {
        if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            GroupWiseAccount gwAccount = (GroupWiseAccount)this.account;
            this.tfIPAddress.setText(gwAccount.getIpAddress());
            this.tfIPPort.setText(String.valueOf(gwAccount.getIpPort()));
            int systemSyncInterval = gwAccount.getSystemSyncInterval();
            this.ckRefreshAddressBookAndRules.setSelected(systemSyncInterval != 0);
            if (systemSyncInterval == 0) {
                systemSyncInterval = 7;
            }
            this.spRefreshAddressBooksTime.setValue(new Integer(systemSyncInterval));
        }
    }

    private void initListeners() {
        if (!(this.account instanceof NntpAccount)) {
            this.initMailListeners();
            if (this.account instanceof Pop3Account) {
                this.initMailPop3Listeners();
            } else if (this.account instanceof ImapAccount) {
                this.initMailImapListeners();
            }
        } else {
            this.initNntpListeners();
        }
    }

    private void initMailListeners() {
        this.ckOutgoingServerRequiresAuth.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountPropertiesDialog.this.ckOutgoingServerRequiresAuth.isSelected()) {
                    AccountPropertiesDialog.this.ckUseSameSettings.setEnabled(true);
                } else {
                    AccountPropertiesDialog.this.ckUseSameSettings.setEnabled(false);
                }
            }
        });
        this.ckUseSameSettings.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountPropertiesDialog.this.ckUseSameSettings.isEnabled() && AccountPropertiesDialog.this.ckUseSameSettings.isSelected() || !AccountPropertiesDialog.this.ckUseSameSettings.isEnabled()) {
                    AccountPropertiesDialog.this.tfOutgoingServerLogin.setEnabled(false);
                    AccountPropertiesDialog.this.tfOutgoingServerPassword.setEnabled(false);
                } else {
                    AccountPropertiesDialog.this.tfOutgoingServerLogin.setEnabled(true);
                    AccountPropertiesDialog.this.tfOutgoingServerPassword.setEnabled(true);
                }
            }
        });
        this.tfOutgoingPort.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    if (AccountPropertiesDialog.this.cbUseOutgoingSSL.isSelected()) {
                        AccountPropertiesDialog.this.btnOutgoingDefaultPort.setEnabled(Integer.parseInt(AccountPropertiesDialog.this.tfOutgoingPort.getText()) != 465);
                    } else {
                        AccountPropertiesDialog.this.btnOutgoingDefaultPort.setEnabled(Integer.parseInt(AccountPropertiesDialog.this.tfOutgoingPort.getText()) != 25);
                    }
                }
                catch (NumberFormatException ex) {
                    AccountPropertiesDialog.this.btnOutgoingDefaultPort.setEnabled(true);
                }
            }
        });
        this.btnOutgoingDefaultPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AccountPropertiesDialog.this.cbUseOutgoingSSL.isSelected()) {
                    AccountPropertiesDialog.this.tfOutgoingPort.setText(String.valueOf(465));
                } else {
                    AccountPropertiesDialog.this.tfOutgoingPort.setText(String.valueOf(25));
                }
                AccountPropertiesDialog.this.btnOutgoingDefaultPort.setEnabled(false);
            }
        });
    }

    private void initNntpListeners() {
        this.cbServerRequiresAuth.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!AccountPropertiesDialog.this.cbServerRequiresAuth.isSelected()) {
                    AccountPropertiesDialog.this.tfIncomingServerLogin.setEnabled(false);
                    AccountPropertiesDialog.this.tfIncomingServerPassword.setEnabled(false);
                } else {
                    AccountPropertiesDialog.this.tfIncomingServerLogin.setEnabled(true);
                    AccountPropertiesDialog.this.tfIncomingServerPassword.setEnabled(true);
                }
            }
        });
        this.tfIncomingPort.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(Integer.parseInt(AccountPropertiesDialog.this.tfIncomingPort.getText()) != 119);
                }
                catch (NumberFormatException ex) {
                    AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(true);
                }
            }
        });
        this.btnIncomingDefaultPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(119));
                AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(false);
            }
        });
        this.rbAllMessages.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountPropertiesDialog.this.rbAllMessages.isSelected()) {
                    AccountPropertiesDialog.this.spMaximum.setEnabled(false);
                    AccountPropertiesDialog.this.ckNeverDownloadOldMessages.setEnabled(false);
                }
            }
        });
        this.rbMaximum.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountPropertiesDialog.this.rbMaximum.isSelected()) {
                    AccountPropertiesDialog.this.spMaximum.setEnabled(true);
                    AccountPropertiesDialog.this.spMaximum.setValue(100);
                    AccountPropertiesDialog.this.ckNeverDownloadOldMessages.setEnabled(true);
                }
            }
        });
        this.ckMessagesLess.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountPropertiesDialog.this.ckMessagesLess.isSelected()) {
                    AccountPropertiesDialog.this.spMessagesLess.setEnabled(true);
                } else {
                    AccountPropertiesDialog.this.spMessagesLess.setEnabled(false);
                }
            }
        });
        this.ckRemoveOldMessages.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountPropertiesDialog.this.ckRemoveOldMessages.isSelected()) {
                    AccountPropertiesDialog.this.spRemoveOldMessages.setEnabled(true);
                } else {
                    AccountPropertiesDialog.this.spRemoveOldMessages.setEnabled(false);
                }
            }
        });
    }

    private void initMailImapListeners() {
        this.tfIncomingPort.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    if (AccountPropertiesDialog.this.cbUseIncomingSSL.isSelected()) {
                        AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(Integer.parseInt(AccountPropertiesDialog.this.tfIncomingPort.getText()) != 993);
                    } else {
                        AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(Integer.parseInt(AccountPropertiesDialog.this.tfIncomingPort.getText()) != 143);
                    }
                }
                catch (NumberFormatException ex) {
                    AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(true);
                }
            }
        });
        this.btnIncomingDefaultPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AccountPropertiesDialog.this.cbUseIncomingSSL.isSelected()) {
                    AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(993));
                } else {
                    AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(143));
                }
                AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(false);
            }
        });
    }

    private void initMailPop3Listeners() {
        this.ckLeaveACopy.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountPropertiesDialog.this.ckLeaveACopy.isSelected()) {
                    AccountPropertiesDialog.this.ckRemoveFromServerAfterDays.setEnabled(true);
                    AccountPropertiesDialog.this.ckRemoveFromServerAfterTrash.setEnabled(true);
                } else {
                    AccountPropertiesDialog.this.ckRemoveFromServerAfterDays.setEnabled(false);
                    AccountPropertiesDialog.this.ckRemoveFromServerAfterTrash.setEnabled(false);
                }
            }
        });
        this.ckRemoveFromServerAfterDays.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (AccountPropertiesDialog.this.ckRemoveFromServerAfterDays.isEnabled() && AccountPropertiesDialog.this.ckRemoveFromServerAfterDays.isSelected()) {
                    AccountPropertiesDialog.this.spRemoveAfterDays.setEnabled(true);
                } else {
                    AccountPropertiesDialog.this.spRemoveAfterDays.setEnabled(false);
                }
            }
        });
        this.tfIncomingPort.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    if (AccountPropertiesDialog.this.cbUseIncomingSSL.isSelected()) {
                        AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(Integer.parseInt(AccountPropertiesDialog.this.tfIncomingPort.getText()) != 995);
                    } else {
                        AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(Integer.parseInt(AccountPropertiesDialog.this.tfIncomingPort.getText()) != 110);
                    }
                }
                catch (NumberFormatException ex) {
                    AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(true);
                }
            }
        });
        this.btnIncomingDefaultPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AccountPropertiesDialog.this.cbUseIncomingSSL.isSelected()) {
                    AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(995));
                } else {
                    AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(110));
                }
                AccountPropertiesDialog.this.btnIncomingDefaultPort.setEnabled(false);
            }
        });
    }

    private void buildUI() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel general = this.buildGeneralPanel();
        OrientablePanel buttonPanel = new OrientablePanel();
        buttonPanel.setLayout(new FlowLayout(4));
        OS.addButtons(buttonPanel, this.getBtnOk(), this.getBtnCancel());
        this.signaturePanel = new SignaturePanel(new OptionChangesListener(), (MVCController)this.getController(), ControlsUtils.getUserGuid(this.getController()), this.account);
        this.signaturePanel.build();
        this.signaturePanel.fireOptionsChanged();
        OrientableTabbedPane tabPane = new OrientableTabbedPane();
        ((JTabbedPane)tabPane).addTab(StringResources.GENERAL, general);
        if (this.account.getType() != 3) {
            ((JTabbedPane)tabPane).addTab(StringResources.SERVER, this.buildServerPanel());
        }
        if (this.account.getType() == 1) {
            ((JTabbedPane)tabPane).addTab(StringResources.FOLDER, this.buildFolderPanel());
        }
        if (this.account instanceof Pop3Account) {
            ((JTabbedPane)tabPane).addTab(StringResources.ADVANCED, this.buildAdvancedPop3Panel());
        } else if (this.account instanceof ImapAccount) {
            ((JTabbedPane)tabPane).addTab(StringResources.ADVANCED, this.buildAdvancedImapPanel());
        } else if (this.account instanceof NntpAccount) {
            ((JTabbedPane)tabPane).addTab(StringResources.ADVANCED, this.buildAdvancedNntpPanel());
        } else if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            ((JTabbedPane)tabPane).addTab(StringResources.ADVANCED, this.buildAdvancedGWPanel());
        }
        ((JTabbedPane)tabPane).addTab(StringResources.SIGNATURE, this.signaturePanel);
        tabPane.setSelectedIndex(0);
        contentPane.add((Component)tabPane, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    private JPanel buildGeneralPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        OrientableLabel lblAccountName = new OrientableLabel(StringResources.ACCOUNT_NAME_DESCRIPTION + '.');
        lblAccountName.setHorizontalTextPosition(2);
        this.tfAccountName = new GWTextField("");
        c.anchor = 21;
        c.fill = 2;
        c.insets = new Insets(10, 10, 0, 10);
        c.gridwidth = 2;
        panel.add((Component)lblAccountName, c);
        c.gridy = 1;
        c.insets = new Insets(5, 10, 10, 10);
        panel.add((Component)this.tfAccountName, c);
        OrientableLabel lblAccountType = new OrientableLabel(StringResources.ACCOUNT_TYPE_C);
        lblAccountType.setHorizontalTextPosition(2);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridy = 2;
        c.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)lblAccountType, c);
        this.lblAccountTypeString = new OrientableLabel("");
        c.gridx = 1;
        c.insets = new Insets(10, 26, 10, 10);
        panel.add((Component)this.lblAccountTypeString, c);
        OrientableLabel lblFromName = new OrientableLabel(StringResources.FROM_NAME_C);
        lblFromName.setHorizontalTextPosition(10);
        c.insets = new Insets(10, 10, 5, 10);
        c.gridy = 3;
        c.gridx = 0;
        panel.add((Component)lblFromName, c);
        this.tfFromName = new GWTextField("");
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(10, 26, 5, 10);
        panel.add((Component)this.tfFromName, c);
        OrientableLabel lblOrganization = new OrientableLabel(StringResources.ORGANIZATION_C);
        lblOrganization.setHorizontalTextPosition(2);
        c.insets = new Insets(0, 10, 5, 10);
        c.fill = 0;
        c.gridy = 4;
        c.gridx = 0;
        panel.add((Component)lblOrganization, c);
        this.tfOrganization = new GWTextField("");
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 26, 5, 10);
        panel.add((Component)this.tfOrganization, c);
        OrientableLabel lblEmailAddress = new OrientableLabel(StringResources.EMAIL_ADDRESS_C);
        lblEmailAddress.setHorizontalTextPosition(2);
        c.insets = new Insets(0, 10, 5, 10);
        c.fill = 0;
        c.gridy = 5;
        c.gridx = 0;
        panel.add((Component)lblEmailAddress, c);
        this.tfEmailAddress = new GWTextField("");
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 26, 5, 10);
        panel.add((Component)this.tfEmailAddress, c);
        if (this.account.getType() != 3) {
            this.tfEmailAddress.setEditable(true);
            this.tfEmailAddress.setEnabled(true);
            OrientableLabel lblReplyAddress = new OrientableLabel(StringResources.REPLY_ADDRESS_C);
            lblEmailAddress.setHorizontalTextPosition(2);
            c.insets = new Insets(0, 10, 5, 10);
            c.fill = 0;
            c.gridy = 6;
            c.gridx = 0;
            panel.add((Component)lblReplyAddress, c);
            this.tfReplyAddress = new GWTextField("");
            this.tfReplyAddress.setEditable(true);
            this.tfReplyAddress.setEnabled(true);
            c.fill = 2;
            c.gridx = 1;
            c.insets = new Insets(0, 26, 5, 10);
            panel.add((Component)this.tfReplyAddress, c);
        } else {
            this.tfEmailAddress.setEditable(false);
            this.tfEmailAddress.setEnabled(false);
        }
        this.ckIncludeAccount = new OrientableCheckBox(StringResources.INCLUDE_ACCOUNT_DESCRIPTION);
        this.ckIncludeAccount.setSelected(this.account.getIncludeInFullRetrieve());
        this.ckIncludeAccount.setEnabled(true);
        c.insets = new Insets(20, 10, 10, 10);
        c.fill = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.gridx = 0;
        panel.add((Component)this.ckIncludeAccount, c);
        if (this.account.getType() != 3) {
            this.ckUploadAccount = new OrientableCheckBox(StringResources.CREATE_ACCOUNT_D1_UPLOAD_THIS_ACCOUNT);
            this.ckUploadAccount.setSelected(this.account.getUploadToMaster());
            this.ckUploadAccount.setEnabled(this.account.canUploadToMaster());
            c.insets = new Insets(0, 10, 10, 10);
            c.fill = 0;
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            panel.add((Component)this.ckUploadAccount, c);
        }
        OrientablePanel placePanel = new OrientablePanel();
        c.fill = 1;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)placePanel, c);
        return panel;
    }

    private JPanel buildServerPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        OrientableLabel lblIncomingServer = this.account.getType() != 4 ? new OrientableLabel(StringResources.formatString(StringResources.INCOMING_MAIL_SERVER, AccountUtils.getAccountTypeString(this.account))) : new OrientableLabel(StringResources.NEWS_SERVER_C);
        lblIncomingServer.setHorizontalTextPosition(10);
        gbc.anchor = 21;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 0, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)lblIncomingServer, gbc);
        gbc.insets = new Insets(5, 10, 10, 10);
        ++gbc.gridy;
        this.tfIncomingServer = new GWTextField("");
        panel.add((Component)this.tfIncomingServer, gbc);
        if (this.account.getType() == 4) {
            this.cbServerRequiresAuth = new OrientableCheckBox(StringResources.CREATE_NEWS_ACCOUNT_D2_MY_SERVER_REQUIRES_AUTHENTICATION);
            gbc.insets = new Insets(0, 10, 10, 10);
            ++gbc.gridy;
            gbc.fill = 2;
            panel.add((Component)this.cbServerRequiresAuth, gbc);
        }
        this.tfIncomingServerLogin = new GWTextField("");
        this.tfIncomingServerPassword = new OrientablePasswordField("");
        ++gbc.gridy;
        gbc.fill = 1;
        panel.add((Component)this.buildLoginPasswordPanel(this.tfIncomingServerLogin, this.tfIncomingServerPassword), gbc);
        if (this.account.getType() != 4) {
            this.ckLogOnUsingSPA = new OrientableCheckBox(StringResources.LOG_ON_USING_SECURE_PASSWORD_AUTHENTICATION);
            gbc.insets = new Insets(0, 10, 10, 10);
            ++gbc.gridy;
            gbc.fill = 2;
            this.addSideBorderToComponent(this.ckLogOnUsingSPA);
            panel.add((Component)this.ckLogOnUsingSPA, gbc);
            OrientableLabel lblOutgoingServer = new OrientableLabel(StringResources.OUTGOING_MAIL_SERVER);
            lblOutgoingServer.setHorizontalTextPosition(10);
            gbc.fill = 2;
            ++gbc.gridy;
            gbc.insets = new Insets(20, 10, 0, 10);
            panel.add((Component)lblOutgoingServer, gbc);
            gbc.insets = new Insets(5, 10, 5, 10);
            ++gbc.gridy;
            this.tfOutgoingServer = new GWTextField("");
            panel.add((Component)this.tfOutgoingServer, gbc);
            this.ckOutgoingServerRequiresAuth = new OrientableCheckBox(StringResources.MY_OUTGOING_SERVER_REQUIRES_AUTHENTICATION);
            ++gbc.gridy;
            gbc.fill = 2;
            panel.add((Component)this.ckOutgoingServerRequiresAuth, gbc);
            this.addSideBorderToComponent(this.ckOutgoingServerRequiresAuth);
            this.ckUseSameSettings = new OrientableCheckBox(StringResources.USE_SAME_SETTINGS_AS_MY_INCOMING_MAIL_SERVER);
            gbc.insets = new Insets(0, 10, 5, 10);
            ++gbc.gridy;
            this.addSideBorderToComponent(this.ckUseSameSettings);
            panel.add((Component)this.ckUseSameSettings, gbc);
            gbc.insets = new Insets(5, 10, 10, 10);
            this.tfOutgoingServerLogin = new GWTextField("");
            this.tfOutgoingServerPassword = new OrientablePasswordField("");
            ++gbc.gridy;
            gbc.fill = 1;
            panel.add((Component)this.buildLoginPasswordPanel(this.tfOutgoingServerLogin, this.tfOutgoingServerPassword), gbc);
        }
        OrientablePanel placePanel = new OrientablePanel();
        gbc.fill = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        panel.add((Component)placePanel, gbc);
        return panel;
    }

    private JPanel buildFolderPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 0, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.btnCreateFolder = new OrientableButton(new CreateFolderAction());
        panel.add((Component)this.btnCreateFolder, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        this.checkFoldersTree = new CheckFoldersTree((MVCController)this.getController(), ControlsUtils.getUserGuid(this.getController()));
        this.checkFoldersTree.setComponentOrientation(UIUtils.getComponentOrientation());
        OrientableScrollPane treeScrollPane = new OrientableScrollPane(this.checkFoldersTree);
        panel.add((Component)treeScrollPane, gbc);
        OrientablePanel placePanel = new OrientablePanel();
        gbc.fill = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        panel.add((Component)placePanel, gbc);
        return panel;
    }

    private JPanel buildLoginPasswordPanel(JTextField tfLoginName, JTextField tfPassword) {
        OrientableLabel lblLoginName = new OrientableLabel(StringResources.LOGIN_NAME_C);
        OrientableLabel lblPassword = new OrientableLabel(StringResources.CREATE_NEWS_ACCOUNT_D2_PASSWORD);
        GridBagConstraints gbc = new GridBagConstraints();
        OrientablePanel loginPasswordPanel = new OrientablePanel(new GridBagLayout());
        loginPasswordPanel.setBorder(BorderFactory.createEmptyBorder());
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 10, 10, 0);
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        loginPasswordPanel.add((Component)lblLoginName, gbc);
        gbc.gridy = 1;
        loginPasswordPanel.add((Component)lblPassword, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        loginPasswordPanel.add((Component)tfLoginName, gbc);
        gbc.gridy = 1;
        loginPasswordPanel.add((Component)tfPassword, gbc);
        this.addSideBorderToComponent(loginPasswordPanel);
        return loginPasswordPanel;
    }

    private void addSideBorderToComponent(JComponent component) {
        if (UIUtils.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            component.setBorder(new EmptyBorder(0, 60, 0, 0));
        } else {
            component.setBorder(new EmptyBorder(0, 0, 0, 60));
        }
    }

    private JPanel buildAdvancedGWPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        OrientableLabel lblIPAddress = new OrientableLabel(StringResources.IP_ADDRESS_C);
        lblIPAddress.setHorizontalTextPosition(10);
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)lblIPAddress, c);
        this.tfIPAddress = new GWTextField("");
        c.gridx = 1;
        c.fill = 2;
        c.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)this.tfIPAddress, c);
        OrientableLabel lblIPPort = new OrientableLabel(StringResources.IP_PORT_C);
        lblIPPort.setHorizontalTextPosition(10);
        c.fill = 0;
        c.gridy = 1;
        c.gridx = 0;
        c.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)lblIPPort, c);
        this.tfIPPort = new GWTextField("");
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)this.tfIPPort, c);
        OrientablePanel buttonPanel = new OrientablePanel(new BorderLayout());
        this.btnOnlinePassword = new JButton(new OnlinePasswordAction());
        buttonPanel.add((Component)this.btnOnlinePassword, "Before");
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = 2;
        c.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)buttonPanel, c);
        this.ckRefreshAddressBookAndRules = new OrientableCheckBox(StringResources.REFRESH_ADDRESS_BOOKS_AND_RULES_EVERY);
        this.ckRefreshAddressBookAndRules.addActionListener(new RefreshAddressBooksUpdateListener());
        this.spRefreshAddressBooksTime = new OrientableSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        this.spRefreshAddressBooksTime.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        OrientableLabel lblRefreshAddressBooksTime = new OrientableLabel(' ' + StringResources.DAYS);
        OrientablePanel pnlRefreshAddressBooks = new OrientablePanel(new BorderLayout());
        pnlRefreshAddressBooks.add((Component)this.ckRefreshAddressBookAndRules, "West");
        pnlRefreshAddressBooks.add((Component)this.spRefreshAddressBooksTime, "Center");
        pnlRefreshAddressBooks.add((Component)lblRefreshAddressBooksTime, "East");
        c.insets = new Insets(10, 10, 10, 10);
        c.fill = 0;
        c.gridy = 3;
        c.gridx = 0;
        panel.add((Component)pnlRefreshAddressBooks, c);
        OrientablePanel placePanel = new OrientablePanel();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 4;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)placePanel, c);
        return panel;
    }

    private JPanel buildAdvancedPop3Panel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridy = 0;
        c.gridx = 0;
        this.ckLeaveACopy = new OrientableCheckBox(StringResources.LEAVE_A_COPY_OF_MESSAGES_ON_THE_SERVER);
        panel.add((Component)this.ckLeaveACopy, c);
        OrientablePanel removeAfterDaysPanel = new OrientablePanel(new GridBagLayout());
        removeAfterDaysPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.ckRemoveFromServerAfterDays = new OrientableCheckBox(StringResources.REMOVE_FROM_SERVER_AFTER);
        removeAfterDaysPanel.add((Component)this.ckRemoveFromServerAfterDays, gbc);
        ++gbc.gridx;
        this.spRemoveAfterDays = new OrientableSpinner(new SpinnerNumberModel(5, 1, 365, 1));
        removeAfterDaysPanel.add((Component)this.spRemoveAfterDays, gbc);
        ++gbc.gridx;
        removeAfterDaysPanel.add((Component)new OrientableLabel(StringResources.L_DAY_S), gbc);
        c.insets = new Insets(5, 10, 5, 10);
        c.fill = 0;
        ++c.gridy;
        this.addSideBorderToComponent(this.ckRemoveFromServerAfterDays);
        panel.add((Component)removeAfterDaysPanel, c);
        ++c.gridy;
        this.ckRemoveFromServerAfterTrash = new OrientableCheckBox(StringResources.REMOVE_FROM_SERVER_AFTER_DELETING_FROM_TRASH);
        this.addSideBorderToComponent(this.ckRemoveFromServerAfterTrash);
        panel.add((Component)this.ckRemoveFromServerAfterTrash, c);
        ++c.gridy;
        c.insets = new Insets(20, 10, 5, 10);
        OrientableLabel lblIncomingServer = new OrientableLabel(StringResources.formatString(StringResources.INCOMING_MAIL_SERVER, StringResources.POP3));
        this.tfIncomingPort = new GWTextField(5);
        this.btnIncomingDefaultPort = new OrientableButton(StringResources.USE_DEFAULT);
        this.cbUseIncomingSSL = new OrientableCheckBox(new UseIncomingSSLAction());
        panel.add((Component)this.buildAdvancedServerPanel(lblIncomingServer, this.tfIncomingPort, this.btnIncomingDefaultPort), c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 5, 10);
        OrientablePanel sslPanel = new OrientablePanel(new BorderLayout());
        sslPanel.setBorder(BorderFactory.createEmptyBorder());
        sslPanel.add((Component)this.cbUseIncomingSSL, "Center");
        panel.add((Component)sslPanel, c);
        ++c.gridy;
        OrientableLabel lblOutgoingServer = new OrientableLabel(StringResources.OUTGOING_MAIL_SERVER);
        this.tfOutgoingPort = new GWTextField(5);
        this.btnOutgoingDefaultPort = new OrientableButton(StringResources.USE_DEFAULT);
        this.cbUseOutgoingSSL = new OrientableCheckBox(new UseOutgoingSSLAction());
        panel.add((Component)this.buildAdvancedServerPanel(lblOutgoingServer, this.tfOutgoingPort, this.btnOutgoingDefaultPort), c);
        ++c.gridy;
        sslPanel = new OrientablePanel(new BorderLayout());
        sslPanel.setBorder(BorderFactory.createEmptyBorder());
        sslPanel.add((Component)this.cbUseOutgoingSSL, "Center");
        panel.add((Component)sslPanel, c);
        ++c.gridy;
        c.insets = new Insets(10, 10, 5, 10);
        panel.add((Component)this.buildServerTimeoutPanel(), c);
        ++c.gridy;
        this.cbShowDetailedError = new OrientableCheckBox(StringResources.SHOW_DETAILED_ERROR_MESSAGES);
        panel.add((Component)this.cbShowDetailedError, c);
        OrientablePanel placePanel = new OrientablePanel();
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)placePanel, c);
        return panel;
    }

    private JPanel buildAdvancedImapPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 5, 10);
        c.gridy = 0;
        c.gridx = 0;
        OrientablePanel rootPanel = new OrientablePanel(new GridBagLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        rootPanel.add((Component)new OrientableLabel(StringResources.ROOT_FOLDER_PATH_C), gbc);
        ++gbc.gridx;
        this.tfRootFolderPath = new GWTextField(20);
        rootPanel.add((Component)this.tfRootFolderPath, gbc);
        ++gbc.gridx;
        panel.add((Component)rootPanel, c);
        c.insets = new Insets(0, 10, 5, 10);
        ++c.gridy;
        this.ckOnlyShowSubscribedFolders = new OrientableCheckBox(StringResources.ONLY_SHOW_SUBSCRIBED_FOLDERS);
        panel.add((Component)this.ckOnlyShowSubscribedFolders, c);
        ++c.gridy;
        this.ckDownloadHeadersOnly = new OrientableCheckBox(StringResources.DOWNLOAD_HEADERS_ONLY);
        panel.add((Component)this.ckDownloadHeadersOnly, c);
        ++c.gridy;
        this.ckDownloadNewItemsOnly = new OrientableCheckBox(StringResources.DOWNLOAD_NEW_ITEMS_ONLY);
        panel.add((Component)this.ckDownloadNewItemsOnly, c);
        ++c.gridy;
        this.ckSendRetrieveWhenFolderIsSelected = new OrientableCheckBox(StringResources.SEND_RETRIEVE_WHEN_FOLDER_IS_SELECTED);
        panel.add((Component)this.ckSendRetrieveWhenFolderIsSelected, c);
        ++c.gridy;
        this.ckRemoveItemsFromTrash = new OrientableCheckBox(StringResources.REMOVE_ITEMS_FROM_TRASH_AS_THEY_ARE_DELETED);
        panel.add((Component)this.ckRemoveItemsFromTrash, c);
        ++c.gridy;
        c.insets = new Insets(20, 10, 5, 10);
        OrientableLabel lblIncomingServer = new OrientableLabel(StringResources.formatString(StringResources.INCOMING_MAIL_SERVER, StringResources.IMAP4));
        this.tfIncomingPort = new GWTextField(5);
        this.btnIncomingDefaultPort = new OrientableButton(StringResources.USE_DEFAULT);
        this.cbUseIncomingSSL = new OrientableCheckBox(new UseIncomingSSLAction());
        panel.add((Component)this.buildAdvancedServerPanel(lblIncomingServer, this.tfIncomingPort, this.btnIncomingDefaultPort), c);
        ++c.gridy;
        c.insets = new Insets(0, 30, 0, 10);
        panel.add((Component)this.cbUseIncomingSSL, c);
        ++c.gridy;
        c.insets = new Insets(5, 10, 5, 10);
        OrientableLabel lblOutgoingServer = new OrientableLabel(StringResources.OUTGOING_MAIL_SERVER);
        this.tfOutgoingPort = new GWTextField(5);
        this.btnOutgoingDefaultPort = new OrientableButton(StringResources.USE_DEFAULT);
        this.cbUseOutgoingSSL = new OrientableCheckBox(new UseOutgoingSSLAction());
        panel.add((Component)this.buildAdvancedServerPanel(lblOutgoingServer, this.tfOutgoingPort, this.btnOutgoingDefaultPort), c);
        ++c.gridy;
        c.insets = new Insets(0, 30, 0, 10);
        panel.add((Component)this.cbUseOutgoingSSL, c);
        ++c.gridy;
        c.insets = new Insets(10, 10, 5, 10);
        panel.add((Component)this.buildServerTimeoutPanel(), c);
        ++c.gridy;
        this.ckDownloadExternalFileBodies = new OrientableCheckBox(StringResources.DOWNLOAD_EXTERNAL_FILE_BODIES);
        panel.add((Component)this.ckDownloadExternalFileBodies, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 5, 10);
        this.cbShowDetailedError = new OrientableCheckBox(StringResources.SHOW_DETAILED_ERROR_MESSAGES);
        panel.add((Component)this.cbShowDetailedError, c);
        OrientablePanel placePanel = new OrientablePanel();
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)placePanel, c);
        return panel;
    }

    private JPanel buildAdvancedNntpPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridy = 0;
        c.gridx = 0;
        OrientableLabel lblIncomingServer = new OrientableLabel(StringResources.NEWS_SERVER_C);
        this.tfIncomingPort = new GWTextField(5);
        this.btnIncomingDefaultPort = new OrientableButton(StringResources.USE_DEFAULT);
        this.cbUseIncomingSSL = new OrientableCheckBox(StringResources.USE_SSL);
        panel.add((Component)this.buildAdvancedServerPanel(lblIncomingServer, this.tfIncomingPort, this.btnIncomingDefaultPort), c);
        ++c.gridy;
        c.insets = new Insets(5, 10, 5, 10);
        panel.add((Component)this.buildServerTimeoutPanel(), c);
        OrientablePanel downloadPanel = new OrientablePanel(new GridBagLayout());
        downloadPanel.setBorder(new TitledBorder(StringResources.DOWNLOAD));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.anchor = 21;
        gbc.fill = 0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.rbAllMessages = new OrientableRadioButton(StringResources.ALL_MESSAGES);
        downloadPanel.add((Component)this.rbAllMessages, gbc);
        ++gbc.gridy;
        this.rbMaximum = new OrientableRadioButton(StringResources.A_MAXIMUM_OF);
        downloadPanel.add((Component)this.rbMaximum, gbc);
        ++gbc.gridx;
        this.spMaximum = new OrientableSpinner(new SpinnerNumberModel(100, 100, 30000, 100));
        downloadPanel.add((Component)this.spMaximum, gbc);
        ++gbc.gridx;
        downloadPanel.add((Component)new OrientableLabel(StringResources.MESSAGES_AT_A_TIME), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        this.ckNeverDownloadOldMessages = new OrientableCheckBox(StringResources.NEVER_DOWNLOAD_OLD_MESSAGES);
        this.addSideBorderToComponent(this.ckNeverDownloadOldMessages);
        downloadPanel.add((Component)this.ckNeverDownloadOldMessages, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.ckMessagesLess = new OrientableCheckBox(StringResources.MESSAGES_LESS_THAN);
        downloadPanel.add((Component)this.ckMessagesLess, gbc);
        ++gbc.gridx;
        this.spMessagesLess = new OrientableSpinner(new SpinnerNumberModel(0, 0, 730, 1));
        downloadPanel.add((Component)this.spMessagesLess, gbc);
        ++gbc.gridx;
        downloadPanel.add((Component)new OrientableLabel(StringResources.DAYS_OLD), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.ckHeadersOnly = new OrientableCheckBox(StringResources.HEADERS_ONLY);
        downloadPanel.add((Component)this.ckHeadersOnly, gbc);
        ButtonGroup rbDownloadGroup = new ButtonGroup();
        rbDownloadGroup.add(this.rbAllMessages);
        rbDownloadGroup.add(this.rbMaximum);
        ++c.gridy;
        panel.add((Component)downloadPanel, c);
        c.insets = new Insets(10, 10, 5, 10);
        ++c.gridy;
        this.ckSendRetrieveWhenFolderIsSelected = new OrientableCheckBox(StringResources.SEND_RETRIEVE_WHEN_FOLDER_IS_SELECTED);
        panel.add((Component)this.ckSendRetrieveWhenFolderIsSelected, c);
        c.insets = new Insets(0, 10, 5, 10);
        ++c.gridy;
        this.ckExpandNewThreads = new OrientableCheckBox(StringResources.EXPAND_NEW_THREADS_AS_THEY_ARE_DOWNLOADED);
        panel.add((Component)this.ckExpandNewThreads, c);
        ++c.gridy;
        this.cbShowDetailedError = new OrientableCheckBox(StringResources.SHOW_DETAILED_ERROR_MESSAGES);
        panel.add((Component)this.cbShowDetailedError, c);
        ++c.gridy;
        OrientablePanel removePanel = new OrientablePanel(new GridBagLayout());
        gbc.anchor = 21;
        gbc.fill = 0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.ckRemoveOldMessages = new OrientableCheckBox(StringResources.REMOVE_MESSAGES_MORE_THAN);
        removePanel.add((Component)this.ckRemoveOldMessages, gbc);
        ++gbc.gridx;
        this.spRemoveOldMessages = new JSpinner(new SpinnerNumberModel(5, 1, 365, 1));
        removePanel.add((Component)this.spRemoveOldMessages, gbc);
        ++gbc.gridx;
        removePanel.add(new OrientableLabel(StringResources.DAYS_OLD));
        panel.add((Component)removePanel, c);
        ++c.gridy;
        this.ckAutomaticallyWatchThreads = new OrientableCheckBox(StringResources.AUTOMATICALLY_WATCH_THREADS);
        panel.add((Component)this.ckAutomaticallyWatchThreads, c);
        OrientablePanel placePanel = new OrientablePanel();
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)placePanel, c);
        return panel;
    }

    private JPanel buildAdvancedServerPanel(JLabel lbServer, JTextField tfPort, JButton btnUseDefault) {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.insets = new Insets(0, 10, 5, 5);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        OrientablePanel portPanel = new OrientablePanel(new GridBagLayout());
        portPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        portPanel.add((Component)lbServer, gbc);
        ++gbc.gridx;
        portPanel.add((Component)tfPort, gbc);
        ++gbc.gridx;
        btnUseDefault.setEnabled(false);
        portPanel.add((Component)btnUseDefault, gbc);
        panel.add((Component)portPanel, c);
        return panel;
    }

    private JPanel buildServerTimeoutPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.insets = new Insets(0, 10, 5, 5);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        this.spServerTimeout = new OrientableSpinner(new SpinnerNumberModel(1, 1, 99, 1));
        panel.add((Component)this.spServerTimeout, c);
        ++c.gridx;
        OrientableLabel lblServerTimeout = new OrientableLabel(StringResources.MINUTES_TO_WAIT_FOR_SERVER_TO_RESPOND);
        panel.add((Component)lblServerTimeout, c);
        return panel;
    }

    private void enableControls() {
        if (this.account instanceof GroupWiseAccount && EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            this.spRefreshAddressBooksTime.setEnabled(this.ckRefreshAddressBookAndRules.isSelected());
        }
    }

    private void applyChanges() {
        this.account.setName(this.tfAccountName.getText());
        this.account.setFromText(this.tfFromName.getText());
        this.account.setOrganization(this.tfOrganization.getText());
        this.account.setEmailAddress(this.tfEmailAddress.getText());
        this.account.setIncludeInFullRetrieve(this.ckIncludeAccount.isSelected());
        if (this.account instanceof GroupWiseAccount) {
            if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
                EngineCommandManager.getUserInfo().setFromText(this.account.getFromText());
                GroupWiseAccount gwAccount = (GroupWiseAccount)this.account;
                int port = gwAccount.getIpPort();
                try {
                    port = Integer.valueOf(this.tfIPPort.getText());
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                gwAccount.setIpAddress(this.tfIPAddress.getText(), port);
                int systemSyncInterval = 0;
                if (this.ckRefreshAddressBookAndRules.isSelected()) {
                    systemSyncInterval = (Integer)this.spRefreshAddressBooksTime.getValue();
                }
                gwAccount.setSystemSyncInterval(systemSyncInterval);
            }
        } else {
            this.account.setReplyAddress(this.tfReplyAddress.getText());
            this.account.setUploadToMaster(this.ckUploadAccount.isSelected(), true);
            if (this.account instanceof Pop3Account) {
                Pop3Account pop3Account = (Pop3Account)this.account;
                pop3Account.setIncomingServer(this.tfIncomingServer.getText());
                pop3Account.setIncomingServerLoginName(this.tfIncomingServerLogin.getText());
                pop3Account.setIncomingServerPassword(new String(this.tfIncomingServerPassword.getPassword()));
                pop3Account.setOutgoingServer(this.tfOutgoingServer.getText());
                pop3Account.setUseSecurePasswordAuth(this.ckLogOnUsingSPA.isSelected());
                pop3Account.setOutgoingServerRequiresAuth(this.ckOutgoingServerRequiresAuth.isSelected());
                pop3Account.setShowDetailedErrorMessages(this.cbShowDetailedError.isSelected());
                if (this.ckUseSameSettings.isEnabled() && !this.ckUseSameSettings.isSelected()) {
                    pop3Account.setUseIncomingAuthForOutgoing(false);
                    pop3Account.setOutgoingServerLoginName(this.tfOutgoingServerLogin.getText());
                    pop3Account.setOutgoingServerPassword(new String(this.tfOutgoingServerPassword.getPassword()));
                } else {
                    pop3Account.setUseIncomingAuthForOutgoing(true);
                }
                pop3Account.setLeaveCopyOnServer(this.ckLeaveACopy.isSelected());
                pop3Account.setRemoveAfterNumDaysState(this.ckRemoveFromServerAfterDays.isSelected());
                pop3Account.setRemoveAfterNumDays(((Integer)this.spRemoveAfterDays.getValue()).intValue());
                pop3Account.setRemoveMessagesAfterPurge(this.ckRemoveFromServerAfterTrash.isSelected());
                Pop3Account gwAccount = (Pop3Account)this.account;
                int port = gwAccount.getIncomingServerPort();
                try {
                    port = Integer.valueOf(this.tfIncomingPort.getText());
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                pop3Account.setIncomingServerPort(port);
                pop3Account.setIncomingServerUseSSL(this.cbUseIncomingSSL.isSelected());
                port = gwAccount.getOutgoingServerPort();
                try {
                    port = Integer.valueOf(this.tfOutgoingPort.getText());
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                pop3Account.setOutgoingServerPort(port);
                pop3Account.setOutgoingServerUseSSL(this.cbUseOutgoingSSL.isSelected());
                pop3Account.setServerTimeout(((Integer)this.spServerTimeout.getValue()).intValue());
                pop3Account.setFolder(this.checkFoldersTree.getSelectedFolder().getNativeFolder().getNativeFolder());
            } else if (this.account instanceof ImapAccount) {
                ImapAccount imapAccount = (ImapAccount)this.account;
                imapAccount.setIncomingServer(this.tfIncomingServer.getText());
                imapAccount.setIncomingServerLoginName(this.tfIncomingServerLogin.getText());
                imapAccount.setIncomingServerPassword(new String(this.tfIncomingServerPassword.getPassword()));
                imapAccount.setIncomingServerUseSSL(this.cbUseIncomingSSL.isSelected());
                imapAccount.setOutgoingServer(this.tfOutgoingServer.getText());
                imapAccount.setOutgoingServerUseSSL(this.cbUseOutgoingSSL.isSelected());
                imapAccount.setUseSecurePasswordAuth(this.ckLogOnUsingSPA.isSelected());
                imapAccount.setOutgoingServerRequiresAuth(this.ckOutgoingServerRequiresAuth.isSelected());
                imapAccount.setShowDetailedErrorMessages(this.cbShowDetailedError.isSelected());
                if (this.ckUseSameSettings.isEnabled() && !this.ckUseSameSettings.isSelected()) {
                    imapAccount.setUseIncomingAuthForOutgoing(false);
                    imapAccount.setOutgoingServerLoginName(this.tfOutgoingServerLogin.getText());
                    imapAccount.setOutgoingServerPassword(new String(this.tfOutgoingServerPassword.getPassword()));
                } else {
                    imapAccount.setUseIncomingAuthForOutgoing(true);
                }
                ImapAccount gwAccount = (ImapAccount)this.account;
                int port = gwAccount.getIncomingServerPort();
                try {
                    port = Integer.valueOf(this.tfIncomingPort.getText());
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                imapAccount.setIncomingServerPort(port);
                port = gwAccount.getOutgoingServerPort();
                try {
                    port = Integer.valueOf(this.tfOutgoingPort.getText());
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                imapAccount.setOutgoingServerPort(port);
                imapAccount.setServerTimeout(((Integer)this.spServerTimeout.getValue()).intValue());
                imapAccount.setRootPath(this.tfRootFolderPath.getText());
                imapAccount.setShowSubscribedOnly(this.ckOnlyShowSubscribedFolders.isSelected());
                imapAccount.setHeadersOnly(this.ckDownloadHeadersOnly.isSelected());
                imapAccount.setDownloadNewOnly(this.ckDownloadNewItemsOnly.isSelected());
                imapAccount.setSyncWhenFolderSelected(this.ckSendRetrieveWhenFolderIsSelected.isSelected());
                imapAccount.setExpungeWhenDeleted(this.ckRemoveItemsFromTrash.isSelected());
                imapAccount.setDownloadExternalBodies(this.ckDownloadExternalFileBodies.isSelected());
            } else if (this.account instanceof NntpAccount) {
                NntpAccount nntpAccount = (NntpAccount)this.account;
                nntpAccount.setIncomingServer(this.tfIncomingServer.getText());
                nntpAccount.setIncomingServerLoginName(this.tfIncomingServerLogin.getText());
                nntpAccount.setIncomingServerPassword(new String(this.tfIncomingServerPassword.getPassword()));
                nntpAccount.setRequiresAuthenticate(this.cbServerRequiresAuth.isSelected());
                nntpAccount.setShowDetailedErrorMessages(this.cbShowDetailedError.isSelected());
                NntpAccount gwAccount = (NntpAccount)this.account;
                int port = gwAccount.getIncomingServerPort();
                try {
                    port = Integer.valueOf(this.tfIncomingPort.getText());
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                nntpAccount.setIncomingServerPort(port);
                nntpAccount.setServerTimeout(((Integer)this.spServerTimeout.getValue()).intValue());
                if (this.rbAllMessages.isSelected()) {
                    nntpAccount.setNumMessagesPerDownload(-1);
                } else {
                    nntpAccount.setNumMessagesPerDownload(((Integer)this.spMaximum.getValue()).intValue());
                }
                nntpAccount.setHeadersOnly(this.ckHeadersOnly.isSelected());
                nntpAccount.setSyncWhenFolderSelected(this.ckSendRetrieveWhenFolderIsSelected.isSelected());
                nntpAccount.setExpandThreads(this.ckExpandNewThreads.isSelected());
                nntpAccount.setAutoWatchMyPostings(this.ckAutomaticallyWatchThreads.isSelected());
                nntpAccount.setBatchSettings(this.ckNeverDownloadOldMessages.isSelected(), this.ckMessagesLess.isSelected() ? (Integer)this.spMessagesLess.getValue() : -1, this.ckRemoveOldMessages.isSelected(), ((Integer)this.spRemoveOldMessages.getValue()).intValue());
            }
        }
        this.signaturePanel.collectValues();
    }

    protected MVCController createController(MVCController parentController) {
        return new AccountPropertiesDialogController(this, parentController);
    }

    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        this.applyChanges();
        this.dispose();
    }

    private class UseOutgoingSSLAction
    extends AbstractAction {
        public UseOutgoingSSLAction() {
            super(StringResources.USE_SSL);
        }

        public void actionPerformed(ActionEvent e) {
            if (((OrientableCheckBox)e.getSource()).isSelected()) {
                AccountPropertiesDialog.this.tfOutgoingPort.setText(String.valueOf(465));
            } else {
                AccountPropertiesDialog.this.tfOutgoingPort.setText(String.valueOf(25));
            }
        }
    }

    private class UseIncomingSSLAction
    extends AbstractAction {
        public UseIncomingSSLAction() {
            super(StringResources.USE_SSL);
        }

        public void actionPerformed(ActionEvent e) {
            if (((OrientableCheckBox)e.getSource()).isSelected()) {
                if (AccountPropertiesDialog.this.account instanceof Pop3Account) {
                    AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(995));
                } else if (AccountPropertiesDialog.this.account instanceof ImapAccount) {
                    AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(993));
                }
            } else if (AccountPropertiesDialog.this.account instanceof Pop3Account) {
                AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(110));
            } else if (AccountPropertiesDialog.this.account instanceof ImapAccount) {
                AccountPropertiesDialog.this.tfIncomingPort.setText(String.valueOf(143));
            }
        }
    }

    private class CreateFolderAction
    extends AbstractAction {
        public CreateFolderAction() {
            super(StringResources.CREATE_FOLDER_D);
        }

        public void actionPerformed(ActionEvent e) {
            GWCommandManager manager = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid());
            IFolder rootFolder = manager.getCurrentDataStore().getRootFolders()[0];
            Window ownerFrame = AccountPropertiesDialog.this.getOwner();
            while (!(ownerFrame instanceof JFrame)) {
                ownerFrame = ownerFrame.getOwner();
            }
            CreateFolderDialog dialog = new CreateFolderDialog((JFrame)ownerFrame, (MVCController)AccountPropertiesDialog.this.getController(), manager.getGWFolder(rootFolder));
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            dialog.dispose();
            AccountPropertiesDialog.this.checkFoldersTree.refreshTree(true);
        }
    }

    private class OnlinePasswordAction
    extends AbstractAction {
        public OnlinePasswordAction() {
            super(StringResources.ONLINE_MAILBOX_PASSWORD + "...");
        }

        public void actionPerformed(ActionEvent e) {
            AccountPropertiesDialog owner = AccountPropertiesDialog.this;
            PasswordChangeDialog dialog = new PasswordChangeDialog(owner, StringResources.CHANGE_ONLINE_MAILBOX_PASSWORD, true);
            UIUtils.centerWindow((Window)dialog, owner);
            dialog.setVisible(true);
            dialog.dispose();
        }
    }

    private class RefreshAddressBooksUpdateListener
    implements ActionListener {
        private RefreshAddressBooksUpdateListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AccountPropertiesDialog.this.enableControls();
        }
    }
}

