/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.mvc.MVCController;
import com.novell.gw.account.Account;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import org.apache.log4j.Logger;

public class AccountUtils {
    private static Logger logger = Logger.getLogger(AccountUtils.class);

    public static String getAccountTypeString(Account theAccount) {
        int type = theAccount.getType();
        switch (type) {
            case 3: {
                return StringResources.GROUPWISE;
            }
            case 2: {
                return StringResources.IMAP4;
            }
            case 4: {
                return StringResources.NNTP;
            }
            case 1: {
                return StringResources.POP3;
            }
            case 7: {
                return StringResources.CAP;
            }
        }
        return StringResources.NONE;
    }

    public static AbstractFolder createFolder(FolderNamePane folderNamePane, MVCController theController) {
        AbstractFolder parentFolder = folderNamePane.getParentFolder();
        String folderName = folderNamePane.getFolderName();
        String folderDescription = folderNamePane.getFolderDescription();
        int folderPosition = folderNamePane.getFolderPosition();
        String userGuid = ControlsUtils.getUserGuid(theController);
        AbstractFolder newFolder = null;
        try {
            FoldersCache.clear();
            ItemListsCache.clear();
            newFolder = GWCommandManager.getInstance(userGuid).createFolder(folderName, folderDescription, parentFolder, folderPosition);
        }
        catch (EngineException e) {
            logger.error((Object)e);
        }
        return newFolder;
    }

    public static Account getAccountForFolder(IFolder folder) {
        return folder.getInternetAccount(EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore());
    }
}

