/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.dateAndTime;

import com.appframework.Tested;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.DateAndTimeElement;
import com.novell.gw.jclient.application.resources.StringResources;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DateAndTimeFormat {
    DATE_SHORT{

        public String getLocalizedName() {
            return StringResources.SHORT_DATE;
        }

        public DateAndTimeElement getLeadingElement() {
            return DateAndTimeElement.SHORT_DATE;
        }

        public DateAndTimeElement getTrailingElement() {
            return null;
        }
    }
    ,
    DATE_LONG{

        public String getLocalizedName() {
            return StringResources.LONG_DATE;
        }

        public DateAndTimeElement getLeadingElement() {
            return DateAndTimeElement.LONG_DATE;
        }

        public DateAndTimeElement getTrailingElement() {
            return null;
        }
    }
    ,
    TIME{

        public String getLocalizedName() {
            return StringResources.TIME;
        }

        public DateAndTimeElement getLeadingElement() {
            return DateAndTimeElement.TIME;
        }

        public DateAndTimeElement getTrailingElement() {
            return null;
        }
    }
    ,
    SHORT_DATE_TIME{

        public String getLocalizedName() {
            return StringResources.SHORT_DATE_TIME;
        }

        public DateAndTimeElement getLeadingElement() {
            return DateAndTimeElement.SHORT_DATE;
        }

        public DateAndTimeElement getTrailingElement() {
            return DateAndTimeElement.TIME;
        }
    }
    ,
    TIME_SHORT_DATE{

        public String getLocalizedName() {
            return StringResources.TIME_SHORT_DATE;
        }

        public DateAndTimeElement getLeadingElement() {
            return DateAndTimeElement.TIME;
        }

        public DateAndTimeElement getTrailingElement() {
            return DateAndTimeElement.SHORT_DATE;
        }
    }
    ,
    LONG_DATE_TIME{

        public String getLocalizedName() {
            return StringResources.LONG_DATE_TIME;
        }

        public DateAndTimeElement getLeadingElement() {
            return DateAndTimeElement.LONG_DATE;
        }

        public DateAndTimeElement getTrailingElement() {
            return DateAndTimeElement.TIME;
        }
    }
    ,
    TIME_LONG_DATE{

        public String getLocalizedName() {
            return StringResources.TIME_LONG_DATE;
        }

        public DateAndTimeElement getLeadingElement() {
            return DateAndTimeElement.TIME;
        }

        public DateAndTimeElement getTrailingElement() {
            return DateAndTimeElement.LONG_DATE;
        }
    };


    public abstract String getLocalizedName();

    public abstract DateAndTimeElement getLeadingElement();

    public abstract DateAndTimeElement getTrailingElement();

    public boolean hasTrailingElement() {
        return this.getTrailingElement() != null;
    }

    public boolean containsElement(DateAndTimeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("element is null");
        }
        return element.equals((Object)this.getLeadingElement()) || element.equals((Object)this.getTrailingElement());
    }

    public static List<String> getLocalizedNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (DateAndTimeFormat format : DateAndTimeFormat.values()) {
            names.add(format.getLocalizedName());
        }
        return names;
    }

    public static DateAndTimeFormat getDateAndTimeFormat(String localizedName) {
        if (Utils.isNullOrEmpty(localizedName)) {
            throw new IllegalArgumentException("localizedName is null or empty");
        }
        for (DateAndTimeFormat format : DateAndTimeFormat.values()) {
            if (!format.getLocalizedName().equals(localizedName)) continue;
            return format;
        }
        throw new IllegalArgumentException("illegal localizedName: " + localizedName);
    }

    @Tested
    public static DateAndTimeFormat getDateAndTimeFormat(DateAndTimeElement leadingElement, DateAndTimeElement trailingElement) {
        if (leadingElement == null) {
            throw new IllegalArgumentException("leadingElement is null");
        }
        for (DateAndTimeFormat format : DateAndTimeFormat.values()) {
            if (!format.getLeadingElement().equals((Object)leadingElement) || !(trailingElement == null ? !format.hasTrailingElement() : trailingElement.equals((Object)format.getTrailingElement()))) continue;
            return format;
        }
        throw new IllegalArgumentException("illegal elements: " + (Object)((Object)leadingElement) + ", " + (Object)((Object)trailingElement));
    }
}

