/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.general.AppearanceOptionsPanel;
import com.novell.gw.jclient.application.frames.options.compose.general.BackupOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.general.CleanupOptionPane;
import com.novell.gw.jclient.application.frames.options.compose.general.CommonPanel;
import com.novell.gw.jclient.application.frames.options.compose.general.DefaultActionsOptionPane;
import com.novell.gw.jclient.application.frames.options.compose.general.FileLocationOptionPane;
import com.novell.gw.jclient.application.frames.options.compose.general.ReplyFormatOptionPane;
import com.novell.gw.jclient.application.frames.options.compose.general.WebOptionPane;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GeneralOptionPane
extends ComposeOption {
    private CommonPanel pnlCommon;
    private GeneralOptions generalOptions;
    private AbstractOptionPanel backupOptionsPane;
    private AbstractOptionPanel cleanupOptionPane;
    private AbstractOptionPanel replyFormatOptionPane;
    private AbstractOptionPanel fileLocationOptionPane;
    private AbstractOptionPanel defaultActionsOptionPane;
    private AbstractOptionPanel appearanceOptionsPanel;
    private AbstractOptionPanel webOptionPanel;
    public String userGuid;

    public GeneralOptionPane(String theID, MVCController theParentController, String userGuid) {
        super(theID, theParentController);
        this.userGuid = userGuid;
        this.prepareForShow();
    }

    protected void build() {
        super.build();
        this.pnlCommon = new CommonPanel(this.changesListener, this.getController());
        this.backupOptionsPane = new BackupOptionsPane(this.changesListener, this.getController());
        this.cleanupOptionPane = new CleanupOptionPane(this.changesListener, this.getController(), this.userGuid);
        this.replyFormatOptionPane = new ReplyFormatOptionPane(this.changesListener, this.getController());
        this.fileLocationOptionPane = new FileLocationOptionPane(this.changesListener, this.getController(), this.userGuid);
        this.defaultActionsOptionPane = new DefaultActionsOptionPane(this.changesListener, this.getController());
        this.appearanceOptionsPanel = new AppearanceOptionsPanel(this.changesListener, this.getController());
        this.webOptionPanel = new WebOptionPane(this.changesListener, this.getController());
        this.setLayout(new BorderLayout());
        OrientableTabbedPane tabOptions = new OrientableTabbedPane();
        tabOptions.add(this.pnlCommon.getName(), this.pnlCommon);
        tabOptions.add(this.fileLocationOptionPane.getName(), this.fileLocationOptionPane);
        tabOptions.add(this.cleanupOptionPane.getName(), this.cleanupOptionPane);
        tabOptions.add(this.defaultActionsOptionPane.getName(), this.defaultActionsOptionPane);
        tabOptions.add(this.replyFormatOptionPane.getName(), this.replyFormatOptionPane);
        if (GWCommandManager.getInstance(this.userGuid).isCachingDataStore()) {
            tabOptions.add(this.backupOptionsPane.getName(), this.backupOptionsPane);
        }
        tabOptions.add(StringResources.APPEARANCE, this.appearanceOptionsPanel);
        tabOptions.add(this.webOptionPanel.getName(), this.webOptionPanel);
        tabOptions.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AbstractOptionPanel option = (AbstractOptionPanel)((JTabbedPane)e.getSource()).getSelectedComponent();
                boolean b = GeneralOptionPane.this.changesListener.valueHasChanged();
                option.prepareForShow();
                if (!b) {
                    GeneralOptionPane.this.changesListener.setValueSaved();
                }
            }
        });
        this.add((Component)tabOptions, "Center");
        this.putOptionValuesIntoFields();
    }

    public void prepareForShow() {
        this.build();
        this.isPrepared = true;
    }

    public void save() {
    }

    public void save(MVCController theController) {
        super.save(theController);
        if (this.changesListener.valueHasChanged()) {
            String cashingPath = OptionManager.getInstance().getCachingPath();
            String path = ((FileLocationOptionPane)this.fileLocationOptionPane).getCashingPath();
            if (!path.equals("")) {
                cashingPath = path;
            }
            if (cashingPath == null || "".equals(cashingPath)) {
                OptionManager.getInstance().setCashingPath("");
            } else if (this.ensurePathExistance(cashingPath)) {
                OptionManager.getInstance().setCashingPath(cashingPath);
            }
            this.collectValues();
            GWCommandManager commandManager = GWCommandManager.getInstance(this.userGuid);
            String newArchDir = commandManager.getArchiveLocation();
            if (GeneralOptionPane.isEmptyString(newArchDir)) {
                commandManager.setArchiveLocation("");
            } else if (!this.ensurePathExistance(newArchDir)) {
                commandManager.setArchiveLocation(((FileLocationOptionPane)this.fileLocationOptionPane).getInitialArchivePath());
            }
            OptionManager.getInstance().setGeneralOptions((GeneralOptions)this.generalOptions.clone());
            this.changesListener.setValueSaved();
            this.getController().processCommand(new GlobalCommand(1410));
        }
    }

    private static boolean isEmptyString(String s) {
        return s == null || "".equals(s);
    }

    public void putOptionValuesIntoFields() {
        this.generalOptions = (GeneralOptions)OptionManager.getInstance().getGeneralOptions().clone();
        this.pnlCommon.setOptions(this.generalOptions);
        this.changesListener.setValueSaved();
    }

    public void collectValues() {
        if (this.pnlCommon.isPrepared) {
            this.pnlCommon.collectValues();
        }
        if (this.backupOptionsPane.isPrepared) {
            this.backupOptionsPane.collectValues();
        }
        if (this.cleanupOptionPane.isPrepared) {
            this.cleanupOptionPane.collectValues();
        }
        if (this.defaultActionsOptionPane.isPrepared) {
            this.defaultActionsOptionPane.collectValues();
        }
        if (this.replyFormatOptionPane.isPrepared) {
            this.replyFormatOptionPane.collectValues();
        }
        if (this.fileLocationOptionPane.isPrepared) {
            this.fileLocationOptionPane.collectValues();
        }
        if (this.appearanceOptionsPanel.isPrepared) {
            this.appearanceOptionsPanel.collectValues();
        }
        if (this.webOptionPanel.isPrepared) {
            this.webOptionPanel.collectValues();
        }
    }

    private boolean ensurePathExistance(String path) {
        boolean result = false;
        if (path != null && !"".equals(path)) {
            File file = new File(path);
            if (file.exists()) {
                result = true;
            } else {
                int res = JOptionPane.showConfirmDialog(this, StringResources.formatString(StringResources.DOES_NOT_EXIST_CREATE_DIRECTORY_Q, path), StringResources.GROUPWISE_CLIENT, 0, 3);
                if (res == 0) {
                    if (file.mkdirs()) {
                        result = true;
                    } else {
                        JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.FAILED_TO_CREATE_DIRECTORY, path), StringResources.GROUPWISE_CLIENT, 0);
                        result = false;
                    }
                }
            }
        }
        return result;
    }
}

