/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.appframework.components.EmptyStringDocumentListener;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.OptionsDialog;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

abstract class AbstractAddressListOptionPanel
extends AbstractOptionPanel {
    protected String userGuid;
    protected JButton btnAddUser;
    protected JButton btnRemoveUser;
    protected JButton btnAddressBook;
    protected JTable tblAddressList;
    protected SearchTextField tfName;
    private JButton defaultButton;
    protected JLabel lblTableTitle;
    protected TitledBorder titledBorder;
    protected String strBorderTitle;

    public AbstractAddressListOptionPanel(OptionChangesListener theChangesListener, MVCController theParentController, String userGuid) {
        super(theChangesListener, theParentController);
        this.userGuid = userGuid;
        this.tfName = new SearchTextField();
        this.lblTableTitle = new JMnemonicLabel("", this.tblAddressList);
        this.btnAddressBook = new OrientableButton(new ViewAddressBookAction());
        this.btnAddressBook.setMargin(new Insets(1, 1, 1, 1));
        this.btnAddUser = new OrientableButton(new AddUserAction());
        this.btnAddUser.addItemListener(this.itemListener);
        this.btnRemoveUser = new OrientableButton(new RemoveUserAction());
        this.btnRemoveUser.addItemListener(this.itemListener);
        this.tblAddressList = new GWTable();
        this.titledBorder = new TitledBorder(this.strBorderTitle);
        this.tfName.getDocument().addDocumentListener(new EmptyStringDocumentListener(this.btnAddUser.getAction()));
        this.tfName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (AbstractAddressListOptionPanel.this.defaultButton == null) {
                        AbstractAddressListOptionPanel.this.defaultButton = AbstractAddressListOptionPanel.this.getRootPane().getDefaultButton();
                    }
                    if (AbstractAddressListOptionPanel.this.tfName.getText().length() != 0) {
                        AbstractAddressListOptionPanel.this.getRootPane().setDefaultButton(AbstractAddressListOptionPanel.this.btnAddUser);
                    }
                }
            }
        });
        this.tfName.setListener(new SearchResultListener(){

            public void searchFinished(SearchEvent e) {
                AbstractAddressListOptionPanel.this.search(e);
            }
        });
        this.tblAddressList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AbstractAddressListOptionPanel.this.processItemSelection();
            }
        });
        this.tblAddressList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (e.getKeyCode() == itemDeleteKey) {
                    AbstractAddressListOptionPanel.this.btnRemoveUser.getAction().actionPerformed(null);
                }
            }
        });
    }

    protected JPanel createAddressListPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        OrientablePanel textPanel = new OrientablePanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 0);
        textPanel.add((Component)new JMnemonicLabel(StringResources.NAME_C, this.tfName), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 5);
        textPanel.add((Component)this.tfName, constraints);
        this.tfName.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        textPanel.add((Component)this.btnAddressBook, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 20);
        panel.add((Component)textPanel, constraints);
        OrientablePanel buttonPanel = new OrientablePanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 5, 0);
        buttonPanel.add((Component)this.btnAddUser, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        buttonPanel.add((Component)this.btnRemoveUser, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)buttonPanel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.lblTableTitle, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridheight = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        ColoredScrollPane scroll = new ColoredScrollPane(this.tblAddressList);
        scroll.setPreferredSize(new Dimension(200, 180));
        scroll.setMinimumSize(new Dimension(100, 100));
        this.add((Component)scroll, constraints);
        panel.add((Component)scroll, constraints);
        return panel;
    }

    abstract void buildUI();

    abstract void processItemSelection();

    abstract void removeUser();

    abstract void addContacts(List var1);

    abstract void search(SearchEvent var1);

    private class RemoveUserAction
    extends AbstractAction {
        public RemoveUserAction() {
            super(StringResources.REMOVE_USER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractAddressListOptionPanel.this.removeUser();
        }
    }

    private class AddUserAction
    extends AbstractAction {
        public AddUserAction() {
            super(StringResources.ADD_USER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractAddressListOptionPanel.this.tfName.updateListener();
        }
    }

    private class ViewAddressBookAction
    extends AbstractAction {
        public ViewAddressBookAction() {
            super(null, ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
        }

        public void actionPerformed(ActionEvent e) {
            OptionsDialog dialog = (OptionsDialog)ControlsUtils.getWindowForComponent(AbstractAddressListOptionPanel.this);
            AddressSelectorDialog selectorDialog = new AddressSelectorDialog(dialog, (MVCController)dialog.getController());
            selectorDialog.setVisible(true);
            if (selectorDialog.isOkActionProcessed() && !selectorDialog.getSelectedContacts().isEmpty()) {
                List<IAddressable> list = selectorDialog.getSelectedContacts();
                AbstractAddressListOptionPanel.this.addContacts(list);
            }
        }
    }
}

